window.addEventListener("load", function() {
    //Obtengo los elementos de la pantalla
    //el inputtext
    var texto = document.getElementById("anime");
    //el elemento source de la etiquet audio
    var cancion = document.getElementById("cancion");
    //la etiqueta audio
    var audio = document.getElementById("audio");
    //el boton anterior
    var anterior = document.getElementById("anterior");
    //el boton siguiente
    var siguiente = document.getElementById("siguiente");
    //el boton home o inicio
    var regresar = document.getElementById("regresar");
    //la imagen de pregunta
    var pregunta = document.getElementById("pregunta");
    //la imagen de respuesta
    var respuesta = document.getElementById("respuesta");
    
    //la variable que me va servir de bandera para las canciones
    var posicion = 0;
    
    //obtengo los animes del json
    var animes = null;
    var xhr = new XMLHttpRequest();
    xhr.overrideMimeType("application/json");
    xhr.open("GET", "canciones.json", true);
    xhr.onreadystatechange = function () {
        if (xhr.readyState === 4 && xhr.status === 200) {
            //cargamos los datos de json
            animes = JSON.parse(xhr.responseText);
            //establezco los valores iniciales
            cancion.src = animes["canciones"][posicion].cancion;
            audio.load();
            audio.play();
        }
    };
    xhr.send();

    //la validacion de la cancion
    function validar() {
        if(texto.value.toUpperCase() === animes["canciones"][posicion].anime){
            pregunta.style.display = "none";
            respuesta.style.display = "block";
            cancion.src = "canciones/ok.ogg";
            audio.load();
            audio.play();
        }
    }
    texto.addEventListener("keyup",validar);

    //que pasa sl presionar siguiente
    function pasar_siguiente(){
        if (posicion < animes["canciones"].length-1) posicion += 1;
        texto.value = "";
        pregunta.style.display = "block";
        respuesta.style.display = "none";
        cancion.src = animes["canciones"][posicion].cancion;
        audio.load();
        audio.play();
    }
    siguiente.addEventListener("click",pasar_siguiente);

    //que pasa al presionar anterior
    function pasar_anterior(){
        if (posicion > 0 )  posicion -= 1;
        texto.value = "";
        pregunta.style.display = "block";
        respuesta.style.display = "none";
        cancion.src = animes["canciones"][posicion].cancion;
        audio.load();
        audio.play();
    }
    anterior.addEventListener("click", pasar_anterior);

    //para regresar al inicio
    function home() {
        location.href = "index.html";
    }
    regresar.addEventListener("click", home);
    
    //para repetir
    function repetir() {
        audio.play();
    }
    pregunta.addEventListener("click",repetir);
});