
/**
 * Defines the DropZone class which acts as a fixed point onto which draggable could be dropped.
 */
var DropZone = function(elem){

    this.elem = elem;
    
    //get positions - simple calculation and assume it doesn't move..
    this.left = elem.offsetLeft;
    this.right = elem.offsetLeft + elem.offsetWidth;
    this.top = elem.offsetTop;
    this.bottom = elem.offsetTop + elem.offsetHeight;
    
    //cache extra info..
    this.centerX = (this.right - this.left)/2 + this.left;
    this.centerY = (this.bottom - this.top)/2 + this.bottom;
};

(function(){

    //returns if the actual range intersects the drop range..
    function intersectsDrop(actMin, actMax, dropMin, dropMax){
        if(dropMin - actMin >= 0){
            return (actMax - dropMin >= 0);
        } else {
            return (dropMax - actMin >= 0);
        }
    }

    //returns whether or not this dropzone intersects the given Draggable..
    DropZone.prototype.intersects = function(top, right, bottom, left){
        return intersectsDrop(top, bottom, this.top, this.bottom) &&
                intersectsDrop(left, right, this.left, this.right);
    };
 
    //returns the sum of the x and y distances between the center of this zone and the given point..
    DropZone.prototype.sumDistanceFromCenter = function(x, y){
        return Math.abs(x - this.centerX) + Math.abs(y - this.centerY);
    };

    //hauls the given draggable in so that its top left point overlays this drop zone's top left point..
    DropZone.prototype.haulIn = function(draggable){
	var haulAnchor = draggable.getHaulAnchor();
        draggable.setPosition(this.left - haulAnchor.x, this.top - haulAnchor.y, true);
    };

})();


