//TODO: remove unnecessary globals (make them part of Puxxle global)..

/**
 * Main program file..
 */

//TODO: for debugging..
function stacktrace() { 
  function st2(f) {
    return !f ? [] : 
        st2(f.caller).concat([f.toString().split('(')[0].substring(9) + '(' + f.arguments.join(',') + ')']);
  }
  return st2(arguments.callee.caller);
}

// prevent dragging..
function blockMove(e){ 
    e.preventDefault();
    window.scroll(0,0);
    return false;
}
function doNothing(e){
    e.preventDefault();
    return false
}
document.addEventListener("touchmove", blockMove, false);  //prevent dragging
document.addEventListener("touchstart", doNothing, false); //prevent android text-selection

//Globals..
var Puxxle = {
    //All possible css cell colour classes..
    cssColours : ['empty', 'colour1', 'colour2', 'colour3', 'colour4'],
    //a minor hack so that the space between piece and holder doesn't
    //affect dragging, must be pieceHolder top padding + border width..
    pieceHolderMargin: 7,
    //pixels between cells..
    cellPadding: 2,
	//Sets the randomSeed..
	setRandomSeed: function(seed) {
		Math.seedrandom(seed);
		resetGame(); //need to do twice as next one is cached already..
		resetGame();
		$.each(pieces, function(i, piece){
            piece.forceDrop()
		});
	},
	//"Re-randomizes the game..
	unsetRandomSeed: function() {
		Puxxle.setRandomSeed(new Date().getTime());
	},
	version: 0.1
};

// Draws a rounded rectangle using the given context
// code adapted from:
// https://developer.mozilla.org/en-US/docs/Canvas_tutorial/Drawing_shapes.
function roundedRect(ctx, x, y, width, height, radius){
    ctx.beginPath();
    ctx.moveTo(x, y + radius);
    ctx.lineTo(x, y + height - radius);
    ctx.quadraticCurveTo(x, y + height, x + radius, y + height);
    ctx.lineTo(x + width - radius, y + height);
    ctx.quadraticCurveTo(x + width, y + height, x + width, y + height - radius);
    ctx.lineTo(x + width, y + radius);
    ctx.quadraticCurveTo(x + width, y, x + width - radius, y);
    ctx.lineTo(x + radius, y);
    ctx.quadraticCurveTo(x, y, x, y + radius);
    ctx.fill();
}

function lighten(canvas, factor) {
    var cxt = canvas.getContext("2d");

    // get all canvas pixel data
    factor++;
    var imageData = cxt.getImageData(0, 0, canvas.width, canvas.height);
    for (var i = 0; i < imageData.data.length; i += 4) {
        var r = Math.min(255, imageData.data[i] * factor);
        var g = Math.min(255, imageData.data[i+1] * factor);
        var b = Math.min(255, imageData.data[i+2] * factor);
        //don't touch alpha..
        imageData.data[i] = r;
        imageData.data[i+1] = g;
        imageData.data[i+2] = b;
    }
    cxt.putImageData(imageData, 0, 0);
}

//Draws the background image, using the given number of pixels for the various
//elements..
function drawBackground(height, width, cellSide, cornerRadius){
    //we set the seed so that the background is the same each time..
    Math.seedrandom(0);

    var canvas = document.getElementById("background");
    canvas.width = width;
    canvas.height = height;
    var ctx = canvas.getContext('2d');
    var padding = Puxxle.cellPadding;
    var x = 0, y = 0;
    var largestSide = Math.max(width, height);

    //fill it black..
    ctx.restore();
    ctx.fillRect(0, 0, width, height);

    ctx.translate(largestSide/2, -largestSide/2);
    ctx.rotate(Math.PI/4); //45deg
    while(y < largestSide * 2){
        while(x < largestSide * 2){
            var shade = Math.round(255 * Math.seededRandom());
            ctx.fillStyle = "rgba(" + shade + ", " + shade + ", " + shade + ", 0.5)";
            roundedRect(ctx, x, y, cellSide, cellSide, cornerRadius);
            x += cellSide + padding;
        }
        x = 0;
        y += cellSide + padding;
    }
    
    //make it a bit brighter - TODO: do this in the above loop to save time!
    lighten(canvas, 0.3);
    
    //make it random again..
    Math.seedrandom(new Date().getTime());
}

//Adds cells to the main table element and returns it.
function setUpTable(){
	var table = document.getElementById("grid");
	for(var i = 0; i < 9; i++){
		var row = document.createElement("tr");
		for(var j = 0; j < 9; j++){
			var cell = document.createElement("td");
			row.appendChild(cell);
		}
		table.appendChild(row);
	}
    return table;
}

//Sets up the sizes of all the game elements so that it will fit
//the given screen size/orientation..
function setGameDimensions(){

    $win = $(window);
    var height = $win.height();
    var width = $win.width();

    var cellSide = Math.floor(
        Math.min(
            (width * 0.8 - 6 * Puxxle.pieceHolderMargin - 12) / 9,
            (height * 0.6 - Puxxle.pieceHolderMargin - 14) / 12
        )
    );
    var cellBorderRadius = Math.floor(cellSide / 6);
    
    //set the cell dimensions..
    $('#grid td, .piece td, #background td').css({
        "width": cellSide + "px",
        "height": cellSide + "px",
        "border-radius": cellBorderRadius + "px"
    });

    $('.outerPieceHolder').css({
        "margin-left": Math.floor(
                (width - 6 * Puxxle.pieceHolderMargin - 9 * cellSide - 12) / 4) + "px"
    });
    
    $('.pieceHolder').css({
        "padding-bottom": Math.floor(
                height * 0.87 - 7 - 14 - (cellSide + 1) * 12) + "px",
        "border-radius":  Math.floor(cellSide / 3) + "px"
    });

    $('#tableHolder').css({
        "margin-left": Math.floor((width - 9 * cellSide - 25) / 2) + "px",
        "margin-bottom": Math.floor(height * 0.01) + "px",
        "border-radius": Math.floor(cellSide / 3) + "px"
    });

    $('#info').css({
        "font-size": Math.floor(height * 0.04) + "px",
        "margin": Math.floor(height * 0.01) + "px"
    });
	
	$('#info #highScoreAlertHolder').css({
        "top": Math.floor(height * 0.01) + "px"
    });

    $('#info div').css({
        "padding": Math.floor(height * 0.01) + "px"
    });

    $('#menus').css({
    	"padding-top": Math.floor(height * 0.1) + "px"
    });
    
    $('#menus .menu h2').css({
        "margin-top": Math.floor(height * 0.08) + "px",
        "font-size": Math.floor(height * 0.08) + "px"
    });
    
    $('#menus .menu h1').css({
    	"font-size": Math.floor(height * 0.1) + "px"
    });
    
    $('#mainTitle').css({
    	"font-size": Math.floor(height * 0.13) + "px"
    });

    $('.menuHolder.withScroller').css('margin-top', Math.floor(height * -0.05) + "px");

	var scrollWrapperHeight = Math.floor(height * 0.57);
    $('#menus .menu .scrollWrapper').css({
    	"height": scrollWrapperHeight + "px",
    	"margin-top": Math.floor(height * 0.02) + "px"
    });
    
    $('#menus .menu .scrollWrapper p').css({
    	"font-size": Math.floor(height * 0.04)
    });
	
	$('#menus .menu .scrollWrapper .licence > *').css({
    	"font-size": Math.max(10, Math.floor(height * 0.02))
    });
   
	var scrollWrapperHeightOver10 = Math.floor(scrollWrapperHeight / 10);
	$('#statsMenuHolder .scroller > div tbody').css({
		'font-size': (scrollWrapperHeightOver10 - 2) + "px",
		'line-height': scrollWrapperHeightOver10 + "px",
		'margin-top': Math.floor((scrollWrapperHeight - (scrollWrapperHeightOver10 * 10)) / 2) + "px"
	});
        
	
    $('#gameOverMenu').css({
    	'padding-bottom': Math.floor(height * 0.04) + "px",
    	'margin-top': Math.floor(height * -0.18) + "px"
    });
    
    $('#gameOverMenu h1').css({
    	"font-size": Math.floor(height * 0.09) + "px"
    });

	$('#gameOverMenu h2').css({
		"margin-top": Math.floor(height * 0.04) + "px",
    	"font-size": Math.floor(height * 0.07) + "px"
    });

    $('#gameOverAward').css({
    	'font-size': Math.floor(height * 0.07) + "px"
    });
	
	var mouseSide = Math.max(cellSide % 2 ? cellSide + 1 : cellSide, 26);
	$('#mouse').css({
		height: mouseSide,
		width: mouseSide,
		'border-radius': (mouseSide / 2) + "px"
	});
	
	var optionsMenuHolder = $('#optionsMenuHolder').show();
	$('.option > .webding').each(function(i, el) {
		el = $(el);
		el.css("font-size", Math.floor(height * 0.06) + "px");
		el.css("top", Math.floor((el.parent().height() - el.height()) / 2) + "px");
	});
	optionsMenuHolder.hide();

    drawBackground(height, width, cellSide, cellBorderRadius);
}

//kicks off the game..
function init(){

	//create the table which will make the grid...
	var table = setUpTable();

    setGameDimensions(); //set initial sizes and draws background..
	//TODO: could do some cool animation..
    
	window.grid = new PuxxleGrid(table);

    //set up the pieces..
    var pieceHolders = document.querySelectorAll(".outerPieceHolder");
    window.pieces = [];
    for(var i = 0, len = pieceHolders.length; i < len; i++){
        window.pieces.push(new PuxxlePiece(pieceHolders[i], grid));
    }

	$('#game').css('visibility', 'hidden'); //initially not hidden due to android bug..
    setTimeout(function () {
        $('#background').css('opacity', 1);
    }, 50);
    setTimeout(function(){
		$('#mainMenuHolder').show();
		setTimeout(function() {
			$('#mainMenuHolder').css('opacity', 1);
		}, 50);
    }, 3000);

	//start background music on a loop..
	soundManager.playMusic("background");
 }

window.addEventListener('load', function() {
    init();
}, false);
