//Class to represent one of the phyiscal drag and dropable pieces, combines logic
//from the Piece class together with the Draggable class.

(function() {
	"use strict";
	
	var allPieceHolders = []; //keep track of all of them so that we can avoid two moving at once..

	function setOthersCanBeMoved(currentPieceHolder, canBeMoved) {
		for (var i = 0, len = allPieceHolders.length; i < len; i++) {
			var pieceHolder = allPieceHolders[i];
			if (pieceHolder !== currentPieceHolder) {
				pieceHolder.canBeMoved = canBeMoved;
			}
		}
	}

	var PuxxlePiece = window.PuxxlePiece = function(pieceHolderDiv, puxxleGrid){

		var subHolder = $(pieceHolderDiv).find('.pieceHolder');
		var subHolderStyle = subHolder[0].style;
		var piece = new Piece(pieceHolderDiv.querySelector(".piece"));

		var that = this;

		var pieceHolder = new Draggable(
			pieceHolderDiv,
			//drop callback..
			function(success, forced){
				setOthersCanBeMoved(pieceHolder, true);
				if(!success){
					subHolder.removeClass("held");
					piece.makeRotate();
					if (!forced) {
						soundManager.playSfx('disallowedDrop');
					}
					return;
				}
				
				//prevent piece doing anything..
				pieceHolder.canBeMoved = false;
				pieceHolder.ableToDrop = false;

				subHolderStyle['background-color'] = 'transparent';
				soundManager.playSfx('haul');

				puxxleGrid.haulIn(pieceHolder, piece, function(){
					var scoringCells = $(puxxleGrid.getScoringCells());
					scoreManager.pieceDropped(scoringCells); //handle score change..
					if(scoringCells.length > 0){
						soundManager.playSfx("score");
						var removeClsTimeout,
							removeClsDone = false;
						var removeCls = function(){
							if (removeClsDone) return; //already done..
							removeClsDone = true;
							clearTimeout(removeClsTimeout);
							//remove set colours..
							scoringCells.addClass("empty");
							scoringCells.removeClass(Puxxle.cssColours.join(" ") + " score");
							puxxleGrid.resetGridState();
							scoringCells.unbind("transitionEnd", removeCls);
						};
						removeClsTimeout = setTimeout(removeCls, 500);
						scoringCells.bind("transitionEnd", removeCls);
						scoringCells.addClass("score"); //enabled animation..
					}

					//Hide the piece holder - move it, reset it and show it again..
					subHolderStyle.visibility = 'hidden';
					setTimeout(function(){
						pieceHolder.setPosition(0,0); //move it..	
						subHolder.removeClass("held");
						subHolderStyle['background-color'] = '';
						piece.resetGrid(); //gets a new random piece..
						subHolderStyle.visibility = 'visible';

						//make piece active again..
						piece.makeRotate();
						if(puxxleGrid.isGameOver()){
							soundManager.playSfx('gameOver');
							scoreManager.onGameOver();
							menu.gameOver();
						}
						pieceHolder.canBeMoved = true;
				   }, 520);
				});
			},
			//can drop..
			function(work){
				return puxxleGrid.canFitPieceIn(pieceHolder, piece);
			},
			//on drag start..
			function(){
				piece.preventRotate(); 
				subHolder.addClass("held");
				soundManager.playSfx('pickUp');
				setOthersCanBeMoved(pieceHolder, false);
			}
		);
		
		allPieceHolders.push(pieceHolder);
		
		//store references to the new objects.
		this.piece = piece;
		this.pieceHolder = pieceHolder;
	};

	//Resets this piece..
	PuxxlePiece.prototype.reset = function(){
		this.piece.resetGrid();
	}

	//Returns a copy of the gird for this piece..
	PuxxlePiece.prototype.getCopyOfGrid = function(){
		return this.piece.getCopyOfGrid();   
	}

	//Returns a copy of the gird for this piece..
	PuxxlePiece.prototype.getCopyOfNextGrid = function(){
		return this.piece.getCopyOfNextGrid();   
	}

	//Causes this piece to be dropped..
	PuxxlePiece.prototype.forceDrop = function(){
		this.pieceHolder.forceDrop();
	}

})();