//Defines the demo object which can play the game based on instructions..
$(function(){

	/* instructions are -
		movePieceToGrid(holderId, row, col)
		rotate(pieceId, times)
		wait(ms)
	*/
	
	//Pre-recorded demos..
	var recordings = [
		{
			randomSeed: 111,
			instructions: [{"fn":"movePieceToGrid","params":["holder2",3,3]},{"fn":"movePieceToGrid","params":["holder3",5,4]},{"fn":"rotate","params":["piece1",1]},{"fn":"movePieceToGrid","params":["holder1",5,2]},{"fn":"rotate","params":["piece3",1]},{"fn":"movePieceToGrid","params":["holder3",4,1]},{"fn":"rotate","params":["piece2",1]},{"fn":"rotate","params":["piece2",1]},{"fn":"rotate","params":["piece2",1]},{"fn":"movePieceToGrid","params":["holder2",6,6]},{"fn":"rotate","params":["piece2",1]},{"fn":"rotate","params":["piece2",1]},{"fn":"movePieceToGrid","params":["holder2",3,6]},{"fn":"rotate","params":["piece2",1]},{"fn":"rotate","params":["piece2",1]},{"fn":"movePieceToGrid","params":["holder2",5,4]},{"fn":"movePieceToGrid","params":["holder1",6,2]},{"fn":"movePieceToGrid","params":["holder1",6,5]},{"fn":"rotate","params":["piece1",1]},{"fn":"rotate","params":["piece1",1]},{"fn":"movePieceToGrid","params":["holder1",5,1]},{"fn":"rotate","params":["piece2",1]},{"fn":"rotate","params":["piece2",1]},{"fn":"rotate","params":["piece2",1]},{"fn":"movePieceToGrid","params":["holder2",7,7]},{"fn":"movePieceToGrid","params":["holder2",4,4]},{"fn":"movePieceToGrid","params":["holder1",6,0]},{"fn":"movePieceToGrid","params":["holder2",6,1]},{"fn":"movePieceToGrid","params":["holder1",3,1]},{"fn":"rotate","params":["piece1",1]},{"fn":"movePieceToGrid","params":["holder1",5,3]},{"fn":"rotate","params":["piece1",1]},{"fn":"rotate","params":["piece1",1]},{"fn":"movePieceToGrid","params":["holder1",5,1]},{"fn":"movePieceToGrid","params":["holder3",4,5]}]
		},
		{
			randomSeed: 121,
			instructions: [{"fn":"movePieceToGrid","params":["holder1",3,3]},{"fn":"rotate","params":["piece3",1]},{"fn":"rotate","params":["piece3",1]},{"fn":"movePieceToGrid","params":["holder3",1,4]},{"fn":"movePieceToGrid","params":["holder1",4,4]},{"fn":"rotate","params":["piece1",1]},{"fn":"movePieceToGrid","params":["holder1",2,3]},{"fn":"movePieceToGrid","params":["holder2",3,1]},{"fn":"rotate","params":["piece1",1]},{"fn":"movePieceToGrid","params":["holder1",4,2]},{"fn":"movePieceToGrid","params":["holder2",5,6]},{"fn":"rotate","params":["piece3",1]},{"fn":"rotate","params":["piece3",1]},{"fn":"movePieceToGrid","params":["holder3",6,3]},{"fn":"rotate","params":["piece1",1]},{"fn":"rotate","params":["piece1",1]},{"fn":"rotate","params":["piece1",1]},{"fn":"movePieceToGrid","params":["holder1",4,3]},{"fn":"rotate","params":["piece2",1]},{"fn":"rotate","params":["piece2",1]},{"fn":"rotate","params":["piece2",1]},{"fn":"movePieceToGrid","params":["holder2",6,5]},{"fn":"movePieceToGrid","params":["holder3",6,3]},{"fn":"movePieceToGrid","params":["holder1",3,2]},{"fn":"rotate","params":["piece2",1]},{"fn":"rotate","params":["piece2",1]},{"fn":"movePieceToGrid","params":["holder2",5,1]},{"fn":"rotate","params":["piece2",1]},{"fn":"rotate","params":["piece2",1]},{"fn":"rotate","params":["piece2",1]},{"fn":"movePieceToGrid","params":["holder2",5,4]}]
		},
		{
			randomSeed: 101,
			instructions: [{"fn":"rotate","params":["piece2",1]},{"fn":"movePieceToGrid","params":["holder2",3,3]},{"fn":"movePieceToGrid","params":["holder2",5,2]},{"fn":"rotate","params":["piece3",1]},{"fn":"rotate","params":["piece3",1]},{"fn":"movePieceToGrid","params":["holder3",6,2]},{"fn":"rotate","params":["piece2",1]},{"fn":"rotate","params":["piece2",1]},{"fn":"rotate","params":["piece2",1]},{"fn":"movePieceToGrid","params":["holder2",5,3]},{"fn":"movePieceToGrid","params":["holder3",3,1]},{"fn":"rotate","params":["piece2",1]},{"fn":"movePieceToGrid","params":["holder2",4,2]},{"fn":"rotate","params":["piece2",1]},{"fn":"movePieceToGrid","params":["holder2",5,3]},{"fn":"movePieceToGrid","params":["holder2",6,5]},{"fn":"rotate","params":["piece3",1]},{"fn":"movePieceToGrid","params":["holder3",5,4]},{"fn":"movePieceToGrid","params":["holder2",7,6]},{"fn":"rotate","params":["piece3",1]},{"fn":"movePieceToGrid","params":["holder3",3,2]},{"fn":"movePieceToGrid","params":["holder2",4,1]},{"fn":"rotate","params":["piece3",1]},{"fn":"rotate","params":["piece3",1]},{"fn":"movePieceToGrid","params":["holder3",5,6]},{"fn":"rotate","params":["piece2",1]},{"fn":"movePieceToGrid","params":["holder2",4,5]},{"fn":"rotate","params":["piece3",1]},{"fn":"rotate","params":["piece3",1]},{"fn":"rotate","params":["piece3",1]},{"fn":"movePieceToGrid","params":["holder3",4,7]},{"fn":"rotate","params":["piece2",1]},{"fn":"movePieceToGrid","params":["holder2",5,7]}]
		}
	];

	var fps = 48; //the number of frames the events should try and match per second..
	var waitToNextFrame = Math.round(1000/fps);
	var $win = $(window);
	var defaultStartX = Math.round($win.width()/2);
	var defaultStartY = Math.round($win.height()/2);
	var touchEvents = Modernizr.touch;
	var mouseToTouchEvents = {
		mousedown: 'touchstart',
		mouseup: 'touchend',
		mousemove: 'touchmove'
	};
	
	//Calculates the time it should take for the mouse to move between
	//the given positions.  Note: was just 500ms for everything..
	var winHeight = $(window).height();
	function getTimeToMoveBetween(startPos, endPos) {
		//quick rough distance..
		var dist = (Math.abs(startPos.x - endPos.x) + Math.abs(startPos.y - endPos.y));
		var timeForDist = 500 * (dist / winHeight);
		return 500	+ dist;
	}
	
	//Appends events to the given array to move the mouse to the
	//desired location using the given target.
	function addEventsToMoveMouseTo(pos, events, target){
		var start = events.length ? events[events.length-1] : {
			timeStamp: 0,
			clientX: defaultStartX,
			clientY: defaultStartY,
			target: target
		};
		var startPos = { x: start.clientX, y: start.clientY };
		var startTime = start.timeStamp;
		var timeToTake = getTimeToMoveBetween(startPos, pos);
		var numEvents = (timeToTake / 1000) * fps;
		
		//add all but last event..
		for(var i = 0; i < numEvents - 1; i++){
			var tweenPos = tween.sinusoidalInOut(waitToNextFrame * i, startPos, pos, timeToTake);
			var next = {
				type: 'mousemove',
				//set time so that last is guarenteed to be on correct time..
				timeStamp: startTime + waitToNextFrame * i,
				clientX: tweenPos.x,
				clientY: tweenPos.y,
				target: target
			};
			events.push(next);
		}
		//add last one..
		events.push({
			type: 'mousemove',
			timeStamp: start.timeStamp + timeToTake,
			clientX: pos.x,
			clientY: pos.y,
			target: target
		});
	}
	
	//Gets the [x,y] location of the element with the given id,
	//if passed an element return the position for that.
	function getXYForId(id){
		var el = typeof id === 'string' ? $('#' + id) : $(id);
		var offset = el.offset();
		return {
			x: offset.left + el.outerWidth() / 2,
			y: offset.top + el.outerHeight() / 2
		};
	}
	
	//Function for specifically getting the picking point of a
	//pieceHolder - since it's not supposed to be in the direct center..
	function getXYForHolder(holder) {
		var offset = holder.offset();
		return {
			x: offset.left + holder.outerWidth() / 2,
			y: offset.top + holder.outerHeight() * 0.7
		};
	}
	
	function getXYForRowCol(row, col){
		return window.grid.getHaulPosition({ row: row, column: col });
	}
	
	var paused = false;
	var quit = false;

	//Fires the given array of events..
	function trigger(events, onFinished, mouse, mouseWidth, mouseHeight){
		if(!events || events.length <= 0 || quit){
			return;
		}
		if(paused) {
			setTimeout(function wait(){
				if(!quit){
					if(paused){
						setTimeout(wait, 100); //wait..
					} else {
						trigger(events, mouse, mouseWidth, mouseHeight); //continue..
					}
				} //else do nothing (cancel)..
			}, 100);
			return;
		}
		if(!mouse){
			mouse = $('#mouse');
			mouseWidth = mouse.outerWidth();
			mouseHeight = mouse.outerHeight();
		}

		var next = events.shift();

		mouse[0].style.transform = 'translate3d(' +
			(next.clientX - mouseWidth / 2) + 'px, ' +
			(next.clientY - mouseHeight / 2) + 'px, 0)';

		if(next.type === 'mousedown'){
			mouse.addClass('pressed');
		} else if(next.type === 'mouseup'){
			mouse.removeClass('pressed');
		}

		next.type = Modernizr.touch ? mouseToTouchEvents[next.type] : next.type;
		var target = next.target;
		var $event = $.Event(next.type);
		$.extend($event, next, {
			touches: [$.extend({}, next)]
		});
		$(target).trigger($event); //replay it..

		//recurse or stop..
		if(events.length > 0) {
			setTimeout(function(){
				trigger(events, onFinished, mouse, mouseWidth, mouseHeight);
			}, events[0].timeStamp - next.timeStamp);
		} else {
			demo.quit();
			if(onFinished){
				onFinished();
			}
		}
	}

	function addMouseEvent(type, pos, target, timeToTake, events){
		var timeStamp = events.length ?
			events[events.length-1].timeStamp + timeToTake : timeToTake;
		events.push({
			type: type,
			clientX: pos.x,
			clientY: pos.y,
			target: target,
			timeStamp: timeStamp
		});
	}

	//Lazily stores the maximum that a hauling point can be away before
	//it has a chance of dropping in the wrong cell..
	var maxColOut;
	var maxRowOut;
	
	var ops = {
		movePieceToGrid: function(holderId, row, col, eventsSoFar){
			var $el = $('#' + holderId);
			var pos = getXYForHolder($el);
			var el = $el[0];
			var cellPos = getXYForRowCol(row, col);

			//the event needs to move the peice to a location where it'll drop in cell..
			var elPos = $el.offset(); //should be a piece..
			var destPos = {
				x: cellPos.x + (pos.x - elPos.left),
				y: cellPos.y + (pos.y - elPos.top)
			};

			//add a few pixels so that the haulin effect can be observed..
			if(!maxColOut || !maxRowOut) {  //lazily initialise these..
				maxColOut = Math.floor(grid.pixelsPerCol / 2) - 2;
				maxRowOut = Math.floor(grid.pixelsPerRow / 2) - 2;
			}
			//Note: use old random so that it doesn't mess with demo..
			var diffX = Math.round(Math.oldRandom() * maxRowOut);
			var diffY = Math.round(Math.oldRandom() * maxColOut);
			destPos.x += Math.oldRandom() > 0.5 ? diffX : 0 - diffX;
			destPos.y += Math.oldRandom() > 0.5 ? diffY : 0 - diffY;

			addEventsToMoveMouseTo(pos, eventsSoFar, document);
			addMouseEvent('mousedown', pos, el, 150, eventsSoFar);
			ops.wait(100, eventsSoFar);
			addEventsToMoveMouseTo(destPos, eventsSoFar, el);		
			addMouseEvent('mouseup', destPos, el, 150, eventsSoFar);
			
			//wait a little bit..
			ops.wait(700, eventsSoFar);
		},
		rotate: function(pieceId, times, eventsSoFar, prevInstruction){
			var pos = getXYForId(pieceId);
			var $el = $('#' + pieceId);
			var el = $el[0];

			//only move if not there already..
			if(!prevInstruction || prevInstruction.fn !== 'rotate'
					|| prevInstruction.params[0] !== pieceId) {
				addEventsToMoveMouseTo(pos, eventsSoFar, document);
			} else {
				ops.wait(50, eventsSoFar);
			}
			for(var i = 0; i < times; i++){
				addMouseEvent('mousedown', pos, el, 200, eventsSoFar);		
				addMouseEvent('mouseup', pos, el, 200, eventsSoFar);
			}
		},
		wait: function(timeToWait, eventsSoFar){
			var lastEvent = eventsSoFar[eventsSoFar.length-1];
			if(lastEvent){
				addMouseEvent('mousemove', {
					x: lastEvent.clientX,
					y: lastEvent.clientY
				}, lastEvent.target, timeToWait, eventsSoFar);
			} else {
				addMouseEvent('mousemove', {
					x: defaultStartX,
					y: defaultStartY
				}, document.body, 0, eventsSoFar);
				addMouseEvent('mousemove', {
					x: defaultStartX,
					y: defaultStartY
				}, document.body, timeToWait, eventsSoFar);
			}
		}
	};

	var playCalled = false;
	
	window.demo = {
	
		//Sets the game up to play the given demo and resets paused and quit....
		prepareToPlay: function(instructions, randomSeed) {
			if(!instructions.length){
				var recording = recordings[instructions % recordings.length];
				randomSeed = recording.randomSeed;
			}
			Puxxle.setRandomSeed(randomSeed);  /* causes odd bug on ios safari */
			quit = false;
			paused = false;
			
			//position the mouse so that it's visible when the demo starts..
            var mouse = $('#mouse');
			mouse.removeClass('pressed').css({
				'visibility': 'visible'
			});
			
			mouse[0].style.transform = 'translate3d(' +
				(defaultStartX - mouse.outerWidth() / 2) + 'px, ' +
				(defaultStartY - mouse.outerHeight() / 2) + 'px, 0)';
		},
		
		pause: function() {
			paused = true;
		},
	
		resume: function() {
			paused = false;
		},
		
		quit: function() {
			quit = true;
			$('#mouse').css('visibility', 'hidden');
		},
	
		isRunable: function() {
			return !quit && !paused;
		},
	
		isOnScreen: function() {
			return !quit && playCalled;
		},
	
		//Given either some instructions, or just a number which
		//indicates the demo to play..
		play: function(instructions, onFinished){
			if(quit){
				return;
			}
			playCalled = true;
			
			if(!instructions.length){
				var recording = recordings[instructions % recordings.length];
				instructions = recording.instructions;
			}
			
			var events = [];
			var prevInstruction;
			for(var i = 0, len = instructions.length; i < len; i++){
				var instruction = instructions[i];
				var args = instruction.params.slice(0);
				args.push(events);
				args.push(prevInstruction);
				ops[instruction.fn].apply(window, args);
				prevInstruction = instruction;
			}
			trigger(events, onFinished);
		}
	};
	
});
