/* 
	Sets up the menu and attaches events for it. 
	Note: this could be massively improved and made part of a framework.
*/
$(function () {
	var touchEvents = Modernizr.touch;

    var menuButtonsActive = true; //boolean with setter to help state..
	var setMenuButtonsActive = function(newValue){
		menuButtonsActive = newValue;
		if(menuButtonsActive) {
			state.back(); //pops "animating" off..
		} else {
			state.pushState("animating");
		}
	};
	var pressAllowed = function(e){
		return menuButtonsActive && !(touchEvents && e.originalEvent.touches.length > 1);
	}
	
    var isEventInside = function(el, jQueryEvent){
        //cancel the event if it's not on element - matches touchupinside..
        if(touchEvents){
            var e = jQueryEvent.originalEvent;
            if(e.touches.length > 0)
                return false;
            //just pick the first changed event..
            if(e.changedTouches && e.changedTouches[0]){
                var touch = e.changedTouches[0];
                var $el = $(el);
                var offset = $el.offset();                
                if(touch.pageX < offset.left || touch.pageX > offset.left + $el.outerWidth())
                    return false;
                if(touch.pageY < offset.top || touch.pageY > offset.top + $el.outerHeight())
                    return false;
            }
        }
        return true;
    };

	var menus = $('#menus');
	var inGameMenuHolder = $('#inGameMenuHolder');
	var mainMenuHolder = $('#mainMenuHolder');
	var optionsMenuHolder = $('#optionsMenuHolder');
	var statsMenuHolder = $('#statsMenuHolder');
	var aboutMenuHolder = $('#aboutMenuHolder');
	var gameOverMenuHolder = $('#gameOverMenuHolder');
	var gameOverMenu = $('#gameOverMenu');
	var game = $('#game');

	//Make public object..
	window.menu = {};

	// Main menu controls..

	//shows the game and executes callback when complete if supplied..
	menu.showGame = function(callback) {
        setMenuButtonsActive(false);
        game.css('visibility', 'visible');
        setTimeout(function(){
        	menus.css('opacity', 0); //starts transition..
        	setTimeout(function(){
				mainMenuHolder.hide();
				mainMenuHolder.css('opacity', 0);
        		setTimeout(function(){
					menus.hide(); //"activates" the page..
        			game.css('opacity', 1); //trigger transition..
					if(callback){
						setTimeout(function(){
							setMenuButtonsActive(true);
							callback();
						}, 1000);
					} else {
						setMenuButtonsActive(true);
					}
        		}, 250);
        	}, 750);
        }, 50);
	};
	
	//All buttons..
	$('.menu h2, #rightButtons div').on(touchEvents ? 'touchend' : 'mouseup', function(e){
		if(!pressAllowed(e) || !isEventInside(this, e) || !$(this).hasClass('active'))
			return;
    	soundManager.playSfx("click");
    });
	
	// Specific buttons..
	
	$('#startGame').on(touchEvents ? 'touchend' : 'mouseup', function(e){
        if(!pressAllowed(e) || !isEventInside(this, e) || !$(this).hasClass('active')){
            return;
    	}
		state.pushState("game");
		menu.showGame();
    });

	function endDemo() {	
		demo.quit();
		setMenuButtonsActive(false);
		game.css('opacity', 0);
		mainMenuHolder.css('opacity', 1); //instant as hidden..
		setTimeout(function(){
			menus.show();
			mainMenuHolder.show();
			game.css('visibility', 'hidden');
			demoMask.hide();
			setTimeout(function(){
				menus.css('opacity', 1);
				setMenuButtonsActive(true);
				Puxxle.unsetRandomSeed();
			}, 50);
		}, 1100);
	}

	//set the demo mask up so that it reflects all user input..
	var demoMask = $('#demoMask');
	demoMask.on('touchstart touchend touchmove mouseup mousedown mousemove click', function(event){
        var originalEvent = event.originalEvent;
        if(originalEvent.type === 'mouseup' || (originalEvent.type === 'touchend' && originalEvent.touches.length === 0)){
			if(demo.isRunable()){ //not done yet..
				state.back(); //endDemo..
			}
		}
		event.stopImmediatePropagation();
		event.preventDefault();
		return false;
	});

	var demoNum = 0;
	$('#startDemo').on(touchEvents ? 'touchend' : 'mouseup', function(e){
        if(!pressAllowed(e) || !isEventInside(this, e) || !$(this).hasClass('active')){
            return;
    	}
		demoMask.show();
		demo.prepareToPlay(demoNum);
		state.pushState("demo");
		menu.showGame(function(){
			//noop in case that already quit..
			demo.play(demoNum, function(){ state.back(); });
			demoNum++;
		});
    });
	
	//Inits and returns a scroller which work inside the given holding div..
	function initScroller($holdingDiv) {
		return new iScroll($holdingDiv.find('.scrollWrapper')[0], {
		   /* useTransition: true, causes strange font effects on android */ 
		   hScrollbar:false,
		   vScrollbar:false
		});
	}
	
    var aboutScroller;
    $('#goToAbout').on(touchEvents ? 'touchend' : 'mouseup', function(e){
        if(!pressAllowed(e) || !isEventInside(this, e) || !$(this).hasClass('active'))
            return;
		state.pushState('about');
		setMenuButtonsActive(false);
        optionsMenuHolder.css('opacity', 0); //start animation..
		setTimeout(function(){
			optionsMenuHolder.hide();
			aboutMenuHolder.show();
			setTimeout(function(){
				setMenuButtonsActive(true);
				aboutMenuHolder.css('opacity', 1);								
				//set up the scrolling (only do it once)..
				if(!aboutScroller){
					aboutScroller = initScroller(aboutMenuHolder);
				} else {
					aboutScroller.scrollTo(0, 0);
				}
			}, 50);
		}, 1000);
    });

	//Stats..
	
    $('#goToStats').on(touchEvents ? 'touchend' : 'mouseup', function(e){
        if(!pressAllowed(e) || !isEventInside(this, e) || !$(this).hasClass('active'))
            return;
		state.pushState('stats');
		setMenuButtonsActive(false);
        mainMenuHolder.css('opacity', 0); //start animation..
		setTimeout(function(){
			mainMenuHolder.hide();
			statsMenuHolder.show();
			setTimeout(function(){
				setMenuButtonsActive(true);
				statsMenuHolder.css('opacity', 1);	
				//don't worry about making it scrollable for now..
			}, 50);
		}, 1000);
    });

	//Transitions from one menu to the next..
	menu.transition = function(fromMenuHolder, toMenuHolder) {
		setMenuButtonsActive(false);
		fromMenuHolder.css('opacity', 0);
		setTimeout(function(){
			fromMenuHolder.hide();
			toMenuHolder.show();
			setTimeout(function(){
				setMenuButtonsActive(true);
				toMenuHolder.css('opacity', 1);
			}, 50);
		}, 1000);
	};

	//In-game menu controls..

	menu.showMenu = function() {
		state.pushState("ingamemenu");
		menus.show();
        inGameMenuHolder.css('opacity', 1); //should not animate as not visible..
        inGameMenuHolder.show();
        setTimeout(function(){
            menus.css('opacity', 1);
		}, 50);
	};

    $('#openMenu').on(touchEvents ? 'touchend' : 'mouseup', function(e){
        if(!pressAllowed(e) || !isEventInside(this, e) || !$(this).hasClass('active'))
            return
		state.back();
    });

    menu.backToGameScreen = function(){
        menus.css('opacity', 0);
		state.pushState('game');
		setMenuButtonsActive(false);
        //would be better to use transitionendevent but it's a bit flakey..
        setTimeout(function(){
            menus.hide();
            inGameMenuHolder.hide();
            setMenuButtonsActive(true);
        }, 520);
    };

    //Make public so that it can be used elsewhere..
    window.resetGame = function(){
    	scoreManager.resetScore();
		grid.emptyGrid();
		$.each(pieces, function(i, piece){
		   piece.reset();     
		});
    };
    $('#restartGame').on(touchEvents ? 'touchend' : 'mouseup', function(e){
        if(!pressAllowed(e) || !isEventInside(this, e) || !$(this).hasClass('active'))
            return;
    	scoreManager.onGameOver();
		resetGame();
		state.back();
    });

	menu.backToMainMenu = function(currentMenuHolder) {
		setMenuButtonsActive(false);
		currentMenuHolder.css('opacity', 0); //start animation..
		game.css('opacity', 0);
		setTimeout(function(){
			currentMenuHolder.hide();
			game.css('visibility', 'hidden');
			mainMenuHolder.show();
			setTimeout(function(){
				setMenuButtonsActive(true);
				mainMenuHolder.css('opacity', 1);
				resetGame();
			}, 50);
		}, 1000);
	};
	
    $('#backToMainMenu').on(touchEvents ? 'touchend' : 'mouseup', function(e){
        if(!pressAllowed(e) || !isEventInside(this, e) || !$(this).hasClass('active'))
            return;
        state.back(true);
    });

	// Options menu..
	
	$('#goToOptions').on(touchEvents ? 'touchend' : 'mouseup', function(e){
        if(!pressAllowed(e) || !isEventInside(this, e) || !$(this).hasClass('active'))
            return;
		state.pushState("options");
        setMenuButtonsActive(false);
		mainMenuHolder.css('opacity', 0); //start animation..
		setTimeout(function(){
			mainMenuHolder.hide();
			optionsMenuHolder.show();
			setTimeout(function(){
				setMenuButtonsActive(true);
				optionsMenuHolder.css('opacity', 1);
			}, 50);
		}, 1000);
    });
	
	$('#goToOptionsInGame').on(touchEvents ? 'touchend' : 'mouseup', function(e){
        if(!pressAllowed(e) || !isEventInside(this, e) || !$(this).hasClass('active'))
            return;
		state.pushState("optionsInGame");
        setMenuButtonsActive(false);
		inGameMenuHolder.css('opacity', 0); //start animation..
		setTimeout(function(){
			inGameMenuHolder.hide();
			optionsMenuHolder.show();
			setTimeout(function(){
				setMenuButtonsActive(true);
				optionsMenuHolder.css('opacity', 1);
			}, 50);
		}, 1000);
    });
	
	//Game Over..

	menu.gameOver = function() {
		gameOverMenuHolder.show();
		state.pushState("gameOver");
		setTimeout(function(){
			gameOverMenu[0].style['transform'] = 'scale(1)'; //animates..
		}, 50);
	};
	
	function gameOverMainMenu() {
		setMenuButtonsActive(false);
        game.css('opacity', 0);
        menus.show();
        mainMenuHolder.css('opacity', 1); //should not animate..
        mainMenuHolder.show();
		setTimeout(function(){
			setMenuButtonsActive(true);
			game.css('visibility', 'hidden');
			resetGame();
			gameOverMenuHolder.hide();
			gameOverMenu[0].style['transform'] = 'scale(0)';
			menus.css('opacity', 1); //starts transition..
		}, 1000);
	}
	
	$('#gameOverMainMenu').on(touchEvents ? 'touchend' : 'mouseup', function(e){
        if(!pressAllowed(e) || !isEventInside(this, e) || !$(this).hasClass('active'))
            return;
        state.back(true);
	});
	
	function gameOverRetry() {
		//note: can't hide pop-up by animation as doesn't work on andriod..
        setMenuButtonsActive(false);
		resetGame();
        setTimeout(function(){
			gameOverMenuHolder.hide();
			gameOverMenu[0].style['transform'] = 'scale(0)';
			setMenuButtonsActive(true);
		}, 250);
	}
	
	$('#retry').on(touchEvents ? 'touchend' : 'mouseup', function(e){
        if(!pressAllowed(e) || !isEventInside(this, e) || !$(this).hasClass('active'))
            return;
        state.back();
	});
	
	//Generic buttons..

    $('.backButton').on(touchEvents ? 'touchend' : 'mouseup', function(e){
        if(!pressAllowed(e) || !isEventInside(this, e) || !$(this).hasClass('active'))
            return;
        state.back();
    });
	
	//All buttons..
	
	//Add/Remove styling when touched for all buttons - attach last so that
	//other handler know about whether button was active..
    $('.menu h2, #rightButtons div').on(touchEvents ? 'touchstart' : 'mousedown', function(e){
        if(!pressAllowed(e))
            return;
        $(this).addClass("active");
    }).on(touchEvents ? 'touchend' : 'mouseup', function(e){
        if(touchEvents && e.originalEvent.touches.length > 1)
            return;
        $(this).removeClass("active");
    }).on(touchEvents ? "touchcancel" : 'mouseout', function(e){
        if(touchEvents && e.originalEvent.touches.length > 1)
            return;
        $(this).removeClass("active"); //on case touchend doesn't fire as expected..
    });
	
	//Allow button events to be added elsewhere..
	menu.addButtonPressHandler = function($button, callback) {
		//use bind first plugin so that it comes before the generic buttons code..
		$button.bindFirst(touchEvents ? 'touchend' : 'mouseup', function(e){
			if(!pressAllowed(e) || !isEventInside($button[0], e) || !$button.hasClass('active'))
				return;
			callback(e);
		});
	};

	//a stack of the states we've added..    
    window.state = {
        stack: ['mainMenu'],
        pushState: function(state) {
            this.stack.push(state);
        },
        back: function (backTwo) {
            var currentState = this.stack.pop();
            if (backTwo)
                this.stack.pop();
            
            if(currentState === 'game') {
                //pause..
                menu.showMenu();
            } else if(currentState === "ingamemenu") {
                if (backTwo) {
                    scoreManager.onGameOver();
                    this.pushState("mainMenu");
                    menu.backToMainMenu(inGameMenuHolder);
                } else {
                    //back to game..
                    menu.backToGameScreen();
                }
            } else if(currentState === "mainMenu") {
                history.back(); //quit the game..
            } else if(currentState === "demo") {
                endDemo();
            } else if(currentState === "animating") {
                //call make when still in-between states..
                if(!menuButtonsActive) {
                    this.pushState("animating");
                }
            } else if(currentState === "about") {
                menu.transition(aboutMenuHolder, optionsMenuHolder);
            } else if(currentState === "stats") {
                menu.backToMainMenu(statsMenuHolder);
            } else if(currentState === "options") {
                menu.backToMainMenu(optionsMenuHolder);
            } else if (currentState === "optionsInGame") {
                menu.transition(optionsMenuHolder, inGameMenuHolder);
            } else if(currentState === "gameOver") {
                if(backTwo) {
                    gameOverMainMenu();
                } else {
                    gameOverRetry();
                }
            }
        }
	};
		
});
