//Deals with the game options..

$(function() {

	//try loading from local storage..
	var options = Util.getFromStorage("puxxle-options", {
		music: true,
		sfx: true
	});
	
	var musicButton = $('.musicOption');
	var sfxButton = $('.sfxOption');
	
	function setButtonAndSoundToProp(button, propName) {
		var prop = options[propName];
		
		var webding = button.find(".webding");
		if(prop) {
			webding.html("&#x2713");
			button.addClass("on");
		} else {
			webding.html("&#x2715");
			button.removeClass("on");
		}

		if (propName === "music") {
			soundManager.allowMusic(prop);
		} else {
			soundManager.allowSfx(prop);
		}
	}
	
	menu.addButtonPressHandler(musicButton, function(e) {
		options.music = !options.music;
		Util.setInStorage("puxxle-options", options);
		setButtonAndSoundToProp(musicButton, "music");
	});

	menu.addButtonPressHandler(sfxButton, function(e) {
		options.sfx = !options.sfx;
		Util.setInStorage("puxxle-options", options);
		setButtonAndSoundToProp(sfxButton, "sfx");
	});
	
	//set them initially and globally..
	setButtonAndSoundToProp(musicButton, "music");
	setButtonAndSoundToProp(sfxButton, "sfx");
	
	window.options = options;
});