//Sets up singleton which manages the scoring of the game and stats..
$(function(){
    
    var defaultStats = { topTen: [], version: Puxxle.version };
	var stats = Util.getFromStorage("puxxle-game-stats", defaultStats);
	if (stats.version !== Puxxle.version) {
		stats = defaultStats;
	}

	//Gets the position that the given score would be if it were added
	//to the top ten, returns -1 if it wouldn't be in the top ten..
	function getTopTenPosition(score) {
		var topTen = stats.topTen;
		var len = topTen.length;
		if (len === 0) {
			return 1;
		}
		for (var i = 0; i < len; i++) {
			if (score > topTen[i].score) {
				return i + 1;
			}
		}
		return -1;
	}
	
    function getFormattedDate() {
        var date = new Date();
        var monthPart = date.getMonth() + 1;
        if (monthPart < 10) {
            monthPart = "0" + monthPart;
        }
        var datePart = date.getDate();
        if (datePart < 10) {
            datePart = "0" + datePart;
        }
        return date.getFullYear() + "-" + monthPart + "-" + datePart; 
    }
    
	function updateStatsOnEndGame(totalScore){
		if (totalScore < 1) {
			return;
		}

		var topTen = stats.topTen;
		if(topTen.length < 10 || totalScore > topTen[9].score){
			topTen.push({
                score: totalScore,
                date: getFormattedDate(),
                timestamp: new Date().getTime()
            });
			topTen.sort(function(a, b) {
				var score = b.score - a.score;
				if (score === 0) {
					b.timestamp - a.timestamp;
				} else {
					return score;
				}
			});
			if(topTen.length > 10){
				topTen.pop();
			}
		}
		setStatsMenu();
		Util.setInStorage("puxxle-game-stats", stats);
	}
    
	//Matches the stats menu with the stats.. 
	function setStatsMenu() {
        var holder = document.querySelector('#statsMenuHolder .scroller > div tbody');
        holder.innerHTML = "";
    
        var frag = document.createDocumentFragment();
        var scores = stats.topTen;
        if (scores.length  == 0) {
            return;
        }
        for(var i = 0, len = scores.length; i < len; i++) {
            var score = scores[i];
            var tr = document.createElement('tr');
            
            var td = document.createElement('td');
            td.innerHTML = (i + 1) + ":" + "&nbsp;";
            tr.appendChild(td);
            
            td = document.createElement('td');
            td.innerHTML = score.date + "&nbsp;";
            tr.appendChild(td);
            
            td = document.createElement('td');
            td.innerHTML = Util.formatNumber(score.score);
            tr.appendChild(td);

            frag.appendChild(tr);
        }
        
        holder.appendChild(frag);
	}
	setStatsMenu(); //do it when ready..
	
    window.scoreManager = (function(){
		var scoreHolder = document.getElementById("scoreHolder");
        var scoreElem = document.getElementById("score");  
        var scorePreamble = document.getElementById('scorePreamble');
        var scorePlusElemHolder = document.getElementById("scorePlusHolder");
        var scorePlusElem = document.getElementById("scorePlus");
        var scorePlusTimeout;

		//gets the preamble for the pos-th highest score..
		var defaultPreamble = "Score: ";
		function getPreambleForPosition(pos) {
			return pos === 1 ? "Top " + defaultPreamble : defaultPreamble; 
		}
		
        //increases the score by the given amount..
        var increaseScore = function(amount){
            if(amount > 0){
				var currentScore = scoreElem.innerHTML * 1;
				var newScore = currentScore + amount;
				scoreElem.innerHTML = newScore;
				 
				scorePlusElem.innerHTML = amount;
				scorePlusHolder.style.opacity = 1;
				clearTimeout(scorePlusTimeout);
				scorePlusTimeout = setTimeout(function(){
					scorePlusHolder.style.opacity = 0;
				}, 2000);
				
				//set preamble if not in demo..
				if (!demo.isOnScreen()) {
					var currentPreamble = scorePreamble.innerHTML;
					var pos = getTopTenPosition(newScore);
					var nextPreamble = getPreambleForPosition(pos);
					if (currentPreamble !== nextPreamble) {
						soundManager.playSfx('topScore');
						scorePreamble.innerHTML = nextPreamble;
					}
					if (pos === 1) {
						scoreHolder.style.color = "gold";
					}
				}
			} else { //just hide plussed about..
				scorePlusHolder.style.opacity = 0;
			}
        };
        
        //return public functions..
        return {
            resetScore: function(){
                scoreElem.innerHTML = "0";
                scorePlusHolder.style.opacity = 0;
				scorePreamble.innerHTML = defaultPreamble;
				scoreHolder.style.color = "";
            },

            //This should be called whenever a piece is dropped on marathon
            //mode, even if the given list is empty.
            //scoringCells should be a list of cells which are adjacent and
            //are considered to be scoring one, as defined in the PuxxleGrid
            //class.
            pieceDropped: function(scoringCells){
                if(!scoringCells.length){
                    increaseScore(1); //token point for dropping something..
                    return;
                }
                var colours = Puxxle.cssColours;
                
                //get number of cells by colour..
                var numCellsByColour = {};
                for(var j = 0, jLen = scoringCells.length; j < jLen; j++){
                    var cell = scoringCells[j];
                    for(var i = 0, iLen = colours.length; i < iLen; i++){
                        var colour = colours[i];
                        if(cell.className.indexOf(colour) != -1){
                            var current = numCellsByColour[colour];
                            if(!current){
                                numCellsByColour[colour] = 1;
                            } else {
                                numCellsByColour[colour]++;
                            }
                            break; //can only have a single colour..
                        } 
                    }
                }
                
                var colourMultiplier = Object.keys(numCellsByColour).length;
                var points = 0;
                $.each(numCellsByColour, function(key, value){
                    points += value * value
                });
                increaseScore(points);
            },
            onGameOver: function() {
            	updateStatsOnEndGame(this.getScore());
            },
            getScore: function(){
                return scoreElem.innerHTML * 1;   
            }
        };
        
    }());

});
