﻿//loads audio files and allows them to be played..

$(function() {

	//Phonegap has Media - Chrome has Audio..
	//Note: currently the setVolume on phonegap is buggy - so don't use music fading.
	//Note: this can cause safari 5.1 to refresh page when it stops for
	//      some annoying reason..

	var inPhoneGap = /\/www\//.test(location);
	var mobileBrowser = navigator.userAgent.match(/Android|BlackBerry|iPhone|iPad|iPod|IEMobile/i);
	
	var sounds = {
		sfx: {
			click: {
				fileName: "multimedia_button_click.mp3",
				maxVolume: 1
			},
			haul: {
				fileName: "multimedia_rollover_034.mp3",
				maxVolume: 1
			},
			turn: {
				fileName: "multimedia_rollover_074.mp3",
				maxVolume: 0.9
			},
			gameOver: {
				fileName: "multimedia_rollover_008.mp3",
				maxVolume: 1
			},
			topScore: {
				fileName: "app_game_interactive_alert_tone_012.mp3",
				maxVolume: 1
			},
			score: {
				fileName: "science_fiction_console_or_control_surface_menu_sound.mp3",
				maxVolume: 0.3
			},
			disallowedDrop:	{
				fileName: "multimedia_minimise_window_sound_good_for_closing_windows_menus_etc.mp3",
				maxVolume: 0.7
			},
			pickUp: {
				fileName: "multimedia_rollover_034.mp3",
				maxVolume: 1,
			}
		},
		music: {
			background: {
				fileName: "the_underworld_dark_track_with_electro_orchestral_percussion_crime_thriller_etc.mp3",
				maxVolume: 0.9
			}
		}
	};

	//Simple object to store an audio track..	
	var Track = function(type, soundName) {
		var soundDef = this.soundDef = sounds[type][soundName],
			fileName = soundDef.fileName,
			maxVolume = soundDef.maxVolume,
			sound;

        //will just load on the fly and can only play one at a time..
        sound = new Audio();
        sound.src = fileName;
        sound.setVolume = function(volume) {
            this.volume = volume;
        };
        sound.stop = sound.pause;
		sound.setVolume(maxVolume);
	
		this.sound = sound;
		this.soundName = soundName;
		this.type = type;
		this.playing = false;
	};
	Track.prototype = {
		
		//plays this track at the current volume if not playing..
		play: function() {
			if (this.playing) {
				console.log("Play called on currently playing track");
				return;
			}
	
			if (this.type === 'music') {
                this.sound.loop = true;
            }
			this.sound.play();
            this.playing = true;
		},

		stop: function() {
			if (this.playing) {
				this.sound.stop();
				this.playing = false;
			} else {
				console.log("stop called on non-playing track.");
			}
		}
		
	};

	//Preload audio hack so not slow first time on phonegap..
    document.addEventListener("deviceready", function() {
		$.each(sounds.sfx, function(soundName, details) {
			var sound = new Media(details.fileName);
			sound.setVolume(0);
			sound.play();
			sound.stop();
		});
	}, false);

	var currentMusicTrack; //the currently playing music..
	var allowMusic = true;
	var allowSfx = true;
	
	var soundManager = {

		playSfx: function(soundName) {
			if (allowSfx) {
				var sound = new Track("sfx", soundName);
				sound.play();
			}
		},

		//plays the given music current track and replacing it..
		playMusic: function(soundName) {
			if (!currentMusicTrack || currentMusicTrack.soundName !== soundName) {
				var track = currentMusicTrack = new Track("music", soundName);
				if (allowMusic) {
					track.play(true);
				}
			}
		},

		//Can be called externally to cancel playing sounds..
		allowMusic: function(allowed) {
			allowMusic = allowed;

			if (allowed) {
				if (currentMusicTrack) {
					currentMusicTrack.play();
				}
			} else if (currentMusicTrack) {
				currentMusicTrack.stop();
			}
		},

		allowSfx: function(allowed) {
			allowSfx = allowed;
		}
	};
	
	//don't bother with mobile browsers as too bad..
	if (mobileBrowser && !inPhoneGap) {
		soundManager = {
			playSfx: $.noop,
			playMusic: $.noop,
			allowMusic: $.noop,
			allowSfx: $.noop
		};
	}

	window.soundManager = soundManager;
    
});
