//Defines some simple tweening functions..
(function(){

	//Obtains the position at the given time, using the given function to
	//calculate the factor that should be applied..
	function applyFactorFunc(time, startPos, endPos, duration, factorFunc) {
		var factor = time/duration;
		var diffX = endPos.x - startPos.x;
		var diffY = endPos.y - startPos.y;
		return {
			x: startPos.x + diffX * factorFunc(factor),
			y: startPos.y + diffY * factorFunc(factor)
		};
	}

	//Public..
	
	window.tween = {
		linear: function(time, startPos, endPos, duration, interpolation) {
			return applyFactorFunc(time, startPos, endPos, duration, function(factor){
				return factor;
			});
		},
		quadratic: function(time, startPos, endPos, duration) {
			return applyFactorFunc(time, startPos, endPos, duration, function(factor){
				return factor * factor;
			});
		},
		sinusoidalInOut: function(time, startPos, endPos, duration) {
			return applyFactorFunc(time, startPos, endPos, duration, function(factor){
				return 0.5 * (1 - Math.cos( Math.PI * factor));
			});
		}
	};
	
}());