var STEP_DELAY = 1800,
    QUESTION_TIME = 60000,
    MAX_SCORE = 10000,
    BONUS = 5000,
    HIGHSCORE = 0,
    TOPSCORES = [],
    QUESTIONS_ON_LEVEL = 4,
    EDUEVENTS_APIKEY = "VuGAoNFPp7QDqsTbJpn9gBeDdkaAnx",
    APP_VERSION = "1.2";
var DEFAULT_TRANSITION = 'flip';
var allQuestions, questionCounts;
var eduevents;
// DOM elements needed often/on every question will be cached here
var DomCache = {};

var messages = {};
messages.incorrect = ["Better luck next time!", "I got you there, didn't I?", "Try again!"];
messages.correct = ["That was all the fun!", "You sure know your Python!", "Amazing!"];
messages.timeout = ["Did you fall asleep?", "Timeout, you were too slow!"];

///////////// Begin utility functions //////////////////

var Utils = {
  // returns a new array with items number of random items from arr
  sampleArray: function(arr, items) {
    items = Math.min(arr.length, items);
    var tmpArr = $.extend(true, [], arr),
        newArr = [],
        rand;
    for (; items-- > 0; ) {
      rand = Math.floor(Math.random()*(tmpArr.length));
      newArr.push(tmpArr[rand]);
      tmpArr.splice(rand, 1);
    }
    return newArr;
  },
  // returns a random message of the given type
  randomMessage: function(type) {
    if (!messages[type]) {
      return "";
    }
    var msgs = messages[type];
    return msgs[Math.floor(Math.random()*msgs.length)];
  },
  // loads the questions from questions.json
  loadQuestions: function(callback){
    if (typeof(questionUrl) == "undefined") { 
      questionUrl = "questions.json";
    }
    $.getJSON(questionUrl, function(data) {
      allQuestions = [];
      $.each(data, function(index, quiz) {
        var diff;
        if ($.isArray(quiz) && quiz.length > 0) {
          diff = quiz[0].difficulty;
        } else {
          diff = quiz.difficulty;
        }
        var arr = allQuestions[diff - 1] || [];
        arr.push(quiz);
        allQuestions[diff - 1] = arr;
      });
      // .. call the callback function
      callback();
    });
  },
  // clear the question timer if it is set
  clearTimer: function() {
    DomCache.$timer.removeClass("active");
    
    if (Game.questionTimer) { // clear the question timeout
      clearTimeout(Game.questionTimer);
    }
  },
  logEvent: function(eventtype, objid, data) {
    // log using eduevents if it's available
    if (eduevents) {
      eduevents.logEduEvent(eventtype, objid, data);
    }
  }
};

/////////////// Begin functionality for the game ///////////

var Game = {
  qPos: 0,
  questionTimer: null,
  score: 0,
  questionStart: null,
  questions: null,
  lastDebug: false,
  setup: function() {
    // setup for game page
    $("#gamePage .answerChoices li").unbind("click").live("click", Game.answerQuestion);
    $("#stopTimer").unbind("click").bind("click", Lifelines.stopTimer);
    $("#helpRemove").unbind("click").bind("click", Lifelines.removeTwo);
    $("#helpSkip").unbind("click").bind("click", Lifelines.skipQuestion);
    $("#helpDebug").unbind("click").bind("click", Lifelines.debug);
  },
  // start asking questions
  start: function(e) {
    if (e) {
      e.preventDefault();
      e.stopPropagation();
    }
    if (window.plugins && window.plugins.AdMob) {
      window.plugins.AdMob.destroyBannerView();
    }
    // reset the game status..
    Game.lastDebug = false;
    DomCache.$total.text(0);
    Game.randomizeQuestions();
    Game.qPos = 0;
    Game.score = 0;
    // ..and reset other stuff in UI
    $("#lastDebug").hide();
    $("button[disabled]").prop("disabled", false);
    $("#highscore").removeClass("show").css("display", "block");

    Game.showQuestion(Game.questions[0]);
    Game.updateProgressBar(0, Game.questions.length);

    Utils.logEvent("initquiz", "question" + Game.questions[0].id);

    if ($(".ui-page-active").attr("id") !== "gamePage") {
      //$.mobile.changePage($("#gamePage"), {transition: "flip"});
      $(document).transition('to', 'gamePage', DEFAULT_TRANSITION);
    }
    $("#gamePage").removeClass("lost won answered");

    return false;
  },
  randomizeQuestions: function() {
    var i;
    if (typeof(questionCounts) == "undefined" || questionCounts.length != 5) {
      questionCounts = [QUESTIONS_ON_LEVEL, QUESTIONS_ON_LEVEL, 
                QUESTIONS_ON_LEVEL, QUESTIONS_ON_LEVEL, QUESTIONS_ON_LEVEL];
      for (i = questionCounts.length; i--; ) {
        if (allQuestions[i]) {
          // use at most 4
          questionCounts[i] = Math.min(QUESTIONS_ON_LEVEL, allQuestions[i].length);
        } else {
          questionCounts[i] = 0;
        }
      }
    }
    var qs = [];
    for (var difficulty = 0; difficulty < 5; difficulty++) {
      if (questionCounts[difficulty] === 0) {
        continue;
      }
      var sample = Utils.sampleArray(allQuestions[difficulty], questionCounts[difficulty]);
      for (i = sample.length - 1; i >= 0 ; i--) {
        var qu = sample[i];
        if ($.isArray(qu)) {
          qs.push(Utils.sampleArray(qu, 1)[0]);
        } else {
          qs.push(qu);
        }
      }
    }
    Game.questions = qs;
  },
  showNextQuestion: function() {
    DomCache.$score.hide();
    if (Game.qPos < Game.questions.length) {
      var qWrapper = $(".question-wrapper");
      qWrapper.addClass("old");
      setTimeout(function() {
        Game.showQuestion(Game.questions[Game.qPos]);
        qWrapper.removeClass("old");
      }, 150);
    } else {
      Game.qPos--; // it was already incremented in answerQuestion
      Utils.logEvent("solvedquiz", "qlpython", {questions: Game.qPos, score: Game.score});
      $("#gamePage").addClass("won");
      $("#game-feedback").text(Utils.randomMessage("correct"));
    }
  },
  showQuestion: function(q) {
    var choices = [];
    choices.push(q.correct);
    var incorrect = Utils.sampleArray(q.incorrect, 3);
    for (var i=3; i--; ) {
      choices.push(incorrect[i]);
    }
    choices = Utils.sampleArray(choices, 4);
    var html = "", correctIndex = -1;
    for (i=0; i < choices.length; i++) {
      html += "<li class='topcoat-button'>" + choices[i] + "</li>";
      if (choices[i] == q.correct) {
        correctIndex = i;
      }
    }
    DomCache.$answerChoices.html(html).parents(".ui-page").removeClass("answered");
    $(DomCache.$answerChoices[0]).data('correct', correctIndex);
    $("#gamePage .questionCode").text(q.code.join('\n'));
    if (q.type === 1) {
      $("#gamePage .question").text("What will the program print?");
    } else {
      $("#gamePage .question").html("What will be the final value of variable <code>" +
                                    q.title + "</code>?");
    }


    Utils.clearTimer(); // make sure we don't have an existing timer
    DomCache.$timer.addClass("active");
    Utils.logEvent("showquestion", "question" + q.id, "", {questionnumber: Game.qPos});
    
    Game.questionTimer = setTimeout(Game.questionTimeout, QUESTION_TIME);
    Game.questionStart = new Date();
    
  },
  questionTimeout: function() {
    Utils.logEvent("quiztimeout", "question" + Game.questions[Game.qPos].id, {questions: Game.qPos, score: Game.score});
    $("#game-feedback").text(Utils.randomMessage("timeout"));
    $("#gamePage").addClass("lost");
  },
  // update the progress bar
  updateProgressBar: function(pos, total) {
    var width = $(window).width() + 15,
        border = width*(1.0*pos/total);
    DomCache.$progress.removeClass("incorrect").css("width", 100.0*pos/total + "%");
  },
  // handle an answer to a question
  answerQuestion: function(evt) {
    if (evt) {
      evt.preventDefault();
      evt.stopPropagation();
    }
    var $this = $(this),
        $page = $this.parents(".ui-page");
    if ($this.hasClass("disabled") || $page.hasClass("answered")) { return false; }
    $page.addClass("answered");
    Utils.clearTimer();
    var questionEnd = new Date(),
        correct = ($this.text() == Game.questions[Game.qPos].correct),
        timediff = questionEnd - Game.questionStart,
        questionScore = MAX_SCORE*((QUESTION_TIME-timediff)/QUESTION_TIME);
    // scoring "function": fifth the points if answered after 4/5 the time,
    // otherwise proportional to the time spent of the max time
    questionScore = Math.floor(Math.max(MAX_SCORE/5, questionScore));
    if (correct) {

      $this.addClass("correct");
      Game.score += questionScore;

      Game.updateProgressBar(Game.qPos + 1, Game.questions.length);
      DomCache.$score.text(questionScore + " points!").show();

      Utils.logEvent("correct", "question" + Game.questions[Game.qPos].id, {questionscore: questionScore});
      Game.qPos++;
      setTimeout(Game.showNextQuestion, STEP_DELAY);
    } else {
      $this.addClass("incorrect");
      $(DomCache.$answerChoices.find("li")[$(DomCache.$answerChoices[0]).data('correct')]).addClass("correct");
      $("#gamePage").addClass("lost");
      correct = false;
      // log the question and answer
      Utils.logEvent("incorrect", "question" + Game.questions[Game.qPos].id, {answer: $this.text()});
      $("#game-feedback").text(Utils.randomMessage("incorrect"));
    }
    DomCache.$total.text(Game.score);
    return false;
  },
  end: function(msg, needDebug) {
    var $questionCode = $("#resultPage .questionCode"),
      addDebug = true;
    DomCache.$score.hide().removeClass("incorrect");
    if (typeof needDebug === "boolean") {
      addDebug = needDebug;
    }
//    if (addDebug) { // make sure debug last button is shown when needed
//      $("#debugLast").show();
//      Game.lastDebug = true;
//    } else { // .. and only when needed
//      $("#debugLast").hide();
//    }
    var feedback = "You made it to question " + (Game.qPos+1) + "\n\nQuestions score: " + Game.score;
    if ($("#helpDebug").prop("disabled")) {
      // debug lifeline used, give bonus for using it for learning
      Game.score += BONUS;
      feedback += "\n+" + BONUS + " debug lifeline used";
    }
    if (!$("#helpSkip").prop("disabled")) {
      // skip lifeline not used, give bonus
      Game.score += BONUS;
      feedback += "\n+" + BONUS + " skip lifeline not used";
    }
    if (!$("#helpRemove").prop("disabled")) {
      // remove two lifeline not used, give bonus
      Game.score += BONUS;
      feedback += "\n+" + BONUS + " remove two lifeline not used";
    }
    if (!$("#stopTimer").prop("disabled")) {
      // stop time lifeline not used, give bonus
      Game.score += BONUS;
      feedback += "\n+" + BONUS + " stop time lifeline not used";
    }
    feedback += "\n\nYour Total Score: " + Game.score;
    // show a message that was passed
//    $("#resultPage .question").text(msg);

    var newScore = [new Date().getTime(), Game.score];
    TOPSCORES.push(newScore);
    TOPSCORES.sort(function(a, b) {
      if (b[1] !== a[1]) { // first sort by score
        return (b[1] - a[1]);
      } else { // then by time (newest first)
        return (b[0] - a[0]);
      }
    });
    // cut the score list down to 10
    if (TOPSCORES.length > 10) {
      TOPSCORES.splice(10, TOPSCORES.length - 10);
    }
    // find the position of the new score
    var scorePos = -1;
    TOPSCORES.forEach(function(item, index) {
      if (item[0] === newScore[0]) {
        scorePos = index;
      }
    });
    var $topscores = $("#topscores tbody"),
      topscoretext = "";
    for (var i=0, l=TOPSCORES.length; i < l; i++) {
      topscoretext += "<tr><td>" + (i+1) + ":</td><td>" + prettyDate(TOPSCORES[i][0]) + "</td><td>" + TOPSCORES[i][1] + " points</td></tr>";
    }
    $topscores.html(topscoretext);
    // mark the new score as changed
    if (scorePos !== -1) {
      var tr = $topscores.find("tr").eq(scorePos);
      tr.find("td").addClass("changed");
    }

    window.localStorage.setItem("topscores", JSON.stringify(TOPSCORES));

    // log the event
    Utils.logEvent("quizend", "question" + Game.questions[Game.qPos].id, {questions: Game.qPos+1, score: Game.score});
    // handle new highscore (if such)
    if (Game.score >= HIGHSCORE) {
      // if a new highscore, store the new score
      HIGHSCORE = Game.score;
      if (window.localStorage) {
        window.localStorage.setItem("highscore", Game.score);
      }
      // .. and animate the badge when showing the result page
      var showHighscore = function() {
        $("#highscore").addClass("show");
        $(this).unbind("pageshow", showHighscore);
      };
      $("#resultPage").bind("pageshow", showHighscore);

      // .. and add the buttons to share the record
      var shareButtons = new IceCube.ShareButtons("Yay, I just got " + HIGHSCORE + " points on Quiz&Learn Python!",
          { url: "http://mobileicecube.com/quiz-learn-python/", eduevents: eduevents});
      $("#resultPage .shareButtons").html("Share your highscore: " + shareButtons.html()).addClass("show");
      shareButtons.attachListeners($("#resultPage .shareButtons")[0]);
    } else {
      // .. not a new highscore, make sure the badge is hidden
      $("#highscore").removeClass("show");
      $("#resultPage .shareButtons").removeClass("show");
    }
    $questionCode.text(feedback);
    // at this point, we are ready to switch to the result page
    //$.mobile.changePage($("#resultPage"), {reverse: false, transition: "flip" });
    $(document).transition('to', 'resultPage', DEFAULT_TRANSITION, false);
    // once the page has shown, scroll the result table to show the new score
    if (Game._scoreScroller) {
      $(document).off("pageshow", Game._scoreScroller);
    }
    Game._scoreScroller = function(evt, $page) {
      if ($page.id === "resultPage" && scorePos !== -1) {
        // Magic numbers, since the element won't be visible until pagechange
        // +5 at end to partially hide first/last row to indicate scrollability
        var scrollTop = (scorePos+0.5)*18 - 72/2 + 5,
            scoreWrap = $(".scoreWrapper");
        scoreWrap[0].scrollTop = Math.max(0, scrollTop);
      }
    };
    $(document).on("pageshow", Game._scoreScroller);
  }
};

////////////// Begin code for the lifeline buttons ///////////
  var Lifelines = {
    stopTimer: function(e) {
      e.preventDefault();
      e.stopPropagation();
      if ($("#stopTimer").prop("disabled")) { return false; }
      $("#stopTimer").prop("disabled", true);
      Utils.clearTimer();
      Utils.logEvent("stoplifeline", "question" + Game.questions[Game.qPos].id);
    },
    removeTwo: function(e) {
      e.preventDefault();
      e.stopPropagation();
      if ($("#helpRemove").prop("disabled")) { return false; }
      Utils.clearTimer();
      $("#helpRemove").prop("disabled", true); // disable Remove 2 button
      var randompos,
         correct = Game.questions[Game.qPos].correct,
         $choices = $("#gamePage .answerChoices li").filter(function(index) {
           return $(this).text() != correct;
         });
      // $choices is a $ list of the li elements (answer choices).
      // above the correct choice is removed from the selection
      // below: disable twice a random element and update the jQ list
      randompos = Math.floor(Math.random()*$choices.size());
      $($choices[randompos]).addClass("disabled").unbind("click");
      $choices = $choices.not(".disabled");
      randompos = Math.floor(Math.random()*$choices.size());
      $($choices[randompos]).addClass("disabled").unbind("click");

      Utils.logEvent("removelifeline", "question" + Game.questions[Game.qPos].id);
    },
    skipQuestion: function(e) {
      e.preventDefault();
      e.stopPropagation();
      if ($("#helpSkip").prop("disabled")) { return false; }
      Utils.clearTimer();
      $("#helpSkip").prop("disabled", true);

      Utils.logEvent("skiplifeline", "question" + Game.questions[Game.qPos].id);

      Game.qPos++;
      Game.updateProgressBar(Game.qPos, Game.questions.length);      
      
      setTimeout(Game.showNextQuestion, STEP_DELAY/3);
    },
    debug: function(e) {
      e.preventDefault();
      e.stopPropagation();
      if ($("#helpDebug").prop("disabled")) { return false; }
      Utils.clearTimer();
      $("#helpDebug").prop("disabled", true);

      Utils.logEvent("debuglifeline", "question" + Game.questions[Game.qPos].id);

//      $.mobile.changePage($("#debugPage"), {transition: "flip"});
      $(document).transition('to', 'debugPage', DEFAULT_TRANSITION);
    }
  };

///////////// Begin functionality for DEBUG PAGE //////////////////
var Debug = {
  pos: 0,
  trace: null,
  history : [],
  initializeDebugger: function() {
    var debuggedQuestion = Game.questions[Game.qPos];
    var codelines = debuggedQuestion.code,
        str = "", length = codelines.length,
        addnbsp = function(line) {
          return line.replace(/ /g,"&nbsp;");
        };
    for (var i = 0; i < length; i++) {
      str += "<li>" + addnbsp(codelines[i]) + "</li>";
    }
    Debug.trace = debuggedQuestion.trace;
    Debug.pos = 0;
    $("#debugPage .frame").remove();
    Debug.stackFrame("Global variables");
    $("#output").hide().find("div").html("");
    $("#debugPage .question").text((debuggedQuestion.type === 1?"What will the program print":
                                    "What will be the final value of variable ") +
                                   debuggedQuestion.title + "?");
    $("#codeLines").html(str).children().eq(Debug.trace[0].line - 1).addClass("current");
    $("#forw").unbind("click").prop("disabled", false).bind("click", Debug.forward); // unbind, in case it was left bound
    if (Game.lastDebug) {
      $("#closeDebug").text("My Results");
      $("#debugPage .homelink").css("display", "block");
    } else {
      $("#closeDebug").text("Close");
      $("#debugPage .homelink").css("display", "none");
    }
    $("#back").unbind("click").prop("disabled", true);
    Debug.history = [];
  },
  stackFrame: function(title) {
    var frame = $("<div class='frame'><h2>" + title + "</h2><table><tbody></tbody></table></div>");
    var container = $("#debugPage .frame").first();
    if (container.size() === 0) {
      container = $("#output");
    }
    frame.insertBefore(container);
    return frame.find("tbody");
  },
  updateVars: function(vars, $container) {
    var key;
    if ("added" in vars) {
      for (key in vars.added) {
        if ($container.find(".var" + key).size() === 0) {
          $container.append("<tr class='var" + key + " new'><td>" + key + "</td><td>" + 
                  vars.added[key] + "</td></tr>");
        }
      }
    }
    var animCallback = function() {
      $(this).remove();
    };
    if ("deleted" in vars) {
      for (key in vars.deleted) {
        $container.find(".var" + key).addClass("deleted").animate({opacity: 0}, 900, animCallback);
      }
    }
    if ("changed" in vars) {
      for (key in vars.changed) {
        $container.find(".var" + key + " td").last().toggleClass("changed")
              .text(vars.changed[key]);
      }
    }
  },
  updateCodeline: function(traceitem) {
    $(".current, .prev").removeClass("prev current");
    if (traceitem.type !== "end") {
      $("#codeLines").children("li").eq(traceitem.line - 1).addClass("current");
      $("#codeLines").children("li").eq(Debug.trace[Debug.pos-1].line - 1).addClass("prev");
    }
  },
  applyReturnAction: function(traceitem) {
    Debug.updateCodeline(traceitem);
    $(".new, .changed").removeClass("new changed");
    var $frame = $("#debugPage .frame").first().addClass("returned"),
        $title = $frame.find("h2"),
        line = $frame.find("tbody").data("call-line");
    $frame.find("table").animate({opacity: 0}, 900, function() {$(this).remove();});
    $title.html($title.html().replace("function call", "return") + "&rarr;" + traceitem.value);
    $(".current").removeClass("current");
    $("#codeLines").children("li").eq(line - 1).addClass("current");
    if ("globals" in traceitem) {
      Debug.updateVars(traceitem.globals, $("#debugPage .frame").last().find("tbody"));
    }
  },
  applyCallAction: function(traceitem) {
    $(".returned").remove();
    var title = "function call " + traceitem.name + "(";
    if ("args" in traceitem) {
      var args = traceitem.args;
      for (var i=0, l=args.length; i < l; i++) {
        title += traceitem.locals.added[args[i]];
        if (i < l - 1) {
          title += ", ";
        }
      }
    }
    title += ")";
    var $tbody = Debug.stackFrame(title);
    $tbody.data("call-line", Debug.trace[Debug.pos - 1].line);
    $(".new, .changed").removeClass("new changed");
    Debug.updateCodeline(traceitem);
  },
  applyLineAction: function(traceitem) {
    $(".returned").remove();
    var $tbody = $("#debugPage .frame").first().find("tbody");
    $(".new, .changed").removeClass("new changed");
    if ("locals" in traceitem) {
      Debug.updateVars(traceitem.locals, $tbody);
    }
    if ("globals" in traceitem) {
      Debug.updateVars(traceitem.globals, $("#debugPage .frame").last().find("tbody"));
    }
    Debug.updateCodeline(traceitem);
    if ("output" in traceitem && traceitem.output) {
      var op = traceitem.output;
      var $op = $("#output").show().find("div");
      $op.append(op);
    }
  },
  apply: function(action, undo) {
    if (undo) {
      $("#debugPage .debugContent").html(Debug.history.pop());
      return;
    }
    Debug.history.push($("#debugPage .debugContent").html());
    switch (action.type) {
      case "line":
        Debug.applyLineAction(action);
        break;
      case "end":
        Debug.applyLineAction(action);
        break;
      case "call":
        Debug.applyCallAction(action);
        break;
      case "return":
        Debug.applyReturnAction(action);
        break;
    }
  },
  forward: function(e) {
    e.preventDefault();
    e.stopPropagation();
    
    if (Debug.pos < Debug.trace.length - 1) {
      Debug.pos++; // first increase
      Debug.apply(Debug.trace[Debug.pos]);
    }
    if (Debug.pos === 1) {
      $("#back").bind("click", Debug.backward).prop("disabled", false);
    }
    if (Debug.pos === Debug.trace.length - 1) {
      $("#forw").prop("disabled", true).unbind("click");
    }
  },
  backward: function(e) {
    e.preventDefault();
    e.stopPropagation();
    if (Debug.pos > 0) {
      Debug.apply(Debug.trace[Debug.pos], true);
      Debug.pos--;
    }
    // we were at the end, now we are one step from it
    if (Debug.pos === Debug.trace.length - 2) {
      $("#forw").prop("disabled", false).bind("click", Debug.forward);
    }
    if (Debug.pos === 0) { // at the beginning, disable button
      $("#back").prop("disabled", true).unbind("click");
    }
  },
  close: function(e) {
    e.preventDefault();
    e.stopPropagation();
    Debug.history = []; // clear the history already
    if (Game.lastDebug) {
      Game.end();
    } else {
      //$.mobile.changePage($("#gamePage"), {transition: "slide", reverse: true});
      $(document).transition('to', 'gamePage', DEFAULT_TRANSITION, true);
    }
  }
};
///////////// End functionality for DEBUG PAGE //////////////////

// get the highscore from the localstorage
if (window.localStorage) {
  HIGHSCORE = window.localStorage.getItem("highscore") || 0;
  TOPSCORES = $.parseJSON(window.localStorage.getItem("topscores")) || [];
}

// check which event to bind to, default document.ready
var readyEvent = "ready";
if ("cordova" in window) { // on phonegap, use deviceready
  readyEvent = "deviceready";
}
// set things up once the page is loaded
$(document).bind(readyEvent, function() {
   // initialize the eduevents logging support
   if (readyEvent === "deviceready") {
     eduevents = new IceCube.EduEvents({version: APP_VERSION,
       startTime: window.START_TIME,
       apikey: EDUEVENTS_APIKEY});
     $(document.body).trigger("qlpython-ready");
     // handle showing adds on main and result pages
     if (window.plugins && window.plugins.AdMob) {
       $(document).on("pageshow", function (evt, $page) {
         if ($page.id === "resultPage" || $page.id === "mainPage") {
           // display a banner at startup
           window.plugins.AdMob.createBannerView({bannerAtTop: $page.id === "mainPage"});
         } else if ($page.id === "aboutPage" || $page.id === "helpPage") {
            // do nothing, here just to make it clear that ads should not be hidden on
            // those pages, which are only accessible from the main page
         } else {
           window.plugins.AdMob.destroyBannerView();
         }
       });
       window.plugins.AdMob.createBannerView();
     }
   }

   // initialize FastClick
   FastClick.attach(document.body);

   if (typeof _gaq !== "undefined") { // analytics for web
     Utils.logEvent = function(category, action, label, value) {
       if (typeof _gaq !== "undefined") {
         _gaq.push(['_trackEvent', category, action, label, value]);
       }
     };
   }
      
    // get back to main page to make page reloads work properly
    if ($(".ui-page-active").attr("id") !== "mainPage") {
      //$.mobile.changePage($("#mainPage"), {transition: "flip"});
      $(document).transition('to', 'mainPage', DEFAULT_TRANSITION);
    }

   Utils.loadQuestions(function() {
      //$("#playLink").css("display", "block");
  
      // setup for main page
      $("#playLink").bind("click", Game.start);
   });
   
  // initialize the cached DOM elements
  DomCache.$answerChoices = $("#gamePage .answerChoices");
  DomCache.$score = $("#score");
  DomCache.$timer = $("#timer");
  DomCache.$total = $("#total");
  DomCache.$progress = $("#progress .progress-bar");
  
  // init Game
  Game.setup();

  // setup for result page
  $("#resultPage .answerChoices li").bind("click", function(e) {
    e.preventDefault();
    e.stopPropagation();
    if (this.id === "debugLast") {
    }
    Game.start();
  });
  $("#debugPage").bind("pagebeforeshow", Debug.initializeDebugger);
  $("#closeDebug").bind("click", Debug.close);
  $("#debugLast").bind("click", function() {
    Game.lastDebug = true;
    Utils.logEvent("debuglast", "question" + Game.questions[Game.qPos].id);
    $(document).transition('to', 'debugPage');
    return;
  });
  $("#showResult").bind("click", function() {
    Game.end();
  });

  // add handlers to link buttons (.button.link) in the options view
  var links = document.querySelectorAll("#aboutPage .link"),
       linkHandler = function(evt) {
         // if something other than the LI element was clicked, get the li parent
         var target = evt.target,
             nodeName = target.nodeName.toLowerCase();
         while (nodeName !== "li" && nodeName !== "span") {
           target = target.parentNode;
           nodeName = target.nodeName.toLowerCase();
         }
         // the url is in the data-url attribute
         var openTarget = "_system";
         if (window.device && window.device.platform === "firefox") {
          console.log("FFOS");
          openTarget = "_blank";
         }
         window.open(target.dataset.url, openTarget);
       };
   // go through the links and add the click handler
   for (var i = links.length; i--; ) {
     links[i].addEventListener("click", linkHandler);
   }

   // bind the pause event to clear the timer
  $(document).bind("pause", function() {
    Utils.clearTimer();
  });
  // bind the cordova resume event to reset the game on resume
   $(document).bind("resume", function() { 
    Utils.clearTimer();
    var pageId = $(".ui-page-active").attr("id");
     // only end the game if we were on the gamePage
    if (pageId === "gamePage") {
      Game.end(Utils.randomMessage("timeout"));
    }

  });
  if (navigator && navigator.splashscreen) {
    navigator.splashscreen.hide();
  }
});// end readyEvent handler
