(function() {
  'use strict';
  var module = angular.module('app', ['onsen', 'lbServices', 'ngSanitize', 'feeds']);

  module.config(function(LoopBackResourceProvider, $httpProvider) {
    //TODO: get CORS working
    $httpProvider.defaults.useXDomain = true;
    delete $httpProvider.defaults.headers.common['X-Requested-With'];


    // Change the URL where to access the LoopBack REST API server
    LoopBackResourceProvider.setUrlBase('http://bikefest.herokuapp.com/api');
  });
  module.controller('AppController', function($scope, $data) {
    $scope.doSomething = function() {
      setTimeout(function() {
        alert('tappaed');
      }, 100);
    };

  });

  module.controller('DetailController', function($scope, $data) {
    $scope.item = $data.selectedItem;

    $scope.showDesc2 = function(type) {
      $scope.ons.navigator.pushPage('desc2.html', {
        param: type
      });

    }
  });

  module.controller('MasterController', function($scope, $data, Activity) {
    $scope.items = $data.items;
    Activity.find().$promise.then(
      function(data) {
        $scope.activities = data;
        console.log(data);
      }
    );
    $scope.showDetail = function(index) {
      var selectedItem = $data.items[index];
      $data.selectedItem = selectedItem;
      $scope.ons.navigator.pushPage('detail.html', {
        title: selectedItem.title
      });
    };
  });

  module.controller('Desc2Controller', function($scope, $data) {

    var page = $scope.ons.navigator.getCurrentPage();
    if (page.options.param == 'desc') {
      $scope.stuff = $data.selectedItem.description2;

    } else {
      $scope.stuff = $data.selectedItem.onTheDay;

    }

  });


  module.factory('$data', function(Activity) {
    var data = {};
    data.items = [];
    Activity.find().$promise.then(
      function(serverData) {
        console.log(serverData);

        for (var i = 0; i < serverData.length; i++) {
          data.items.push(serverData[i])
        }
      }
    );


    //data.items = [
    //    {
    //        title: 'Item 1 Title',
    //        label: '4h',
    //        desc: 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.'
    //    },
    //    {
    //        title: 'Another Item Title',
    //        label: '6h',
    //        desc: 'Ut enim ad minim veniam.'
    //    },
    //    {
    //        title: 'Yet Another Item Title',
    //        label: '1day ago',
    //        desc: 'Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.'
    //    },
    //    {
    //        title: 'Yet Another Item Title',
    //        label: '1day ago',
    //        desc: 'Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur.'
    //    }
    //];
    console.log(data.items);
    return data;
  });
})();