var lock;

var app = {
    initialize: function() {
        this.bindEvents();
    },
    
    bindEvents: function() {
        window.addEventListener('load', this.onDeviceReady, false);
        
    },

    onDeviceReady: function() {
      lock = window.navigator.requestWakeLock('screen');
        // analytics.startTrackerWithId('UA-52337027-1');
        // analytics.trackView('QueSorte');
    },
};


function s(val){
  return document.querySelector(val);
}

// ANIMAÇÃO CAPA
setTimeout(function(){
  s("#logo").className = "logo";
  s("#carregando").style.display = "none";
  s("#home .form").style.opacity = 1;
},2000);


// TRANSIÇÕES DE TELA
function mudarPagina(off,on) {
 setTimeout(function(){
 	if(on == "sobre"){
 		s("#" + off).className = "disableAll";
		s("#" + on).className = "active "+off;
 	} else {
	 	s("#" + off).className = "disable";
		s("#" + on).className = "active";
 	}
 },0);
}

// GERAR SORTE
function gerarSorte(val) {

  var megasena = new Array();
  var numeros;
  var qtdNum;
  if(val == 6){
    qtdNum = 59;
  }else {
    qtdNum = 79;
  }

  var i = 0;
  while(i < val){
    numeros = Math.round(Math.random() * qtdNum + 1);
    if(megasena.indexOf(numeros) == -1){
      megasena.push(numeros);
      i++;
    }
  }

  for (indice=0; indice < megasena.length; indice++){
    if(val == 6){
      if (megasena[indice] >= 0 && megasena[indice] < 10) {
        s("#mg"+indice).textContent = "0"+megasena[indice];
      } else {
        s("#mg"+indice).textContent = megasena[indice];
      }
    } else {
      if (megasena[indice] >= 0 && megasena[indice] < 10) {
        s("#qn"+indice).textContent = "0"+megasena[indice];
      } else {
        s("#qn"+indice).textContent = megasena[indice];
      }
    }
  }
}

// HOME -> TELA MEGA
Hammer(s("#botoes-home .mega")).on("tap", function() {
  mudarPagina('home','mega');
});

// HOME -> TELA QUINA
Hammer(s("#botoes-home .quina")).on("tap", function() {
  mudarPagina('home','quina');
});

// HOME -> TELA RESULTADOS
Hammer(s("#botoes-home .resultados")).on("tap", function() {
  mudarPagina('home','resultados');
});

// TELA MEGA -> HOME
Hammer(s("#mega header .back")).on("tap", function() {
  mudarPagina('mega','home');
});

// TELA QUINA -> HOME
Hammer(s("#quina header .back")).on("tap", function() {
  mudarPagina('quina','home');
});

// TELA RESULTADOS -> HOME
Hammer(s("#resultados header .back")).on("tap", function() {
  mudarPagina('resultados','home');
});

// TELA MEGA -> TELA SOBRE
Hammer(s("#mega header .bt-sobre")).on("tap", function() {
  mudarPagina('mega','sobre');
});

// TELA QUINA -> TELA SOBRE
Hammer(s("#quina header .bt-sobre")).on("tap", function() {
  mudarPagina('quina','sobre');
});

// TELA RESULTADOS -> TELA SOBRE
Hammer(s("#resultados header .bt-sobre")).on("tap", function() {
  mudarPagina('resultados','sobre');
});

// TELA SOBRE -> TELA MEGA
Hammer(s("#bk-mega")).on("tap", function() {
  mudarPagina('sobre','mega');
});

// TELA SOBRE -> TELA QUINA
Hammer(s("#bk-quina")).on("tap", function() {
  mudarPagina('sobre','quina');
});

// TELA SOBRE -> TELA RESULTADOS
Hammer(s("#bk-resultados")).on("tap", function() {
  mudarPagina('sobre','resultados');
});

// RESULTADO QUINA
Hammer(s("#logoQuina")).on("tap", function() {
  setTimeout(function(){
    s("#ctt_mega").style.display = "none";
    s("#ctt_quina").style.display = "block";
    s("#logoQuina").className = "btAtivo";
    s("#logoMega").className = "";
  },0);
});

// RESULTADO MEGA
Hammer(s("#logoMega")).on("tap", function() {
  setTimeout(function(){
    s("#ctt_mega").style.display = "block";
    s("#ctt_quina").style.display = "none";
    s("#logoQuina").className = "";
    s("#logoMega").className = "btAtivo";
  },0);
});

// GERAR MEGA
Hammer(s("#gerarMega")).on("tap", function() {
  gerarSorte(6);
});

// GERAR QUINA
Hammer(s("#gerarQuina")).on("tap", function() {
  gerarSorte(5);
});

$(document).ready(function() {
  $.ajax({
    crossDomain: true,
    type:"GET",
    url: "http://www.celopes.com.br/projetos/queSorte/json?jsonp=parseResponse",
    contentType: "application/json; charset=utf-8",
    dataType: "jsonp",
    jsonp: false,
    jsonpCallback: 'jsonQueSorteFeed',
    success: function(data) {

      var resultMega = new Array();
      resultMega = data.mega_nunSort;

      var resultQuina = new Array();
      resultQuina = data.quina_nunSort;

      $.each( resultQuina, function( i, val ) {
        $( "#resultado_qn" + i ).text( val );
      });

      $.each( resultMega, function( i, val ) {
        $( "#resultado_mg" + i ).text( val );
      });

      $( "#ms_vlrEst" ).text(data.mega_estimado);
      $( "#ms_prox" ).text(data.mega_prox);
      $( "#ms_virada" ).text(data.mega_virada);
      
      $( "#qn_vlrEst" ).text(data.quina_estimado);
      $( "#qn_prox" ).text(data.quina_prox);
      $( "#qn_virada" ).text(data.quina_virada);

    }
  });
});