angular.module('ngCordova.plugins.ga', [])

    .factory('$cordovaGA', ['$q', function ($q) {

        return {
            
            init: function (id, mingap) {
                var q = $q.defer();
                mingap = (mingap >= 0) ? mingap : 10;
                window.plugins.gaPlugin.init(function (result) {q.resolve(result); },
                                                    function (error) {q.reject(error); },
                                                    id, mingap);
                return q.promise;
            },
            
            trackEvent: function (success, fail, category, eventAction, eventLabel, eventValue) {
                var q = $q.defer();
                window.plugins.gaPlugin.trackEvent(function (result) {q.resolve(result); },
                                                    function (error) {q.reject(error); },
                                                    category, eventAction, eventLabel, eventValue);
                return q.promise;
            },
            
            trackPage: function (success, fail, pageURL) {
                var q = $q.defer();
                window.plugins.gaPlugin.trackPage(function (result) {q.resolve(result); },
                                                    function (error) {q.reject(error); },
                                                    pageURL);
                return q.promise;
            },
            
            setVariable: function (success, fail, index, value) {
                var q = $q.defer();
                window.plugins.gaPlugin.setVariable(function (result) {q.resolve(result); },
                                                    function (error) {q.reject(error); },
                                                    index, value);
                return q.promise;
            },
            
            exit: function (success, fail) {
                var q = $q.defer();
                window.plugins.gaPlugin.exit(function (result) {q.resolve(result); },
                                                    function (error) {q.reject(error); });
                return q.promise;
            }
            
        };

    }]);