var content;
var display;
var textbox;
var isDisplayed = false;
var isFeature = false;
var fitting = false;
var currentFeature = "";
var messages = [];
var currentMessage = -1;
var CLICK = 0;
var FAVORITE = 1;
var ROTATE = 2;

$(window).load(
	init()
);

// window.screen.onmozorientationchange = function() { 
// 	alert("ORNEITATION CHANGE!");
// 	if(isDisplayed) {
// 		isDisplayed = false;
// 		fit(13,ROTATE);
// 	}
// };

window.onresize = function(){
	console.log("RESIZE");
	if(fitting)
		return;

    init();
	if(isDisplayed && !isFeature){
		isDisplayed = false;
		fit(13);
	}
	if(isFeature)
		feature(currentFeature);
};


function init(){

	content = document.getElementById("content");
	display = document.getElementById("display");
	textbox = document.getElementById("textbox");

	display.innerHTML = "&nbsp;";
	content_width = content.offsetWidth;
	content_height = content.offsetHeight;
	size = Math.sqrt((content_width * content_height) / 3);
	display.style.fontSize = size + "px";

	$("#content").fadeTo(0,0);
}

document.onkeydown = function(e){
	e = e || window.event;
	fit(e.keyCode);
};

function fit(key, action, already){
	if(key == 13){
		if(isDisplayed)
			return hide();
        if($("#textbox").is(":focus") || !already) {
            $("#textbox").blur();
            return setTimeout("fit(" + key + "," + action + ",true)", 200);
        }
        
        content = document.getElementById("content");
        display = document.getElementById("display");
        textbox = document.getElementById("textbox");
        
        display.innerHTML = "&nbsp;";
        content_width = content.offsetWidth;
        content_height = content.offsetHeight;
        size = Math.sqrt((content_width * content_height) / 3);
        display.style.fontSize = size + "px";
        
		var string = textbox.value;
		if(string.length == 0)
			return;

		fitting = true;
		display.innerHTML = string;
		display.style.fontSize= size + "px";
        
		while(true){
			var width = content.offsetWidth;
			var height = content.offsetHeight;
			if(width > content_width || height > content_height){
				size *= 0.9;
				display.style.fontSize=size+"px";
			}else{
				break;
			}
		}
        
		show();

		// switch(action) {
		// 	case CLICK:
		// 		ga('send','event','Display','Click', getCurrentStyle(), textbox.value.length);
		// 		break;
  //           case ROTATE:
		// 		ga('send','event','Display','Rotate', getCurrentStyle(), textbox.value.length);
		// 		break;
		// 	default:
		// 		ga('send','event','Display','Enter', getCurrentStyle(), textbox.value.length);
		// 		break;
		// }
	}

	if(key == 27 || key == 8 || key == 32){
		if(isDisplayed)
			hide();
	}

	fitting = false;
}

function show(){
	$("#content").css("opacity","1");
	$("#overlay").css("visibility","visible");
	$("#textbox").css("visibility","hidden");
	$("#textbox").blur();
	$("form").css("z-index","2");
	$("#button").css("visibility","hidden");

	isDisplayed = true;
}

function hide(){
	$("#content").css("opacity","0");
	$("#overlay").css("visibility","hidden");
	$("#textbox").css("visibility","visible");
	$("form").css("z-index","3");
	$("#button").css("visibility","visible");
	$("#textbox").focus();
	$("#textbox")[0].setSelectionRange(0, $("#textbox").val().length);

	size = Math.sqrt((content_width * content_height) / 3);
	display.innerHTML = "&nbsp;";
	isDisplayed = false;
	isFeature = false;
}

function toggleCSS() {}

function getCurrentStyle() {return "light";}

function showMessage(n) {}

function saveMessage() {}

function deleteMessage() {}

function saveMessageData() {}

function loadMessageData() {}

function feature(page){
	isFeature = true;
	currentFeature = page;
	display.style.fontSize = "1em";
	$.get("features/" + page + ".html",function(data){
		display.innerHTML = data;
	});
	show();
}