var quantidade_smartphones;
var pagina_atual = 'home';
var smartphones;
var propriedades_perguntas = [{pr:'peso',pe:'Qual é o peso do smartphone '},
								{pr:'tamanho_tela',pe:'Qual é o tamanho da tela do smartphone '},
								{pr:'resolucao_tela',pe:'Qual é a resolução da tela do smartphone '},
								{pr:'bateria',pe:'Qual é a capacidade da bateria do smartphone '},
								{pr:'ram',pe:'Qual é quantidade de memória RAM do smartphone '},
								{pr:'ano',pe:'Qual foi o ano de lançamento do smartphone '},
								{pr:'processador',pe:'Qual é o processador do smartphone '},
								{pr:'camera_frontal',pe:'Qual é a qualidade da câmera frontal do smartphone '},
								{pr:'camera_traseira',pe:'Qual é a qualidade da câmera traseira do smartphone '},
								{pr:'sistema_operacional',pe:'Qual é o sistema operacional do smartphone '},
								{pr:'imagem',pe:'Qual smartphone aparece na imagem?'}
							];
var resposta_certa;
var quantidade_perguntas;
var pergunta_atual = 0;
var pontos = 0;
var maior_pontuacao = [];
var tempo = new Number();
tempo = 20;
var time;
maior_pontuacao[30] = localStorage.getItem("maior_pontuacao_30");
maior_pontuacao[50] = localStorage.getItem("maior_pontuacao_50");
maior_pontuacao[100] = localStorage.getItem("maior_pontuacao_100");
maior_pontuacao[200] = localStorage.getItem("maior_pontuacao_200");

var adUnit = "ca-app-pub-3454733032130094/7615904968";
var adUnitFullScreen = "ca-app-pub-3454733032130094/3493429769";
var isOverlap = true; //true: overlap, false: split
var isTest = false;
document.addEventListener("deviceready", function(){
    window.admob.setUp(adUnit, adUnitFullScreen, isOverlap, isTest);
    window.admob.preloadBannerAd();
    window.admob.showBannerAd('bottom-center', 'SMART_BANNER');
    document.addEventListener("backbutton", botao_voltar, false);
});

$(function(){
	$.ajax({
		dataType: "json",
		url: 'js/smartphone.json',
		success: function(data){
			smartphones = data;
			quantidade_smartphones = data.smartphone.length;
		}
	});
	menu_principal();
	$(document).on('click','#jogar',function(){
		quantidade_perguntas_pagina();
	});
	$(document).on('click','#sobre',function(){
		sobre();
	});
	$(document).on('click','#maior',function(){
		maior();
	});
	$(document).on('click','.quantidade',function(){
		quantidade_perguntas = $(this).attr('data-value');
		gerar_pergunta();
	});
	$(document).on('click','#voltar, #close',function(){
		pontos = 0;
		pergunta_atual = 0;
		resposta_certa = 0;
		clearTimeout(time);
		$('#tempo').html('');
		menu_principal();
	});
	$(document).on('click','.resposta', function(){
		clearTimeout(time);
		$('#tempo').html('');
		if($(this).attr('data-posicao') == resposta_certa){
			pontos++;
			$('.resposta[data-posicao='+resposta_certa+']').css('background-color','#70FF80');
		}
		else{
			$(this).css('background-color','#FF7070');
			$('.resposta[data-posicao='+resposta_certa+']').css('background-color','#70FF80');
		}
		$('.resposta').removeClass('resposta');
		if (quantidade_perguntas > pergunta_atual) {
			setTimeout(function() {
				gerar_pergunta();
			}, 1500);
		}
		else{
			window.admob.preloadFullScreenAd();
       		window.admob.showFullScreenAd();
			setTimeout(function() {
				gerar_pontuacao(pontos);
				pontos = 0;
				pergunta_atual = 0;
				resposta_certa = 0;
			}, 1500);
		}
	});
})

function shuffle(array) {
	var aux = [], aux2, repitido = false;
	aux[0] = aux2 = Math.floor((Math.random() * array.length));
	for (var i = 1; i < array.length; i++) {
		repitido = false;
		aux2 = Math.floor((Math.random() * array.length));
		for (var j = 0; j < array.length; j++) {
			if (aux2 == aux[j]) {
				repitido = true;
				break;
			};
		};
		if (!repitido) {
			aux[i] = aux2;
		}
		else{
			i--;
		}
	};
	var retorno = [];
  	for (var i = 0; i < aux.length; i++) {
  		retorno[aux[i]] = array[i];
  	};
  	return retorno;
}

function gerar_pontuacao(pontos){
	clearTimeout(time);
	$('#tempo').html('');	
	pagina_atual = 'pontuacao';
	var html = '<div class="menu">\
					<ul class="table-view lista">\
						<li class="table-view-cell">\
							<span>Você fez '+pontos+' pontos!</span>\
						</li>';
	if (pontos > maior_pontuacao[quantidade_perguntas]) {
		html = html + '<li class="table-view-cell">\
							<span>Novo recorde! Parabéns</span>\
						</li>';
		localStorage.setItem("maior_pontuacao_"+quantidade_perguntas,pontos);
		maior_pontuacao[quantidade_perguntas] = pontos;			
	};
	var html = html + '<li id="jogar" class="table-view-cell">\
					<span>Jogar Novamente</span>\
				</li>\
			</ul>\
		</div>';
	$('#conteudo').html(html);
}

function quantidade_perguntas_pagina(){
	pagina_atual = 'quantidade_perguntas';
	$('#close').hide();
	$('#voltar').show();
	var html = '<div class="menu">\
					<ul class="table-view lista">\
						<li class="table-view-cell">\
							<span>Quantidade de perguntas:</span>\
						</li>\
						<li class="table-view-cell">\
							<a class="quantidade" data-value="30">\
								<span>30</span>\
							</a>\
						</li>\
						<li class="table-view-cell">\
							<a class="quantidade" data-value="50">\
								<span>50</span>\
							</a>\
						</li>\
						<li class="table-view-cell">\
							<a class="quantidade" data-value="100">\
								<span>100</span>\
							</a>\
						</li>\
						<li class="table-view-cell">\
							<a class="quantidade" data-value="200">\
								<span>200</span>\
							</a>\
						</li>\
					</ul>\
				</div>';
	$('#conteudo').html(html);
}
function sobre(){
	pagina_atual = 'sobre';
	$('#voltar').show();
	var html = '<div class="menu">\
					<ul class="table-view lista">\
						<li id="sobre" class="table-view-cell">\
							<span>Desenvolvido por Huebra Developer<br /><br />Se encontrar algum erro nos dados de smartphones envie um email para romarioj2h@gmail.com e ajude no desenvolvimento desse app.</span>\
						</li>\
					</ul>\
				</div>';
	$('#conteudo').html(html);
}

function maior(){
	pagina_atual = 'maior';
	$('#voltar').show();
	var html = '<div class="menu">\
					<ul class="table-view lista">\
					<li class="table-view-cell">\
							<span>Maiores pontuações</span>\
						</li>\
						<li class="table-view-cell">\
							<span>30 perguntas: '+verifica_maior_pont(maior_pontuacao[30])+'</span>\
						</li>\
						<li class="table-view-cell">\
							<span>50 perguntas: '+verifica_maior_pont(maior_pontuacao[50])+'</span>\
						</li>\
						<li class="table-view-cell">\
							<span>100 perguntas: '+verifica_maior_pont(maior_pontuacao[100])+'</span>\
						</li>\
						<li class="table-view-cell">\
							<span>200 perguntas: '+verifica_maior_pont(maior_pontuacao[200])+'</span>\
						</li>\
					</ul>\
				</div>';
	$('#conteudo').html(html);
}

function menu_principal(){
	pagina_atual = 'home';
	$('#voltar').hide();
	$('#close').hide();
	var html = '<div class="menu">\
					<ul class="table-view lista">\
						<li id="jogar" class="table-view-cell">\
							<a>\
								<span>Jogar</span>\
							</a>\
						</li>\
						<li id="maior" class="table-view-cell">\
							<a>\
								<span>Maiores pontuações</span>\
							</a>\
						</li>\
						<li id="sobre" class="table-view-cell">\
							<a>\
								<span>Sobre</span>\
							</a>\
						</li>\
					</ul>\
				</div>';
	$('#conteudo').html(html);
}

function gerar_pergunta(){
	tempo = 20;
	clearTimeout(time);
	startCountdown();
	pagina_atual = 'perguntas';
	if (pergunta_atual < quantidade_perguntas) {
		var posicoes = [];
		var random;
		var deu_ruim;
		var posicao_pergunta = Math.floor((Math.random() * propriedades_perguntas.length));
		console.log(propriedades_perguntas[posicao_pergunta].pe);
		posicoes[0] = Math.floor(Math.random() * (quantidade_smartphones ));
		for (var i = 1; i <= 3; i++) {
			deu_ruim = false;
			random = Math.floor(Math.random() * (quantidade_smartphones));
			for (var j = 0; j < posicoes.length; j++) {
				if (random == posicoes[j]) {
					i--;
					deu_ruim = true;
					break;
	 			}
	 			if(smartphones.smartphone[random][propriedades_perguntas[posicao_pergunta].pr] == smartphones.smartphone[posicoes[j]][propriedades_perguntas[posicao_pergunta].pr]){
	 				i--;
	 				deu_ruim = true;
					break;
	 			}
			}
			if (!deu_ruim) {
				posicoes[i] = random;
			}
		}
		resposta_certa = posicoes[0];
		var posicoes_smartphone = [];
		posicoes_smartphone = shuffle(posicoes);
		$('#voltar').hide();
		$('#close').show();
		if (posicao_pergunta == 10) {
			var html = '<div class="menu">\
							<div class="card">\
								<ul class="table-view">\
									<li class="table-view-cell">\
										<span>'+ propriedades_perguntas[posicao_pergunta].pe +'</span>\
										<div class="div-imagem">\
											<img class="imagem" src="img/'+ smartphones.smartphone[resposta_certa].imagem +'.jpg"></img>\
										</div>\
									</li>\
								</ul>\
							</div>\
							<div class="card">\
								<ul class="table-view">\
									<li class="table-view-cell resposta" data-posicao="' + posicoes_smartphone[0] + '">\
										<a>\
											<span>'+ smartphones.smartphone[posicoes_smartphone[0]].nome +'</span>\
										</a>\
									</li>\
									<li class="table-view-cell resposta" data-posicao="' + posicoes_smartphone[1] + '">\
										<a>\
											<span>'+ smartphones.smartphone[posicoes_smartphone[1]].nome +'</span>\
										</a>\
									</li>\
									<li class="table-view-cell resposta" data-posicao="' + posicoes_smartphone[2] + '">\
										<a>\
											<span>'+ smartphones.smartphone[posicoes_smartphone[2]].nome +'</span>\
										</a>\
									</li>\
									<li class="table-view-cell resposta" data-posicao="' + posicoes_smartphone[3] + '">\
										<a>\
											<span>'+ smartphones.smartphone[posicoes_smartphone[3]].nome +'</span>\
										</a>\
									</li>\
								</ul>\
							</div>\
						</div>';
		}
		else{
			var html = '<div class="menu">\
							<div class="card">\
								<ul class="table-view">\
									<li class="table-view-cell pergunta">\
										<span>'+ propriedades_perguntas[posicao_pergunta].pe + smartphones.smartphone[posicoes[0]].nome +'?</span>\
									</li>\
								</ul>\
							</div>\
							<div class="card">\
								<ul class="table-view">\
									<li class="table-view-cell resposta" data-posicao="' + posicoes_smartphone[0] + '">\
										<a>\
											<span>'+ smartphones.smartphone[posicoes_smartphone[0]][propriedades_perguntas[posicao_pergunta].pr] +'</span>\
										</a>\
									</li>\
									<li class="table-view-cell resposta" data-posicao="' + posicoes_smartphone[1] + '">\
										<a>\
											<span>'+ smartphones.smartphone[posicoes_smartphone[1]][propriedades_perguntas[posicao_pergunta].pr] +'</span>\
										</a>\
									</li>\
									<li class="table-view-cell resposta" data-posicao="' + posicoes_smartphone[2] + '">\
										<a>\
											<span>'+ smartphones.smartphone[posicoes_smartphone[2]][propriedades_perguntas[posicao_pergunta].pr] +'</span>\
										</a>\
									</li>\
									<li class="table-view-cell resposta" data-posicao="' + posicoes_smartphone[3] + '">\
										<a>\
											<span>'+ smartphones.smartphone[posicoes_smartphone[3]][propriedades_perguntas[posicao_pergunta].pr] +'</span>\
										</a>\
									</li>\
								</ul>\
							</div>\
						</div>';
		}
		$('#conteudo').html(html);
		pergunta_atual++;
	}
}

function verifica_maior_pont(pontos){
	if(pontos == null){
		return '0 pontos';
	}
	return pontos+' pontos';
}

function startCountdown(){

	// Se o tempo não for zerado
	if((tempo - 1) >= 0){

		// Pega a parte inteira dos minutos
		var min = parseInt(tempo/60);
		// Calcula os segundos restantes
		var seg = tempo%60;

		// Formata o número menor que dez, ex: 08, 07, ...
		if(min < 10){
			min = "0"+min;
			min = min.substr(0, 2);
		}
		if(seg <=9){
			seg = "0"+seg;
		}

		// Cria a variável para formatar no estilo hora/cronômetro
		horaImprimivel = seg;
		//JQuery pra setar o valor
		$("#tempo").html(horaImprimivel);

		// Define que a função será executada novamente em 1000ms = 1 segundo
		time = setTimeout('startCountdown()',1000);

		// diminui o tempo
		tempo--;

	// Quando o contador chegar a zero faz esta ação
	} else {
		$("#tempo").html('00');
		$('.resposta[data-posicao='+resposta_certa+']').css('background-color','#FFBA3D');
		if (quantidade_perguntas > pergunta_atual) {
			setTimeout(function() {
				gerar_pergunta();
			}, 1500);
		}
		else{
			setTimeout(function() {
				gerar_pontuacao(pontos);
				pontos = 0;
				pergunta_atual = 0;
				resposta_certa = 0;
			}, 1500);
		}
	}
}

function botao_voltar(){
	if(pagina_atual == 'sobre' || pagina_atual == 'maior' || pagina_atual == 'quantidade_perguntas' || pagina_atual == 'pontuacao'){
		menu_principal();
	}
	else if(pagina_atual == 'perguntas' || pagina_atual == 'home') {
		return false;
	}
}