angular.module('app', ['ionic', 'app.controllers', 'app.services'])

.run(function($ionicPlatform) {
	$ionicPlatform.ready(function() {
		// Hide the accessory bar by default (remove this to show the accessory bar above the keyboard
		// for form inputs)
		if(window.cordova && window.cordova.plugins.Keyboard) {
			cordova.plugins.Keyboard.hideKeyboardAccessoryBar(true);
		}
		if(window.StatusBar) {
			// org.apache.cordova.statusbar required
			StatusBar.styleDefault();
		}
	});
})

.config(['$compileProvider', function($compileProvider) {
		$compileProvider.aHrefSanitizationWhitelist(/^\s*(https?|ftp|mailto|app|file):/);
		$compileProvider.imgSrcSanitizationWhitelist(/^\s*(https?|ftp|mailto|app|file):/);
	}
])

.config(function($sceDelegateProvider) {
	$sceDelegateProvider.resourceUrlWhitelist([
		// Allow same origin resource loads.
		'self',
		// Allow loading from our assets domain.  Notice the difference between * and **.
		'http://www.ourholyquran.com/**'
	]);
})

.config(function($stateProvider, $urlRouterProvider) {

	// Ionic uses AngularUI Router which uses the concept of states
	// Learn more here: https://github.com/angular-ui/ui-router
	// Set up the various states which the app can be in.
	// Each state's controller can be found in controllers.js
	$stateProvider
		
		.state('index', {
			url: '/index',
			templateUrl: 'templates/index.tpl'
		})

		.state('about', {
			url: '/about',
			templateUrl: 'templates/about.tpl'
		})
		
		.state('surah', {
			url: '/surah/:surahId',
			templateUrl: 'templates/surah.tpl',
			controller: 'SurahCtrl'
		})
		;

	// if none of the above states are matched, use this as the fallback
	
	$urlRouterProvider.otherwise('/index');
	

});
