// sections
var player = document.getElementById('player');
var help = document.getElementById('help');
var switcher = document.getElementById('switcher');

// ui elements
var radio_logo = document.getElementById('radio-logo');
var now_playing = document.getElementById('now-playing');

// audio player
var audio = document.getElementById('audio-player');

// background music
audio.mozAudioChannelType = 'content';

var clickTimer = null;

function switchAudio (n) {
	switcher.hidden = true;
	if (audio.paused) {
		new_source =  "http://icestreaming.rai.it/" + n + ".mp3";
		audio.src = new_source;
		audio.play();

	} else {
		audio.pause();
		switchAudio(n);
	}
}

function switchBackground (n) {
	player.className = "radio" + n;
}

function switchLogo (n) {
	radio_logo.className = "radio" + n;
}

function nowPlaying (n) {
	var radio_name;
	switch (n) {
		case 1: 
			radio_name = "Radio 1";
			break;
		case 2:
			radio_name = "Radio 2";
			break;
		case 3:
			radio_name = "Radio 3";
			break;
		case 4:
			radio_name = "Radio Filodiffusione 4";
			break;
		case 5:
			radio_name = "Radio Filodiffusione 5";
			break;
		case 6:
			radio_name = "Isoradio";
			break;
		case 7:
			radio_name = "GR Parlamento";
			break;
		case 9:
			radio_name = "Web Radio 6";
			break;
		case 10:
			radio_name = "Web Radio 7";
			break;
		case 11:
			radio_name = "Web Radio 8";
			break;
		default:
			radio_name = "Canale non riconosciuto";
	}
			
	now_playing.textContent = radio_name;			
}

function playPause () {
	if (audio.paused) {
		audio.play();
	} else {
		audio.pause();
	}
}

var radio1 = document.
		getElementById('radio1').
		addEventListener('click', function () {
			switchBackground(1);
			nowPlaying(1);
			switchAudio(1);
		});
var radio2 = document.
		getElementById('radio2').
		addEventListener('click', function () {
			switchBackground(2);
			nowPlaying(2);
			switchAudio(2);
		});
var radio3 = document.
		getElementById('radio3').
		addEventListener('click', function () {
			switchBackground(3);
			nowPlaying(3);
			switchAudio(3);
		});
var radio4 = document.
		getElementById('radio4').
		addEventListener('click', function () {
			switchBackground(4);
			nowPlaying(4);
			switchAudio(4);
		});
var radio5 = document.
		getElementById('radio5').
		addEventListener('click', function () {
			switchBackground(5);
			nowPlaying(5);
			switchAudio(5);
		});
var radio6 = document.
		getElementById('radio6').
		addEventListener('click', function () {
			switchBackground(6);
			nowPlaying(6);
			switchAudio(6);
		});
var radio7 = document.
		getElementById('radio7').
		addEventListener('click', function () {
			switchBackground(7);
			nowPlaying(7);
			switchAudio(7);
		});
var radio9 = document.
		getElementById('radio9').
		addEventListener('click', function () {
			switchBackground(9);
			nowPlaying(9);
			switchAudio(9);
		});
var radio10 = document.
		getElementById('radio10').
		addEventListener('click', function () {
			switchBackground(10);
			nowPlaying(10);
			switchAudio(10);
		});
var radio11 = document.
		getElementById('radio11').
		addEventListener('click', function () {
			switchBackground(11);
			nowPlaying(11);
			switchAudio(11);
		});

// buttons
var channel_change_button = document.
			getElementById('channel-change');

var help_button = document.
			getElementById('help-button');

var back_button = document.
			getElementById('back-button');

var cancel_button = document.
			getElementById('cancel');

channel_change_button.
		addEventListener('click', function () {
			switcher.hidden = false;
		});

help_button.
	addEventListener('click', function () {
		help.hidden = false;
	});

back_button.
	addEventListener('click', function() {
		help.hidden = true;
	});

cancel_button.
	addEventListener('click', function () {
		switcher.hidden = true;
	});

player.
	addEventListener('click', function () {
		if (clickTimer == null) {
			clickTimer = setTimeout(function () {
				clickTimer = null;
			}, 500);
		} else {
			clearTimeout(clickTimer);
			clickTimer = null;
			playPause();
		}
	});
