/**
 * @author arbuzov <info@whitediver.com>
 *
 */
ServiceManager = function(login, password) {
	
	//this.apiurl = 'http://api.radugainternet.ru/customer-service/'
	this.apiurl = 'http://api.rad.localhost/customer-service/'
	
	/**
	 * 
	 */
	this.login = login;
	
	/**
	 * 
	 */
	this.password = password;

	var parent = this;
	
	/**
	 * @param Array of suscriptions
	 */
	this.subscriptions = [];
	
	this.curentSubcription = 0;
	
	
	this.debug = function(message) {
		$('div#debug').html(message);
	}

	
	
	this.addButton = /**
	 * Adds buttons to table cell
	 * @param cell jQuery
	 */
	function (cell) {
		var list = $('<ul>')
			.addClass('dropdown-menu dropdown-menu-right')
			.attr('role', 'menu')
			.append($('<li>').append($('<a>').addClass('customerService').attr('href','#').attr('x-data-action', 'change').html('Перейти')))
			.append($('<li>').append($('<a>').addClass('customerService').attr('href','#').attr('x-data-action', 'change1').html('Сменить на час')))
			.append($('<li>').append($('<a>').addClass('customerService').attr('href','#').attr('x-data-action', 'change2').html('Вернуться')));
		var button = $('<button>')
			.addClass('btn btn-default btn-sm dropdown-toggle')
			.attr('data-toggle', 'dropdown')
			.attr('type', 'button')
			.html('Изменить')
			.append($('<span>').addClass('caret'));
		var container = $('<div>').addClass('btn-group');
		$(container).append(button).append(list);
		$(cell).append(container);
	};
	
	this.addServiceLevel = function (levelInfo) {
		var row = $('<tr>')
			.append($('<td>').html(levelInfo.level))
			.append($('<td>').html(levelInfo.BIR/1024+ ' кбит'))
			.append($('<td>').html(levelInfo.fee))
			.append($('<td>'))
			.append($('<td>').addClass('actionCell'));
		$('table#downLink>tbody').append(row);
	}
	
	this.init = /**
	 * Init object collect initial date
	 */
	function() {
		$.post(parent.apiurl+'subscribe/', {'login' : parent.login, 'password': parent.password}).done(function(data){
			parent.subscriptions = data;
			if (data.list.length==1) {
				parent.curentSubcription = 0; 
			}
			if (parent.curentSubcription == null) {
				$('div#control').hide();
				$('div#login').show();
			} else {
				$('div#control').show();
				$('div#login').hide();
				$('div#control').attr('x-data-ctsi', data.ctsi);
				$('table#downLink>tbody>tr').remove();
				$.each(data.list[parent.curentSubcription].serviceLevels, function(index, element){
					parent.addServiceLevel(element);
				});
				
				$('td.actionCell').map(function(){
					parent.addButton(this);
				});
				$('ul').delegate('a.customerService', 'click', function(){
					parent.switchAction($(this).attr('x-data-action'));
				});
			}
		});
	};
	
	this.switchAction = /**
	 * Action button handler
	 * @param actionId
	 */
	function(actionId) {
		$.post(parent.apiurl+'switch/'+$('div#control').attr('x-data-ctsi'), {'operation':actionId}).done(function(data){
			parent.debug(data);
		});
		
	};
	
};

document.addEventListener('DOMContentLoaded', function() {
	var service = new ServiceManager(localStorage["login"], localStorage["password"]);
	service.init();
});
