var $hxClasses = $hxClasses || {},$estr = function() { return js.Boot.__string_rec(this,''); };
function $extend(from, fields) {
	function inherit() {}; inherit.prototype = from; var proto = new inherit();
	for (var name in fields) proto[name] = fields[name];
	return proto;
}
var EReg = $hxClasses["EReg"] = function(r,opt) {
	opt = opt.split("u").join("");
	this.r = new RegExp(r,opt);
};
EReg.__name__ = ["EReg"];
EReg.prototype = {
	customReplace: function(s,f) {
		var buf = new StringBuf();
		while(true) {
			if(!this.match(s)) break;
			buf.b += Std.string(this.matchedLeft());
			buf.b += Std.string(f(this));
			s = this.matchedRight();
		}
		buf.b += Std.string(s);
		return buf.b;
	}
	,replace: function(s,by) {
		return s.replace(this.r,by);
	}
	,split: function(s) {
		var d = "#__delim__#";
		return s.replace(this.r,d).split(d);
	}
	,matchedPos: function() {
		if(this.r.m == null) throw "No string matched";
		return { pos : this.r.m.index, len : this.r.m[0].length};
	}
	,matchedRight: function() {
		if(this.r.m == null) throw "No string matched";
		var sz = this.r.m.index + this.r.m[0].length;
		return this.r.s.substr(sz,this.r.s.length - sz);
	}
	,matchedLeft: function() {
		if(this.r.m == null) throw "No string matched";
		return this.r.s.substr(0,this.r.m.index);
	}
	,matched: function(n) {
		return this.r.m != null && n >= 0 && n < this.r.m.length?this.r.m[n]:(function($this) {
			var $r;
			throw "EReg::matched";
			return $r;
		}(this));
	}
	,match: function(s) {
		if(this.r.global) this.r.lastIndex = 0;
		this.r.m = this.r.exec(s);
		this.r.s = s;
		return this.r.m != null;
	}
	,r: null
	,__class__: EReg
}
var HxOverrides = $hxClasses["HxOverrides"] = function() { }
HxOverrides.__name__ = ["HxOverrides"];
HxOverrides.dateStr = function(date) {
	var m = date.getMonth() + 1;
	var d = date.getDate();
	var h = date.getHours();
	var mi = date.getMinutes();
	var s = date.getSeconds();
	return date.getFullYear() + "-" + (m < 10?"0" + m:"" + m) + "-" + (d < 10?"0" + d:"" + d) + " " + (h < 10?"0" + h:"" + h) + ":" + (mi < 10?"0" + mi:"" + mi) + ":" + (s < 10?"0" + s:"" + s);
}
HxOverrides.strDate = function(s) {
	switch(s.length) {
	case 8:
		var k = s.split(":");
		var d = new Date();
		d.setTime(0);
		d.setUTCHours(k[0]);
		d.setUTCMinutes(k[1]);
		d.setUTCSeconds(k[2]);
		return d;
	case 10:
		var k = s.split("-");
		return new Date(k[0],k[1] - 1,k[2],0,0,0);
	case 19:
		var k = s.split(" ");
		var y = k[0].split("-");
		var t = k[1].split(":");
		return new Date(y[0],y[1] - 1,y[2],t[0],t[1],t[2]);
	default:
		throw "Invalid date format : " + s;
	}
}
HxOverrides.cca = function(s,index) {
	var x = s.charCodeAt(index);
	if(x != x) return undefined;
	return x;
}
HxOverrides.substr = function(s,pos,len) {
	if(pos != null && pos != 0 && len != null && len < 0) return "";
	if(len == null) len = s.length;
	if(pos < 0) {
		pos = s.length + pos;
		if(pos < 0) pos = 0;
	} else if(len < 0) len = s.length + len - pos;
	return s.substr(pos,len);
}
HxOverrides.remove = function(a,obj) {
	var i = 0;
	var l = a.length;
	while(i < l) {
		if(a[i] == obj) {
			a.splice(i,1);
			return true;
		}
		i++;
	}
	return false;
}
HxOverrides.iter = function(a) {
	return { cur : 0, arr : a, hasNext : function() {
		return this.cur < this.arr.length;
	}, next : function() {
		return this.arr[this.cur++];
	}};
}
var IntIter = $hxClasses["IntIter"] = function(min,max) {
	this.min = min;
	this.max = max;
};
IntIter.__name__ = ["IntIter"];
IntIter.prototype = {
	next: function() {
		return this.min++;
	}
	,hasNext: function() {
		return this.min < this.max;
	}
	,max: null
	,min: null
	,__class__: IntIter
}
var Lambda = $hxClasses["Lambda"] = function() { }
Lambda.__name__ = ["Lambda"];
Lambda.array = function(it) {
	var a = new Array();
	var $it0 = $iterator(it)();
	while( $it0.hasNext() ) {
		var i = $it0.next();
		a.push(i);
	}
	return a;
}
Lambda.list = function(it) {
	var l = new List();
	var $it0 = $iterator(it)();
	while( $it0.hasNext() ) {
		var i = $it0.next();
		l.add(i);
	}
	return l;
}
Lambda.map = function(it,f) {
	var l = new List();
	var $it0 = $iterator(it)();
	while( $it0.hasNext() ) {
		var x = $it0.next();
		l.add(f(x));
	}
	return l;
}
Lambda.mapi = function(it,f) {
	var l = new List();
	var i = 0;
	var $it0 = $iterator(it)();
	while( $it0.hasNext() ) {
		var x = $it0.next();
		l.add(f(i++,x));
	}
	return l;
}
Lambda.has = function(it,elt,cmp) {
	if(cmp == null) {
		var $it0 = $iterator(it)();
		while( $it0.hasNext() ) {
			var x = $it0.next();
			if(x == elt) return true;
		}
	} else {
		var $it1 = $iterator(it)();
		while( $it1.hasNext() ) {
			var x = $it1.next();
			if(cmp(x,elt)) return true;
		}
	}
	return false;
}
Lambda.exists = function(it,f) {
	var $it0 = $iterator(it)();
	while( $it0.hasNext() ) {
		var x = $it0.next();
		if(f(x)) return true;
	}
	return false;
}
Lambda.foreach = function(it,f) {
	var $it0 = $iterator(it)();
	while( $it0.hasNext() ) {
		var x = $it0.next();
		if(!f(x)) return false;
	}
	return true;
}
Lambda.iter = function(it,f) {
	var $it0 = $iterator(it)();
	while( $it0.hasNext() ) {
		var x = $it0.next();
		f(x);
	}
}
Lambda.filter = function(it,f) {
	var l = new List();
	var $it0 = $iterator(it)();
	while( $it0.hasNext() ) {
		var x = $it0.next();
		if(f(x)) l.add(x);
	}
	return l;
}
Lambda.fold = function(it,f,first) {
	var $it0 = $iterator(it)();
	while( $it0.hasNext() ) {
		var x = $it0.next();
		first = f(x,first);
	}
	return first;
}
Lambda.count = function(it,pred) {
	var n = 0;
	if(pred == null) {
		var $it0 = $iterator(it)();
		while( $it0.hasNext() ) {
			var _ = $it0.next();
			n++;
		}
	} else {
		var $it1 = $iterator(it)();
		while( $it1.hasNext() ) {
			var x = $it1.next();
			if(pred(x)) n++;
		}
	}
	return n;
}
Lambda.empty = function(it) {
	return !$iterator(it)().hasNext();
}
Lambda.indexOf = function(it,v) {
	var i = 0;
	var $it0 = $iterator(it)();
	while( $it0.hasNext() ) {
		var v2 = $it0.next();
		if(v == v2) return i;
		i++;
	}
	return -1;
}
Lambda.concat = function(a,b) {
	var l = new List();
	var $it0 = $iterator(a)();
	while( $it0.hasNext() ) {
		var x = $it0.next();
		l.add(x);
	}
	var $it1 = $iterator(b)();
	while( $it1.hasNext() ) {
		var x = $it1.next();
		l.add(x);
	}
	return l;
}
var List = $hxClasses["List"] = function() {
	this.length = 0;
};
List.__name__ = ["List"];
List.prototype = {
	map: function(f) {
		var b = new List();
		var l = this.h;
		while(l != null) {
			var v = l[0];
			l = l[1];
			b.add(f(v));
		}
		return b;
	}
	,filter: function(f) {
		var l2 = new List();
		var l = this.h;
		while(l != null) {
			var v = l[0];
			l = l[1];
			if(f(v)) l2.add(v);
		}
		return l2;
	}
	,join: function(sep) {
		var s = new StringBuf();
		var first = true;
		var l = this.h;
		while(l != null) {
			if(first) first = false; else s.b += Std.string(sep);
			s.b += Std.string(l[0]);
			l = l[1];
		}
		return s.b;
	}
	,toString: function() {
		var s = new StringBuf();
		var first = true;
		var l = this.h;
		s.b += Std.string("{");
		while(l != null) {
			if(first) first = false; else s.b += Std.string(", ");
			s.b += Std.string(Std.string(l[0]));
			l = l[1];
		}
		s.b += Std.string("}");
		return s.b;
	}
	,iterator: function() {
		return { h : this.h, hasNext : function() {
			return this.h != null;
		}, next : function() {
			if(this.h == null) return null;
			var x = this.h[0];
			this.h = this.h[1];
			return x;
		}};
	}
	,remove: function(v) {
		var prev = null;
		var l = this.h;
		while(l != null) {
			if(l[0] == v) {
				if(prev == null) this.h = l[1]; else prev[1] = l[1];
				if(this.q == l) this.q = prev;
				this.length--;
				return true;
			}
			prev = l;
			l = l[1];
		}
		return false;
	}
	,clear: function() {
		this.h = null;
		this.q = null;
		this.length = 0;
	}
	,isEmpty: function() {
		return this.h == null;
	}
	,pop: function() {
		if(this.h == null) return null;
		var x = this.h[0];
		this.h = this.h[1];
		if(this.h == null) this.q = null;
		this.length--;
		return x;
	}
	,last: function() {
		return this.q == null?null:this.q[0];
	}
	,first: function() {
		return this.h == null?null:this.h[0];
	}
	,push: function(item) {
		var x = [item,this.h];
		this.h = x;
		if(this.q == null) this.q = x;
		this.length++;
	}
	,add: function(item) {
		var x = [item];
		if(this.h == null) this.h = x; else this.q[1] = x;
		this.q = x;
		this.length++;
	}
	,length: null
	,q: null
	,h: null
	,__class__: List
}
var Reflect = $hxClasses["Reflect"] = function() { }
Reflect.__name__ = ["Reflect"];
Reflect.hasField = function(o,field) {
	return Object.prototype.hasOwnProperty.call(o,field);
}
Reflect.field = function(o,field) {
	var v = null;
	try {
		v = o[field];
	} catch( e ) {
	}
	return v;
}
Reflect.setField = function(o,field,value) {
	o[field] = value;
}
Reflect.getProperty = function(o,field) {
	var tmp;
	return o == null?null:o.__properties__ && (tmp = o.__properties__["get_" + field])?o[tmp]():o[field];
}
Reflect.setProperty = function(o,field,value) {
	var tmp;
	if(o.__properties__ && (tmp = o.__properties__["set_" + field])) o[tmp](value); else o[field] = value;
}
Reflect.callMethod = function(o,func,args) {
	return func.apply(o,args);
}
Reflect.fields = function(o) {
	var a = [];
	if(o != null) {
		var hasOwnProperty = Object.prototype.hasOwnProperty;
		for( var f in o ) {
		if(hasOwnProperty.call(o,f)) a.push(f);
		}
	}
	return a;
}
Reflect.isFunction = function(f) {
	return typeof(f) == "function" && !(f.__name__ || f.__ename__);
}
Reflect.compare = function(a,b) {
	return a == b?0:a > b?1:-1;
}
Reflect.compareMethods = function(f1,f2) {
	if(f1 == f2) return true;
	if(!Reflect.isFunction(f1) || !Reflect.isFunction(f2)) return false;
	return f1.scope == f2.scope && f1.method == f2.method && f1.method != null;
}
Reflect.isObject = function(v) {
	if(v == null) return false;
	var t = typeof(v);
	return t == "string" || t == "object" && !v.__enum__ || t == "function" && (v.__name__ || v.__ename__);
}
Reflect.deleteField = function(o,f) {
	if(!Reflect.hasField(o,f)) return false;
	delete(o[f]);
	return true;
}
Reflect.copy = function(o) {
	var o2 = { };
	var _g = 0, _g1 = Reflect.fields(o);
	while(_g < _g1.length) {
		var f = _g1[_g];
		++_g;
		o2[f] = Reflect.field(o,f);
	}
	return o2;
}
Reflect.makeVarArgs = function(f) {
	return function() {
		var a = Array.prototype.slice.call(arguments);
		return f(a);
	};
}
var Std = $hxClasses["Std"] = function() { }
Std.__name__ = ["Std"];
Std["is"] = function(v,t) {
	return js.Boot.__instanceof(v,t);
}
Std.string = function(s) {
	return js.Boot.__string_rec(s,"");
}
Std["int"] = function(x) {
	return x | 0;
}
Std.parseInt = function(x) {
	var v = parseInt(x,10);
	if(v == 0 && (HxOverrides.cca(x,1) == 120 || HxOverrides.cca(x,1) == 88)) v = parseInt(x);
	if(isNaN(v)) return null;
	return v;
}
Std.parseFloat = function(x) {
	return parseFloat(x);
}
Std.random = function(x) {
	return Math.floor(Math.random() * x);
}
var StringBuf = $hxClasses["StringBuf"] = function() {
	this.b = "";
};
StringBuf.__name__ = ["StringBuf"];
StringBuf.prototype = {
	toString: function() {
		return this.b;
	}
	,addSub: function(s,pos,len) {
		this.b += HxOverrides.substr(s,pos,len);
	}
	,addChar: function(c) {
		this.b += String.fromCharCode(c);
	}
	,add: function(x) {
		this.b += Std.string(x);
	}
	,b: null
	,__class__: StringBuf
}
var StringTools = $hxClasses["StringTools"] = function() { }
StringTools.__name__ = ["StringTools"];
StringTools.urlEncode = function(s) {
	return encodeURIComponent(s);
}
StringTools.urlDecode = function(s) {
	return decodeURIComponent(s.split("+").join(" "));
}
StringTools.htmlEscape = function(s) {
	return s.split("&").join("&amp;").split("<").join("&lt;").split(">").join("&gt;");
}
StringTools.htmlUnescape = function(s) {
	return s.split("&gt;").join(">").split("&lt;").join("<").split("&amp;").join("&");
}
StringTools.startsWith = function(s,start) {
	return s.length >= start.length && HxOverrides.substr(s,0,start.length) == start;
}
StringTools.endsWith = function(s,end) {
	var elen = end.length;
	var slen = s.length;
	return slen >= elen && HxOverrides.substr(s,slen - elen,elen) == end;
}
StringTools.isSpace = function(s,pos) {
	var c = HxOverrides.cca(s,pos);
	return c >= 9 && c <= 13 || c == 32;
}
StringTools.ltrim = function(s) {
	var l = s.length;
	var r = 0;
	while(r < l && StringTools.isSpace(s,r)) r++;
	if(r > 0) return HxOverrides.substr(s,r,l - r); else return s;
}
StringTools.rtrim = function(s) {
	var l = s.length;
	var r = 0;
	while(r < l && StringTools.isSpace(s,l - r - 1)) r++;
	if(r > 0) return HxOverrides.substr(s,0,l - r); else return s;
}
StringTools.trim = function(s) {
	return StringTools.ltrim(StringTools.rtrim(s));
}
StringTools.rpad = function(s,c,l) {
	var sl = s.length;
	var cl = c.length;
	while(sl < l) if(l - sl < cl) {
		s += HxOverrides.substr(c,0,l - sl);
		sl = l;
	} else {
		s += c;
		sl += cl;
	}
	return s;
}
StringTools.lpad = function(s,c,l) {
	var ns = "";
	var sl = s.length;
	if(sl >= l) return s;
	var cl = c.length;
	while(sl < l) if(l - sl < cl) {
		ns += HxOverrides.substr(c,0,l - sl);
		sl = l;
	} else {
		ns += c;
		sl += cl;
	}
	return ns + s;
}
StringTools.replace = function(s,sub,by) {
	return s.split(sub).join(by);
}
StringTools.hex = function(n,digits) {
	var s = "";
	var hexChars = "0123456789ABCDEF";
	do {
		s = hexChars.charAt(n & 15) + s;
		n >>>= 4;
	} while(n > 0);
	if(digits != null) while(s.length < digits) s = "0" + s;
	return s;
}
StringTools.fastCodeAt = function(s,index) {
	return s.charCodeAt(index);
}
StringTools.isEOF = function(c) {
	return c != c;
}
var ValueType = $hxClasses["ValueType"] = { __ename__ : ["ValueType"], __constructs__ : ["TNull","TInt","TFloat","TBool","TObject","TFunction","TClass","TEnum","TUnknown"] }
ValueType.TNull = ["TNull",0];
ValueType.TNull.toString = $estr;
ValueType.TNull.__enum__ = ValueType;
ValueType.TInt = ["TInt",1];
ValueType.TInt.toString = $estr;
ValueType.TInt.__enum__ = ValueType;
ValueType.TFloat = ["TFloat",2];
ValueType.TFloat.toString = $estr;
ValueType.TFloat.__enum__ = ValueType;
ValueType.TBool = ["TBool",3];
ValueType.TBool.toString = $estr;
ValueType.TBool.__enum__ = ValueType;
ValueType.TObject = ["TObject",4];
ValueType.TObject.toString = $estr;
ValueType.TObject.__enum__ = ValueType;
ValueType.TFunction = ["TFunction",5];
ValueType.TFunction.toString = $estr;
ValueType.TFunction.__enum__ = ValueType;
ValueType.TClass = function(c) { var $x = ["TClass",6,c]; $x.__enum__ = ValueType; $x.toString = $estr; return $x; }
ValueType.TEnum = function(e) { var $x = ["TEnum",7,e]; $x.__enum__ = ValueType; $x.toString = $estr; return $x; }
ValueType.TUnknown = ["TUnknown",8];
ValueType.TUnknown.toString = $estr;
ValueType.TUnknown.__enum__ = ValueType;
var Type = $hxClasses["Type"] = function() { }
Type.__name__ = ["Type"];
Type.getClass = function(o) {
	if(o == null) return null;
	return o.__class__;
}
Type.getEnum = function(o) {
	if(o == null) return null;
	return o.__enum__;
}
Type.getSuperClass = function(c) {
	return c.__super__;
}
Type.getClassName = function(c) {
	var a = c.__name__;
	return a.join(".");
}
Type.getEnumName = function(e) {
	var a = e.__ename__;
	return a.join(".");
}
Type.resolveClass = function(name) {
	var cl = $hxClasses[name];
	if(cl == null || !cl.__name__) return null;
	return cl;
}
Type.resolveEnum = function(name) {
	var e = $hxClasses[name];
	if(e == null || !e.__ename__) return null;
	return e;
}
Type.createInstance = function(cl,args) {
	switch(args.length) {
	case 0:
		return new cl();
	case 1:
		return new cl(args[0]);
	case 2:
		return new cl(args[0],args[1]);
	case 3:
		return new cl(args[0],args[1],args[2]);
	case 4:
		return new cl(args[0],args[1],args[2],args[3]);
	case 5:
		return new cl(args[0],args[1],args[2],args[3],args[4]);
	case 6:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5]);
	case 7:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5],args[6]);
	case 8:
		return new cl(args[0],args[1],args[2],args[3],args[4],args[5],args[6],args[7]);
	default:
		throw "Too many arguments";
	}
	return null;
}
Type.createEmptyInstance = function(cl) {
	function empty() {}; empty.prototype = cl.prototype;
	return new empty();
}
Type.createEnum = function(e,constr,params) {
	var f = Reflect.field(e,constr);
	if(f == null) throw "No such constructor " + constr;
	if(Reflect.isFunction(f)) {
		if(params == null) throw "Constructor " + constr + " need parameters";
		return f.apply(e,params);
	}
	if(params != null && params.length != 0) throw "Constructor " + constr + " does not need parameters";
	return f;
}
Type.createEnumIndex = function(e,index,params) {
	var c = e.__constructs__[index];
	if(c == null) throw index + " is not a valid enum constructor index";
	return Type.createEnum(e,c,params);
}
Type.getInstanceFields = function(c) {
	var a = [];
	for(var i in c.prototype) a.push(i);
	HxOverrides.remove(a,"__class__");
	HxOverrides.remove(a,"__properties__");
	return a;
}
Type.getClassFields = function(c) {
	var a = Reflect.fields(c);
	HxOverrides.remove(a,"__name__");
	HxOverrides.remove(a,"__interfaces__");
	HxOverrides.remove(a,"__properties__");
	HxOverrides.remove(a,"__super__");
	HxOverrides.remove(a,"prototype");
	return a;
}
Type.getEnumConstructs = function(e) {
	var a = e.__constructs__;
	return a.slice();
}
Type["typeof"] = function(v) {
	switch(typeof(v)) {
	case "boolean":
		return ValueType.TBool;
	case "string":
		return ValueType.TClass(String);
	case "number":
		if(Math.ceil(v) == v % 2147483648.0) return ValueType.TInt;
		return ValueType.TFloat;
	case "object":
		if(v == null) return ValueType.TNull;
		var e = v.__enum__;
		if(e != null) return ValueType.TEnum(e);
		var c = v.__class__;
		if(c != null) return ValueType.TClass(c);
		return ValueType.TObject;
	case "function":
		if(v.__name__ || v.__ename__) return ValueType.TObject;
		return ValueType.TFunction;
	case "undefined":
		return ValueType.TNull;
	default:
		return ValueType.TUnknown;
	}
}
Type.enumEq = function(a,b) {
	if(a == b) return true;
	try {
		if(a[0] != b[0]) return false;
		var _g1 = 2, _g = a.length;
		while(_g1 < _g) {
			var i = _g1++;
			if(!Type.enumEq(a[i],b[i])) return false;
		}
		var e = a.__enum__;
		if(e != b.__enum__ || e == null) return false;
	} catch( e ) {
		return false;
	}
	return true;
}
Type.enumConstructor = function(e) {
	return e[0];
}
Type.enumParameters = function(e) {
	return e.slice(2);
}
Type.enumIndex = function(e) {
	return e[1];
}
Type.allEnums = function(e) {
	var all = [];
	var cst = e.__constructs__;
	var _g = 0;
	while(_g < cst.length) {
		var c = cst[_g];
		++_g;
		var v = Reflect.field(e,c);
		if(!Reflect.isFunction(v)) all.push(v);
	}
	return all;
}
var co = co || {}
if(!co.doubleduck) co.doubleduck = {}
co.doubleduck.BaseAssets = $hxClasses["co.doubleduck.BaseAssets"] = function() {
};
co.doubleduck.BaseAssets.__name__ = ["co","doubleduck","BaseAssets"];
co.doubleduck.BaseAssets._localizedAssets = null;
co.doubleduck.BaseAssets.loader = function() {
	if(co.doubleduck.BaseAssets._loader == null) {
		co.doubleduck.BaseAssets._loader = new createjs.LoadQueue(true);
		co.doubleduck.BaseAssets._loader.installPlugin(createjs.LoadQueue.SOUND);
		co.doubleduck.BaseAssets._loader.onFileLoad = co.doubleduck.BaseAssets.handleFileLoaded;
		co.doubleduck.BaseAssets._loader.onError = co.doubleduck.BaseAssets.handleLoadError;
		co.doubleduck.BaseAssets._loader.setMaxConnections(10);
	}
	return co.doubleduck.BaseAssets._loader;
}
co.doubleduck.BaseAssets.loadAndCall = function(uri,callbackFunc) {
	co.doubleduck.BaseAssets.loader().loadFile(uri);
	co.doubleduck.BaseAssets._loadCallbacks[uri] = callbackFunc;
}
co.doubleduck.BaseAssets.finishLoading = function(manifest,sounds) {
	if(co.doubleduck.SoundManager.available) {
		var _g1 = 0, _g = sounds.length;
		while(_g1 < _g) {
			var currSound = _g1++;
			manifest.push(sounds[currSound] + co.doubleduck.SoundManager.EXTENSION);
			co.doubleduck.SoundManager.initSound(sounds[currSound]);
		}
	}
	if(co.doubleduck.BaseAssets._useLocalStorage) co.doubleduck.BaseAssets.loadFromLocalStorage(manifest);
	if(manifest.length == 0) {
		if(co.doubleduck.BaseAssets.onLoadAll != null) co.doubleduck.BaseAssets.onLoadAll();
	}
	if(co.doubleduck.BaseGame.isLocalized && co.doubleduck.BaseAssets._localizedAssets != null) {
		var _g1 = 0, _g = manifest.length;
		while(_g1 < _g) {
			var itemIndex = _g1++;
			var currItem = manifest[itemIndex];
			currItem = co.doubleduck.BaseAssets.getLocalisedImage(currItem);
			manifest[itemIndex] = currItem;
		}
	}
	co.doubleduck.BaseAssets.loader().onProgress = co.doubleduck.BaseAssets.handleProgress;
	co.doubleduck.BaseAssets.loader().onFileLoad = co.doubleduck.BaseAssets.manifestFileLoad;
	co.doubleduck.BaseAssets.loader().loadManifest(manifest);
	co.doubleduck.BaseAssets.loader().load();
}
co.doubleduck.BaseAssets.loadAll = function(manifest,sounds) {
	manifest[manifest.length] = "images/duckling/orientation_error_port.png";
	manifest[manifest.length] = "images/duckling/orientation_error_land.png";
	manifest[manifest.length] = "images/duckling/page_marker.png";
}
co.doubleduck.BaseAssets.setLocalizedAssets = function(assets) {
	co.doubleduck.BaseAssets._localizedAssets = assets;
}
co.doubleduck.BaseAssets.audioLoaded = function(event) {
	co.doubleduck.BaseAssets._cacheData[event.item.src] = event;
}
co.doubleduck.BaseAssets.manifestFileLoad = function(event) {
	if(co.doubleduck.BaseAssets._useLocalStorage && event != null) {
		var utils = new ddjsutils();
		try {
			var fileName = event.item.src;
			if(HxOverrides.substr(fileName,fileName.length - 3,null) == "jpg") return;
			co.doubleduck.BasePersistence.setValue(event.item.src,utils.getBase64Image(event.result));
		} catch( err ) {
		}
	}
}
co.doubleduck.BaseAssets.loadFromLocalStorage = function(manifest) {
	var entriesToRemove = new Array();
	var _g1 = 0, _g = manifest.length;
	while(_g1 < _g) {
		var i = _g1++;
		var entry = manifest[i];
		var value = co.doubleduck.BasePersistence.getValue(entry);
		if(value != null) {
			var bmp = new createjs.Bitmap("data:image/png;base64," + value);
			co.doubleduck.BaseAssets._cacheData[entry] = bmp.image;
			entriesToRemove.push(manifest[i]);
		}
	}
	var _g1 = 0, _g = entriesToRemove.length;
	while(_g1 < _g) {
		var j = _g1++;
		HxOverrides.remove(manifest,entriesToRemove[j]);
	}
}
co.doubleduck.BaseAssets.handleProgress = function(event) {
	co.doubleduck.BaseAssets.loaded = event.loaded;
	if(event.loaded == event.total) {
		co.doubleduck.BaseAssets.loader().onProgress = null;
		co.doubleduck.BaseAssets.onLoadAll();
	}
}
co.doubleduck.BaseAssets.handleLoadError = function(event) {
}
co.doubleduck.BaseAssets.handleFileLoaded = function(event) {
	if(event != null) {
		co.doubleduck.BaseAssets._cacheData[event.item.src] = event.result;
		var callbackFunc = Reflect.field(co.doubleduck.BaseAssets._loadCallbacks,event.item.src);
		if(callbackFunc != null) callbackFunc();
	}
}
co.doubleduck.BaseAssets.getAsset = function(uri) {
	var cache = Reflect.field(co.doubleduck.BaseAssets._cacheData,uri);
	if(cache == null) {
		if(co.doubleduck.BaseAssets.loader().getResult(uri) != null) {
			cache = co.doubleduck.BaseAssets.loader().getResult(uri);
			co.doubleduck.BaseAssets._cacheData[uri] = cache;
		}
	}
	return cache;
}
co.doubleduck.BaseAssets.getLocalisedImage = function(image) {
	var currItem = image;
	if(co.doubleduck.BaseAssets._localizedAssets != null && Lambda.indexOf(co.doubleduck.BaseAssets._localizedAssets,currItem) != -1) {
		var delim = ".png";
		var delimIndex = currItem.indexOf(delim);
		var localisedItem = HxOverrides.substr(currItem,0,delimIndex);
		localisedItem += "-" + co.doubleduck.BaseGame.activeLocale + ".png";
		return localisedItem;
	}
	return currItem;
}
co.doubleduck.BaseAssets.getRawImage = function(uri) {
	uri = co.doubleduck.BaseAssets.getLocalisedImage(uri);
	var cache = co.doubleduck.BaseAssets.getAsset(uri);
	if(cache == null) {
		var bmp = new createjs.Bitmap(uri);
		co.doubleduck.BaseAssets._cacheData[uri] = bmp.image;
		cache = bmp.image;
		null;
	}
	return cache;
}
co.doubleduck.BaseAssets.getImage = function(uri,mouseEnabled) {
	if(mouseEnabled == null) mouseEnabled = false;
	var result = new createjs.Bitmap(co.doubleduck.BaseAssets.getRawImage(uri));
	result.mouseEnabled = mouseEnabled;
	return result;
}
co.doubleduck.BaseAssets.prototype = {
	__class__: co.doubleduck.BaseAssets
}
co.doubleduck.Assets = $hxClasses["co.doubleduck.Assets"] = function() {
	co.doubleduck.BaseAssets.call(this);
};
co.doubleduck.Assets.__name__ = ["co","doubleduck","Assets"];
co.doubleduck.Assets.loadAll = function() {
	var manifest = new Array();
	var sounds = new Array();
	sounds.push("sound/button");
	sounds.push("sound/car_pass");
	sounds.push("sound/crash");
	sounds.push("sound/level_complete");
	sounds.push("sound/level_fail");
	sounds.push("sound/rail_barrier");
	sounds.push("sound/menu_music");
	co.doubleduck.BaseAssets.loadAll(manifest,sounds);
	var localisedAssets = [];
	manifest.push("images/general/logo.png");
	var _g = 0;
	while(_g < 10) {
		var i = _g++;
		manifest.push("images/general/font_small/" + i + ".png");
	}
	manifest.push("images/splash/bg1.jpg");
	manifest.push("images/splash/bg3.png");
	manifest.push("images/splash/block.png");
	manifest.push("images/splash/blur.png");
	manifest.push("images/splash/car.png");
	manifest.push("images/splash/car2.png");
	manifest.push("images/splash/man1.jpg");
	manifest.push("images/splash/man2.jpg");
	manifest.push("images/splash/train.png");
	manifest.push("images/splash/lights.png");
	manifest.push("images/splash/sepia.png");
	manifest.push("images/menu/help.png");
	manifest.push("images/menu/arrow.png");
	manifest.push("images/menu/level_list.png");
	manifest.push("images/menu/level.png");
	manifest.push("images/menu/level_completed.png");
	manifest.push("images/menu/level_locked.png");
	manifest.push("images/menu/sound.png");
	var _g = 0;
	while(_g < 10) {
		var i = _g++;
		manifest.push("images/menu/font/" + i + ".png");
	}
	manifest.push("images/menu/help_screen.png");
	manifest.push("images/menu/help1.png");
	manifest.push("images/menu/help2.png");
	manifest.push("images/menu/next.png");
	manifest.push("images/menu/gotit.png");
	localisedAssets = localisedAssets.concat(["images/menu/gotit.png","images/menu/help1.png","images/menu/help2.png","images/menu/next.png"]);
	manifest.push("images/session/grass.jpg");
	manifest.push("images/session/car.png");
	manifest.push("images/session/road.png");
	manifest.push("images/session/rail_track.png");
	manifest.push("images/session/intersection.png");
	manifest.push("images/session/barrier_stop.png");
	manifest.push("images/session/barrier_go.png");
	manifest.push("images/session/train.png");
	manifest.push("images/session/enginecar.png");
	manifest.push("images/session/traincar.png");
	manifest.push("images/session/crash_focus.png");
	manifest.push("images/session/closeproximity.png");
	manifest.push("images/session/explosion.png");
	var _g = 1;
	while(_g < 12) {
		var i = _g++;
		manifest.push("images/session/car" + i + "u.png");
		manifest.push("images/session/car" + i + "d.png");
	}
	manifest.push("images/session/level_end/play.png");
	manifest.push("images/session/level_end/pause.png");
	manifest.push("images/session/hud/pause.png");
	manifest.push("images/session/hud/cars.png");
	manifest.push("images/session/hud/time.png");
	manifest.push("images/session/level_end/fail1.png");
	manifest.push("images/session/level_end/fail2.png");
	manifest.push("images/session/level_end/success1.png");
	manifest.push("images/session/level_end/light.png");
	manifest.push("images/session/level_end/menu.png");
	manifest.push("images/session/level_end/next.png");
	manifest.push("images/session/level_end/retry.png");
	manifest.push("images/session/level_end/endgame.png");
	localisedAssets = localisedAssets.concat(["images/session/level_end/endgame.png","images/session/level_end/fail1.png","images/session/level_end/fail2.png","images/session/level_end/pause.png","images/session/level_end/success1.png"]);
	co.doubleduck.BaseAssets.setLocalizedAssets(localisedAssets);
	co.doubleduck.BaseAssets.finishLoading(manifest,sounds);
}
co.doubleduck.Assets.__super__ = co.doubleduck.BaseAssets;
co.doubleduck.Assets.prototype = $extend(co.doubleduck.BaseAssets.prototype,{
	__class__: co.doubleduck.Assets
});
co.doubleduck.Barrier = $hxClasses["co.doubleduck.Barrier"] = function(direction) {
	createjs.Container.call(this);
	this._state = co.doubleduck.BarrierState.STOP;
	if(direction == 1) {
		this._stopUri = "images/session/barrier_stop.png";
		this._goUri = "images/session/barrier_go.png";
	} else {
		this._stopUri = "images/session/barrier_stop.png";
		this._goUri = "images/session/barrier_go.png";
	}
	this._barrier = co.doubleduck.BaseAssets.getImage(this._stopUri,true);
	this._barrier.regX = this._barrier.regY = 0;
	this._barrier.scaleX = this._barrier.scaleY = co.doubleduck.BaseGame.getScale();
	this.addChild(this._barrier);
	this._overlay = new createjs.Shape();
	this._overlay.graphics.beginFill("#000000");
	this._overlay.graphics.drawRect(0,0,this._barrier.image.width * co.doubleduck.BaseGame.getScale(),this._barrier.image.height * co.doubleduck.BaseGame.getScale());
	this._overlay.graphics.endFill();
	this._overlay.alpha = 0.01;
	this._overlay.mouseEnabled = true;
	this._overlay.onPress = $bind(this,this.changeState);
	this.addChild(this._overlay);
};
co.doubleduck.Barrier.__name__ = ["co","doubleduck","Barrier"];
co.doubleduck.Barrier.__super__ = createjs.Container;
co.doubleduck.Barrier.prototype = $extend(createjs.Container.prototype,{
	getHeight: function() {
		return this._barrier.image.height;
	}
	,getWidth: function() {
		return this._barrier.image.width;
	}
	,getState: function() {
		return this._state;
	}
	,changeState: function() {
		if(co.doubleduck.GameStateManager.getIsGameRunning()) {
			if(this._state == co.doubleduck.BarrierState.GO) {
				this._state = co.doubleduck.BarrierState.STOP;
				this._barrier.image = co.doubleduck.BaseAssets.getRawImage(this._stopUri);
			} else {
				this._state = co.doubleduck.BarrierState.GO;
				this._barrier.image = co.doubleduck.BaseAssets.getRawImage(this._goUri);
			}
			co.doubleduck.SoundManager.playEffect("sound/rail_barrier");
		}
	}
	,_overlay: null
	,_barrier: null
	,_goUri: null
	,_stopUri: null
	,_state: null
	,__class__: co.doubleduck.Barrier
});
co.doubleduck.BarrierState = $hxClasses["co.doubleduck.BarrierState"] = { __ename__ : ["co","doubleduck","BarrierState"], __constructs__ : ["STOP","GO"] }
co.doubleduck.BarrierState.STOP = ["STOP",0];
co.doubleduck.BarrierState.STOP.toString = $estr;
co.doubleduck.BarrierState.STOP.__enum__ = co.doubleduck.BarrierState;
co.doubleduck.BarrierState.GO = ["GO",1];
co.doubleduck.BarrierState.GO.toString = $estr;
co.doubleduck.BarrierState.GO.__enum__ = co.doubleduck.BarrierState;
co.doubleduck.BaseGame = $hxClasses["co.doubleduck.BaseGame"] = function(stage) {
	this._waitingToStart = false;
	this._orientError = null;
	this._prevWinSize = new createjs.Rectangle(0,0,1,1);
	if(co.doubleduck.BaseGame._wantLandscape) {
		co.doubleduck.BaseGame.MAX_HEIGHT = 320;
		co.doubleduck.BaseGame.MAX_WIDTH = 570;
	} else {
		co.doubleduck.BaseGame.MAX_HEIGHT = 570;
		co.doubleduck.BaseGame.MAX_WIDTH = 320;
	}
	if(co.doubleduck.BaseGame.DEBUG) co.doubleduck.BasePersistence.clearAll();
	var isGS3Stock = /Android 4.0.4/.test(navigator.userAgent);
	isGS3Stock = isGS3Stock && /GT-I9300/.test(navigator.userAgent);
	isGS3Stock = isGS3Stock && !/Chrome/.test(navigator.userAgent);
	if(isGS3Stock) {
		var loc = window.location.href;
		if(loc.lastIndexOf("index.html") != -1) loc = HxOverrides.substr(loc,0,loc.lastIndexOf("index.html"));
		loc += "error.html";
		window.location.href=loc;
		return;
	}
	co.doubleduck.Persistence.initGameData();
	co.doubleduck.BaseGame._stage = stage;
	co.doubleduck.BaseGame._stage.onTick = $bind(this,this.handleStageTick);
	co.doubleduck.BaseGame._viewport = new createjs.Rectangle(0,0,1,1);
	co.doubleduck.BaseGame.hammer = new Hammer(js.Lib.document.getElementById("stageCanvas"));
	viewporter.preventPageScroll = true;
	viewporter.change($bind(this,this.handleViewportChanged));
	if(viewporter.ACTIVE) {
		viewporter.preventPageScroll = true;
		viewporter.change($bind(this,this.handleViewportChanged));
		if(co.doubleduck.BaseGame._wantLandscape != viewporter.isLandscape()) {
			if(co.doubleduck.BaseGame._wantLandscape) co.doubleduck.BaseAssets.loadAndCall(co.doubleduck.BaseGame.ORIENT_LAND_URI,$bind(this,this.waitForOrientation)); else co.doubleduck.BaseAssets.loadAndCall(co.doubleduck.BaseGame.ORIENT_PORT_URI,$bind(this,this.waitForOrientation));
		} else co.doubleduck.BaseAssets.loadAndCall(co.doubleduck.BaseGame.LOGO_URI,$bind(this,this.loadBarFill));
	} else co.doubleduck.BaseAssets.loadAndCall(co.doubleduck.BaseGame.LOGO_URI,$bind(this,this.loadBarFill));
};
co.doubleduck.BaseGame.__name__ = ["co","doubleduck","BaseGame"];
co.doubleduck.BaseGame._stage = null;
co.doubleduck.BaseGame._wantLandscape = null;
co.doubleduck.BaseGame.MAX_HEIGHT = null;
co.doubleduck.BaseGame.MAX_WIDTH = null;
co.doubleduck.BaseGame.activeLocale = null;
co.doubleduck.BaseGame.availableLocales = null;
co.doubleduck.BaseGame.defaultLocale = null;
co.doubleduck.BaseGame.hammer = null;
co.doubleduck.BaseGame.getViewport = function() {
	return co.doubleduck.BaseGame._viewport;
}
co.doubleduck.BaseGame.getScreenSize = function() {
	if(co.doubleduck.BaseGame._wantLandscape) return new createjs.Rectangle(0,0,Math.floor(co.doubleduck.BaseGame._viewport.width / co.doubleduck.BaseGame._scale),co.doubleduck.BaseGame.MAX_HEIGHT); else return new createjs.Rectangle(0,0,co.doubleduck.BaseGame.MAX_WIDTH,Math.floor(co.doubleduck.BaseGame._viewport.height / co.doubleduck.BaseGame._scale));
}
co.doubleduck.BaseGame.getScale = function() {
	return co.doubleduck.BaseGame._scale;
}
co.doubleduck.BaseGame.getStage = function() {
	return co.doubleduck.BaseGame._stage;
}
co.doubleduck.BaseGame.prototype = {
	setScale: function() {
		var fixedVal = co.doubleduck.BaseGame._viewport.width;
		var varVal = co.doubleduck.BaseGame._viewport.height;
		var idealFixed = co.doubleduck.BaseGame.MAX_WIDTH;
		var idealVar = co.doubleduck.BaseGame.MAX_HEIGHT;
		if(co.doubleduck.BaseGame._wantLandscape) {
			fixedVal = co.doubleduck.BaseGame._viewport.height;
			varVal = co.doubleduck.BaseGame._viewport.width;
			idealFixed = co.doubleduck.BaseGame.MAX_HEIGHT;
			idealVar = co.doubleduck.BaseGame.MAX_WIDTH;
		}
		var regScale = varVal / idealVar;
		if(fixedVal >= varVal) co.doubleduck.BaseGame._scale = regScale; else if(idealFixed * regScale < fixedVal) co.doubleduck.BaseGame._scale = fixedVal / idealFixed; else co.doubleduck.BaseGame._scale = regScale;
	}
	,handleViewportChanged: function() {
		if(co.doubleduck.BaseGame._wantLandscape != viewporter.isLandscape()) {
			if(this._orientError == null) {
				var err = co.doubleduck.BaseGame.ORIENT_PORT_URI;
				if(co.doubleduck.BaseGame._wantLandscape) err = co.doubleduck.BaseGame.ORIENT_LAND_URI;
				this._orientError = co.doubleduck.BaseAssets.getImage(err);
				this._orientError.regX = this._orientError.image.width / 2;
				this._orientError.regY = this._orientError.image.height / 2;
				this._orientError.x = co.doubleduck.BaseGame._viewport.height / 2;
				this._orientError.y = co.doubleduck.BaseGame._viewport.width / 2;
				co.doubleduck.BaseGame._stage.addChildAt(this._orientError,co.doubleduck.BaseGame._stage.getNumChildren());
				co.doubleduck.BaseGame._stage.update();
			}
		} else if(this._orientError != null) {
			co.doubleduck.BaseGame._stage.removeChild(this._orientError);
			this._orientError = null;
			if(createjs.Ticker.getPaused()) co.doubleduck.BaseGame._stage.update();
			if(this._waitingToStart) {
				this._waitingToStart = false;
				co.doubleduck.BaseAssets.loadAndCall(co.doubleduck.BaseGame.LOGO_URI,$bind(this,this.loadBarFill));
			}
		}
	}
	,focused: function() {
		co.doubleduck.SoundManager.unmute();
	}
	,blured: function(e) {
		co.doubleduck.SoundManager.mute();
	}
	,handleResize: function(e) {
		var isFirefox = /Firefox/.test(navigator.userAgent);
		var isAndroid = /Android/.test(navigator.userAgent);
		var screenW = js.Lib.window.innerWidth;
		var screenH = js.Lib.window.innerHeight;
		co.doubleduck.BaseGame._stage.canvas.width = screenW;
		co.doubleduck.BaseGame._stage.canvas.height = screenH;
		var shouldResize = co.doubleduck.BaseGame._wantLandscape == viewporter.isLandscape() || !viewporter.ACTIVE;
		if(shouldResize) {
			if(isFirefox) {
				screenH = Math.floor(co.doubleduck.Main.getFFHeight());
				var ffEstimate = Math.ceil((js.Lib.window.screen.height - 110) * (screenW / js.Lib.window.screen.width));
				if(!isAndroid) ffEstimate = Math.ceil(js.Lib.window.screen.height * (screenW / js.Lib.window.screen.width));
				if(ffEstimate < screenH) screenH = Math.floor(ffEstimate);
			}
			var wrongSize = screenH < screenW;
			if(co.doubleduck.BaseGame._wantLandscape) wrongSize = screenH > screenW;
			if(!viewporter.ACTIVE || !wrongSize) {
				co.doubleduck.BaseGame._viewport.width = screenW;
				co.doubleduck.BaseGame._viewport.height = screenH;
				this.setScale();
			}
			if(this._orientError != null && isFirefox) this.handleViewportChanged();
		} else if(isFirefox) this.handleViewportChanged();
		if(createjs.Ticker.getPaused()) co.doubleduck.BaseGame._stage.update();
	}
	,handleBackToMenu: function() {
		this._session.destroy();
		co.doubleduck.BaseGame._stage.removeChild(this._session);
		this._session = null;
		this._menu = new co.doubleduck.Menu();
		co.doubleduck.BaseGame._stage.addChildAt(this._menu,0);
		this._menu.onPlayClick = $bind(this,this.handlePlayClick);
	}
	,handleRestart: function(properties) {
		this._session.destroy();
		co.doubleduck.BaseGame._stage.removeChild(this._session);
		this._session = null;
		this.startSession(properties);
	}
	,handleSessionEnd: function() {
	}
	,handlePlayClick: function(properties) {
		co.doubleduck.BaseGame._stage.removeChild(this._menu);
		this.startSession(properties);
		this._menu.destroy();
		this._menu = null;
	}
	,startSession: function(properties) {
		this._session = new co.doubleduck.Session(properties);
		this._session.onBackToMenu = $bind(this,this.handleBackToMenu);
		this._session.onRestart = $bind(this,this.handleRestart);
		this._session.onSessionEnd = $bind(this,this.handleSessionEnd);
		co.doubleduck.BaseGame._stage.addChild(this._session);
	}
	,showMenu: function() {
		this._menu = new co.doubleduck.Menu();
		co.doubleduck.BaseGame._stage.addChildAt(this._menu,0);
		this._menu.onPlayClick = $bind(this,this.handlePlayClick);
	}
	,alphaFade: function(fadeElement) {
		if(fadeElement != null && js.Boot.__instanceof(fadeElement,createjs.Bitmap)) this._fadedText = fadeElement; else if(this._fadedText == null) return;
		if(this._fadedText.alpha == 0) createjs.Tween.get(this._fadedText).to({ alpha : 1},750).call($bind(this,this.alphaFade)); else if(this._fadedText.alpha == 1) createjs.Tween.get(this._fadedText).to({ alpha : 0},1500).call($bind(this,this.alphaFade));
	}
	,showGameSplash: function() {
	}
	,splashEnded: function() {
		js.Lib.document.body.bgColor = "#000000";
		co.doubleduck.BaseGame._stage.removeChild(this._splash);
		this._splash = null;
		js.Lib.window.onresize = $bind(this,this.handleResize);
		this.handleResize(null);
		this.showGameSplash();
	}
	,handleDoneLoading: function() {
		createjs.Tween.get(this._splash).wait(200).to({ alpha : 0},800).call($bind(this,this.splashEnded));
		co.doubleduck.BaseGame._stage.removeChild(this._loadingBar);
		co.doubleduck.BaseGame._stage.removeChild(this._loadingStroke);
	}
	,updateLoading: function() {
		if(co.doubleduck.BaseAssets.loaded != 1) {
			this._loadingBar.visible = true;
			var percent = co.doubleduck.BaseAssets.loaded;
			var barMask = new createjs.Shape();
			barMask.graphics.beginFill("#00000000");
			barMask.graphics.drawRect(this._loadingBar.x - this._loadingBar.image.width / 2,this._loadingBar.y,this._loadingBar.image.width * percent | 0,this._loadingBar.image.height);
			barMask.graphics.endFill();
			this._loadingBar.mask = barMask;
			co.doubleduck.Utils.waitAndCall(this,10,$bind(this,this.updateLoading));
		}
	}
	,exitFocus: function() {
		var hidden = document.mozHidden;
		if(hidden) co.doubleduck.SoundManager.mute(false); else if(!co.doubleduck.SoundManager.getPersistedMute()) co.doubleduck.SoundManager.unmute(false);
	}
	,showSplash: function() {
		if(viewporter.ACTIVE) js.Lib.document.body.bgColor = "#00A99D"; else js.Lib.document.body.bgColor = "#D94D00";
		this._splash = co.doubleduck.BaseAssets.getImage(co.doubleduck.BaseGame.LOGO_URI);
		this._splash.regX = this._splash.image.width / 2;
		this._splash.x = js.Lib.window.innerWidth / 2;
		if(co.doubleduck.BaseGame._wantLandscape) this._splash.y = 20; else this._splash.y = 90;
		co.doubleduck.BaseGame._stage.addChild(this._splash);
		this._loadingStroke = co.doubleduck.BaseAssets.getImage(co.doubleduck.BaseGame.LOAD_STROKE_URI);
		this._loadingStroke.regX = this._loadingStroke.image.width / 2;
		co.doubleduck.BaseGame._stage.addChildAt(this._loadingStroke,0);
		this._loadingBar = co.doubleduck.BaseAssets.getImage(co.doubleduck.BaseGame.LOAD_FILL_URI);
		this._loadingBar.regX = this._loadingBar.image.width / 2;
		co.doubleduck.BaseGame._stage.addChildAt(this._loadingBar,1);
		this._loadingBar.x = js.Lib.window.innerWidth / 2;
		this._loadingBar.y = this._splash.y + 192;
		this._loadingStroke.x = this._loadingBar.x;
		this._loadingStroke.y = this._loadingBar.y;
		this._loadingBar.visible = false;
		this.updateLoading();
		co.doubleduck.BaseGame._stage.canvas.width = js.Lib.window.innerWidth;
		co.doubleduck.BaseGame._stage.canvas.height = js.Lib.window.innerHeight;
		co.doubleduck.BaseAssets.onLoadAll = $bind(this,this.handleDoneLoading);
		co.doubleduck.Assets.loadAll();
	}
	,loadLocale: function() {
		if(co.doubleduck.BaseGame.isLocalized) {
			var lang = navigator.language;
			lang = HxOverrides.substr(lang.toLowerCase(),0,2);
			if(co.doubleduck.BaseGame.availableLocales != null && co.doubleduck.BaseGame.availableLocales.length > 0) {
				if(Lambda.indexOf(co.doubleduck.BaseGame.availableLocales,lang) != -1) {
					co.doubleduck.BaseGame.activeLocale = lang;
					this.showSplash();
					return;
				} else {
					co.doubleduck.BaseGame.activeLocale = co.doubleduck.BaseGame.defaultLocale;
					this.showSplash();
					return;
				}
			} else {
				co.doubleduck.BaseGame.activeLocale = co.doubleduck.BaseGame.defaultLocale;
				if(co.doubleduck.BaseGame.defaultLocale == null) throw "DDException: default locale not set";
			}
		}
		this.showSplash();
	}
	,waitForOrientation: function() {
		this._waitingToStart = true;
		if(this._orientError == null) {
			this._orientError = this.getErrorImage();
			this._orientError.regX = this._orientError.image.width / 2;
			this._orientError.regY = this._orientError.image.height / 2;
			this._orientError.x = js.Lib.window.innerWidth / 2;
			this._orientError.y = js.Lib.window.innerHeight / 2;
			co.doubleduck.BaseGame._stage.addChildAt(this._orientError,co.doubleduck.BaseGame._stage.getNumChildren());
		}
	}
	,getErrorImage: function() {
		if(co.doubleduck.BaseGame._wantLandscape) return co.doubleduck.BaseAssets.getImage(co.doubleduck.BaseGame.ORIENT_LAND_URI); else return co.doubleduck.BaseAssets.getImage(co.doubleduck.BaseGame.ORIENT_PORT_URI);
	}
	,loadBarStroke: function() {
		co.doubleduck.BaseAssets.loadAndCall(co.doubleduck.BaseGame.LOAD_STROKE_URI,$bind(this,this.loadLocale));
	}
	,loadBarFill: function() {
		co.doubleduck.BaseAssets.loadAndCall(co.doubleduck.BaseGame.LOAD_FILL_URI,$bind(this,this.loadBarStroke));
	}
	,handleStageTick: function() {
		if(js.Lib.window.innerWidth != this._prevWinSize.width || js.Lib.window.innerHeight != this._prevWinSize.height) {
			this._prevWinSize.width = js.Lib.window.innerWidth;
			this._prevWinSize.height = js.Lib.window.innerHeight;
			this.handleResize(null);
		}
	}
	,_prevWinSize: null
	,_fadedText: null
	,_loadingStroke: null
	,_loadingBar: null
	,_waitingToStart: null
	,_orientError: null
	,_session: null
	,_menu: null
	,_splash: null
	,__class__: co.doubleduck.BaseGame
}
co.doubleduck.BaseMenu = $hxClasses["co.doubleduck.BaseMenu"] = function() {
	createjs.Container.call(this);
};
co.doubleduck.BaseMenu.__name__ = ["co","doubleduck","BaseMenu"];
co.doubleduck.BaseMenu.__super__ = createjs.Container;
co.doubleduck.BaseMenu.prototype = $extend(createjs.Container.prototype,{
	destroy: function() {
		this.onPlayClick = null;
	}
	,onPlayClick: null
	,__class__: co.doubleduck.BaseMenu
});
co.doubleduck.BasePersistence = $hxClasses["co.doubleduck.BasePersistence"] = function() { }
co.doubleduck.BasePersistence.__name__ = ["co","doubleduck","BasePersistence"];
co.doubleduck.BasePersistence.localStorageSupported = function() {
	var result = null;
	try {
		localStorage.setItem("test","test");
		localStorage.removeItem("test");
		result = true;
	} catch( e ) {
		result = false;
	}
	return result;
}
co.doubleduck.BasePersistence.getValue = function(key) {
	if(!co.doubleduck.BasePersistence.available) return "0";
	var val = localStorage[co.doubleduck.BasePersistence.GAME_PREFIX + key];
	return val;
}
co.doubleduck.BasePersistence.setValue = function(key,value) {
	if(!co.doubleduck.BasePersistence.available) return;
	localStorage[co.doubleduck.BasePersistence.GAME_PREFIX + key] = value;
}
co.doubleduck.BasePersistence.clearAll = function() {
	if(!co.doubleduck.BasePersistence.available) return;
	localStorage.clear();
}
co.doubleduck.BasePersistence.initVar = function(initedVar,defaultVal) {
	if(defaultVal == null) defaultVal = "0";
	var value = co.doubleduck.BasePersistence.getValue(initedVar);
	if(value == null) try {
		co.doubleduck.BasePersistence.setValue(initedVar,defaultVal);
	} catch( e ) {
		co.doubleduck.BasePersistence.available = false;
	}
}
co.doubleduck.BasePersistence.getDynamicValue = function(key) {
	if(!co.doubleduck.BasePersistence.available) return { };
	var val = localStorage[co.doubleduck.BasePersistence.GAME_PREFIX + key];
	return val;
}
co.doubleduck.BasePersistence.setDynamicValue = function(key,value) {
	if(!co.doubleduck.BasePersistence.available) return;
	localStorage[co.doubleduck.BasePersistence.GAME_PREFIX + key] = value;
}
co.doubleduck.BasePersistence.initDynamicVar = function(initedVar,defaultVal) {
	var value = co.doubleduck.BasePersistence.getDynamicValue(initedVar);
	if(value == null) try {
		co.doubleduck.BasePersistence.setDynamicValue(initedVar,defaultVal);
	} catch( e ) {
		co.doubleduck.BasePersistence.available = false;
	}
}
co.doubleduck.BasePersistence.printAll = function() {
	var ls = localStorage;
	var localStorageLength = ls.length;
	var _g = 0;
	while(_g < localStorageLength) {
		var entry = _g++;
		null;
	}
}
co.doubleduck.BaseSession = $hxClasses["co.doubleduck.BaseSession"] = function() {
	createjs.Container.call(this);
};
co.doubleduck.BaseSession.__name__ = ["co","doubleduck","BaseSession"];
co.doubleduck.BaseSession.__super__ = createjs.Container;
co.doubleduck.BaseSession.prototype = $extend(createjs.Container.prototype,{
	destroy: function() {
		createjs.Ticker.removeListener(this);
		this.onRestart = null;
		this.onBackToMenu = null;
		this.onSessionEnd = null;
		this.onNextLevel = null;
	}
	,sessionEnded: function() {
		if(this.onSessionEnd != null) {
			createjs.Ticker.setPaused(false);
			this.onSessionEnd();
		}
	}
	,handleReplayClick: function(properties) {
		if(this.onRestart != null) {
			createjs.Ticker.setPaused(false);
			this.onRestart(properties);
		}
	}
	,handleMenuClick: function() {
		if(this.onBackToMenu != null) {
			createjs.Ticker.setPaused(false);
			this.onBackToMenu();
		}
	}
	,_replayBtn: null
	,_menuBtn: null
	,onNextLevel: null
	,onBackToMenu: null
	,onSessionEnd: null
	,onRestart: null
	,__class__: co.doubleduck.BaseSession
});
co.doubleduck.LabeledContainer = $hxClasses["co.doubleduck.LabeledContainer"] = function(bmp) {
	createjs.Container.call(this);
	this._bitmap = bmp;
	if(this._bitmap != null) {
		if(js.Boot.__instanceof(this._bitmap,createjs.Bitmap)) {
			this._bmp = this._bitmap;
			this.image = this._bmp.image;
		} else if(js.Boot.__instanceof(this._bitmap,createjs.BitmapAnimation)) {
			this.anim = this._bitmap;
			this.image = { width : this.anim.spriteSheet._frameWidth, height : this.anim.spriteSheet._frameHeight};
		}
	}
};
co.doubleduck.LabeledContainer.__name__ = ["co","doubleduck","LabeledContainer"];
co.doubleduck.LabeledContainer.__super__ = createjs.Container;
co.doubleduck.LabeledContainer.prototype = $extend(createjs.Container.prototype,{
	getLabel: function() {
		return this._label;
	}
	,addBitmap: function() {
		this.addChild(this._bitmap);
	}
	,addCenteredBitmap: function() {
		this._bitmap.regX = this.image.width / 2;
		this._bitmap.regY = this.image.height / 2;
		this._bitmap.x = this.image.width / 2;
		this._bitmap.y = this.image.height / 2;
		this.addChild(this._bitmap);
	}
	,addBitmapLabel: function(label,fontType,padding,centered) {
		if(centered == null) centered = true;
		if(padding == null) padding = 0;
		if(fontType == null) fontType = "";
		if(this._bitmapText != null) this.removeChild(this._bitmapText);
		var fontHelper = new co.doubleduck.FontHelper(fontType);
		this._bitmapText = fontHelper.getNumber(Std.parseInt(label),1,true,null,padding,centered);
		if(this.image != null) {
			this._bitmapText.x = this.image.width / 2;
			this._bitmapText.y = this.image.height / 2;
		}
		this._label = label;
		this.addChild(this._bitmapText);
	}
	,scaleBitmapFont: function(scale) {
		this._bitmapText.scaleX = this._bitmapText.scaleY = scale;
	}
	,shiftLabel: function(shiftX,shiftY) {
		this._bitmapText.x *= shiftX;
		this._bitmapText.y *= shiftY;
	}
	,setBitmapLabelY: function(ly) {
		this._bitmapText.y = ly;
	}
	,setBitmapLabelX: function(lx) {
		this._bitmapText.x = lx;
	}
	,getBitmapLabelWidth: function() {
		var maxWidth = 0;
		var _g1 = 0, _g = this._bitmapText.getNumChildren();
		while(_g1 < _g) {
			var digit = _g1++;
			var currentDigit = js.Boot.__cast(this._bitmapText.getChildAt(digit) , createjs.Bitmap);
			var endsAt = currentDigit.x + currentDigit.image.width;
			if(endsAt > maxWidth) maxWidth = endsAt;
		}
		return maxWidth;
	}
	,setLabelY: function(ly) {
		this._text.y = ly;
	}
	,setLabelX: function(lx) {
		this._text.x = lx;
	}
	,addLabel: function(label,color) {
		if(color == null) color = "#000000";
		if(this._text != null) this.removeChild(this._text);
		this._label = label;
		this._text = new createjs.Text(label,"bold 22px Arial",color);
		this._text.regY = this._text.getMeasuredHeight() / 2;
		this._text.textAlign = "center";
		if(this._bitmap != null) {
			this._text.x = this._bitmap.x;
			this._text.y = this._bitmap.y;
		}
		this.addChild(this._text);
	}
	,changeText: function(txt) {
	}
	,_bitmapText: null
	,_text: null
	,_bmp: null
	,_bitmap: null
	,_label: null
	,anim: null
	,image: null
	,__class__: co.doubleduck.LabeledContainer
});
co.doubleduck.Button = $hxClasses["co.doubleduck.Button"] = function(bmp,pauseAffected,clickType,clickSound) {
	if(clickType == null) clickType = 2;
	if(pauseAffected == null) pauseAffected = true;
	this._lastClickTime = 0;
	co.doubleduck.LabeledContainer.call(this,bmp);
	if(clickSound == null && co.doubleduck.Button._defaultSound != null) this._clickSound = co.doubleduck.Button._defaultSound; else this._clickSound = clickSound;
	this._bitmap.mouseEnabled = true;
	this._clickType = clickType;
	this._pauseAffected = pauseAffected;
	if(clickType == co.doubleduck.Button.CLICK_TYPE_TOGGLE) {
		var initObject = { };
		var size = this.image.width / 2;
		initObject.images = [this.image];
		initObject.frames = { width : size, height : this.image.height, regX : size / 2, regY : this.image.height / 2};
		this._states = new createjs.BitmapAnimation(new createjs.SpriteSheet(initObject));
		this._states.gotoAndStop(0);
		this.onClick = $bind(this,this.handleToggle);
		this.addChild(this._states);
	} else this.addCenteredBitmap();
	this.onPress = $bind(this,this.handlePress);
};
co.doubleduck.Button.__name__ = ["co","doubleduck","Button"];
co.doubleduck.Button.setDefaultSound = function(sound) {
	co.doubleduck.Button._defaultSound = sound;
}
co.doubleduck.Button.__super__ = co.doubleduck.LabeledContainer;
co.doubleduck.Button.prototype = $extend(co.doubleduck.LabeledContainer.prototype,{
	handleEndPressTint: function() {
		co.doubleduck.Utils.tintBitmap(this._bmp,1,1,1,1);
		if(createjs.Ticker.getPaused()) co.doubleduck.BaseGame.getStage().update();
	}
	,setToggle: function(flag) {
		if(flag) this._states.gotoAndStop(0); else this._states.gotoAndStop(1);
	}
	,handleToggle: function(e) {
		if(this.onToggle == null) return;
		if(this._lastClickPos == null) this._lastClickPos = new createjs.Point(0,0);
		if((this._lastClickPos.x < e.stageX + 1 || this._lastClickPos.x > e.stageX + 1) && (this._lastClickPos.y < e.stageY + 1 || this._lastClickPos.y > e.stageY + 1)) {
			var now = createjs.Ticker.getTime(true);
			if(now < this._lastClickTime + 500) return;
		}
		this._lastClickPos.x = e.stageX;
		this._lastClickPos.y = e.stageY;
		this._lastClickTime = createjs.Ticker.getTime(true);
		this._states.gotoAndStop(1 - this._states.currentFrame);
		this.onToggle();
	}
	,handlePress: function(event) {
		if(createjs.Ticker.getPaused() && this._pauseAffected) return;
		if(this._clickType == co.doubleduck.Button.CLICK_TYPE_HOLD) {
			if(this.onHoldStart != null) {
				this.onHoldStart();
				event.onMouseUp = this.onHoldFinish;
			}
		}
		if(this.onClick != null) {
			if(this._clickSound != null) co.doubleduck.SoundManager.playEffect(this._clickSound);
			switch(this._clickType) {
			case co.doubleduck.Button.CLICK_TYPE_TINT:
				if(this._bmp != null) {
					co.doubleduck.Utils.tintBitmap(this._bmp,0.55,0.55,0.55,1);
					var tween = createjs.Tween.get(this._bmp);
					tween.ignoreGlobalPause = true;
					tween.wait(200).call($bind(this,this.handleEndPressTint));
					if(createjs.Ticker.getPaused()) co.doubleduck.BaseGame.getStage().update();
				}
				break;
			case co.doubleduck.Button.CLICK_TYPE_JUICY:
				this._juiceTween = createjs.Tween.get(this._bitmap);
				this._juiceTween.ignoreGlobalPause = true;
				var startScaleX = this._bitmap.scaleX;
				var startScaleY = this._bitmap.scaleY;
				this._bitmap.scaleX = startScaleX * 1.25;
				this._bitmap.scaleY = startScaleY * 0.75;
				this._juiceTween.to({ scaleX : startScaleX, scaleY : startScaleY},500,createjs.Ease.elasticOut);
				break;
			case co.doubleduck.Button.CLICK_TYPE_SCALE:
				this._juiceTween = createjs.Tween.get(this._bitmap);
				this._juiceTween.ignoreGlobalPause = true;
				var startScaleX = this._bitmap.scaleX;
				var startScaleY = this._bitmap.scaleY;
				this._bitmap.scaleX = startScaleX * 1.18;
				this._bitmap.scaleY = startScaleY * 1.18;
				this._juiceTween.to({ scaleX : startScaleX, scaleY : startScaleY},200,createjs.Ease.elasticOut);
				break;
			case co.doubleduck.Button.CLICK_TYPE_TOGGLE:
				break;
			case co.doubleduck.Button.CLICK_TYPE_NONE:
				break;
			case co.doubleduck.Button.CLICK_TYPE_HOLD:
				throw "Use onHoldStart with CLICK_TYPE_HOLD, not onClick";
				break;
			}
		}
	}
	,setNoSound: function() {
		this._clickSound = null;
	}
	,_lastClickPos: null
	,_lastClickTime: null
	,_clickSound: null
	,_juiceTween: null
	,_clickType: null
	,_pauseAffected: null
	,_states: null
	,onHoldFinish: null
	,onHoldStart: null
	,onToggle: null
	,__class__: co.doubleduck.Button
});
co.doubleduck.Car = $hxClasses["co.doubleduck.Car"] = function(direction,carSpeed) {
	createjs.Container.call(this);
	this._finishedRoad = false;
	this._closeProximityTrain = -1;
	this._direction = direction;
	co.doubleduck.Car._baseSpeed = carSpeed;
	co.doubleduck.Car._acceleration = co.doubleduck.Car._baseSpeed * 6;
	var carUri;
	if(direction == 1) carUri = "images/session/car" + (Std.random(11) + 1) + "d.png"; else carUri = "images/session/car" + (Std.random(11) + 1) + "u.png";
	this._car = co.doubleduck.BaseAssets.getImage(carUri,true);
	this.addChild(this._car);
	if(direction == 1) {
		this.y = -this._car.image.height * co.doubleduck.BaseGame.getScale();
		this.regY = 0;
	} else {
		this.y = co.doubleduck.BaseGame.getViewport().height;
		this.regY = 0;
	}
	this.x = 0;
	this.regX = this._car.image.width / 2;
	this.scaleX = co.doubleduck.BaseGame.getScale();
	this.scaleY = co.doubleduck.BaseGame.getScale();
	this._speed = co.doubleduck.Car._baseSpeed;
};
co.doubleduck.Car.__name__ = ["co","doubleduck","Car"];
co.doubleduck.Car._baseSpeed = null;
co.doubleduck.Car._acceleration = null;
co.doubleduck.Car.__super__ = createjs.Container;
co.doubleduck.Car.prototype = $extend(createjs.Container.prototype,{
	getBoundingRect: function() {
		var result = new createjs.Rectangle(this.x - co.doubleduck.BaseGame.getViewport().width / co.doubleduck.Car.TOTAL_COLS * 0.25,this.y,co.doubleduck.BaseGame.getViewport().width / co.doubleduck.Car.TOTAL_COLS * 0.5,this._car.image.height * co.doubleduck.BaseGame.getScale());
		return result;
	}
	,setCloseProximityTrain: function(closeProximity) {
		this._closeProximityTrain = closeProximity;
	}
	,getCloseProximityTrain: function() {
		return this._closeProximityTrain;
	}
	,moveCar: function(elapsed) {
		if(!this._finishedRoad) {
			var potentialY = this.y + this._direction * (this._speed * (elapsed / 1000)) * co.doubleduck.BaseGame.getScale();
			if(this._closestBarrierY != -1 && this._direction == 1 && potentialY + this._car.image.height * co.doubleduck.BaseGame.getScale() >= this._closestBarrierY) this.y = this._closestBarrierY - (this._car.image.height + co.doubleduck.Car.STOPPING_DISTANCE) * co.doubleduck.BaseGame.getScale(); else if(this._closestBarrierY != -1 && this._direction == -1 && potentialY <= this._closestBarrierY + this._closestBarrierHeight * co.doubleduck.BaseGame.getScale()) this.y = this._closestBarrierY + (this._closestBarrierHeight + co.doubleduck.Car.STOPPING_DISTANCE) * co.doubleduck.BaseGame.getScale(); else {
				this.y = potentialY;
				if(this._closestBarrierY != -1 && (this._direction == 1 && this.y >= this._closestBarrierY - (this._car.image.height + co.doubleduck.Car.STOPPING_DISTANCE * (co.doubleduck.Car._baseSpeed / 50)) * co.doubleduck.BaseGame.getScale() || this._direction == -1 && this.y <= this._closestBarrierY + (this._closestBarrierHeight + co.doubleduck.Car.STOPPING_DISTANCE * (co.doubleduck.Car._baseSpeed / 50)) * co.doubleduck.BaseGame.getScale())) {
					if(this._speed > co.doubleduck.Car._baseSpeed / 2) this._speed -= co.doubleduck.Car._acceleration * (elapsed / 1000); else this._speed = co.doubleduck.Car._baseSpeed / 2;
					if(this._speed != 0 && (this._direction == 1 && this.y >= this._closestBarrierY - (this._car.image.height + co.doubleduck.Car.STOPPING_DISTANCE) * co.doubleduck.BaseGame.getScale() || this._direction == -1 && this.y <= this._closestBarrierY + (this._closestBarrierHeight + co.doubleduck.Car.STOPPING_DISTANCE) * co.doubleduck.BaseGame.getScale())) {
						this._speed = 0;
						if(this._direction == 1) this.y = this._closestBarrierY - (this._car.image.height + co.doubleduck.Car.STOPPING_DISTANCE) * co.doubleduck.BaseGame.getScale(); else this.y = this._closestBarrierY + (this._closestBarrierHeight + co.doubleduck.Car.STOPPING_DISTANCE) * co.doubleduck.BaseGame.getScale();
					}
				} else if(this._speed < co.doubleduck.Car._baseSpeed) this._speed += co.doubleduck.Car._acceleration * (elapsed / 1000); else if(this._speed > co.doubleduck.Car._baseSpeed) this._speed = co.doubleduck.Car._baseSpeed;
			}
			if(this._direction == 1 && this.y >= co.doubleduck.BaseGame.getViewport().height || this._direction == -1 && this.y <= -this._car.image.height * co.doubleduck.BaseGame.getScale()) {
				this._finishedRoad = true;
				this.onCarFinishedRoad(this);
			}
		}
	}
	,setClosestBarrier: function(closestBarrierY,closestBarrierHeight) {
		this._closestBarrierY = closestBarrierY;
		this._closestBarrierHeight = closestBarrierHeight;
	}
	,getHeight: function() {
		return this._car.image.height;
	}
	,getWidth: function() {
		return this._car.image.width;
	}
	,debugHitbox: null
	,_finishedRoad: null
	,_closeProximityTrain: null
	,_closestBarrierHeight: null
	,_closestBarrierY: null
	,_direction: null
	,_speed: null
	,_car: null
	,onCarFinishedRoad: null
	,__class__: co.doubleduck.Car
});
co.doubleduck.DataLoader = $hxClasses["co.doubleduck.DataLoader"] = function() { }
co.doubleduck.DataLoader.__name__ = ["co","doubleduck","DataLoader"];
co.doubleduck.DataLoader._gameplayData = null;
co.doubleduck.DataLoader.getLevelData = function(levelId) {
	return co.doubleduck.DataLoader.getGameplayData().levels[levelId - 1];
}
co.doubleduck.DataLoader.getGameplayData = function() {
	if(co.doubleduck.DataLoader._gameplayData == null) {
		co.doubleduck.DataLoader._gameplayData = new GameplayDB();
		co.doubleduck.DataLoader._gameplayData = co.doubleduck.DataLoader._gameplayData.getGameplayData();
	}
	return co.doubleduck.DataLoader._gameplayData;
}
co.doubleduck.FontHelper = $hxClasses["co.doubleduck.FontHelper"] = function(type) {
	this._fontType = type;
};
co.doubleduck.FontHelper.__name__ = ["co","doubleduck","FontHelper"];
co.doubleduck.FontHelper.prototype = {
	getNumber: function(num,scale,forceContainer,dims,padding,centered) {
		if(centered == null) centered = true;
		if(padding == null) padding = 0;
		if(forceContainer == null) forceContainer = false;
		if(scale == null) scale = 1;
		if(num >= 0 && num < 10) {
			var result = new createjs.Container();
			var bmp = this.getDigit(num);
			bmp.scaleX = bmp.scaleY = scale;
			result.addChild(bmp);
			if(centered) {
				result.regX = bmp.image.width / 2;
				result.regY = bmp.image.height / 2;
			}
			if(forceContainer) {
				if(dims != null) {
					dims.width = bmp.image.width;
					dims.height = bmp.image.height;
				}
				return result;
			} else return bmp;
		} else {
			var result = new createjs.Container();
			var numString = "" + num;
			var digits = new Array();
			var totalWidth = 0;
			digits[digits.length] = this.getDigit(Std.parseInt(HxOverrides.substr(numString,0,1)));
			digits[0].scaleX = digits[0].scaleY = scale;
			result.addChild(digits[0]);
			totalWidth += digits[0].image.width * scale;
			if(numString.length == 4 || numString.length == 7) {
				this._lastComma = this.getComma();
				this._lastComma.scaleX = this._lastComma.scaleY = scale;
				this._lastComma.x = digits[0].x + digits[0].image.width + padding;
				result.addChild(this._lastComma);
				totalWidth += this._lastComma.image.width * scale;
			}
			var _g1 = 1, _g = numString.length;
			while(_g1 < _g) {
				var i = _g1++;
				var index = digits.length;
				digits[index] = this.getDigit(Std.parseInt(HxOverrides.substr(numString,i,1)));
				if(numString.length - i == 3 || numString.length - i == 6) digits[index].x = this._lastComma.x + this._lastComma.image.width + padding; else digits[index].x = digits[index - 1].x + digits[index - 1].image.width + padding;
				digits[index].scaleX = digits[index].scaleY = scale;
				result.addChild(digits[index]);
				totalWidth += digits[index].image.width * scale + padding;
				if(numString.length - i == 4 || numString.length - i == 7) {
					this._lastComma = this.getComma();
					this._lastComma.scaleX = this._lastComma.scaleY = scale;
					this._lastComma.x = digits[index].x + digits[index].image.width + padding;
					result.addChild(this._lastComma);
					totalWidth += this._lastComma.image.width * scale + padding;
				}
			}
			if(centered) {
				result.regX = totalWidth / 2;
				result.regY = digits[0].image.height / 2;
			}
			if(dims != null) {
				dims.width = totalWidth;
				dims.height = digits[0].image.height;
			}
			return result;
		}
	}
	,getDigit: function(digit) {
		var digit1 = co.doubleduck.BaseAssets.getImage(this._fontType + digit + ".png");
		return digit1;
	}
	,getComma: function() {
		return co.doubleduck.BaseAssets.getImage(this._fontType + "comma.png");
	}
	,_fontType: null
	,_lastComma: null
	,__class__: co.doubleduck.FontHelper
}
co.doubleduck.Game = $hxClasses["co.doubleduck.Game"] = function(stage) {
	co.doubleduck.BaseGame._wantLandscape = false;
	co.doubleduck.Button.setDefaultSound("sound/button");
	co.doubleduck.BaseGame.isLocalized = true;
	co.doubleduck.BaseGame.defaultLocale = "en";
	co.doubleduck.BaseGame.availableLocales = ["en","es"];
	co.doubleduck.BaseGame.call(this,stage);
};
co.doubleduck.Game.__name__ = ["co","doubleduck","Game"];
co.doubleduck.Game.__super__ = co.doubleduck.BaseGame;
co.doubleduck.Game.prototype = $extend(co.doubleduck.BaseGame.prototype,{
	handleBackToMenu: function() {
		this._session.destroy();
		co.doubleduck.BaseGame.getStage().removeChild(this._session);
		var properties = null;
		if(this._session.isNextLevelRequested()) {
			properties = { };
			properties.level = co.doubleduck.Session.getLevel() + 1;
		}
		this._session = null;
		this._menu = new co.doubleduck.Menu();
		co.doubleduck.BaseGame.getStage().addChildAt(this._menu,0);
		this._menu.onPlayClick = $bind(this,this.handlePlayClick);
		if(properties != null) this._menu.goToLevel(properties.level);
	}
	,handleTap2Play: function() {
		this._gameSplash.onTap2Play = null;
		co.doubleduck.BaseGame._stage.removeChild(this._gameSplash);
		this._gameSplash = null;
		this.showMenu();
	}
	,showGameSplash: function() {
		this._gameSplash = new co.doubleduck.GameSplash();
		this._gameSplash.onTap2Play = $bind(this,this.handleTap2Play);
		co.doubleduck.BaseGame._stage.addChild(this._gameSplash);
	}
	,_gameSplash: null
	,__class__: co.doubleduck.Game
});
co.doubleduck.GameSplash = $hxClasses["co.doubleduck.GameSplash"] = function() {
	createjs.Container.call(this);
	this._blurBG = co.doubleduck.Utils.getCenteredImage("images/splash/bg1.jpg",true);
	this._blurBG.x = co.doubleduck.BaseGame.getViewport().width / 2;
	this._blurBG.y = co.doubleduck.BaseGame.getViewport().height / 2;
	this._blurBG.mouseEnabled = true;
	this._blurBG.onClick = $bind(this,this.handleBGClick);
	this.addChild(this._blurBG);
	this._car = co.doubleduck.Utils.getCenteredImage("images/splash/car.png",true);
	this._car.x = co.doubleduck.BaseGame.getViewport().width * 0.8;
	this._car.y = this._blurBG.y + this._blurBG.image.height * 0.28 * co.doubleduck.BaseGame.getScale();
	this.addChild(this._car);
	this.shakeElement(this._car,this._car.x,this._car.y,1,4);
	createjs.Tween.get(this).wait(1500).call($bind(this,this.showTrainA));
};
co.doubleduck.GameSplash.__name__ = ["co","doubleduck","GameSplash"];
co.doubleduck.GameSplash.hasJustSeen = function() {
	var val = co.doubleduck.GameSplash._justSeenSplash;
	co.doubleduck.GameSplash._justSeenSplash = false;
	return val;
}
co.doubleduck.GameSplash.__super__ = createjs.Container;
co.doubleduck.GameSplash.prototype = $extend(createjs.Container.prototype,{
	doneBlackFade: function() {
		if(this.onTap2Play != null) this.onTap2Play();
	}
	,handleBGClick: function() {
		this.addChild(co.doubleduck.Transition.getInstance());
		co.doubleduck.Transition.transitionOut($bind(this,this.doneBlackFade));
	}
	,shakeElement: function(obj,srcX,srcY,tX,tY) {
		var dX = Math.random() * tX;
		dX *= co.doubleduck.BaseGame.getScale();
		var dY = Math.random() * tY;
		dY *= co.doubleduck.BaseGame.getScale();
		createjs.Tween.get(obj).to({ x : srcX + dX, y : srcY + dY},30).call($bind(this,this.shakeElement),[obj,srcX,srcY,tX,tY]);
	}
	,doneWithFlash: function() {
		if(this.onTap2Play != null) {
			co.doubleduck.GameSplash._justSeenSplash = true;
			this.onTap2Play();
		}
	}
	,showFlash: function(flashWhite) {
		flashWhite.visible = true;
		createjs.Tween.get(flashWhite).to({ alpha : 0},500,createjs.Ease.sineIn).call($bind(this,this.doneWithFlash));
		this._logo.visible = true;
		this._sepia.visible = true;
	}
	,disableSkip: function() {
		this._blurBG.onClick = null;
	}
	,showFinalScene: function() {
		this.removeChild(this._manIdle);
		this.removeChild(this._manPull);
		this._crossroadBG = co.doubleduck.Utils.getCenteredImage("images/splash/bg3.png",true);
		this._crossroadBG.x = co.doubleduck.BaseGame.getViewport().width / 2;
		this._crossroadBG.y = co.doubleduck.BaseGame.getViewport().height / 2;
		this.addChild(this._crossroadBG);
		var trainX = -400;
		var trainY = 30;
		this._trainBlur = co.doubleduck.Utils.getCenteredImage("images/splash/blur.png",true);
		this._trainBlur.x = this._crossroadBG.x - this._crossroadBG.image.width * 0.3 * co.doubleduck.BaseGame.getScale();
		this._trainBlur.y = this._crossroadBG.y - this._crossroadBG.image.height * 0.05 * co.doubleduck.BaseGame.getScale();
		this._trainBlur.x += trainX * co.doubleduck.BaseGame.getScale();
		this._trainBlur.y += trainY * co.doubleduck.BaseGame.getScale();
		this.addChild(this._trainBlur);
		var lights = co.doubleduck.Utils.getCenteredImage("images/splash/lights.png",true);
		lights.x = this._crossroadBG.x - this._crossroadBG.image.width * 0.075 * co.doubleduck.BaseGame.getScale();
		lights.y = this._crossroadBG.y + this._crossroadBG.image.height * 0.075 * co.doubleduck.BaseGame.getScale();
		this._blockBar = co.doubleduck.Utils.getCenteredImage("images/splash/block.png",true);
		this._blockBar.regX = 0;
		this._blockBar.regY = this._blockBar.image.height * 0.8;
		this._blockBar.x = lights.x - lights.image.width * co.doubleduck.BaseGame.getScale() * 0.2;
		this._blockBar.y = lights.y + lights.image.height * co.doubleduck.BaseGame.getScale() * 0.28;
		this._blockBar.rotation = -80;
		this.addChild(this._blockBar);
		this.addChild(lights);
		var carX = 200;
		var carY = 200;
		var car2 = co.doubleduck.Utils.getCenteredImage("images/splash/car2.png",true);
		car2.x = this._crossroadBG.x + this._crossroadBG.image.width * 0.22 * co.doubleduck.BaseGame.getScale();
		car2.y = this._crossroadBG.y + this._crossroadBG.image.height * 0.22 * co.doubleduck.BaseGame.getScale();
		car2.x += carX * co.doubleduck.BaseGame.getScale();
		car2.y += carY * co.doubleduck.BaseGame.getScale();
		this.addChild(car2);
		this._sepia = co.doubleduck.Utils.getCenteredImage("images/splash/sepia.png",true);
		this._sepia.x = co.doubleduck.BaseGame.getViewport().width / 2;
		this._sepia.y = co.doubleduck.BaseGame.getViewport().height / 2;
		this._sepia.visible = false;
		this.addChild(this._sepia);
		this._logo = co.doubleduck.Utils.getCenteredImage("images/general/logo.png",true);
		this._logo.x = co.doubleduck.BaseGame.getViewport().width * 0.5;
		this._logo.y = co.doubleduck.BaseGame.getViewport().height * 0.18;
		this._logo.visible = false;
		this.addChild(this._logo);
		var flashWhite = new createjs.Shape();
		flashWhite.graphics.beginFill("#ffffff");
		flashWhite.graphics.drawRect(0,0,co.doubleduck.BaseGame.getViewport().width,co.doubleduck.BaseGame.getViewport().height);
		flashWhite.graphics.endFill();
		flashWhite.visible = false;
		this.addChild(flashWhite);
		createjs.Tween.get(this._blockBar).wait(100).to({ rotation : 0},150);
		createjs.Tween.get(car2).wait(250).to({ x : car2.x - carX * co.doubleduck.BaseGame.getScale(), y : car2.y - carY * co.doubleduck.BaseGame.getScale()},450,createjs.Ease.circOut);
		createjs.Tween.get(this._trainBlur).wait(720).call($bind(this,this.disableSkip)).to({ x : this._trainBlur.x - trainX * co.doubleduck.BaseGame.getScale(), y : this._trainBlur.y - trainY * co.doubleduck.BaseGame.getScale()},300).call($bind(this,this.showFlash),[flashWhite]);
	}
	,showMan: function() {
		createjs.Tween.removeTweens(this._train);
		this.removeChild(this._train);
		createjs.Tween.removeTweens(this._car);
		this.removeChild(this._car);
		this._manIdle = co.doubleduck.Utils.getCenteredImage("images/splash/man1.jpg",true);
		this._manIdle.x = co.doubleduck.BaseGame.getViewport().width / 2;
		this._manIdle.y = co.doubleduck.BaseGame.getViewport().height / 2;
		this.addChild(this._manIdle);
		this._manPull = co.doubleduck.Utils.getCenteredImage("images/splash/man2.jpg",true);
		this._manPull.x = co.doubleduck.BaseGame.getViewport().width / 2;
		this._manPull.y = co.doubleduck.BaseGame.getViewport().height / 2;
		this._manPull.alpha = 0;
		this.addChild(this._manPull);
		createjs.Tween.get(this._manPull).wait(300).to({ alpha : 1},120).wait(450).call($bind(this,this.showFinalScene));
	}
	,showTrainB: function() {
		createjs.Tween.removeTweens(this._car);
		this.removeChild(this._car);
		this.shakeElement(this._train,this._train.x,this._train.y,0,2);
		this.addChild(this._train);
		createjs.Tween.get(this).wait(600).call($bind(this,this.showMan));
	}
	,showCarB: function() {
		createjs.Tween.removeTweens(this._train);
		this.removeChild(this._train);
		this.addChild(this._car);
		this.shakeElement(this._car,this._car.x,this._car.y,1,4);
		createjs.Tween.get(this).wait(700).call($bind(this,this.showTrainB));
	}
	,showTrainA: function() {
		createjs.Tween.removeTweens(this._car);
		this.removeChild(this._car);
		this._train = co.doubleduck.Utils.getCenteredImage("images/splash/train.png",true);
		this._train.x = co.doubleduck.BaseGame.getViewport().width * 0.2;
		this._train.y = this._blurBG.y + this._blurBG.image.height * 0.19 * co.doubleduck.BaseGame.getScale();
		this.shakeElement(this._train,this._train.x,this._train.y,0,2);
		this.addChild(this._train);
		createjs.Tween.get(this).wait(1100).call($bind(this,this.showCarB));
	}
	,_logo: null
	,_sepia: null
	,_blockBar: null
	,_trainBlur: null
	,_crossroadBG: null
	,_manPull: null
	,_manIdle: null
	,_train: null
	,_car: null
	,_blurBG: null
	,onTap2Play: null
	,__class__: co.doubleduck.GameSplash
});
co.doubleduck.GameStateManager = $hxClasses["co.doubleduck.GameStateManager"] = function() {
};
co.doubleduck.GameStateManager.__name__ = ["co","doubleduck","GameStateManager"];
co.doubleduck.GameStateManager.setIsGameRunning = function(isGameRunning) {
	co.doubleduck.GameStateManager._isGameRunning = isGameRunning;
}
co.doubleduck.GameStateManager.getIsGameRunning = function() {
	return co.doubleduck.GameStateManager._isGameRunning;
}
co.doubleduck.GameStateManager.prototype = {
	__class__: co.doubleduck.GameStateManager
}
co.doubleduck.Hud = $hxClasses["co.doubleduck.Hud"] = function(timeLimit) {
	this.BUTTON_Y_PADDING = 20;
	this.BUTTON_X_PADDING = 20;
	createjs.Container.call(this);
	if(co.doubleduck.Hud._fontSmall == null) co.doubleduck.Hud._fontSmall = new co.doubleduck.FontHelper("images/general/font_small/");
	this._hudPad = 10 * co.doubleduck.BaseGame.getScale();
	this._pauseBtn = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage("images/session/hud/pause.png"));
	this._pauseBtn.scaleX = this._pauseBtn.scaleY = co.doubleduck.BaseGame.getScale();
	this._pauseBtn.x = co.doubleduck.BaseGame.getViewport().width - this._hudPad - this._pauseBtn.image.width * co.doubleduck.BaseGame.getScale();
	this._pauseBtn.y = co.doubleduck.BaseGame.getViewport().height - this._hudPad - this._pauseBtn.image.height * co.doubleduck.BaseGame.getScale();
	this._pauseBtn.onClick = $bind(this,this.handlePauseClick);
	this.addChild(this._pauseBtn);
	this._carsImage = co.doubleduck.BaseAssets.getImage("images/session/hud/cars.png",false);
	this._carsImage.scaleX = this._carsImage.scaleY = co.doubleduck.BaseGame.getScale();
	this._carsImage.x = this._hudPad;
	this._carsImage.y = this._hudPad;
	this.addChild(this._carsImage);
	this._timeImage = co.doubleduck.BaseAssets.getImage("images/session/hud/time.png",false);
	this._timeImage.scaleX = this._timeImage.scaleY = co.doubleduck.BaseGame.getScale();
	this._timeImage.x = co.doubleduck.BaseGame.getViewport().width - this._hudPad - this._timeImage.image.width * co.doubleduck.BaseGame.getScale();
	this._timeImage.y = this._hudPad;
	this.addChild(this._timeImage);
	this._timeLeft = timeLimit;
	this._timeLeftRounded = Math.round(this._timeLeft);
	this.updateTimeLeft();
	this.createPauseMenu();
	this.onTick = $bind(this,this.handleTick);
};
co.doubleduck.Hud.__name__ = ["co","doubleduck","Hud"];
co.doubleduck.Hud._fontSmall = null;
co.doubleduck.Hud.__super__ = createjs.Container;
co.doubleduck.Hud.prototype = $extend(createjs.Container.prototype,{
	handleResumeClick: function() {
		this._pauseContainer.visible = false;
		this._pauseBtn.mouseEnabled = true;
		co.doubleduck.GameStateManager.setIsGameRunning(true);
	}
	,handleMenuClick: function() {
		this._btnRetry.mouseEnabled = false;
		this._btnMenu.mouseEnabled = false;
		this._btnResume.mouseEnabled = false;
		co.doubleduck.Transition.transitionOut(this.onQuitGame);
	}
	,handleRetryClick: function() {
		this._btnRetry.mouseEnabled = false;
		this._btnMenu.mouseEnabled = false;
		this._btnResume.mouseEnabled = false;
		co.doubleduck.Transition.transitionOut(this.onRetryClick);
	}
	,handlePauseClick: function() {
		co.doubleduck.GameStateManager.setIsGameRunning(false);
		this._pauseBtn.mouseEnabled = false;
		this._pauseContainer.visible = true;
	}
	,updateTimeLeft: function() {
		if(this._timeLeftDisplay != null) this.removeChild(this._timeLeftDisplay);
		var dims = new createjs.Rectangle(0,0,0,0);
		this._timeLeftDisplay = co.doubleduck.Hud._fontSmall.getNumber(this._timeLeftRounded,1,true,dims,-1);
		co.doubleduck.Utils.scaleObject(this._timeLeftDisplay);
		this._timeLeftDisplay.regX = 0;
		this._timeLeftDisplay.regY = dims.height / 2;
		var totalW = dims.width;
		this._timeLeftDisplay.x = this._timeImage.x - (dims.width + 5) * co.doubleduck.BaseGame.getScale();
		this._timeLeftDisplay.y = this._timeImage.y + this._timeImage.image.height * co.doubleduck.BaseGame.getScale() * 0.5;
		this.addChild(this._timeLeftDisplay);
	}
	,updateCarsLeft: function(carsLeft) {
		if(this._carsLeft != null) this.removeChild(this._carsLeft);
		var dims = new createjs.Rectangle(0,0,0,0);
		this._carsLeft = co.doubleduck.Hud._fontSmall.getNumber(carsLeft,1,true,dims,-1);
		co.doubleduck.Utils.scaleObject(this._carsLeft);
		this._carsLeft.regX = 0;
		this._carsLeft.regY = dims.height / 2;
		var totalW = dims.width;
		this._carsLeft.x = this._carsImage.x + (this._carsImage.image.width + 5) * co.doubleduck.BaseGame.getScale();
		this._carsLeft.y = this._carsImage.y + this._carsImage.image.height * co.doubleduck.BaseGame.getScale() * 0.5;
		this.addChild(this._carsLeft);
	}
	,handleTick: function(elapsed) {
		if(co.doubleduck.GameStateManager.getIsGameRunning()) {
			this._timeLeft -= elapsed / 1000;
			if(this._timeLeftRounded - 1 >= this._timeLeft && this._timeLeftRounded >= 0) {
				this._timeLeftRounded--;
				if(this._timeLeftRounded < 0) this.onTimeLimitReached(); else this.updateTimeLeft();
			}
		}
	}
	,createPauseMenu: function() {
		this._pauseContainer = new createjs.Container();
		this._pauseBG = co.doubleduck.Utils.getCenteredImage("images/session/level_end/pause.png",true);
		this._pauseBG.x = co.doubleduck.BaseGame.getViewport().width / 2;
		this._pauseBG.y = co.doubleduck.BaseGame.getViewport().height / 2;
		this._pauseContainer.addChild(this._pauseBG);
		this._btnRetry = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage("images/session/level_end/retry.png"));
		this._btnRetry.scaleX = this._btnRetry.scaleY = co.doubleduck.BaseGame.getScale();
		this._btnRetry.regX = this._btnRetry.image.width / 2;
		this._btnRetry.regY = this._btnRetry.image.height;
		this._btnRetry.onClick = $bind(this,this.handleRetryClick);
		this._btnRetry.y = this._pauseBG.y + this._pauseBG.image.height * co.doubleduck.BaseGame.getScale() * 0.5 - this.BUTTON_Y_PADDING * co.doubleduck.BaseGame.getScale();
		this._btnRetry.x = this._pauseBG.x;
		this._pauseContainer.addChild(this._btnRetry);
		this._btnMenu = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage("images/session/level_end/menu.png"));
		this._btnMenu.scaleX = this._btnMenu.scaleY = co.doubleduck.BaseGame.getScale();
		this._btnMenu.regX = this._btnMenu.image.width;
		this._btnMenu.regY = this._btnMenu.image.height;
		this._btnMenu.onClick = $bind(this,this.handleMenuClick);
		this._btnMenu.y = this._pauseBG.y + this._pauseBG.image.height * co.doubleduck.BaseGame.getScale() * 0.5 - this.BUTTON_Y_PADDING * co.doubleduck.BaseGame.getScale();
		this._btnMenu.x = this._btnRetry.x - this._btnRetry.image.width * co.doubleduck.BaseGame.getScale() * 0.5 - this.BUTTON_X_PADDING * co.doubleduck.BaseGame.getScale();
		this._pauseContainer.addChild(this._btnMenu);
		this._btnResume = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage("images/session/level_end/play.png"));
		this._btnResume.scaleX = this._btnResume.scaleY = co.doubleduck.BaseGame.getScale();
		this._btnResume.regX = 0;
		this._btnResume.regY = this._btnResume.image.height;
		this._btnResume.onClick = $bind(this,this.handleResumeClick);
		this._btnResume.y = this._pauseBG.y + this._pauseBG.image.height * co.doubleduck.BaseGame.getScale() * 0.5 - this.BUTTON_Y_PADDING * co.doubleduck.BaseGame.getScale();
		this._btnResume.x = this._btnRetry.x + this._btnRetry.image.width * co.doubleduck.BaseGame.getScale() * 0.5 + this.BUTTON_X_PADDING * co.doubleduck.BaseGame.getScale();
		this._pauseContainer.addChild(this._btnResume);
		this._pauseContainer.visible = false;
		this.addChild(this._pauseContainer);
	}
	,_btnRetry: null
	,_btnResume: null
	,_btnMenu: null
	,_pauseBG: null
	,_pauseContainer: null
	,_hudPad: null
	,_timeLeft: null
	,_timeLeftRounded: null
	,_timeImage: null
	,_carsImage: null
	,_pauseBtn: null
	,_timeLeftDisplay: null
	,_carsLeft: null
	,onQuitGame: null
	,onRetryClick: null
	,onTimeLimitReached: null
	,BUTTON_Y_PADDING: null
	,BUTTON_X_PADDING: null
	,__class__: co.doubleduck.Hud
});
co.doubleduck.LevelEnd = $hxClasses["co.doubleduck.LevelEnd"] = function() {
	this.HEADER_Y_PADDING = 50;
	this.BUTTON_X_PADDING = 10;
	this.BUTTON_Y_PADDING = 10;
	createjs.Container.call(this);
};
co.doubleduck.LevelEnd.__name__ = ["co","doubleduck","LevelEnd"];
co.doubleduck.LevelEnd.__super__ = createjs.Container;
co.doubleduck.LevelEnd.prototype = $extend(createjs.Container.prototype,{
	handleRetryClick: function() {
		this._btnAction.mouseEnabled = false;
		this._btnMenu.mouseEnabled = false;
		co.doubleduck.Transition.transitionOut(this.onRetryClick);
	}
	,handleNextClick: function() {
		this._btnAction.mouseEnabled = false;
		this._btnMenu.mouseEnabled = false;
		co.doubleduck.Transition.transitionOut(this.onNextClick);
	}
	,handleMenuClick: function() {
		this._btnAction.mouseEnabled = false;
		this._btnMenu.mouseEnabled = false;
		co.doubleduck.Transition.transitionOut(this.onMenuClick);
	}
	,glowTween: function() {
		this._glow.rotation = 0;
		createjs.Tween.get(this._glow).to({ rotation : 360},5000).call($bind(this,this.glowTween));
	}
	,showLevelFailed: function(isCrashed) {
		if(this._header != null) {
			this.removeChild(this._header);
			this.removeChild(this._btnAction);
			this.removeChild(this._btnMenu);
		}
		if(isCrashed) this._header = co.doubleduck.Utils.getCenteredImage("images/session/level_end/fail1.png",true); else this._header = co.doubleduck.Utils.getCenteredImage("images/session/level_end/fail2.png",true);
		this._header.x = co.doubleduck.BaseGame.getViewport().width / 2;
		this._header.y = co.doubleduck.BaseGame.getViewport().height / 2;
		this.addChild(this._header);
		this._btnMenu = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage("images/session/level_end/menu.png"));
		this._btnMenu.scaleX = this._btnMenu.scaleY = co.doubleduck.BaseGame.getScale();
		this._btnMenu.regX = this._btnMenu.image.width;
		this._btnMenu.regY = this._btnMenu.image.height;
		this._btnMenu.onClick = $bind(this,this.handleMenuClick);
		this._btnMenu.y = this._header.y + this._header.image.height * co.doubleduck.BaseGame.getScale() * 0.5 - this.BUTTON_Y_PADDING * co.doubleduck.BaseGame.getScale();
		this._btnMenu.x = this._header.x - this.BUTTON_X_PADDING * co.doubleduck.BaseGame.getScale();
		this.addChild(this._btnMenu);
		this._btnAction = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage("images/session/level_end/retry.png"));
		this._btnAction.scaleX = this._btnAction.scaleY = co.doubleduck.BaseGame.getScale();
		this._btnAction.regX = 0;
		this._btnAction.regY = this._btnAction.image.height;
		this._btnAction.onClick = $bind(this,this.handleRetryClick);
		this._btnAction.y = this._header.y + this._header.image.height * co.doubleduck.BaseGame.getScale() * 0.5 - this.BUTTON_Y_PADDING * co.doubleduck.BaseGame.getScale();
		this._btnAction.x = this._header.x + this.BUTTON_X_PADDING * co.doubleduck.BaseGame.getScale();
		this.addChild(this._btnAction);
		co.doubleduck.SoundManager.playEffect("sound/level_fail");
		this.alpha = 0;
		this.visible = true;
		createjs.Tween.get(this).to({ alpha : 1},500,createjs.Ease.sineIn);
	}
	,showLevelComplete: function(isRegularComplete) {
		if(isRegularComplete == null) isRegularComplete = true;
		if(this._header != null) {
			this.removeChild(this._header);
			this.removeChild(this._btnAction);
			this.removeChild(this._btnMenu);
		}
		if(isRegularComplete) this._header = co.doubleduck.Utils.getCenteredImage("images/session/level_end/success1.png",true); else this._header = co.doubleduck.Utils.getCenteredImage("images/session/level_end/endgame.png",true);
		this._header.x = co.doubleduck.BaseGame.getViewport().width / 2;
		this._header.y = co.doubleduck.BaseGame.getViewport().height / 2;
		this.addChild(this._header);
		if(isRegularComplete) {
			this._btnMenu = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage("images/session/level_end/menu.png"));
			this._btnMenu.scaleX = this._btnMenu.scaleY = co.doubleduck.BaseGame.getScale();
			this._btnMenu.regX = this._btnMenu.image.width;
			this._btnMenu.regY = this._btnMenu.image.height;
			this._btnMenu.onClick = $bind(this,this.handleMenuClick);
			this._btnMenu.y = this._header.y + this._header.image.height * co.doubleduck.BaseGame.getScale() * 0.5 - this.BUTTON_Y_PADDING * co.doubleduck.BaseGame.getScale();
			this._btnMenu.x = this._header.x - this.BUTTON_X_PADDING * co.doubleduck.BaseGame.getScale();
			this._btnAction = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage("images/session/level_end/next.png"));
			this._btnAction.scaleX = this._btnAction.scaleY = co.doubleduck.BaseGame.getScale();
			this._btnAction.regX = 0;
			this._btnAction.regY = this._btnAction.image.height;
			this._btnAction.onClick = $bind(this,this.handleNextClick);
			this._btnAction.y = this._header.y + this._header.image.height * co.doubleduck.BaseGame.getScale() * 0.5 - this.BUTTON_Y_PADDING * co.doubleduck.BaseGame.getScale();
			this._btnAction.x = this._header.x + this.BUTTON_X_PADDING * co.doubleduck.BaseGame.getScale();
			this._glow = co.doubleduck.Utils.getCenteredImage("images/session/level_end/light.png",true);
			this._glow.x = this._btnAction.x + this._btnAction.image.width * 0.5 * co.doubleduck.BaseGame.getScale();
			this._glow.y = this._btnAction.y - this._btnAction.image.height * 0.5 * co.doubleduck.BaseGame.getScale();
			this.addChild(this._glow);
			this.glowTween();
			this.addChild(this._btnAction);
		} else {
			this._btnMenu = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage("images/session/level_end/next.png"));
			this._btnMenu.scaleX = this._btnMenu.scaleY = co.doubleduck.BaseGame.getScale();
			this._btnMenu.regX = this._btnMenu.image.width;
			this._btnMenu.regY = this._btnMenu.image.height;
			this._btnMenu.onClick = $bind(this,this.handleMenuClick);
			this._btnMenu.y = this._header.y + this._header.image.height * co.doubleduck.BaseGame.getScale() * 0.5 - 20 * co.doubleduck.BaseGame.getScale();
			this._btnMenu.x = co.doubleduck.BaseGame.getViewport().width * 0.84;
		}
		this.addChild(this._btnMenu);
		co.doubleduck.SoundManager.playEffect("sound/level_complete");
		this.alpha = 0;
		this.visible = true;
		createjs.Tween.get(this).to({ alpha : 1},500,createjs.Ease.sineIn);
	}
	,_glow: null
	,_btnAction: null
	,_btnMenu: null
	,_header: null
	,onRetryClick: null
	,onNextClick: null
	,onMenuClick: null
	,HEADER_Y_PADDING: null
	,BUTTON_X_PADDING: null
	,BUTTON_Y_PADDING: null
	,__class__: co.doubleduck.LevelEnd
});
co.doubleduck.Main = $hxClasses["co.doubleduck.Main"] = function() { }
co.doubleduck.Main.__name__ = ["co","doubleduck","Main"];
co.doubleduck.Main._stage = null;
co.doubleduck.Main._game = null;
co.doubleduck.Main._ffHeight = null;
co.doubleduck.Main.main = function() {
	co.doubleduck.Main.testFFHeight();
	createjs.Ticker.useRAF = true;
	createjs.Ticker.setFPS(60);
	co.doubleduck.Main._stage = new createjs.Stage(js.Lib.document.getElementById("stageCanvas"));
	co.doubleduck.Main._game = new co.doubleduck.Game(co.doubleduck.Main._stage);
	createjs.Ticker.addListener(co.doubleduck.Main._stage);
	createjs.Touch.enable(co.doubleduck.Main._stage,true,false);
}
co.doubleduck.Main.testFFHeight = function() {
	var isAplicable = /Firefox/.test(navigator.userAgent);
	if(isAplicable && viewporter.ACTIVE) co.doubleduck.Main._ffHeight = js.Lib.window.innerHeight;
}
co.doubleduck.Main.getFFHeight = function() {
	return co.doubleduck.Main._ffHeight;
}
co.doubleduck.Menu = $hxClasses["co.doubleduck.Menu"] = function() {
	co.doubleduck.BaseMenu.call(this);
	this._back = co.doubleduck.Utils.getCenteredImage("images/splash/sepia.png",true);
	this._back.x = co.doubleduck.BaseGame.getViewport().width / 2;
	this._back.y = co.doubleduck.BaseGame.getViewport().height / 2;
	this.addChild(this._back);
	this._logo = co.doubleduck.Utils.getCenteredImage("images/general/logo.png",true);
	this._logo.x = co.doubleduck.BaseGame.getViewport().width * 0.5;
	this._logo.y = co.doubleduck.BaseGame.getViewport().height * 0.18;
	this.addChild(this._logo);
	var focusLevel = co.doubleduck.Session.getLevel();
	if(focusLevel == -1) focusLevel = co.doubleduck.Persistence.getUnlockedLevel();
	this._numLevels = co.doubleduck.DataLoader.getGameplayData().levels.length;
	if(focusLevel >= this._numLevels) focusLevel--;
	this._currPageNum = (focusLevel - 1) / (co.doubleduck.Menu.ROWS * co.doubleduck.Menu.COLS) | 0;
	this._allLevels = new createjs.Container();
	this._numPages = ((this._numLevels - 1) / (co.doubleduck.Menu.ROWS * co.doubleduck.Menu.COLS) | 0) + 1;
	var pageWidth;
	var pageHeight;
	var _g1 = 0, _g = this._numPages;
	while(_g1 < _g) {
		var currPage = _g1++;
		var _currPage = new createjs.Container();
		var _g3 = 0, _g2 = co.doubleduck.Menu.ROWS;
		while(_g3 < _g2) {
			var currRow = _g3++;
			var _g5 = 0, _g4 = co.doubleduck.Menu.COLS;
			while(_g5 < _g4) {
				var currCol = _g5++;
				var levelNum = co.doubleduck.Menu.COLS * co.doubleduck.Menu.ROWS * currPage + currRow * co.doubleduck.Menu.COLS + (currCol + 1);
				if(levelNum > this._numLevels) break;
				var imageType = "";
				var label = "" + levelNum;
				var clickable = true;
				if(levelNum < co.doubleduck.Persistence.getUnlockedLevel()) imageType = "images/menu/level_completed.png"; else if(levelNum == co.doubleduck.Persistence.getUnlockedLevel()) imageType = "images/menu/level.png"; else {
					imageType = "images/menu/level_locked.png";
					clickable = false;
				}
				var currLevel = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage(imageType));
				currLevel.x = (currLevel.image.width + co.doubleduck.Menu.PADDING_WIDTH) * currCol;
				currLevel.y = (currLevel.image.width + co.doubleduck.Menu.PADDING_HEIGHT) * currRow;
				_currPage.addChild(currLevel);
				if(clickable) currLevel.onClick = $bind(this,this.handlePlayClick);
				if(label != "") {
					currLevel.addBitmapLabel(label,"images/menu/font/");
					currLevel.setBitmapLabelX(currLevel.image.width * 0.45);
					currLevel.setBitmapLabelY(currLevel.image.width * 0.4);
				}
			}
		}
		pageWidth = co.doubleduck.Menu.CELL_WIDTH * co.doubleduck.Menu.COLS + co.doubleduck.Menu.PADDING_WIDTH * (co.doubleduck.Menu.COLS - 1);
		pageHeight = co.doubleduck.Menu.CELL_HEIGHT * co.doubleduck.Menu.ROWS + co.doubleduck.Menu.PADDING_HEIGHT * (co.doubleduck.Menu.ROWS - 1);
		_currPage.scaleX = _currPage.scaleY = co.doubleduck.BaseGame.getScale();
		_currPage.regX = pageWidth / 2;
		_currPage.regY = pageHeight / 2;
		_currPage.x = co.doubleduck.BaseGame.getViewport().width / 2;
		_currPage.x += currPage * co.doubleduck.BaseGame.getViewport().width;
		var lvlBack = co.doubleduck.Utils.getCenteredImage("images/menu/level_list.png",true);
		lvlBack.x = _currPage.x;
		lvlBack.y = _currPage.y - 5 * co.doubleduck.BaseGame.getScale();
		this._allLevels.addChild(lvlBack);
		this._allLevels.addChild(_currPage);
	}
	this._allLevels.y = co.doubleduck.BaseGame.getViewport().height * 0.63;
	this.addChild(this._allLevels);
	this._nextBtn = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage("images/menu/arrow.png"));
	this._nextBtn.regY = this._nextBtn.image.height / 2;
	this._nextBtn.y = this._allLevels.y;
	this._nextBtn.regX = this._nextBtn.image.width;
	this._nextBtn.x = co.doubleduck.BaseGame.getViewport().width - 14 * co.doubleduck.BaseGame.getScale();
	this._nextBtn.scaleX = this._nextBtn.scaleY = co.doubleduck.BaseGame.getScale();
	this._nextBtn.onClick = $bind(this,this.targetNextPack);
	this.addChild(this._nextBtn);
	this._prevBtn = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage("images/menu/arrow.png"));
	this._prevBtn.regY = this._prevBtn.image.height / 2;
	this._prevBtn.y = this._nextBtn.y;
	this._prevBtn.regX = this._prevBtn.image.width;
	this._prevBtn.x = 16 * co.doubleduck.BaseGame.getScale();
	this._prevBtn.scaleX = this._prevBtn.scaleY = co.doubleduck.BaseGame.getScale();
	this._prevBtn.scaleX *= -1;
	this._prevBtn.onClick = $bind(this,this.targetPrevPack);
	this.addChild(this._prevBtn);
	this._helpBtn = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage("images/menu/help.png"));
	this._helpBtn.scaleX = this._helpBtn.scaleY = co.doubleduck.BaseGame.getScale();
	this._helpBtn.regY = this._helpBtn.image.height;
	this._helpBtn.x = 10 * co.doubleduck.BaseGame.getScale();
	this._helpBtn.y = co.doubleduck.BaseGame.getViewport().height - 10 * co.doubleduck.BaseGame.getScale();
	this._helpBtn.onClick = $bind(this,this.showHelpMenu);
	this.addChild(this._helpBtn);
	if(co.doubleduck.SoundManager.available) {
		this._muteButton = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage("images/menu/sound.png"),true,co.doubleduck.Button.CLICK_TYPE_TOGGLE);
		this._muteButton.regY = this._muteButton.image.height / 2;
		this._muteButton.scaleX = this._muteButton.scaleY = co.doubleduck.BaseGame.getScale();
		this._muteButton.x = this._helpBtn.x + this._helpBtn.image.width * co.doubleduck.BaseGame.getScale() * 1.6;
		this._muteButton.y = this._helpBtn.y;
		this._muteButton.setToggle(co.doubleduck.SoundManager.isMuted());
		this._muteButton.onToggle = co.doubleduck.SoundManager.toggleMute;
		this.addChild(this._muteButton);
	}
	this._uiOverlay = new createjs.Shape();
	this._uiOverlay.graphics.beginFill("#000000");
	this._uiOverlay.graphics.drawRect(-30,-30,co.doubleduck.BaseGame.getViewport().width + 60,co.doubleduck.BaseGame.getViewport().height + 60);
	this._uiOverlay.graphics.endFill();
	this._uiOverlay.alpha = 0;
	this.addChild(this._uiOverlay);
	this._helpScreen = new co.doubleduck.PagedHelp("images/menu/help_screen.png","images/menu/next.png","images/menu/gotit.png",["images/menu/help1.png","images/menu/help2.png"]);
	this._helpScreen.x = co.doubleduck.BaseGame.getViewport().width / 2;
	this._helpScreen.y = co.doubleduck.BaseGame.getViewport().height / 2;
	this._helpScreen.scaleX = this._helpScreen.scaleY = co.doubleduck.BaseGame.getScale();
	this._helpScreen.alpha = 0;
	this._helpScreen.onGotIt = $bind(this,this.closeHelp);
	this._helpScreen.setMarkersPos(5);
	this._helpScreen.setButtonsPos(0.69,0.51);
	this.addChild(this._helpScreen);
	this.addChild(co.doubleduck.Transition.getInstance());
	if(co.doubleduck.GameSplash.hasJustSeen()) {
		this._allLevels.alpha = 0;
		createjs.Tween.get(this._allLevels).wait(200).to({ alpha : 1},400);
		this._prevBtn.alpha = 0;
		createjs.Tween.get(this._prevBtn).wait(200).to({ alpha : 1},400);
		this._nextBtn.alpha = 0;
		createjs.Tween.get(this._nextBtn).wait(200).to({ alpha : 1},400);
		this._helpBtn.alpha = 0;
		createjs.Tween.get(this._helpBtn).wait(200).to({ alpha : 1},400);
		if(this._muteButton != null) {
			this._muteButton.alpha = 0;
			createjs.Tween.get(this._muteButton).wait(200).to({ alpha : 1},400);
		}
	} else co.doubleduck.Transition.transitionIn();
	this._menuMusic = co.doubleduck.SoundManager.playMusic("sound/menu_music");
	this.focusPage(this._currPageNum,false);
	co.doubleduck.BaseGame.hammer.onswipe = $bind(this,this.handleSwipe);
	this.onTick = $bind(this,this.handleTick);
};
co.doubleduck.Menu.__name__ = ["co","doubleduck","Menu"];
co.doubleduck.Menu.__super__ = co.doubleduck.BaseMenu;
co.doubleduck.Menu.prototype = $extend(co.doubleduck.BaseMenu.prototype,{
	handleTick: function(elapsed) {
		if(Math.abs(this._levelsTargetX - this._allLevels.x) > 0.1) {
			var delta = co.doubleduck.Menu.SWIPE_EASE * elapsed;
			delta = Math.min(delta,0.2);
			delta *= this._levelsTargetX - this._allLevels.x;
			this._allLevels.x += delta;
		}
	}
	,handlePlayClick: function(e) {
		this._allLevels.mouseEnabled = false;
		if(this.onPlayClick != null) {
			var btn = e.target;
			var num = Std.parseInt(btn.getLabel());
			co.doubleduck.Transition.transitionOut(this.onPlayClick,[num]);
			this._menuMusic.stop();
		}
	}
	,targetNextPack: function() {
		if(this._currPageNum < this._numPages - 1) {
			this._currPageNum += 1;
			this.focusPage(this._currPageNum);
		}
	}
	,targetPrevPack: function() {
		if(this._currPageNum > 0) {
			this._currPageNum -= 1;
			this.focusPage(this._currPageNum);
		}
	}
	,handleSwipe: function(e) {
		if(e.direction == "right") this.targetPrevPack(); else if(e.direction == "left") this.targetNextPack();
	}
	,setArrowsVisibility: function() {
		this._nextBtn.visible = this._currPageNum < this._numPages - 1;
		this._prevBtn.visible = this._currPageNum > 0;
	}
	,toggleOverlay: function(flag) {
		var targetAlpha = 0;
		if(flag) targetAlpha = 0.65;
		createjs.Tween.removeTweens(this._uiOverlay);
		createjs.Tween.get(this._uiOverlay).to({ alpha : targetAlpha},300);
		this._allLevels.mouseEnabled = !flag;
		if(flag) {
			this._helpBtn.onClick = null;
			this._prevBtn.visible = this._nextBtn.visible = false;
		} else {
			this._helpBtn.onClick = $bind(this,this.showHelpMenu);
			this.setArrowsVisibility();
		}
	}
	,closeHelp: function() {
		this.toggleOverlay(false);
		createjs.Tween.removeTweens(this._helpScreen);
		createjs.Tween.removeTweens(this._helpBtn);
		createjs.Tween.get(this._helpScreen).to({ alpha : 0},600);
		this._helpBtn.alpha = 1;
		co.doubleduck.BaseGame.hammer.onswipe = $bind(this,this.handleSwipe);
	}
	,showHelpMenu: function() {
		this._helpScreen.rewindPages();
		this.toggleOverlay(true);
		this._helpScreen.enableSwipe();
		createjs.Tween.get(this._helpScreen).to({ alpha : 1},1000,createjs.Ease.sineOut);
		createjs.Tween.get(this._helpBtn).to({ alpha : 0},1000,createjs.Ease.sineOut);
		this._helpScreen.visible = true;
	}
	,focusPage: function(currPage,tween) {
		if(tween == null) tween = true;
		this._levelsTargetX = -1 * currPage * co.doubleduck.BaseGame.getViewport().width;
		if(!tween) this._allLevels.x = this._levelsTargetX;
		this.setArrowsVisibility();
	}
	,goToLevel: function(levelId) {
		this.onPlayClick(levelId);
	}
	,_helpScreen: null
	,_helpBtn: null
	,_menuMusic: null
	,_uiOverlay: null
	,_levelsTargetX: null
	,_currPageNum: null
	,_numPages: null
	,_numLevels: null
	,_muteButton: null
	,_prevBtn: null
	,_nextBtn: null
	,_allLevels: null
	,_playBtn: null
	,_logo: null
	,_back: null
	,__class__: co.doubleduck.Menu
});
co.doubleduck.PagedHelp = $hxClasses["co.doubleduck.PagedHelp"] = function(backUri,nextBtnUri,gotItBtnUri,pages) {
	createjs.Container.call(this);
	this._background = co.doubleduck.BaseAssets.getImage(backUri);
	this.addChild(this._background);
	this.regX = this._background.image.width / 2;
	this.regY = this._background.image.height / 2;
	this._contentLayer = new createjs.Container();
	if(pages.length > 0) {
		var _g1 = 0, _g = pages.length;
		while(_g1 < _g) {
			var i = _g1++;
			this.addPage(pages[i],i);
		}
		this.addChild(this._contentLayer);
		this._pagesCount = pages.length;
		this._mask = new createjs.Shape();
		this._mask.graphics.beginFill("#000000");
		this._mask.graphics.drawRect(20,20,this._background.image.width - 40,this._background.image.height - 40);
		this._mask.graphics.endFill();
		this._contentLayer.mask = this._mask;
	} else this._pagesCount = 0;
	if(nextBtnUri != null && nextBtnUri != "") {
		this._nextBtn = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage(nextBtnUri),true,co.doubleduck.Button.CLICK_TYPE_SCALE);
		this._nextBtn.regX = this._nextBtn.image.width / 2;
		this._nextBtn.regY = this._nextBtn.image.height / 2;
		this._nextBtn.onClick = $bind(this,this.handleNextClick);
		this.addChild(this._nextBtn);
	}
	this._gotItBtn = new co.doubleduck.Button(co.doubleduck.BaseAssets.getImage(gotItBtnUri),true,co.doubleduck.Button.CLICK_TYPE_SCALE);
	this._gotItBtn.regX = this._gotItBtn.image.width / 2;
	this._gotItBtn.regY = this._gotItBtn.image.height / 2;
	this._gotItBtn.onClick = $bind(this,this.handleGotItClick);
	this.addChild(this._gotItBtn);
	this.setButtonsPos();
	this._currPage = 0;
	this.enableSwipe();
	this.addPageMarkers();
	this.setButtonsVis();
};
co.doubleduck.PagedHelp.__name__ = ["co","doubleduck","PagedHelp"];
co.doubleduck.PagedHelp.__super__ = createjs.Container;
co.doubleduck.PagedHelp.prototype = $extend(createjs.Container.prototype,{
	createPageMarker: function() {
		var img = co.doubleduck.BaseAssets.getRawImage("images/duckling/page_marker.png");
		var initObject = { };
		initObject.images = [img];
		initObject.frames = { width : 16, height : 18};
		initObject.animations = { };
		initObject.animations.idle = { frames : 0, frequency : 20};
		initObject.animations.active = { frames : 1, frequency : 20};
		var pageMarker = new createjs.BitmapAnimation(new createjs.SpriteSheet(initObject));
		pageMarker.gotoAndStop("idle");
		return pageMarker;
	}
	,handleNextClick: function() {
		this._currPage++;
		if(this._currPage >= this._pagesCount) {
			this._currPage = this._pagesCount - 1;
			return;
		}
		this._pageMarkers[this._currPage - 1].gotoAndStop("idle");
		this._pageMarkers[this._currPage].gotoAndStop("active");
		createjs.Tween.get(this._contentLayer).to({ x : -1 * this._background.image.width * this._currPage},200,createjs.Ease.sineOut);
		this.setButtonsVis();
	}
	,handlePrevClick: function() {
		this._currPage--;
		if(this._currPage < 0) {
			this._currPage = 0;
			return;
		}
		this._pageMarkers[this._currPage + 1].gotoAndStop("idle");
		this._pageMarkers[this._currPage].gotoAndStop("active");
		createjs.Tween.get(this._contentLayer).to({ x : -1 * this._background.image.width * this._currPage},200,createjs.Ease.sineOut);
		this.setButtonsVis();
	}
	,setButtonsVis: function() {
		if(this._pagesCount == 0) {
			this._gotItBtn.visible = true;
			return;
		}
		if(this._currPage == this._pagesCount - 1) {
			this._gotItBtn.visible = true;
			this._nextBtn.visible = false;
		} else {
			this._gotItBtn.visible = false;
			this._nextBtn.visible = true;
		}
	}
	,handleSwipe: function(event) {
		if(event.direction == "left") this.handleNextClick(); else if(event.direction == "right") this.handlePrevClick();
	}
	,handleGotItClick: function() {
		if(this.onGotIt != null) this.onGotIt();
	}
	,addPageMarkers: function() {
		if(this._pagesCount == 0) return;
		this._pageMarkers = new Array();
		var totalWidth = 0;
		this._markersLayer = new createjs.Container();
		var _g1 = 0, _g = this._pagesCount;
		while(_g1 < _g) {
			var currPage = _g1++;
			var pageMarker = this.createPageMarker();
			this._pageMarkers.push(pageMarker);
			if(currPage != 0) {
				pageMarker.x = this._pageMarkers[currPage - 1].x + this._pageMarkers[currPage - 1].spriteSheet._frameWidth + 5;
				totalWidth += 5;
			}
			totalWidth += pageMarker.spriteSheet._frameWidth;
			this._markersLayer.addChild(pageMarker);
		}
		this._markersLayer.y = this._background.image.height * 0.80;
		this._markersLayer.x = this._background.image.width / 2;
		this._markersLayer.regX = totalWidth / 2;
		this.addChild(this._markersLayer);
		this._pageMarkers[0].gotoAndStop("active");
	}
	,addPage: function(pageUri,index) {
		var page = co.doubleduck.BaseAssets.getImage(pageUri);
		page.x += this._background.image.width * index;
		this._contentLayer.addChild(page);
	}
	,goToPage: function(page) {
		this._pageMarkers[this._currPage].gotoAndStop("idle");
		this._currPage = page;
		this._pageMarkers[this._currPage].gotoAndStop("active");
		this._contentLayer.x = -1 * this._background.image.width * this._currPage;
		this.setButtonsVis();
	}
	,changeContentMask: function(topPad,bottomPad,leftPad,rightPad) {
		this._mask.graphics.clear();
		this._mask.graphics.beginFill("#000000");
		this._mask.graphics.drawRect(leftPad,topPad,this._background.image.width - (rightPad + leftPad),this._background.image.height - (bottomPad + topPad));
		this._mask.graphics.endFill();
	}
	,rewindPages: function() {
		this.goToPage(0);
	}
	,enableSwipe: function() {
		co.doubleduck.BaseGame.hammer.onswipe = $bind(this,this.handleSwipe);
	}
	,setMarkersPos: function(percentY,percentX) {
		if(percentX == null) percentX = 0.5;
		this._markersLayer.y = this._background.image.height * percentY;
		this._markersLayer.x = this._background.image.width * percentX;
	}
	,setButtonsPos: function(percentX,percentY) {
		if(percentY == null) percentY = 0.5;
		if(percentX == null) percentX = 0.5;
		if(this._nextBtn != null) {
			this._nextBtn.x = this._background.image.width * percentX;
			this._nextBtn.y = this._background.image.height * percentY;
		}
		this._gotItBtn.x = this._background.image.width * percentX;
		this._gotItBtn.y = this._background.image.height * percentY;
	}
	,_currPage: null
	,_pagesCount: null
	,_gotItBtn: null
	,_nextBtn: null
	,_pageMarkers: null
	,_markersLayer: null
	,_mask: null
	,_contentLayer: null
	,_background: null
	,onGotIt: null
	,__class__: co.doubleduck.PagedHelp
});
co.doubleduck.Persistence = $hxClasses["co.doubleduck.Persistence"] = function() { }
co.doubleduck.Persistence.__name__ = ["co","doubleduck","Persistence"];
co.doubleduck.Persistence.initGameData = function() {
	co.doubleduck.BasePersistence.GAME_PREFIX = "RAIL_";
	if(!co.doubleduck.BasePersistence.available) return;
	co.doubleduck.BasePersistence.initVar("unlockedLevel","1");
}
co.doubleduck.Persistence.getUnlockedLevel = function() {
	return Std.parseInt(co.doubleduck.BasePersistence.getValue("unlockedLevel"));
}
co.doubleduck.Persistence.setUnlockedLevel = function(level) {
	co.doubleduck.BasePersistence.setValue("unlockedLevel","" + level);
}
co.doubleduck.Persistence.__super__ = co.doubleduck.BasePersistence;
co.doubleduck.Persistence.prototype = $extend(co.doubleduck.BasePersistence.prototype,{
	__class__: co.doubleduck.Persistence
});
co.doubleduck.Railtrack = $hxClasses["co.doubleduck.Railtrack"] = function(spawnRate,trainSpeed,direction,minCars,maxCars) {
	this.PROXIMITY_DISTANCE = 5;
	createjs.Container.call(this);
	this._minCars = minCars;
	this._maxCars = maxCars;
	this._trainSpeed = trainSpeed;
	this._direction = direction;
	this._trainPassing = false;
	this._trainSpawnRate = spawnRate;
	this._nextTrainSpawn = createjs.Ticker.getTime(true) + spawnRate * 1000;
	this._railTrack = co.doubleduck.BaseAssets.getImage("images/session/rail_track.png");
	this._railTrack.scaleX = this._railTrack.scaleY = co.doubleduck.BaseGame.getScale();
	this._railTrack.regX = this._railTrack.regY = 0;
	this._railTrack.x = this._railTrack.y = 0;
	this.addChild(this._railTrack);
	this.onTick = $bind(this,this.handleTick);
};
co.doubleduck.Railtrack.__name__ = ["co","doubleduck","Railtrack"];
co.doubleduck.Railtrack.__super__ = createjs.Container;
co.doubleduck.Railtrack.prototype = $extend(createjs.Container.prototype,{
	getProximityBoundingRect: function() {
		var result = new createjs.Rectangle(this._train.x - (this._train.getWidth() * 0.5 + this.PROXIMITY_DISTANCE * 4 * co.doubleduck.BaseGame.getScale()),this._train.y - co.doubleduck.BaseGame.getViewport().width / co.doubleduck.Railtrack.TOTAL_COLS * 0.5,this._train.getWidth() + this.PROXIMITY_DISTANCE * 8 * co.doubleduck.BaseGame.getScale(),co.doubleduck.BaseGame.getViewport().width / co.doubleduck.Railtrack.TOTAL_COLS);
		return result;
	}
	,getBoundingRect: function() {
		var result = new createjs.Rectangle(this._train.x - this._train.getWidth() * 0.5,this._train.y - co.doubleduck.BaseGame.getViewport().width / co.doubleduck.Railtrack.TOTAL_COLS * 0.3,this._train.getWidth(),co.doubleduck.BaseGame.getViewport().width / co.doubleduck.Railtrack.TOTAL_COLS * 0.6);
		return result;
	}
	,isTrainPassing: function() {
		return this._trainPassing;
	}
	,handleTick: function(elapsed) {
		var now = createjs.Ticker.getTime(true);
		elapsed = Math.min(elapsed,200);
		if(co.doubleduck.GameStateManager.getIsGameRunning()) {
			if(!this._trainPassing && this._nextTrainSpawn <= now) {
				this._train = new co.doubleduck.Train(Std.random(this._maxCars - this._minCars + 1) + this._minCars,this._direction);
				this._train.y = this._railTrack.y + this._railTrack.image.height * co.doubleduck.BaseGame.getScale() * 0.5;
				if(this._direction == 1) this._train.x = -this._train.getWidth() * co.doubleduck.BaseGame.getScale(); else this._train.x = co.doubleduck.BaseGame.getViewport().width + this._train.getWidth() * co.doubleduck.BaseGame.getScale();
				this._trainPassing = true;
				this.onAddTrain(this._train,this);
			}
			if(this._trainPassing) {
				this._train.x += this._trainSpeed * this._direction * (elapsed / 1000) * co.doubleduck.BaseGame.getScale();
				if(this._direction == 1 && this._train.x >= co.doubleduck.BaseGame.getViewport().width + this._train.getWidth() * 0.5 * co.doubleduck.BaseGame.getScale() || this._direction == -1 && this._train.x <= -this._train.getWidth() * 0.5 * co.doubleduck.BaseGame.getScale()) {
					this._trainPassing = false;
					this.onRemoveTrain(this._train);
					this._nextTrainSpawn = now + (this._trainSpawnRate * js.Boot.__cast(co.doubleduck.DataLoader.getGameplayData().train_random , Float) + this._trainSpawnRate * Math.random() * js.Boot.__cast(co.doubleduck.DataLoader.getGameplayData().train_random , Float)) * 1000;
				}
			}
		}
	}
	,_maxCars: null
	,_minCars: null
	,_nextTrainSpawn: null
	,_trainSpawnRate: null
	,_trainPassing: null
	,_train: null
	,_railTrack: null
	,_direction: null
	,_trainSpeed: null
	,PROXIMITY_DISTANCE: null
	,onRemoveTrain: null
	,onAddTrain: null
	,__class__: co.doubleduck.Railtrack
});
co.doubleduck.Road = $hxClasses["co.doubleduck.Road"] = function(spawnRate,direction,carSpeed) {
	createjs.Container.call(this);
	this._direction = direction;
	this._carSpeed = carSpeed;
	this._barriers = new Array();
	this._cars = new Array();
	this._nextCarSpawn = createjs.Ticker.getTime(true) + spawnRate * 1000;
	this._carSpawnRate = spawnRate;
	this._road = co.doubleduck.BaseAssets.getImage("images/session/road.png");
	this._road.scaleX = this._road.scaleY = co.doubleduck.BaseGame.getScale();
	this._road.regX = this._road.regY = 0;
	this._road.x = this._road.y = 0;
	this.addChild(this._road);
	this.onTick = $bind(this,this.handleTick);
};
co.doubleduck.Road.__name__ = ["co","doubleduck","Road"];
co.doubleduck.Road.__super__ = createjs.Container;
co.doubleduck.Road.prototype = $extend(createjs.Container.prototype,{
	drawHitbox: function(currCar) {
		if(currCar.debugHitbox != null) {
			this.removeChild(currCar.debugHitbox);
			currCar.debugHitbox = null;
		}
		var obsRect = currCar.getBoundingRect();
		currCar.debugHitbox = new createjs.Shape();
		currCar.debugHitbox.graphics.beginFill("#FF0000");
		currCar.debugHitbox.graphics.drawRect(obsRect.x,obsRect.y,obsRect.width,obsRect.height);
		currCar.debugHitbox.graphics.endFill();
		currCar.debugHitbox.alpha = 0.4;
		this.addChild(currCar.debugHitbox);
	}
	,getWidth: function() {
		return this._road.image.width;
	}
	,addTrainIntersection: function(intersectionY) {
		this._road = co.doubleduck.BaseAssets.getImage("images/session/intersection.png");
		this._road.scaleX = this._road.scaleY = co.doubleduck.BaseGame.getScale();
		this._road.regX = this._road.regY = 0;
		this._road.x = 0;
		this._road.y = intersectionY;
		this.addChild(this._road);
	}
	,getCarBoundingRect: function(currCar) {
		var hitbox = currCar.getBoundingRect().clone();
		hitbox.x += this.x;
		return hitbox;
	}
	,testCollision: function(currTrain) {
		var _g = 0, _g1 = this._cars;
		while(_g < _g1.length) {
			var currCar = _g1[_g];
			++_g;
			if(co.doubleduck.Utils.rectOverlap(currTrain.getBoundingRect(),this.getCarBoundingRect(currCar))) return currCar.getBoundingRect();
		}
		return null;
	}
	,handleCarFinishedRoad: function(finishedCar) {
		this._cars.shift();
		this.removeChild(finishedCar);
		this.onRemoveCar();
	}
	,addBarrier: function(barrierY) {
		var newBarrier = new co.doubleduck.Barrier(this._direction);
		newBarrier.regX = newBarrier.getWidth() * 0.5 * co.doubleduck.BaseGame.getScale();
		if(this._direction == 1) newBarrier.y = barrierY - 12 * co.doubleduck.BaseGame.getScale() - (co.doubleduck.Road.BARRIER_Y_OFFSET * 2 + co.doubleduck.BaseGame.getViewport().width / co.doubleduck.Road.TOTAL_COLS * this._direction); else newBarrier.y = barrierY - co.doubleduck.Road.BARRIER_Y_OFFSET * co.doubleduck.BaseGame.getScale() * this._direction;
		this._barriers.push(newBarrier);
		return newBarrier;
	}
	,findNextBarrier: function(currCar) {
		var _g1 = 0, _g = this._barriers.length;
		while(_g1 < _g) {
			var i = _g1++;
			var currBarrier;
			if(this._direction == 1) currBarrier = this._barriers[i]; else currBarrier = this._barriers[this._barriers.length - i - 1];
			if(currBarrier.getState() == co.doubleduck.BarrierState.STOP) {
				if(this._direction == 1 && currCar.y + currCar.getHeight() * co.doubleduck.BaseGame.getScale() <= currBarrier.y + currBarrier.getHeight() * co.doubleduck.BaseGame.getScale() || this._direction == -1 && currCar.y >= currBarrier.y + currBarrier.getHeight() * co.doubleduck.BaseGame.getScale()) return currBarrier;
			}
		}
		return null;
	}
	,setClosestBarrierForCar: function(currCarId) {
		var closestBarrier = this.findNextBarrier(this._cars[currCarId]);
		if(closestBarrier != null) {
			if(currCarId == 0) {
				if(this._direction == 1) this._cars[currCarId].setClosestBarrier(closestBarrier.y + closestBarrier.getHeight() * co.doubleduck.BaseGame.getScale(),closestBarrier.getHeight()); else this._cars[currCarId].setClosestBarrier(closestBarrier.y,closestBarrier.getHeight());
			} else if(this._direction == 1 && this._cars[currCarId - 1].y < closestBarrier.y + co.doubleduck.BaseGame.getViewport().width / co.doubleduck.Road.TOTAL_COLS * 0.5 * co.doubleduck.BaseGame.getScale() || this._direction == -1 && this._cars[currCarId - 1].y > closestBarrier.y + closestBarrier.getHeight() * co.doubleduck.BaseGame.getScale()) this._cars[currCarId].setClosestBarrier(this._cars[currCarId - 1].y,this._cars[currCarId - 1].getHeight()); else if(this._direction == 1) this._cars[currCarId].setClosestBarrier(closestBarrier.y + closestBarrier.getHeight() * co.doubleduck.BaseGame.getScale(),closestBarrier.getHeight()); else this._cars[currCarId].setClosestBarrier(closestBarrier.y,closestBarrier.getHeight());
		} else if(currCarId > 0) this._cars[currCarId].setClosestBarrier(this._cars[currCarId - 1].y,this._cars[currCarId - 1].getHeight()); else this._cars[currCarId].setClosestBarrier(-1,0);
	}
	,handleTick: function(elapsed) {
		var now = createjs.Ticker.getTime(true);
		elapsed = Math.min(elapsed,200);
		if(co.doubleduck.GameStateManager.getIsGameRunning()) {
			if(this._nextCarSpawn <= now) {
				if(this._cars.length == 0 || this._direction == 1 && this._cars[this._cars.length - 1].y > 0 || this._direction == -1 && this._cars[this._cars.length - 1].y < co.doubleduck.BaseGame.getViewport().height - this._cars[this._cars.length - 1].getHeight() * co.doubleduck.BaseGame.getScale()) {
					var newCar = new co.doubleduck.Car(this._direction,this._carSpeed);
					newCar.x += this._road.image.width * co.doubleduck.BaseGame.getScale() * 0.5;
					newCar.setClosestBarrier(-1,0);
					newCar.onCarFinishedRoad = $bind(this,this.handleCarFinishedRoad);
					this._cars.push(newCar);
					this.addChild(newCar);
				}
				this._nextCarSpawn = now + (this._carSpawnRate * 0.5 + this._carSpawnRate * Math.random() * 0.5) * 1000;
			}
			var _g1 = 0, _g = this._cars.length;
			while(_g1 < _g) {
				var i = _g1++;
				if(this._cars[i] != null) {
					this.setClosestBarrierForCar(i);
					this._cars[i].moveCar(elapsed);
				}
			}
		}
	}
	,_barriers: null
	,_carSpeed: null
	,_cars: null
	,_nextCarSpawn: null
	,_carSpawnRate: null
	,_direction: null
	,_road: null
	,onCloseProximity: null
	,onRemoveCar: null
	,onAddCar: null
	,__class__: co.doubleduck.Road
});
co.doubleduck.Session = $hxClasses["co.doubleduck.Session"] = function(properties) {
	co.doubleduck.BaseSession.call(this);
	co.doubleduck.Session._currLevelId = properties;
	this.CELL_SIZE = co.doubleduck.BaseGame.getViewport().width / co.doubleduck.Session.TOTAL_COLS;
	co.doubleduck.Session.Y_OFFSET = co.doubleduck.BaseGame.getViewport().height - this.CELL_SIZE * co.doubleduck.Session.TOTAL_ROWS;
	this._nextLevelRequested = false;
	this._isSessionEnded = false;
	this._currentPassedCars = 0;
	this.loadLevel(properties);
	this._hud = new co.doubleduck.Hud(this._timeLimit);
	this._hud.onTimeLimitReached = $bind(this,this.handleTimeLimitReached);
	this._hud.onQuitGame = $bind(this,this.handleQuitGame);
	this._hud.onRetryClick = $bind(this,this.handleRetryClick);
	this._hud.updateCarsLeft(this._passedCarsGoal);
	this.addChild(this._hud);
	this._levelEnded = new co.doubleduck.LevelEnd();
	this._levelEnded.onNextClick = $bind(this,this.handleNextClick);
	this._levelEnded.onMenuClick = $bind(this,this.handleMenuClick);
	this._levelEnded.onRetryClick = $bind(this,this.handleRetryClick);
	this._levelEnded.visible = false;
	this.addChild(this._levelEnded);
	this.addChild(co.doubleduck.Transition.getInstance());
	co.doubleduck.Transition.transitionIn();
	co.doubleduck.GameStateManager.setIsGameRunning(true);
	this.onTick = $bind(this,this.handleTick);
};
co.doubleduck.Session.__name__ = ["co","doubleduck","Session"];
co.doubleduck.Session.getLevel = function() {
	return co.doubleduck.Session._currLevelId;
}
co.doubleduck.Session.__super__ = co.doubleduck.BaseSession;
co.doubleduck.Session.prototype = $extend(co.doubleduck.BaseSession.prototype,{
	isNextLevelRequested: function() {
		return this._nextLevelRequested;
	}
	,handleRetryClick: function() {
		this.onRestart(co.doubleduck.Session._currLevelId);
	}
	,handleNextClick: function() {
		this._nextLevelRequested = true;
		this.onBackToMenu();
	}
	,handleQuitGame: function() {
		this.onBackToMenu();
	}
	,showLevelFailed: function() {
		co.doubleduck.GameStateManager.setIsGameRunning(false);
		this._levelEnded.showLevelFailed(true);
		this._hud.visible = false;
	}
	,killCloseProximity: function() {
		this._closeProximity = null;
	}
	,handleCloseProximity: function() {
		if(this._closeProximity == null) {
			this._closeProximity = co.doubleduck.Utils.getCenteredImage("images/session/closeproximity.png",true);
			this._closeProximity.scaleX = this._closeProximity.scaleY = co.doubleduck.BaseGame.getScale();
			this._closeProximity.skewY = 60;
			this._closeProximity.x = -this._closeProximity.image.width * co.doubleduck.BaseGame.getScale();
			this._closeProximity.y = co.doubleduck.BaseGame.getViewport().height * 0.8;
			this.addChild(this._closeProximity);
			createjs.Tween.get(this._closeProximity).to({ skewY : 0, x : co.doubleduck.BaseGame.getViewport().width / 2},500,createjs.Ease.sineIn).wait(500).to({ skewY : -60, x : co.doubleduck.BaseGame.getViewport().width + this._closeProximity.image.width * co.doubleduck.BaseGame.getScale()},200).call($bind(this,this.killCloseProximity));
		}
	}
	,handleTimeLimitReached: function() {
		co.doubleduck.GameStateManager.setIsGameRunning(false);
		this._levelEnded.showLevelFailed(false);
		this._hud.visible = false;
	}
	,handleRemoveTrain: function(theTrain) {
		this._trainContainer.removeChild(theTrain);
	}
	,handleAddTrain: function(theTrain,theTrack) {
		theTrain.y += theTrack.y;
		var addedTrain = false;
		var _g1 = 0, _g = this._trainContainer.children.length;
		while(_g1 < _g) {
			var i = _g1++;
			if(this._trainContainer.getChildAt(i).y > theTrain.y) {
				this._trainContainer.addChildAt(theTrain,i);
				addedTrain = true;
				break;
			}
		}
		if(!addedTrain) this._trainContainer.addChild(theTrain);
	}
	,handleRemoveCar: function(theCar) {
		this._currentPassedCars++;
		this._hud.updateCarsLeft(this._passedCarsGoal - this._currentPassedCars);
		if(this._currentPassedCars == this._passedCarsGoal) {
			co.doubleduck.GameStateManager.setIsGameRunning(false);
			this._levelEnded.showLevelComplete(co.doubleduck.DataLoader.getGameplayData().levels.length > co.doubleduck.Session._currLevelId);
			this._hud.visible = false;
			if(co.doubleduck.Persistence.getUnlockedLevel() == co.doubleduck.Session._currLevelId) co.doubleduck.Persistence.setUnlockedLevel(co.doubleduck.Session._currLevelId + 1);
		} else co.doubleduck.SoundManager.playEffect("sound/car_pass");
	}
	,endCrash: function() {
		this._explosionAnimation.stop();
		this._explosionAnimation.visible = false;
		this.showLevelFailed();
	}
	,showCrash: function(crashX,crashY) {
		var bmpExplosion = co.doubleduck.BaseAssets.getImage("images/session/explosion.png");
		var initExplosionObject = { };
		initExplosionObject.images = [bmpExplosion.image];
		initExplosionObject.frames = { width : 98, height : 79, regX : 49, regY : 39.5};
		initExplosionObject.animations = { explode : { frames : [0,1,2,3,4,5], frequency : 1}};
		this._explosionAnimation = new createjs.BitmapAnimation(new createjs.SpriteSheet(initExplosionObject));
		this._explosionAnimation.x = crashX;
		this._explosionAnimation.y = crashY;
		this.addChildAt(this._explosionAnimation,this.getChildIndex(this._levelEnded));
		this._explosionAnimation.onAnimationEnd = $bind(this,this.endCrash);
		this._explosionAnimation.play();
	}
	,handleTick: function() {
		if(!this._isSessionEnded) {
			var _g = 0, _g1 = this._railTracks;
			while(_g < _g1.length) {
				var currTrack = _g1[_g];
				++_g;
				if(currTrack.isTrainPassing()) {
					var _g2 = 0, _g3 = this._roads;
					while(_g2 < _g3.length) {
						var currRoad = _g3[_g2];
						++_g2;
						var currCrash = currRoad.testCollision(currTrack);
						if(currCrash != null) {
							this._isSessionEnded = true;
							co.doubleduck.SoundManager.playEffect("sound/crash");
							var crashPoint = currRoad.localToGlobal(currCrash.x,currCrash.y);
							this.showCrash(crashPoint.x + currCrash.width * 0.5,crashPoint.y + currCrash.height * 0.5);
							co.doubleduck.GameStateManager.setIsGameRunning(false);
							return;
						}
					}
				}
			}
		}
	}
	,loadLevel: function(levelId) {
		var currLevelData = co.doubleduck.DataLoader.getLevelData(levelId);
		this._passedCarsGoal = js.Boot.__cast(currLevelData.car_goal , Int);
		this._timeLimit = js.Boot.__cast(currLevelData.time_limit , Float);
		this._trainContainer = new createjs.Container();
		this._roads = new Array();
		this._railTracks = new Array();
		this._barriers = new Array();
		this._bg = co.doubleduck.Utils.getCenteredImage("images/session/grass.jpg",true);
		this._bg.x = co.doubleduck.BaseGame.getViewport().width / 2;
		this._bg.y = co.doubleduck.BaseGame.getViewport().height / 2;
		this.addChild(this._bg);
		var _g1 = 0, _g = currLevelData.railtracks.length;
		while(_g1 < _g) {
			var i = _g1++;
			var currDirection;
			if(currLevelData.railtracks[i].direction == "right") currDirection = 1; else currDirection = -1;
			var newTrack = new co.doubleduck.Railtrack(js.Boot.__cast(currLevelData.railtracks[i].interval , Float),js.Boot.__cast(currLevelData.railtracks[i].speed , Float),currDirection,js.Boot.__cast(currLevelData.railtracks[i].min_cars , Int),js.Boot.__cast(currLevelData.railtracks[i].max_cars , Int));
			newTrack.y = (js.Boot.__cast(currLevelData.railtracks[i].row , Int) - 1) * this.CELL_SIZE + co.doubleduck.Session.Y_OFFSET;
			newTrack.onAddTrain = $bind(this,this.handleAddTrain);
			newTrack.onRemoveTrain = $bind(this,this.handleRemoveTrain);
			this._railTracks.push(newTrack);
			this.addChild(newTrack);
		}
		var _g1 = 0, _g = currLevelData.roads.length;
		while(_g1 < _g) {
			var backwardsI = _g1++;
			var i = js.Boot.__cast(currLevelData.roads.length - backwardsI - 1 , Int);
			var currDirection;
			if(currLevelData.roads[i].direction == "down") currDirection = 1; else currDirection = -1;
			var newRoad = new co.doubleduck.Road(js.Boot.__cast(currLevelData.roads[i].interval , Float),currDirection,co.doubleduck.DataLoader.getGameplayData().car_speed);
			newRoad.x = (js.Boot.__cast(currLevelData.roads[i].column , Int) - 1) * this.CELL_SIZE;
			var _g3 = 0, _g2 = currLevelData.railtracks.length;
			while(_g3 < _g2) {
				var k = _g3++;
				newRoad.addTrainIntersection((js.Boot.__cast(currLevelData.railtracks[k].row , Int) - 1) * this.CELL_SIZE + co.doubleduck.Session.Y_OFFSET);
			}
			var _g3 = 0, _g2 = currLevelData.barriers.length;
			while(_g3 < _g2) {
				var j = _g3++;
				if(currLevelData.barriers[j].column == currLevelData.roads[i].column) {
					var currBarrier = newRoad.addBarrier((js.Boot.__cast(currLevelData.barriers[j].row , Int) - 1) * this.CELL_SIZE + co.doubleduck.Session.Y_OFFSET);
					currBarrier.x = newRoad.x + newRoad.getWidth() * 0.5 * co.doubleduck.BaseGame.getScale();
					this._barriers.push(currBarrier);
				}
			}
			newRoad.onRemoveCar = $bind(this,this.handleRemoveCar);
			newRoad.onCloseProximity = $bind(this,this.handleCloseProximity);
			this._roads.push(newRoad);
			this.addChild(newRoad);
		}
		this.addChild(this._trainContainer);
		var _g1 = 0, _g = this._barriers.length;
		while(_g1 < _g) {
			var i = _g1++;
			this.addChild(this._barriers[i]);
		}
	}
	,debugHitbox2: null
	,debugHitbox: null
	,_levelEnded: null
	,_explosionAnimation: null
	,_closeProximity: null
	,_hud: null
	,_nextLevelRequested: null
	,_timeLimit: null
	,_passedCarsGoal: null
	,_currentPassedCars: null
	,_isSessionEnded: null
	,_trainContainer: null
	,_barriers: null
	,_railTracks: null
	,_roads: null
	,_bg: null
	,CELL_SIZE: null
	,__class__: co.doubleduck.Session
});
co.doubleduck.SoundType = $hxClasses["co.doubleduck.SoundType"] = { __ename__ : ["co","doubleduck","SoundType"], __constructs__ : ["WEB_AUDIO","AUDIO_FX","AUDIO_NO_OVERLAP","HOWLER","NONE"] }
co.doubleduck.SoundType.WEB_AUDIO = ["WEB_AUDIO",0];
co.doubleduck.SoundType.WEB_AUDIO.toString = $estr;
co.doubleduck.SoundType.WEB_AUDIO.__enum__ = co.doubleduck.SoundType;
co.doubleduck.SoundType.AUDIO_FX = ["AUDIO_FX",1];
co.doubleduck.SoundType.AUDIO_FX.toString = $estr;
co.doubleduck.SoundType.AUDIO_FX.__enum__ = co.doubleduck.SoundType;
co.doubleduck.SoundType.AUDIO_NO_OVERLAP = ["AUDIO_NO_OVERLAP",2];
co.doubleduck.SoundType.AUDIO_NO_OVERLAP.toString = $estr;
co.doubleduck.SoundType.AUDIO_NO_OVERLAP.__enum__ = co.doubleduck.SoundType;
co.doubleduck.SoundType.HOWLER = ["HOWLER",3];
co.doubleduck.SoundType.HOWLER.toString = $estr;
co.doubleduck.SoundType.HOWLER.__enum__ = co.doubleduck.SoundType;
co.doubleduck.SoundType.NONE = ["NONE",4];
co.doubleduck.SoundType.NONE.toString = $estr;
co.doubleduck.SoundType.NONE.__enum__ = co.doubleduck.SoundType;
if(!co.doubleduck.audio) co.doubleduck.audio = {}
co.doubleduck.audio.AudioAPI = $hxClasses["co.doubleduck.audio.AudioAPI"] = function() { }
co.doubleduck.audio.AudioAPI.__name__ = ["co","doubleduck","audio","AudioAPI"];
co.doubleduck.audio.AudioAPI.prototype = {
	setVolume: null
	,pause: null
	,stop: null
	,playMusic: null
	,playEffect: null
	,init: null
	,__class__: co.doubleduck.audio.AudioAPI
}
co.doubleduck.audio.WebAudioAPI = $hxClasses["co.doubleduck.audio.WebAudioAPI"] = function(src) {
	this._src = src;
	this.loadAudioFile(this._src);
};
co.doubleduck.audio.WebAudioAPI.__name__ = ["co","doubleduck","audio","WebAudioAPI"];
co.doubleduck.audio.WebAudioAPI.__interfaces__ = [co.doubleduck.audio.AudioAPI];
co.doubleduck.audio.WebAudioAPI.context = null;
co.doubleduck.audio.WebAudioAPI.webAudioInit = function() {
	co.doubleduck.audio.WebAudioAPI.context = new webkitAudioContext();
}
co.doubleduck.audio.WebAudioAPI.saveBuffer = function(buffer,name) {
	co.doubleduck.audio.WebAudioAPI._buffers[name] = buffer;
}
co.doubleduck.audio.WebAudioAPI.decodeError = function() {
	null;
}
co.doubleduck.audio.WebAudioAPI.prototype = {
	setVolume: function(volume) {
		if(this._gainNode != null) this._gainNode.gain.value = volume;
	}
	,pause: function() {
	}
	,stop: function(fadeOut) {
		if(fadeOut == null) fadeOut = 0;
		if(this._source != null) this._source.noteOff(0);
	}
	,playMusic: function(volume,loop,fadeIn) {
		if(fadeIn == null) fadeIn = 0;
		if(loop == null) loop = true;
		if(volume == null) volume = 1;
		this.playBuffer(this._src,loop);
		this.setVolume(volume);
	}
	,playEffect: function(volume,overrideOtherEffects,loop,fadeIn) {
		if(fadeIn == null) fadeIn = 0;
		if(loop == null) loop = false;
		if(overrideOtherEffects == null) overrideOtherEffects = true;
		if(volume == null) volume = 1;
		this.playBuffer(this._src,loop);
		this.setVolume(volume);
	}
	,playBuffer: function(name,loop) {
		if(loop == null) loop = false;
		if(this._gainNode == null) {
			this._gainNode = co.doubleduck.audio.WebAudioAPI.context.createGainNode();
			this._gainNode.connect(co.doubleduck.audio.WebAudioAPI.context.destination);
		}
		this._buffer = Reflect.getProperty(co.doubleduck.audio.WebAudioAPI._buffers,this._src);
		if(this._buffer == null) return;
		this._source = co.doubleduck.audio.WebAudioAPI.context.createBufferSource();
		this._source.buffer = this._buffer;
		this._source.loop = loop;
		this._source.connect(this._gainNode);
		this._source.noteOn(0);
	}
	,loadAudioFile: function(src) {
		var request = new XMLHttpRequest();
		request.open("get",src,true);
		request.responseType = "arraybuffer";
		request.onload = function() { co.doubleduck.audio.WebAudioAPI.context.decodeAudioData(request.response, function(decodedBuffer) { buffer = decodedBuffer; co.doubleduck.audio.WebAudioAPI.saveBuffer(buffer,src); }, co.doubleduck.audio.WebAudioAPI.decodeError) }
		request.send();
	}
	,init: function() {
	}
	,_source: null
	,_gainNode: null
	,_buffer: null
	,_src: null
	,__class__: co.doubleduck.audio.WebAudioAPI
}
co.doubleduck.SoundManager = $hxClasses["co.doubleduck.SoundManager"] = function() {
};
co.doubleduck.SoundManager.__name__ = ["co","doubleduck","SoundManager"];
co.doubleduck.SoundManager.engineType = null;
co.doubleduck.SoundManager.EXTENSION = null;
co.doubleduck.SoundManager.getPersistedMute = function() {
	var mute = co.doubleduck.BasePersistence.getValue("mute");
	if(mute == "0") {
		mute = "false";
		co.doubleduck.SoundManager.setPersistedMute(false);
	}
	return mute == "true";
}
co.doubleduck.SoundManager.setPersistedMute = function(mute) {
	var val = "true";
	if(!mute) val = "false";
	co.doubleduck.BasePersistence.setValue("mute",val);
}
co.doubleduck.SoundManager.isSoundAvailable = function() {
	var isFirefox = /Firefox/.test(navigator.userAgent);
	var isChrome = /Chrome/.test(navigator.userAgent);
	var isMobile = /Mobile/.test(navigator.userAgent);
	var isAndroid = /Android/.test(navigator.userAgent);
	var isAndroid4 = /Android 4/.test(navigator.userAgent);
	var isSafari = /Safari/.test(navigator.userAgent);
	var agent = navigator.userAgent;
	var reg = new EReg("iPhone OS 6","");
	var isIOS6 = reg.match(agent) && isSafari && isMobile;
	var isIpad = /iPad/.test(navigator.userAgent);
	isIpad = isIpad && /OS 6/.test(navigator.userAgent);
	isIOS6 = isIOS6 || isIpad;
	if(isFirefox) {
		co.doubleduck.SoundManager.engineType = co.doubleduck.SoundType.AUDIO_FX;
		co.doubleduck.SoundManager.EXTENSION = ".ogg";
		return true;
	}
	if(isChrome && (!isAndroid && !isMobile)) {
		co.doubleduck.SoundManager.engineType = co.doubleduck.SoundType.WEB_AUDIO;
		co.doubleduck.audio.WebAudioAPI.webAudioInit();
		co.doubleduck.SoundManager.EXTENSION = ".ogg";
		return true;
	}
	co.doubleduck.SoundManager.engineType = co.doubleduck.SoundType.NONE;
	co.doubleduck.BasePersistence.initVar("mute");
	return false;
}
co.doubleduck.SoundManager.mute = function(persisted) {
	if(persisted == null) persisted = true;
	if(!co.doubleduck.SoundManager.available) return;
	co.doubleduck.SoundManager._muted = true;
	var _g1 = 0, _g = Reflect.fields(co.doubleduck.SoundManager._cache).length;
	while(_g1 < _g) {
		var currSound = _g1++;
		var mySound = Reflect.getProperty(co.doubleduck.SoundManager._cache,Reflect.fields(co.doubleduck.SoundManager._cache)[currSound]);
		if(mySound != null) mySound.setVolume(0);
	}
	if(persisted) co.doubleduck.SoundManager.setPersistedMute(co.doubleduck.SoundManager._muted);
}
co.doubleduck.SoundManager.unmute = function(persisted) {
	if(persisted == null) persisted = true;
	if(!co.doubleduck.SoundManager.available) return;
	co.doubleduck.SoundManager._muted = false;
	try {
		var _g1 = 0, _g = Reflect.fields(co.doubleduck.SoundManager._cache).length;
		while(_g1 < _g) {
			var currSound = _g1++;
			var mySound = Reflect.getProperty(co.doubleduck.SoundManager._cache,Reflect.fields(co.doubleduck.SoundManager._cache)[currSound]);
			if(mySound != null) mySound.setVolume(1);
		}
	} catch( e ) {
		null;
	}
	if(persisted) co.doubleduck.SoundManager.setPersistedMute(co.doubleduck.SoundManager._muted);
}
co.doubleduck.SoundManager.toggleMute = function() {
	if(co.doubleduck.SoundManager._muted) co.doubleduck.SoundManager.unmute(); else co.doubleduck.SoundManager.mute();
}
co.doubleduck.SoundManager.isMuted = function() {
	co.doubleduck.SoundManager._muted = co.doubleduck.SoundManager.getPersistedMute();
	return co.doubleduck.SoundManager._muted;
}
co.doubleduck.SoundManager.getAudioInstance = function(src) {
	if(!co.doubleduck.SoundManager.available) return new co.doubleduck.audio.DummyAudioAPI();
	src += co.doubleduck.SoundManager.EXTENSION;
	var audio = Reflect.getProperty(co.doubleduck.SoundManager._cache,src);
	if(audio == null) {
		switch( (co.doubleduck.SoundManager.engineType)[1] ) {
		case 1:
			audio = new co.doubleduck.audio.AudioFX(src);
			break;
		case 0:
			audio = new co.doubleduck.audio.WebAudioAPI(src);
			break;
		case 2:
			audio = new co.doubleduck.audio.NonOverlappingAudio(src);
			break;
		case 3:
			audio = new co.doubleduck.audio.HowlerAudio(src);
			break;
		case 4:
			return new co.doubleduck.audio.DummyAudioAPI();
		}
		Reflect.setProperty(co.doubleduck.SoundManager._cache,src,audio);
	}
	return audio;
}
co.doubleduck.SoundManager.playEffect = function(src,volume,optional) {
	if(optional == null) optional = false;
	if(volume == null) volume = 1;
	if(optional && co.doubleduck.SoundManager.engineType == co.doubleduck.SoundType.AUDIO_NO_OVERLAP) return new co.doubleduck.audio.DummyAudioAPI();
	var audio = co.doubleduck.SoundManager.getAudioInstance(src);
	var playVolume = volume;
	if(co.doubleduck.SoundManager._muted) playVolume = 0;
	audio.playEffect(playVolume);
	return audio;
}
co.doubleduck.SoundManager.playMusic = function(src,volume,loop) {
	if(loop == null) loop = true;
	if(volume == null) volume = 1;
	var audio = co.doubleduck.SoundManager.getAudioInstance(src);
	var playVolume = volume;
	if(co.doubleduck.SoundManager._muted) playVolume = 0;
	audio.playMusic(playVolume,loop);
	return audio;
}
co.doubleduck.SoundManager.initSound = function(src) {
	co.doubleduck.SoundManager.getAudioInstance(src);
}
co.doubleduck.SoundManager.prototype = {
	__class__: co.doubleduck.SoundManager
}
co.doubleduck.Train = $hxClasses["co.doubleduck.Train"] = function(trainLength,direction) {
	createjs.Container.call(this);
	trainLength--;
	this._width = 0;
	if(direction == -1) {
		this._engineCar = co.doubleduck.BaseAssets.getImage("images/session/enginecar.png");
		this._engineCar.scaleX = this._engineCar.scaleY = co.doubleduck.BaseGame.getScale();
		this.addChild(this._engineCar);
		this._width = this._engineCar.image.width;
		this._height = this._engineCar.image.height;
		this.regY = this._height / 2 * co.doubleduck.BaseGame.getScale();
	}
	var _g = 0;
	while(_g < trainLength) {
		var i = _g++;
		var trainCar = co.doubleduck.BaseAssets.getImage("images/session/traincar.png");
		trainCar.scaleX = trainCar.scaleY = co.doubleduck.BaseGame.getScale();
		trainCar.regX = trainCar.regY = 0;
		trainCar.x = this._width * co.doubleduck.BaseGame.getScale();
		this.addChild(trainCar);
		this._width += trainCar.image.width;
	}
	if(direction == 1) {
		this._engineCar = co.doubleduck.BaseAssets.getImage("images/session/enginecar.png");
		this._engineCar.scaleX = this._engineCar.scaleY = co.doubleduck.BaseGame.getScale();
		this._engineCar.x = this._width * co.doubleduck.BaseGame.getScale();
		this.addChild(this._engineCar);
		this._width += this._engineCar.image.width;
		this._height = this._engineCar.image.height;
		this.regY = this._height / 2 * co.doubleduck.BaseGame.getScale();
	}
	this._width *= co.doubleduck.BaseGame.getScale();
	this._height *= co.doubleduck.BaseGame.getScale();
	this.regX = this._width / 2;
};
co.doubleduck.Train.__name__ = ["co","doubleduck","Train"];
co.doubleduck.Train.__super__ = createjs.Container;
co.doubleduck.Train.prototype = $extend(createjs.Container.prototype,{
	getHeight: function() {
		return this._height;
	}
	,getWidth: function() {
		return this._width;
	}
	,_engineCar: null
	,_height: null
	,_width: null
	,__class__: co.doubleduck.Train
});
co.doubleduck.Transition = $hxClasses["co.doubleduck.Transition"] = function() {
	createjs.Container.call(this);
	if(co.doubleduck.Transition._allowInstantiation == false) return;
	this.name = "Transition";
	this._blackOverlay = new createjs.Shape();
	this._blackOverlay.graphics.beginFill("#000000");
	this._blackOverlay.graphics.drawRect(0,0,co.doubleduck.BaseGame.getViewport().width,co.doubleduck.BaseGame.getViewport().height);
	this._blackOverlay.graphics.endFill();
	this.addChild(this._blackOverlay);
	this._blackOverlay.alpha = 0;
};
co.doubleduck.Transition.__name__ = ["co","doubleduck","Transition"];
co.doubleduck.Transition._instance = null;
co.doubleduck.Transition.getInstance = function() {
	co.doubleduck.Transition._allowInstantiation = true;
	if(co.doubleduck.Transition._instance != null) return co.doubleduck.Transition._instance;
	var instance = new co.doubleduck.Transition();
	co.doubleduck.Transition._instance = instance;
	return instance;
}
co.doubleduck.Transition.transitionIn = function() {
	if(co.doubleduck.Transition._instance == null) return;
	co.doubleduck.Transition._instance._blackOverlay.alpha = 1;
	createjs.Tween.get(co.doubleduck.Transition._instance._blackOverlay).to({ alpha : 0},1000);
}
co.doubleduck.Transition.transitionOut = function(handler,params) {
	if(co.doubleduck.Transition._instance == null) return;
	co.doubleduck.Transition._instance._blackOverlay.alpha = 0;
	createjs.Tween.get(co.doubleduck.Transition._instance._blackOverlay).to({ alpha : 1},500).call(handler,params);
}
co.doubleduck.Transition.__super__ = createjs.Container;
co.doubleduck.Transition.prototype = $extend(createjs.Container.prototype,{
	_blackOverlay: null
	,__class__: co.doubleduck.Transition
});
co.doubleduck.Utils = $hxClasses["co.doubleduck.Utils"] = function() { }
co.doubleduck.Utils.__name__ = ["co","doubleduck","Utils"];
co.doubleduck.Utils.dateDeltaInDays = function(day1,day2) {
	var delta = Math.abs(day2.getTime() - day1.getTime());
	return delta / 86400000;
}
co.doubleduck.Utils.getTodayDate = function() {
	var newDate = new Date();
	return HxOverrides.dateStr(newDate);
}
co.doubleduck.Utils.getHour = function() {
	var newDate = new Date();
	return newDate.getHours();
}
co.doubleduck.Utils.rectOverlap = function(r1,r2) {
	var r1TopLeft = new createjs.Point(r1.x,r1.y);
	var r1BottomRight = new createjs.Point(r1.x + r1.width,r1.y + r1.height);
	var r1TopRight = new createjs.Point(r1.x + r1.width,r1.y);
	var r1BottomLeft = new createjs.Point(r1.x,r1.y + r1.height);
	var r2TopLeft = new createjs.Point(r2.x,r2.y);
	var r2BottomRight = new createjs.Point(r2.x + r2.width,r2.y + r2.height);
	var r2TopRight = new createjs.Point(r2.x + r2.width,r2.y);
	var r2BottomLeft = new createjs.Point(r2.x,r2.y + r2.height);
	if(co.doubleduck.Utils.rectContainPoint(r2TopLeft,r2BottomRight,r1TopLeft)) return true;
	if(co.doubleduck.Utils.rectContainPoint(r2TopLeft,r2BottomRight,r1BottomRight)) return true;
	if(co.doubleduck.Utils.rectContainPoint(r2TopLeft,r2BottomRight,r1TopRight)) return true;
	if(co.doubleduck.Utils.rectContainPoint(r2TopLeft,r2BottomRight,r1BottomLeft)) return true;
	if(co.doubleduck.Utils.rectContainPoint(r1TopLeft,r1BottomRight,r2TopLeft)) return true;
	if(co.doubleduck.Utils.rectContainPoint(r1TopLeft,r1BottomRight,r2BottomRight)) return true;
	if(co.doubleduck.Utils.rectContainPoint(r1TopLeft,r1BottomRight,r2TopRight)) return true;
	if(co.doubleduck.Utils.rectContainPoint(r1TopLeft,r1BottomRight,r2BottomLeft)) return true;
	return false;
}
co.doubleduck.Utils.overlap = function(obj1,obj1Width,obj1Height,obj2,obj2Width,obj2Height) {
	var o1TopLeft = new createjs.Point(obj1.x - obj1.regX * co.doubleduck.BaseGame.getScale(),obj1.y - obj1.regY * co.doubleduck.BaseGame.getScale());
	var o1BottomRight = new createjs.Point(o1TopLeft.x - obj1.regX * co.doubleduck.BaseGame.getScale() + obj1Width * co.doubleduck.BaseGame.getScale(),o1TopLeft.y + obj1Height * co.doubleduck.BaseGame.getScale() - obj1.regY * co.doubleduck.BaseGame.getScale());
	var o1TopRight = new createjs.Point(o1BottomRight.x - obj1.regX * co.doubleduck.BaseGame.getScale(),o1TopLeft.y - obj1.regY * co.doubleduck.BaseGame.getScale());
	var o1BottomLeft = new createjs.Point(o1TopLeft.x - obj1.regX * co.doubleduck.BaseGame.getScale(),o1BottomRight.y - obj1.regY * co.doubleduck.BaseGame.getScale());
	var o2TopLeft = new createjs.Point(obj2.x - obj2.regX * co.doubleduck.BaseGame.getScale(),obj2.y - obj2.regY * co.doubleduck.BaseGame.getScale());
	var o2BottomRight = new createjs.Point(o2TopLeft.x + obj2Width * co.doubleduck.BaseGame.getScale() - obj2.regX * co.doubleduck.BaseGame.getScale(),o2TopLeft.y + obj2Height * co.doubleduck.BaseGame.getScale() - obj2.regY * co.doubleduck.BaseGame.getScale());
	var o2TopRight = new createjs.Point(o2BottomRight.x - obj2.regX * co.doubleduck.BaseGame.getScale(),o2TopLeft.y - obj2.regY * co.doubleduck.BaseGame.getScale());
	var o2BottomLeft = new createjs.Point(o2TopLeft.x - obj2.regX * co.doubleduck.BaseGame.getScale(),o2BottomRight.y - obj2.regY * co.doubleduck.BaseGame.getScale());
	if(co.doubleduck.Utils.rectContainPoint(o2TopLeft,o2BottomRight,o1TopLeft)) return true;
	if(co.doubleduck.Utils.rectContainPoint(o2TopLeft,o2BottomRight,o1BottomRight)) return true;
	if(co.doubleduck.Utils.rectContainPoint(o2TopLeft,o2BottomRight,o1TopRight)) return true;
	if(co.doubleduck.Utils.rectContainPoint(o2TopLeft,o2BottomRight,o1BottomLeft)) return true;
	if(co.doubleduck.Utils.rectContainPoint(o1TopLeft,o1BottomRight,o2TopLeft)) return true;
	if(co.doubleduck.Utils.rectContainPoint(o1TopLeft,o1BottomRight,o2BottomRight)) return true;
	if(co.doubleduck.Utils.rectContainPoint(o1TopLeft,o1BottomRight,o2TopRight)) return true;
	if(co.doubleduck.Utils.rectContainPoint(o1TopLeft,o1BottomRight,o2BottomLeft)) return true;
	return false;
}
co.doubleduck.Utils.rectContainPoint = function(rectTopLeft,rectBottomRight,point) {
	return point.x >= rectTopLeft.x && point.x <= rectBottomRight.x && point.y >= rectTopLeft.y && point.y <= rectBottomRight.y;
}
co.doubleduck.Utils.objectContains = function(dyn,memberName) {
	return Reflect.hasField(dyn,memberName);
}
co.doubleduck.Utils.contains = function(arr,obj) {
	var _g = 0;
	while(_g < arr.length) {
		var element = arr[_g];
		++_g;
		if(element == obj) return true;
	}
	return false;
}
co.doubleduck.Utils.isMobileFirefox = function() {
	var isFirefox = /Firefox/.test(navigator.userAgent);
	return isFirefox && viewporter.ACTIVE;
}
co.doubleduck.Utils.get = function(x,y,tiles,columns) {
	return tiles[columns * y + x];
}
co.doubleduck.Utils.getBitmapLabel = function(label,fontType,padding) {
	if(padding == null) padding = 0;
	if(fontType == null) fontType = "";
	var fontHelper = new co.doubleduck.FontHelper(fontType);
	var bitmapText = fontHelper.getNumber(Std.parseInt(label),1,true,null,padding);
	return bitmapText;
}
co.doubleduck.Utils.concatWithoutDuplicates = function(array,otherArray) {
	var _g = 0;
	while(_g < otherArray.length) {
		var element = otherArray[_g];
		++_g;
		co.doubleduck.Utils.addToArrayWithoutDuplicates(array,element);
	}
	return array;
}
co.doubleduck.Utils.addToArrayWithoutDuplicates = function(array,element) {
	var _g = 0;
	while(_g < array.length) {
		var currElement = array[_g];
		++_g;
		if(currElement == element) return array;
	}
	array.push(element);
	return array;
}
co.doubleduck.Utils.getImageData = function(image) {
	var ctx = co.doubleduck.Utils.getCanvasContext();
	var img = co.doubleduck.BaseAssets.getImage(image);
	ctx.drawImage(img.image,0,0);
	return ctx.getImageData(0,0,img.image.width,img.image.height);
}
co.doubleduck.Utils.getCanvasContext = function() {
	var dom = js.Lib.document.createElement("Canvas");
	var canvas = dom;
	return canvas.getContext("2d");
}
co.doubleduck.Utils.joinArrays = function(a1,a2) {
	var arr = a1.slice();
	var _g = 0;
	while(_g < a2.length) {
		var el = a2[_g];
		++_g;
		arr.push(el);
	}
	return arr;
}
co.doubleduck.Utils.getRandomElement = function(arr) {
	return arr[Std.random(arr.length)];
}
co.doubleduck.Utils.splitArray = function(arr,parts) {
	var arrs = new Array();
	var _g = 0;
	while(_g < parts) {
		var p = _g++;
		arrs.push(new Array());
	}
	var currArr = 0;
	while(arr.length > 0) {
		arrs[currArr].push(arr.pop());
		currArr++;
		currArr %= parts;
	}
	return arrs;
}
co.doubleduck.Utils.map = function(value,aMin,aMax,bMin,bMax) {
	if(bMax == null) bMax = 1;
	if(bMin == null) bMin = 0;
	if(value <= aMin) return bMin;
	if(value >= aMax) return bMax;
	return (value - aMin) * (bMax - bMin) / (aMax - aMin) + bMin;
}
co.doubleduck.Utils.waitAndCall = function(parent,delay,func,args) {
	createjs.Tween.get(parent).wait(delay).call(func,args);
}
co.doubleduck.Utils.tintBitmap = function(src,redMultiplier,greenMultiplier,blueMultiplier,alphaMultiplier) {
	var colorFilter = new createjs.ColorFilter(redMultiplier,greenMultiplier,blueMultiplier,alphaMultiplier);
	src.cache(src.x,src.y,src.image.width,src.image.height);
	src.filters = [colorFilter];
	src.updateCache();
}
co.doubleduck.Utils.containBitmaps = function(bitmapList,spacing,isRow,dims) {
	if(isRow == null) isRow = true;
	if(spacing == null) spacing = 0;
	var totalWidth = 0;
	var totalHeight = 0;
	var result = new createjs.Container();
	var _g1 = 0, _g = bitmapList.length;
	while(_g1 < _g) {
		var currBitmap = _g1++;
		var bmp = bitmapList[currBitmap];
		bmp.regY = bmp.image.height / 2;
		if(currBitmap != 0) {
			if(isRow) {
				bmp.x = bitmapList[currBitmap - 1].x + bitmapList[currBitmap - 1].image.width + spacing;
				if(bmp.image.height > totalHeight) totalHeight = bmp.image.height;
				totalWidth += bmp.image.width + spacing;
			} else {
				bmp.y = bitmapList[currBitmap - 1].y + bitmapList[currBitmap - 1].image.height + spacing;
				if(bmp.image.width > totalWidth) totalWidth = bmp.image.width;
				totalHeight += bmp.image.height + spacing;
			}
		} else {
			totalWidth = bmp.image.width;
			totalHeight = bmp.image.height;
		}
		result.addChild(bmp);
	}
	result.regX = totalWidth / 2;
	result.regY = totalHeight / 2;
	if(dims != null) {
		dims.width = totalWidth;
		dims.height = totalHeight;
	}
	return result;
}
co.doubleduck.Utils.getCenteredImage = function(name,scaleToGame) {
	if(scaleToGame == null) scaleToGame = false;
	var img = co.doubleduck.BaseAssets.getImage(name);
	img.regX = img.image.width / 2;
	img.regY = img.image.height / 2;
	if(scaleToGame) img.scaleX = img.scaleY = co.doubleduck.BaseGame.getScale();
	return img;
}
co.doubleduck.Utils.setCenterReg = function(bmp) {
	bmp.regX = bmp.image.width / 2;
	bmp.regY = bmp.image.height / 2;
}
co.doubleduck.Utils.shuffleArray = function(arr) {
	var tmp, j, i = arr.length;
	while(i > 0) {
		j = Math.random() * i | 0;
		tmp = arr[--i];
		arr[i] = arr[j];
		arr[j] = tmp;
	}
}
co.doubleduck.Utils.scaleObject = function(obj) {
	obj.scaleX = obj.scaleY = co.doubleduck.BaseGame.getScale();
}
co.doubleduck.Utils.getRectangle = function(rect,color) {
	var ret = new createjs.Shape();
	ret.graphics.beginFill(color);
	ret.graphics.drawRect(rect.x,rect.y,rect.width,rect.height);
	ret.graphics.endFill();
	return ret;
}
co.doubleduck.Utils.getDistance = function(p1,p2) {
	var distX = p1.x - p2.x;
	var distY = p1.y - p2.y;
	var dist = Math.sqrt(distX * distX + distY * distY);
	return dist;
}
co.doubleduck.Utils.average = function(arr) {
	var sum = 0;
	var _g = 0;
	while(_g < arr.length) {
		var i = arr[_g];
		++_g;
		sum += i;
	}
	return sum / arr.length;
}
co.doubleduck.Utils.radToDeg = function(rad) {
	return rad * 180 / Math.PI;
}
co.doubleduck.Utils.degToRad = function(deg) {
	return deg * Math.PI / 180;
}
co.doubleduck.Utils.sign = function(num) {
	if(num < 0) return -1; else if(num > 0) return 1;
	return 0;
}
co.doubleduck.Utils.loadSpriteSheet = function(imgPath,numberOfFrames,animName,animFrequency,centerReg) {
	if(centerReg == null) centerReg = true;
	if(animFrequency == null) animFrequency = 1;
	var ret;
	var data = { };
	var img = co.doubleduck.BaseAssets.getRawImage(imgPath);
	var numFrames = numberOfFrames;
	var imageHeight = 0;
	var imageWidth = 0;
	if(img.width > img.height) {
		imageWidth = img.width / numFrames;
		imageHeight = img.height;
	} else {
		imageHeight = img.height / numFrames;
		imageWidth = img.width;
	}
	if(centerReg) data.frames = { width : imageWidth, height : imageHeight, regX : imageWidth / 2, regY : imageHeight / 2}; else data.frames = { width : imageWidth, height : imageHeight};
	data.images = [img];
	data.animations = { };
	var framesArr = [];
	var _g = 0;
	while(_g < numFrames) {
		var i = _g++;
		framesArr.push(i);
	}
	data[animName] = { frames : framesArr, frequency : 5};
	ret = new createjs.SpriteSheet(data);
	return ret;
}
co.doubleduck.audio.AudioFX = $hxClasses["co.doubleduck.audio.AudioFX"] = function(src) {
	this._jsAudio = null;
	this._src = src;
	this._loop = false;
	this._volume = 1;
};
co.doubleduck.audio.AudioFX.__name__ = ["co","doubleduck","audio","AudioFX"];
co.doubleduck.audio.AudioFX.__interfaces__ = [co.doubleduck.audio.AudioAPI];
co.doubleduck.audio.AudioFX._currentlyPlaying = null;
co.doubleduck.audio.AudioFX.prototype = {
	setVolume: function(volume) {
		this._volume = volume;
		if(this._jsAudio != null) this._jsAudio.setVolume(volume);
	}
	,pause: function() {
	}
	,stop: function(fadeOut) {
		if(fadeOut == null) fadeOut = 0;
		this._jsAudio.stop();
	}
	,playMusic: function(volume,loop,fadeIn) {
		if(fadeIn == null) fadeIn = 0;
		if(loop == null) loop = true;
		if(volume == null) volume = 1;
		if(this._jsAudio == null) this.load(loop);
		this._jsAudio.play();
		this.setVolume(volume);
	}
	,playEffect: function(volume,overrideOtherEffects,loop,fadeIn) {
		if(fadeIn == null) fadeIn = 0;
		if(loop == null) loop = false;
		if(overrideOtherEffects == null) overrideOtherEffects = true;
		if(volume == null) volume = 1;
		if(this._jsAudio == null) this.load(loop,co.doubleduck.SoundManager.audioPoolSize);
		this._jsAudio.play();
		this.setVolume(volume);
	}
	,load: function(isLoop,pool) {
		if(pool == null) pool = 1;
		var pathNoExtension = this._src;
		this._jsAudio = AudioFX(pathNoExtension, { loop: isLoop, pool: pool });
	}
	,init: function() {
	}
	,_volume: null
	,_loop: null
	,_jsAudio: null
	,_src: null
	,__class__: co.doubleduck.audio.AudioFX
}
co.doubleduck.audio.DummyAudioAPI = $hxClasses["co.doubleduck.audio.DummyAudioAPI"] = function() {
};
co.doubleduck.audio.DummyAudioAPI.__name__ = ["co","doubleduck","audio","DummyAudioAPI"];
co.doubleduck.audio.DummyAudioAPI.__interfaces__ = [co.doubleduck.audio.AudioAPI];
co.doubleduck.audio.DummyAudioAPI.prototype = {
	setVolume: function(volume) {
	}
	,pause: function() {
	}
	,stop: function(fadeOut) {
		if(fadeOut == null) fadeOut = 0;
	}
	,playMusic: function(volume,loop,fadeIn) {
		if(fadeIn == null) fadeIn = 0;
		if(loop == null) loop = true;
		if(volume == null) volume = 1;
	}
	,playEffect: function(volume,overrideOtherEffects,loop,fadeIn) {
		if(fadeIn == null) fadeIn = 0;
		if(loop == null) loop = false;
		if(overrideOtherEffects == null) overrideOtherEffects = true;
		if(volume == null) volume = 1;
	}
	,init: function() {
	}
	,__class__: co.doubleduck.audio.DummyAudioAPI
}
co.doubleduck.audio.HowlerAudio = $hxClasses["co.doubleduck.audio.HowlerAudio"] = function(src) {
	this._jsAudio = null;
	this._src = src;
	this._loop = false;
	this._volume = 1;
};
co.doubleduck.audio.HowlerAudio.__name__ = ["co","doubleduck","audio","HowlerAudio"];
co.doubleduck.audio.HowlerAudio.__interfaces__ = [co.doubleduck.audio.AudioAPI];
co.doubleduck.audio.HowlerAudio._currentlyPlaying = null;
co.doubleduck.audio.HowlerAudio.prototype = {
	setVolume: function(volume) {
		this._volume = volume;
		if(this._jsAudio != null) this._jsAudio.volume = volume;
	}
	,pause: function() {
	}
	,stop: function(fadeOut) {
		if(fadeOut == null) fadeOut = 0;
		this._jsAudio.stop();
	}
	,playMusic: function(volume,loop,fadeIn) {
		if(fadeIn == null) fadeIn = 0;
		if(loop == null) loop = true;
		if(volume == null) volume = 1;
		if(this._jsAudio == null) this.load(loop);
		this._jsAudio.play();
		this.setVolume(volume);
	}
	,playEffect: function(volume,overrideOtherEffects,loop,fadeIn) {
		if(fadeIn == null) fadeIn = 0;
		if(loop == null) loop = false;
		if(overrideOtherEffects == null) overrideOtherEffects = true;
		if(volume == null) volume = 1;
		if(this._jsAudio == null) this.load(loop,1);
		this._jsAudio.play();
		this.setVolume(volume);
	}
	,load: function(isLoop,pool) {
		if(pool == null) pool = 1;
		var pathNoExtension = this._src;
		var myUrls = new Array();
		myUrls.push(this._src + ".mp3");
		myUrls.push(this._src + ".ogg");
		this._jsAudio = new Howl({urls: myUrls, loop: false});
	}
	,init: function() {
	}
	,_volume: null
	,_loop: null
	,_jsAudio: null
	,_src: null
	,__class__: co.doubleduck.audio.HowlerAudio
}
co.doubleduck.audio.NonOverlappingAudio = $hxClasses["co.doubleduck.audio.NonOverlappingAudio"] = function(src) {
	this._src = src;
	this.load();
	this._isMusic = false;
};
co.doubleduck.audio.NonOverlappingAudio.__name__ = ["co","doubleduck","audio","NonOverlappingAudio"];
co.doubleduck.audio.NonOverlappingAudio.__interfaces__ = [co.doubleduck.audio.AudioAPI];
co.doubleduck.audio.NonOverlappingAudio._currentlyPlaying = null;
co.doubleduck.audio.NonOverlappingAudio.prototype = {
	getSrc: function() {
		return this._src;
	}
	,audio: function() {
		return this._audio;
	}
	,setVolume: function(volume) {
		if(this._audio != null) this._audio.volume = volume;
	}
	,pause: function() {
		if(this._audio != null) this._audio.pause();
	}
	,stop: function(fadeOut) {
		if(fadeOut == null) fadeOut = 0;
		if(this._isMusic) co.doubleduck.audio.NonOverlappingAudio._musicPlaying = false;
		if(this._audio != null) {
			this._audio.removeEventListener("ended",$bind(this,this.handleEnded));
			this._audio.currentTime = 0;
			this._audio.pause();
		}
	}
	,playMusic: function(volume,loop,fadeIn) {
		if(fadeIn == null) fadeIn = 0;
		if(loop == null) loop = false;
		if(volume == null) volume = 1;
		if(co.doubleduck.audio.NonOverlappingAudio._currentlyPlaying != null) co.doubleduck.audio.NonOverlappingAudio._currentlyPlaying.stop();
		this._isMusic = true;
		co.doubleduck.audio.NonOverlappingAudio._musicPlaying = true;
		this._audio.play();
		this._audio.volume = volume;
		this._audio.loop = loop;
		if(!loop) this._audio.addEventListener("ended",$bind(this,this.stop));
	}
	,handleEnded: function() {
		this._audio.removeEventListener("ended",$bind(this,this.handleEnded));
		this._audio.currentTime = 0;
	}
	,handleTimeUpdate: function() {
		if(this._audio.currentTime >= this._audio.duration - 0.3) this.stop();
	}
	,playEffect: function(volume,overrideOtherEffects,loop,fadeIn) {
		if(fadeIn == null) fadeIn = 0;
		if(loop == null) loop = false;
		if(overrideOtherEffects == null) overrideOtherEffects = true;
		if(volume == null) volume = 1;
		if(co.doubleduck.audio.NonOverlappingAudio._musicPlaying) return;
		if(overrideOtherEffects && co.doubleduck.audio.NonOverlappingAudio._currentlyPlaying != null) co.doubleduck.audio.NonOverlappingAudio._currentlyPlaying.stop();
		this._audio.play();
		this._audio.volume = volume;
		this._audio.loop = loop;
		if(!loop) this._audio.addEventListener("ended",$bind(this,this.stop));
		co.doubleduck.audio.NonOverlappingAudio._currentlyPlaying = this;
	}
	,handleError: function() {
	}
	,handleCanPlay: function() {
	}
	,load: function() {
		this._audio = new Audio();
		this._audio.src = this._src;
		this._audio.initialTime = 0;
		this._audio.addEventListener("canplaythrough",$bind(this,this.handleCanPlay));
		this._audio.addEventListener("onerror",$bind(this,this.handleError));
	}
	,init: function() {
	}
	,_isMusic: null
	,_audio: null
	,_src: null
	,__class__: co.doubleduck.audio.NonOverlappingAudio
}
var haxe = haxe || {}
haxe.Log = $hxClasses["haxe.Log"] = function() { }
haxe.Log.__name__ = ["haxe","Log"];
haxe.Log.trace = function(v,infos) {
	js.Boot.__trace(v,infos);
}
haxe.Log.clear = function() {
	js.Boot.__clear_trace();
}
haxe.Public = $hxClasses["haxe.Public"] = function() { }
haxe.Public.__name__ = ["haxe","Public"];
haxe.StackItem = $hxClasses["haxe.StackItem"] = { __ename__ : ["haxe","StackItem"], __constructs__ : ["CFunction","Module","FilePos","Method","Lambda"] }
haxe.StackItem.CFunction = ["CFunction",0];
haxe.StackItem.CFunction.toString = $estr;
haxe.StackItem.CFunction.__enum__ = haxe.StackItem;
haxe.StackItem.Module = function(m) { var $x = ["Module",1,m]; $x.__enum__ = haxe.StackItem; $x.toString = $estr; return $x; }
haxe.StackItem.FilePos = function(s,file,line) { var $x = ["FilePos",2,s,file,line]; $x.__enum__ = haxe.StackItem; $x.toString = $estr; return $x; }
haxe.StackItem.Method = function(classname,method) { var $x = ["Method",3,classname,method]; $x.__enum__ = haxe.StackItem; $x.toString = $estr; return $x; }
haxe.StackItem.Lambda = function(v) { var $x = ["Lambda",4,v]; $x.__enum__ = haxe.StackItem; $x.toString = $estr; return $x; }
haxe.Stack = $hxClasses["haxe.Stack"] = function() { }
haxe.Stack.__name__ = ["haxe","Stack"];
haxe.Stack.callStack = function() {
	var oldValue = Error.prepareStackTrace;
	Error.prepareStackTrace = function(error,callsites) {
		var stack = [];
		var _g = 0;
		while(_g < callsites.length) {
			var site = callsites[_g];
			++_g;
			var method = null;
			var fullName = site.getFunctionName();
			if(fullName != null) {
				var idx = fullName.lastIndexOf(".");
				if(idx >= 0) {
					var className = HxOverrides.substr(fullName,0,idx);
					var methodName = HxOverrides.substr(fullName,idx + 1,null);
					method = haxe.StackItem.Method(className,methodName);
				}
			}
			stack.push(haxe.StackItem.FilePos(method,site.getFileName(),site.getLineNumber()));
		}
		return stack;
	};
	var a = haxe.Stack.makeStack(new Error().stack);
	a.shift();
	Error.prepareStackTrace = oldValue;
	return a;
}
haxe.Stack.exceptionStack = function() {
	return [];
}
haxe.Stack.toString = function(stack) {
	var b = new StringBuf();
	var _g = 0;
	while(_g < stack.length) {
		var s = stack[_g];
		++_g;
		b.b += Std.string("\nCalled from ");
		haxe.Stack.itemToString(b,s);
	}
	return b.b;
}
haxe.Stack.itemToString = function(b,s) {
	var $e = (s);
	switch( $e[1] ) {
	case 0:
		b.b += Std.string("a C function");
		break;
	case 1:
		var m = $e[2];
		b.b += Std.string("module ");
		b.b += Std.string(m);
		break;
	case 2:
		var line = $e[4], file = $e[3], s1 = $e[2];
		if(s1 != null) {
			haxe.Stack.itemToString(b,s1);
			b.b += Std.string(" (");
		}
		b.b += Std.string(file);
		b.b += Std.string(" line ");
		b.b += Std.string(line);
		if(s1 != null) b.b += Std.string(")");
		break;
	case 3:
		var meth = $e[3], cname = $e[2];
		b.b += Std.string(cname);
		b.b += Std.string(".");
		b.b += Std.string(meth);
		break;
	case 4:
		var n = $e[2];
		b.b += Std.string("local function #");
		b.b += Std.string(n);
		break;
	}
}
haxe.Stack.makeStack = function(s) {
	if(typeof(s) == "string") {
		var stack = s.split("\n");
		var m = [];
		var _g = 0;
		while(_g < stack.length) {
			var line = stack[_g];
			++_g;
			m.push(haxe.StackItem.Module(line));
		}
		return m;
	} else return s;
}
if(!haxe.unit) haxe.unit = {}
haxe.unit.TestCase = $hxClasses["haxe.unit.TestCase"] = function() {
};
haxe.unit.TestCase.__name__ = ["haxe","unit","TestCase"];
haxe.unit.TestCase.__interfaces__ = [haxe.Public];
haxe.unit.TestCase.prototype = {
	assertEquals: function(expected,actual,c) {
		this.currentTest.done = true;
		if(actual != expected) {
			this.currentTest.success = false;
			this.currentTest.error = "expected '" + Std.string(expected) + "' but was '" + Std.string(actual) + "'";
			this.currentTest.posInfos = c;
			throw this.currentTest;
		}
	}
	,assertFalse: function(b,c) {
		this.currentTest.done = true;
		if(b == true) {
			this.currentTest.success = false;
			this.currentTest.error = "expected false but was true";
			this.currentTest.posInfos = c;
			throw this.currentTest;
		}
	}
	,assertTrue: function(b,c) {
		this.currentTest.done = true;
		if(b == false) {
			this.currentTest.success = false;
			this.currentTest.error = "expected true but was false";
			this.currentTest.posInfos = c;
			throw this.currentTest;
		}
	}
	,print: function(v) {
		haxe.unit.TestRunner.print(v);
	}
	,tearDown: function() {
	}
	,setup: function() {
	}
	,currentTest: null
	,__class__: haxe.unit.TestCase
}
haxe.unit.TestResult = $hxClasses["haxe.unit.TestResult"] = function() {
	this.m_tests = new List();
	this.success = true;
};
haxe.unit.TestResult.__name__ = ["haxe","unit","TestResult"];
haxe.unit.TestResult.prototype = {
	toString: function() {
		var buf = new StringBuf();
		var failures = 0;
		var $it0 = this.m_tests.iterator();
		while( $it0.hasNext() ) {
			var test = $it0.next();
			if(test.success == false) {
				buf.b += Std.string("* ");
				buf.b += Std.string(test.classname);
				buf.b += Std.string("::");
				buf.b += Std.string(test.method);
				buf.b += Std.string("()");
				buf.b += Std.string("\n");
				buf.b += Std.string("ERR: ");
				if(test.posInfos != null) {
					buf.b += Std.string(test.posInfos.fileName);
					buf.b += Std.string(":");
					buf.b += Std.string(test.posInfos.lineNumber);
					buf.b += Std.string("(");
					buf.b += Std.string(test.posInfos.className);
					buf.b += Std.string(".");
					buf.b += Std.string(test.posInfos.methodName);
					buf.b += Std.string(") - ");
				}
				buf.b += Std.string(test.error);
				buf.b += Std.string("\n");
				if(test.backtrace != null) {
					buf.b += Std.string(test.backtrace);
					buf.b += Std.string("\n");
				}
				buf.b += Std.string("\n");
				failures++;
			}
		}
		buf.b += Std.string("\n");
		if(failures == 0) buf.b += Std.string("OK "); else buf.b += Std.string("FAILED ");
		buf.b += Std.string(this.m_tests.length);
		buf.b += Std.string(" tests, ");
		buf.b += Std.string(failures);
		buf.b += Std.string(" failed, ");
		buf.b += Std.string(this.m_tests.length - failures);
		buf.b += Std.string(" success");
		buf.b += Std.string("\n");
		return buf.b;
	}
	,add: function(t) {
		this.m_tests.add(t);
		if(!t.success) this.success = false;
	}
	,success: null
	,m_tests: null
	,__class__: haxe.unit.TestResult
}
haxe.unit.TestRunner = $hxClasses["haxe.unit.TestRunner"] = function() {
	this.result = new haxe.unit.TestResult();
	this.cases = new List();
};
haxe.unit.TestRunner.__name__ = ["haxe","unit","TestRunner"];
haxe.unit.TestRunner.print = function(v) {
	var msg = StringTools.htmlEscape(js.Boot.__string_rec(v,"")).split("\n").join("<br/>");
	var d = document.getElementById("haxe:trace");
	if(d == null) alert("haxe:trace element not found"); else d.innerHTML += msg;
}
haxe.unit.TestRunner.customTrace = function(v,p) {
	haxe.unit.TestRunner.print(p.fileName + ":" + p.lineNumber + ": " + Std.string(v) + "\n");
}
haxe.unit.TestRunner.prototype = {
	runCase: function(t) {
		var old = haxe.Log.trace;
		haxe.Log.trace = haxe.unit.TestRunner.customTrace;
		var cl = Type.getClass(t);
		var fields = Type.getInstanceFields(cl);
		haxe.unit.TestRunner.print("Class: " + Type.getClassName(cl) + " ");
		var _g = 0;
		while(_g < fields.length) {
			var f = fields[_g];
			++_g;
			var fname = f;
			var field = Reflect.field(t,f);
			if(StringTools.startsWith(fname,"test") && Reflect.isFunction(field)) {
				t.currentTest = new haxe.unit.TestStatus();
				t.currentTest.classname = Type.getClassName(cl);
				t.currentTest.method = fname;
				t.setup();
				try {
					field.apply(t,new Array());
					if(t.currentTest.done) {
						t.currentTest.success = true;
						haxe.unit.TestRunner.print(".");
					} else {
						t.currentTest.success = false;
						t.currentTest.error = "(warning) no assert";
						haxe.unit.TestRunner.print("W");
					}
				} catch( $e0 ) {
					if( js.Boot.__instanceof($e0,haxe.unit.TestStatus) ) {
						var e = $e0;
						haxe.unit.TestRunner.print("F");
						t.currentTest.backtrace = haxe.Stack.toString(haxe.Stack.exceptionStack());
					} else {
					var e = $e0;
					haxe.unit.TestRunner.print("E");
					if(e.message != null) t.currentTest.error = "exception thrown : " + Std.string(e) + " [" + Std.string(e.message) + "]"; else t.currentTest.error = "exception thrown : " + Std.string(e);
					t.currentTest.backtrace = haxe.Stack.toString(haxe.Stack.exceptionStack());
					}
				}
				this.result.add(t.currentTest);
				t.tearDown();
			}
		}
		haxe.unit.TestRunner.print("\n");
		haxe.Log.trace = old;
	}
	,run: function() {
		this.result = new haxe.unit.TestResult();
		var $it0 = this.cases.iterator();
		while( $it0.hasNext() ) {
			var c = $it0.next();
			this.runCase(c);
		}
		haxe.unit.TestRunner.print(this.result.toString());
		return this.result.success;
	}
	,add: function(c) {
		this.cases.add(c);
	}
	,cases: null
	,result: null
	,__class__: haxe.unit.TestRunner
}
haxe.unit.TestStatus = $hxClasses["haxe.unit.TestStatus"] = function() {
	this.done = false;
	this.success = false;
};
haxe.unit.TestStatus.__name__ = ["haxe","unit","TestStatus"];
haxe.unit.TestStatus.prototype = {
	backtrace: null
	,posInfos: null
	,classname: null
	,method: null
	,error: null
	,success: null
	,done: null
	,__class__: haxe.unit.TestStatus
}
var js = js || {}
js.Boot = $hxClasses["js.Boot"] = function() { }
js.Boot.__name__ = ["js","Boot"];
js.Boot.__unhtml = function(s) {
	return s.split("&").join("&amp;").split("<").join("&lt;").split(">").join("&gt;");
}
js.Boot.__trace = function(v,i) {
	var msg = i != null?i.fileName + ":" + i.lineNumber + ": ":"";
	msg += js.Boot.__string_rec(v,"");
	var d;
	if(typeof(document) != "undefined" && (d = document.getElementById("haxe:trace")) != null) d.innerHTML += js.Boot.__unhtml(msg) + "<br/>"; else if(typeof(console) != "undefined" && console.log != null) console.log(msg);
}
js.Boot.__clear_trace = function() {
	var d = document.getElementById("haxe:trace");
	if(d != null) d.innerHTML = "";
}
js.Boot.isClass = function(o) {
	return o.__name__;
}
js.Boot.isEnum = function(e) {
	return e.__ename__;
}
js.Boot.getClass = function(o) {
	return o.__class__;
}
js.Boot.__string_rec = function(o,s) {
	if(o == null) return "null";
	if(s.length >= 5) return "<...>";
	var t = typeof(o);
	if(t == "function" && (o.__name__ || o.__ename__)) t = "object";
	switch(t) {
	case "object":
		if(o instanceof Array) {
			if(o.__enum__) {
				if(o.length == 2) return o[0];
				var str = o[0] + "(";
				s += "\t";
				var _g1 = 2, _g = o.length;
				while(_g1 < _g) {
					var i = _g1++;
					if(i != 2) str += "," + js.Boot.__string_rec(o[i],s); else str += js.Boot.__string_rec(o[i],s);
				}
				return str + ")";
			}
			var l = o.length;
			var i;
			var str = "[";
			s += "\t";
			var _g = 0;
			while(_g < l) {
				var i1 = _g++;
				str += (i1 > 0?",":"") + js.Boot.__string_rec(o[i1],s);
			}
			str += "]";
			return str;
		}
		var tostr;
		try {
			tostr = o.toString;
		} catch( e ) {
			return "???";
		}
		if(tostr != null && tostr != Object.toString) {
			var s2 = o.toString();
			if(s2 != "[object Object]") return s2;
		}
		var k = null;
		var str = "{\n";
		s += "\t";
		var hasp = o.hasOwnProperty != null;
		for( var k in o ) { ;
		if(hasp && !o.hasOwnProperty(k)) {
			continue;
		}
		if(k == "prototype" || k == "__class__" || k == "__super__" || k == "__interfaces__" || k == "__properties__") {
			continue;
		}
		if(str.length != 2) str += ", \n";
		str += s + k + " : " + js.Boot.__string_rec(o[k],s);
		}
		s = s.substring(1);
		str += "\n" + s + "}";
		return str;
	case "function":
		return "<function>";
	case "string":
		return o;
	default:
		return String(o);
	}
}
js.Boot.__interfLoop = function(cc,cl) {
	if(cc == null) return false;
	if(cc == cl) return true;
	var intf = cc.__interfaces__;
	if(intf != null) {
		var _g1 = 0, _g = intf.length;
		while(_g1 < _g) {
			var i = _g1++;
			var i1 = intf[i];
			if(i1 == cl || js.Boot.__interfLoop(i1,cl)) return true;
		}
	}
	return js.Boot.__interfLoop(cc.__super__,cl);
}
js.Boot.__instanceof = function(o,cl) {
	try {
		if(o instanceof cl) {
			if(cl == Array) return o.__enum__ == null;
			return true;
		}
		if(js.Boot.__interfLoop(o.__class__,cl)) return true;
	} catch( e ) {
		if(cl == null) return false;
	}
	switch(cl) {
	case Int:
		return Math.ceil(o%2147483648.0) === o;
	case Float:
		return typeof(o) == "number";
	case Bool:
		return o === true || o === false;
	case String:
		return typeof(o) == "string";
	case Dynamic:
		return true;
	default:
		if(o == null) return false;
		if(cl == Class && o.__name__ != null) return true; else null;
		if(cl == Enum && o.__ename__ != null) return true; else null;
		return o.__enum__ == cl;
	}
}
js.Boot.__cast = function(o,t) {
	if(js.Boot.__instanceof(o,t)) return o; else throw "Cannot cast " + Std.string(o) + " to " + Std.string(t);
}
js.Lib = $hxClasses["js.Lib"] = function() { }
js.Lib.__name__ = ["js","Lib"];
js.Lib.document = null;
js.Lib.window = null;
js.Lib.debug = function() {
	debugger;
}
js.Lib.alert = function(v) {
	alert(js.Boot.__string_rec(v,""));
}
js.Lib.eval = function(code) {
	return eval(code);
}
js.Lib.setErrorHandler = function(f) {
	js.Lib.onerror = f;
}
function $iterator(o) { if( o instanceof Array ) return function() { return HxOverrides.iter(o); }; return typeof(o.iterator) == 'function' ? $bind(o,o.iterator) : o.iterator; };
var $_;
function $bind(o,m) { var f = function(){ return f.method.apply(f.scope, arguments); }; f.scope = o; f.method = m; return f; };
if(Array.prototype.indexOf) HxOverrides.remove = function(a,o) {
	var i = a.indexOf(o);
	if(i == -1) return false;
	a.splice(i,1);
	return true;
}; else null;
Math.__name__ = ["Math"];
Math.NaN = Number.NaN;
Math.NEGATIVE_INFINITY = Number.NEGATIVE_INFINITY;
Math.POSITIVE_INFINITY = Number.POSITIVE_INFINITY;
$hxClasses.Math = Math;
Math.isFinite = function(i) {
	return isFinite(i);
};
Math.isNaN = function(i) {
	return isNaN(i);
};
String.prototype.__class__ = $hxClasses.String = String;
String.__name__ = ["String"];
Array.prototype.__class__ = $hxClasses.Array = Array;
Array.__name__ = ["Array"];
Date.prototype.__class__ = $hxClasses.Date = Date;
Date.__name__ = ["Date"];
var Int = $hxClasses.Int = { __name__ : ["Int"]};
var Dynamic = $hxClasses.Dynamic = { __name__ : ["Dynamic"]};
var Float = $hxClasses.Float = Number;
Float.__name__ = ["Float"];
var Bool = $hxClasses.Bool = Boolean;
Bool.__ename__ = ["Bool"];
var Class = $hxClasses.Class = { __name__ : ["Class"]};
var Enum = { };
var Void = $hxClasses.Void = { __ename__ : ["Void"]};
if(typeof document != "undefined") js.Lib.document = document;
if(typeof window != "undefined") {
	js.Lib.window = window;
	js.Lib.window.onerror = function(msg,url,line) {
		var f = js.Lib.onerror;
		if(f == null) return false;
		return f(msg,[url + ":" + line]);
	};
}
co.doubleduck.BaseAssets.onLoadAll = null;
co.doubleduck.BaseAssets._loader = null;
co.doubleduck.BaseAssets._cacheData = { };
co.doubleduck.BaseAssets._loadCallbacks = { };
co.doubleduck.BaseAssets.loaded = 0;
co.doubleduck.BaseAssets._useLocalStorage = false;
co.doubleduck.BaseGame._viewport = null;
co.doubleduck.BaseGame._scale = 1;
co.doubleduck.BaseGame.DEBUG = false;
co.doubleduck.BaseGame.LOGO_URI = "images/duckling/splash_logo.png";
co.doubleduck.BaseGame.LOAD_STROKE_URI = "images/duckling/loading_stroke.png";
co.doubleduck.BaseGame.LOAD_FILL_URI = "images/duckling/loading_fill.png";
co.doubleduck.BaseGame.ORIENT_PORT_URI = "images/duckling/orientation_error_port.png";
co.doubleduck.BaseGame.ORIENT_LAND_URI = "images/duckling/orientation_error_land.png";
co.doubleduck.BaseGame.isLocalized = false;
co.doubleduck.BasePersistence.GAME_PREFIX = "DUCK";
co.doubleduck.BasePersistence.available = co.doubleduck.BasePersistence.localStorageSupported();
co.doubleduck.Button.CLICK_TYPE_NONE = 0;
co.doubleduck.Button.CLICK_TYPE_TINT = 1;
co.doubleduck.Button.CLICK_TYPE_JUICY = 2;
co.doubleduck.Button.CLICK_TYPE_SCALE = 3;
co.doubleduck.Button.CLICK_TYPE_TOGGLE = 4;
co.doubleduck.Button.CLICK_TYPE_HOLD = 5;
co.doubleduck.Button._defaultSound = null;
co.doubleduck.Car.TOTAL_COLS = 7;
co.doubleduck.Car.STOPPING_DISTANCE = 5;
co.doubleduck.GameSplash._justSeenSplash = false;
co.doubleduck.GameStateManager._isGameRunning = true;
co.doubleduck.Menu.PADDING_WIDTH = 13;
co.doubleduck.Menu.PADDING_HEIGHT = -3;
co.doubleduck.Menu.CELL_WIDTH = 66;
co.doubleduck.Menu.CELL_HEIGHT = 66;
co.doubleduck.Menu.ROWS = 2;
co.doubleduck.Menu.COLS = 3;
co.doubleduck.Menu.TWEEN_DURATION = 200;
co.doubleduck.Menu.ROTATION_PER_SEC = 5;
co.doubleduck.Menu.SWIPE_EASE = 0.007;
co.doubleduck.Railtrack.TOTAL_COLS = 7;
co.doubleduck.Road.BARRIER_Y_OFFSET = 10;
co.doubleduck.Road.TOTAL_COLS = 7;
co.doubleduck.Session.TOTAL_ROWS = 8;
co.doubleduck.Session.TOTAL_COLS = 7;
co.doubleduck.Session.Y_OFFSET = 100;
co.doubleduck.Session._currLevelId = -1;
co.doubleduck.audio.WebAudioAPI._buffers = { };
co.doubleduck.SoundManager._muted = false;
co.doubleduck.SoundManager._cache = { };
co.doubleduck.SoundManager.audioPoolSize = 2;
co.doubleduck.SoundManager.available = co.doubleduck.SoundManager.isSoundAvailable();
co.doubleduck.Transition._allowInstantiation = false;
co.doubleduck.audio.AudioFX._muted = false;
co.doubleduck.audio.HowlerAudio._muted = false;
co.doubleduck.audio.NonOverlappingAudio._musicPlaying = false;
js.Lib.onerror = null;
co.doubleduck.Main.main();
