
var sound = undefined;

function continueLoading() {
  $("#loading").hide();
  $("#hint").show();
  animatehint();
  $(".fullsize").click(toggleSound);
}

function loadError() {
  $("#loading").hide();
  $("#hint").hide();
  $("#appinfo").show();
  $("#appinfo").prepend("<p>I'm sorry. Your device doesn't seem to support this app at this moment.</p>");
}

function toggleSound() {
  if (sound === undefined) {
    return;
  }
  if (!sound.fading) {
    if (sound.playing) {
      stopRain();
      $("#hint").show();
    } else {
      startRain();
      $("#hint").hide();
    }
  }
  $("#appinfo").hide();
}

function clearFading() {
  if (sound) sound.fading = false;
}

function startRain() {
  sound.playing = true;
  sound.fading = true;
  sound.play();
  sound.fade(0,1,1000, clearFading);
}

function stopRain() {
  sound.fading = true;
  sound.fade(1,0,1000, function() { clearFading(); sound.pause(); });
  sound.playing = false;
}

function loadAudio() {
  var url = "RainyDay1m.ogg";
  sound = new Howl({
    urls: [url],
    autoplay: false,
    loop: true,
    onload: continueLoading,
    onloaderror: loadError
  });
  sound.playing = false;
};

function animatehint() {
  window.setInterval(
    function() {
    $("#hint").animate({opacity: 0}, 500, function() {
      $("#hint").animate({opacity: 1}, 500);
    })
  }, 1000);
}

$(".appname").click(function(){
  if ($("#appinfo:visible").length == 0) {
    $("#appinfo").show();
  } else {
    $("#appinfo").hide();
  }
});
loadAudio();

