/**
 * @license [group_template.js] [ver.1.2]
 * Copyright (c) @2012 Rakuten.Inc
 * Date : 2013/02/15
 */
 var loginStatus = 'default';
/**
 * 'default' = error happened before this function
 * 'login'   = login status
 * 'logout'  = logout status
 */


(function($){
  if(typeof jQuery == 'undefined' || typeof jQuery.noConflict != 'function'){
    return;
  }
  var $ = jQuery;

  $(function(){

    var _memberDetail = $('#memberDetail'),
      _close = $('div.close',_memberDetail),
      _memberMenu = $('li.memberMenu',_memberDetail),
      _menuTab = $('#menuTab'),
      _serviceMenu = $('li.serviceMenu',_memberDetail),
      //_container = $('#container'),
      _detailInfo = $('#detailInfo'),
      _serviceInfo = $('#serviceInfo'),
      _statusInfo = $('#statusInfo'),
      //variable for opening feedback form
      _openFBform = $('.feedbackLink'),
      _feedbackForm = $('#feedbackForm'),
      fbUrl = 'https://docs.google.com/forms/d/1qD5ZWDniWkLls0_W-xGKP40YZa-fxoDnCqrZs3Hlf-c/viewform?embedded=true';

    _memberDetail.css('top','500%').hide();
    var viewPoint;
    _close.click(function(){
      //_container.show();
      _memberDetail.animate({
        top: $(window).height()
        },200,function(){$(this).hide()});
    });

    _detailInfo.click(function(){
      viewPoint = $(window).scrollTop();
			_memberMenu.addClass('open');
			_serviceMenu.removeClass('open');
			_serviceInfo.hide();
			_statusInfo.show();
			_menuTab.show();
      _memberDetail.show().animate({
        top: 0
        //}
        //,200,function(){
          //_container.hide();
        });
    });
    _memberMenu.click(function(){
      $(this).addClass('open');
      _serviceMenu.removeClass('open');
      _serviceInfo.hide();
      _statusInfo.show();
    });
    _serviceMenu.click(function(){
      $(this).addClass('open');
      _memberMenu.removeClass('open');
      _statusInfo.hide();
      _serviceInfo.show();
      _feedbackForm.attr('src', fbUrl);
    });

  //open feedback form
  $('#information').on('click', _openFBform, function(){
    $('.close-reveal-modal').trigger('reveal:close');
      _memberDetail.show().animate({
        top: 0
        //},200,function(){
        //_container.hide();
      });
      _serviceMenu.addClass('open');
      _memberMenu.removeClass('open');
      _statusInfo.hide();
      _serviceInfo.show();
      _menuTab.hide();
      _feedbackForm.attr('src', fbUrl);
  });

    _openFBform.on('click', function(){
      _memberDetail.show().animate({
        top: 0
        //},200,function(){
          //_container.hide();
        });
      _serviceMenu.addClass('open');
      _memberMenu.removeClass('open');
      _statusInfo.hide();
      _serviceInfo.show();
      _menuTab.hide();
      _feedbackForm.attr('src', fbUrl);
    });


    var addFigure = function(str) {
      var num = new String(str).replace(/,/g, "");
      while(num != (num = num.replace(/^(-?\d+)(\d{3})/, "$1,$2")));
      return num;
    }

    $.support.cors = true;
    var myTarget = $('#header,#longHeader,#memberDetail');

    $.ajax({
      url: "https://app.rakuten.co.jp/engine/zapi/MemberInformation/GetPointWithRz/20121011",
      type: "GET",
      dataType: "json",
      success: function(data) {
      var myRankClass = '',
          myRankName = '',
          myPointAll = addFigure(data.cash + data.fixedPoint + data.limitedPoint + data.temporaryPoint),
          myPointCash = addFigure(data.cash),
          myPointFixed = addFigure(data.fixedPoint),
          myPointLimited = addFigure(data.limitedPoint);

          loginStatus = 'login';

        switch(data.rank){
          case 1:
            myRankClass = 'normal';
            myRankName = 'レギュラー会員';
            break;
          case 2:
            myRankClass = 'silver';
            myRankName = 'シルバー会員';
            break;
          case 3:
            myRankClass = 'gold';
            myRankName = 'ゴールド会員';
            break;
          case 4:
            myRankClass = 'platinum';
            myRankName = 'プラチナ会員';
            break;
          case 5:
            myRankClass = 'diamond';
            myRankName = 'ダイヤモンド会員';
            break;
        }

        // s.tl send value to sitecatalyst
         s.eVar22 = 'login ' + myRankClass;
        // s.t send value to sitecatalyst
        try {var s_code=s.t();if(s_code)document.write(s_code);} catch(e) {rakutenSC.log(e);}
        // end s.t send value to sitecatalyst

        $('.memberName',myTarget).html(data.username);
        $('.nickName',myTarget).html(data.nickname);
        $('.memberPoint',myTarget).html(myPointAll);
        $('.memberTemporaryPoint',myTarget).html(myPointLimited);
        $('.memberCache',myTarget).html(myPointCash);
        $('.memberRankName',myTarget).html(myRankName);
        $('#statusInfo',myTarget).addClass(myRankClass);
        $('#serviceInfo',myTarget).addClass(myRankClass);

        $('.login',myTarget).css('visibility','visible').show();
        $('.logout',myTarget).hide();
        $('.logoutBtn', '#footer').show();
      },
      error: function(xhr, statusText, e) {
        var message = $.parseJSON(xhr.responseText);

         loginStatus = 'logout';

        // s.tl send value to sitecatalyst
         s.eVar22 = 'logout';
        // s.t send value to sitecatalyst
        try {var s_code=s.t();if(s_code)document.write(s_code);} catch(e) {rakutenSC.log(e);}
        // end of s.t send value to sitecatalyst

        if (xhr.status == 400) {
          $('.login',myTarget).hide();
          $('.logout',myTarget).css('visibility','visible').show();

        } else if ('xhr status', xhr.status == 503) {
          if ("error_description" in message
            && message.error_description.match(/under maintenance/)) {
          } else {
          }
        } else {
        }
      },
      xhrFields: {
        withCredentials: true
      }
    });

  });
})(jQuery);

var tabHome = null;

(function($){

    tabHome = getAjaxResponse;

    //get response
    function getAjaxResponse(rseData) {
        console.log('### homeTab: start ###');
        var isTargetAndroid  =  navigator.userAgent.indexOf('Android 2.3')  !=  -1;
        var dataFetchPromise = null;
        var promise = null;

        if(!isTargetAndroid) {

            if ( rseData ) {
                dataFetchPromise = new $.Deferred().resolve(rseData).promise();
            }
            else {
                var d = (new Date()).getTime();
                var url = 'http://www.linkshare.ne.jp/ch/rg/timeline.json?'+d;
                dataFetchPromise= $.ajax({
                    url: url,
                    dataType: 'json',
                    timeout: 5000,
                });
            }

            promise = dataFetchPromise.then(function(data) {
                // resolved
                data = sortdata(data);
                var p = selectDataHotBlog(data).then(function() {
                    // refresh
                    pageScrolls[0].refresh();
                    // calcurate loading time
                    window.homeTabTime = Date.now() - window.startTime;
                    // send value to sitecatalyst
                    s.linkTrackVars="eVar39";
                    s.eVar39 = ''+window.homeTabTime;
                    s.tl(this,'o','HomeTab');

                    console.log('home: '+s.eVar39+'ms');
                    console.log(' === hotBlog: end ===');
                    console.log('### homeTab: end ###');
                    return new $.Deferred().resolve().promise();
                },function(){//fail(second argument)
                    new $.Deferred().reject().promise();
                }).then(function() {
                    return selectDataArticleBlog(data).then(function() {
                        pageScrolls[4].refresh();
                        console.log(' === articleBlog: end ===');
                        return new $.Deferred().resolve().promise();
                    });
                });
                return p;
            }, function(error) {
                // rejected
                $('#fan__blog--more').hide();
                showErrorMsg('#hotBlogReviews');
                showErrorMsg('#fanBlogs');
                OnButtonReload('#hotBlogReviews', getAjaxResponse);
                OnButtonReload('#fanBlogs', getAjaxResponse);
                console.error(' === hotBlog: error ===');
                return new $.Deferred().resolve(error);
            });
        }
        else {
            $('#block-homeHotBlogReviews').hide();
            $('#fanReviewContent').hide();

            promise = new $.Deferred().resolve().promise();
        }
        return promise;
    }

    //sorting registered urls
    function isRegisteredURL(url) {
        var regex = /^(http:\/\/35-45\.net\/|http:\/\/blog\.bbi\.boo\.jp\/|http:\/\/luchin\.blog6\.fc2\.com\/|http:\/\/nagomin08\.blog\.fc2\.com\/|http:\/\/sayonnn12\.blog118\.fc2.com\/|http:\/\/syuminokimono\.seesaa\.net\/article\/|http:\/\/techoo\.net\/|http:\/\/www\.web-ryoku\.com\/tuhan\/)/;
        var result = url.match(regex);
        return (result && result.length > 0);
    }

    function layoutDataForHotBlog(itemList) {
        var reviewTag= '',
            len = itemList.length,
            itemTag = '<ul class="pickupReview">',
            wrapperSize = _imgWrapperSize(),
            catalystId_home = 'scid=wi_gwa_bmk4_home',
            item,
            itemUrl;

        len = Math.min(2, len);

        for (var i = 0 ; i < len; i++) {
            item = itemList[i];
            itemUrl = '<li>';
            itemUrl += '<a href="#" class="clickbutton" style="width:'+ wrapperSize +'px"';
            itemUrl += 'data-image="'+escapeHTML(item['image_url'])+'" ';
            itemUrl += 'data-link="'+escapeHTML(appendParamToURL(item['link_url'], catalystId_home))+'" ';
            itemUrl += 'data-caption="'+escapeHTML(item['text'])+'" ';
            itemUrl += 'data-title="'+escapeHTML(item['title'])+'" ';
            itemUrl += '>';
            itemUrl += '<div class="image-wrapper loading" style="width:'+wrapperSize+'px; height:'+wrapperSize+'px">';
            itemUrl += '<img class="image-photo" src="' + item['image_url'] + '" alt="'+ item['title'] +'">';
            itemUrl += '</div>';
            itemUrl += '<div class="description">' + item['title'] + '</div>';
            itemUrl += '</a>';
            itemUrl += '</li>';
            reviewTag += itemUrl;
        }
        itemTag += reviewTag;
        itemTag += '</ul>';
        return itemTag;
    }

    function layoutDataForArticleBlog(itemList) {
        var reviewTag= '',
            reviewTag2= '',
            len2 = itemList.length,
            itemTag2 = '<ul class="fanReview">',
            wrapperSize2 = _imgWrapperSize2(),
            catalystId_article = 'scid=wi_gwa_bmk4_article_ichiba_facebook',
            item2,
            itemUrl2;

        len2 = Math.min(6, len2);  //Article Blogs

        //Article Blogs
        for ( var i = 0 ; i < len2; i++) {
            item2 = itemList[i];
            itemUrl2 = '<li>';
            itemUrl2 += '<a href="#" class="clickbutton pLink" ';
            itemUrl2 += 'data-image="'+escapeHTML(item2['image_url'])+'" ';
            itemUrl2 += 'data-link="'+escapeHTML(appendParamToURL(item2['link_url'], catalystId_article))+'" ';
            itemUrl2 += 'data-caption="'+escapeHTML(item2['text'])+'" ';
            itemUrl2 += 'data-title="'+escapeHTML(item2['title'])+'" ';
            itemUrl2 += '>';
            itemUrl2 += '<div class="image-wrapper loading" style="width:'+wrapperSize2+'px; height:'+wrapperSize2+'px">';
            itemUrl2 += '<img class="articleImg" src="' + item2['image_url'] + '" alt="'+ item2['title'] +'">';
            itemUrl2 += '</div>';
            itemUrl2 += '<div class="description">' + item2['title'] + '</div>';
            itemUrl2 += '</a>';
            itemUrl2 += '</li>';
            reviewTag2 += itemUrl2;
        }
        itemTag2 += reviewTag2;
        itemTag2 += '</ul>';
        return itemTag2;
    }

    function selectDataHotBlog(itemList) {
        console.log(' === hotBlog: start ===');
        var promise;
        // show hotBlog
        var len = Math.min(2, itemList.length); //hotBlogs
        if ( len > 0 ) {
            var itemTag = layoutDataForHotBlog(itemList, len);
            promise = adjustImages('square', '#hotBlogReviews', itemTag);
            setPopup('#hotBlogReviews');
            $('#layoutDataForHotBlog').show();
            $('#ttl-hotBlogReviews').show();
        }
        else {
            promise = (new $.Deferred()).resolve().promise();
        }
        return promise;
    }

    function selectDataArticleBlog(itemList) {
        console.log(' === articleBlog: start ===');
        var promise;
        // show Article Blogs
        var len = Math.min(6, itemList.length);
        if ( len > 0 ) {
            var itemTag = layoutDataForArticleBlog(itemList, len);
            var ratio = 4;
            var textSelector = '.description';
            setPopup('#fanBlogs');
            promise = adjustImages('square', '#fanBlogs', itemTag,
                                   '.fanReview > li .articleImg',
                                   ratio, textSelector);
        }
        else {
            // return vacant
            promise = new $.Deferred().resolve().promise();
        }
        return promise;
    }


    //sorting registered urls and return results
    function sortdata(dataurls){
        var resultdata = [],
            len = dataurls.length,
            i = 0,
            itemLinkUrl;

        for (i; i < len; i++) {
            itemLinkUrl = dataurls[i]['link_url'];
            if (isRegisteredURL(itemLinkUrl)){
                resultdata.push(dataurls[i]);
            }
        }
        return resultdata;
    }

})(jQuery);
var feedIchibaHistory = null;

(function($){
    var layoutData = function(items,len) {
        var wrapperSize = _imgWrapperSize(),
            historyCataID = 'scid=wi_gwa_bmk4_ichiba_browsing_history_item',
            isTargetAndroid  =  navigator.userAgent.indexOf('Android 2.3')  !=  -1,
            itemTag,
            url,
            itemName,
            imageUrl,
            len = Math.min(len, items.length);

        itemTag = '';
        itemTag += '<ul class="pickupReview">';

        for (var i = 0; i < len; i++) {
            url = items[i].itemurlfull;
            url = escapeHTML(appendParamToURL(url, historyCataID));
            url = setAffiliateLink(url);
            itemName = items[i].itemname;

            if(!isTargetAndroid) {
                imageUrl = items[i].imageurl;
            }
            else {
                imageUrl = items[i].imageurl128;
            }

            itemTag += '<li>';
            itemTag += '<a href="'+ escapeHTML(appendParamToURL(url, historyCataID)) +'" style="width:'+wrapperSize+'px">';
            itemTag += '<div class="image-wrapper loading" style="width:'+wrapperSize+'px; height:'+wrapperSize+'px"><img class="image-photo" src="' + imageUrl + '" alt=" '+ itemName +'"></div>';
            itemTag += '<div class="description">' + itemName + '</div>';
            itemTag += '</a></li>';
        }
        itemTag += '</ul>';
        return itemTag;
    }

    var _feedIchibaHistory = function() {
        console.log(' === ichibaHistory: start ===');
        var url = 'http://ashiato.rakuten.co.jp/rms/sd/ashiato/vc?act=6&sid=1';

        var promise = $.ajax({
            url: url,
            dataType: 'jsonp',
            timeout: 5000,
        }).then(function(data) {
            var p,
                q,
                deferredReady,
                data = data.items,
                len,
                itemTag,
                itemTag2;

            if ( data && data.length > 0 ) {
                itemTag = layoutData(data, 4);
                itemTag2 = layoutData(data, 2);
                p = adjustImages('square', '#history',
                                 itemTag,
                                 '.pickupReview > li .image-photo');
                if (loginStatus === 'login') {
                    $('#ttl-homeHistory').show();
                    $('#homeIchibaRanking2').hide();
                    q = adjustImages('square', '#homeHistory',
                                     itemTag2,
                                     '.pickupReview > li .image-photo');
                } else {
                    q = new $.Deferred().resolve().promise();
                }

                deferredReady = $.when(p,q);
            }
            else {
                deferredReady = new $.Deferred().reject('failed').promise();
            }
            return deferredReady;
        }, function(){//fail(second argument)
            new $.Deferred().reject().promise();
        }).then(function() {
            // refresh iScroll
            pageScrolls[1].refresh();

            // return promise;
            console.log(' === ichibaHistory: end ===');
            return new $.Deferred().resolve().promise();
        }, function(error) {

            $('#ichiba__history-more').hide();
             if (error === 'failed') {
                if(loginStatus ==='login') {
                    $('#history .noData').show();
                    $('#homeHistory .noData').show();
                    $('#ttl-homeHistory').show();
                } else {
                    $('#history .noItems').show();
                }
             }
             else {
                showErrorMsg('#history');
                OnButtonReload('#history', _feedIchibaHistory);
             }
            // refresh iScroll
            pageScrolls[1].refresh();

            // return promise;
            console.log(' === ichibaHistory: error ===');
            return new $.Deferred().resolve().promise();
        });
        return promise;
    }
    // export
    feedIchibaHistory = _feedIchibaHistory;
})(jQuery);

var feedIchibaBookmark = null;

(function($){

    feedIchibaBookmark = getBookmarkAjaxResponse;

     var layoutData = function(items,len) {
        var itemTag = '<ul class="pickupReview">',
            catalystId = 'scid=wi_gwa_bmk4_ichiba_bookmark_item',
            wrapperSize = _imgWrapperSize(),
            len = Math.min(len, items.length);

        for (var i = 0; i < len; ++i) {
            var item = items[i],
            url = items[i].itemurl,
            itemName = items[i].itemname,
            imageUrl = items[i].imageurl;

            url = escapeHTML(appendParamToURL(url, catalystId));
            url = setAffiliateLink(url);

            itemTag += '<li>';
            itemTag += '<a href="'+ escapeHTML(appendParamToURL(url, catalystId)) +'" style="width:'+wrapperSize+'px">';
            itemTag += '<div class="image-wrapper" style="width:'+wrapperSize+'px; height:'+wrapperSize+'px"><img class="image-photo" src="' + imageUrl + '" alt=" '+ itemName +'"></div>';
            itemTag += '<div class="description">' + itemName + '</div>';
            itemTag += '</a></li>';
        }
        itemTag += '</ul>';
        return itemTag;
    }

    function getBookmarkAjaxResponse(){
        console.log(' === ichibaBookmark: start ===');
        var url = 'http://api.bookmark.rakuten.co.jp/ichiba/?param2=20&param7=1&param5=json&callback=jsonp1375423803961&_=1375423804503';
        var promise = $.ajax({
            url: url,
            dataType: 'jsonp',
            scriptCharset: "EUC-JP",
            timeout: 5000,
        }).then(function(data) {//done(first argument)
            var p,
                q,
                deferredReady,
                data = data.items,
                itemTag,
                itemTag2;

            if ( data && data.length > 0) {
                itemTag = layoutData(data, 4);
                itemTag2 = layoutData(data, 2);
                p = adjustImages('square', '#bookmark',
                                 itemTag,
                                 '.pickupReview > li .image-photo');
                if (loginStatus === 'login') {
                    $('#ttl-homeBookmark').show();
                    $('#homeIchibaRanking3').hide();
                    q = adjustImages('square', '#homeBookmark',
                                 itemTag2,
                                 '.pickupReview > li .image-photo');
                } else {
                    q = new $.Deferred().resolve().promise();
                }

                deferredReady = $.when(p,q);
            }
            else {
                deferredReady = new $.Deferred().reject('failed').promise();
            }
            return deferredReady;
        }, function(xhr, statusText, e){//fail(second argument)
            new $.Deferred().reject(statusText).promise();
        }).then(function() {
            // refresh iScroll
            pageScrolls[1].refresh();

            // return promise;
            console.log(' === ichibaBookmark: end ===');
            return new $.Deferred().resolve().promise();

        }, function(error) {
            $('#ichiba__bookmark-more').hide();
             if (error === 'failed') {
                if(loginStatus ==='login') {
                    $('#bookmark .noData').show();
                    $('#homeBookmark .noData').show();
                    $('#ttl-homeBookmark').show();
                } else {
                    $('#bookmark .noItems').show();
                }
             }
             else {
                showErrorMsg('#bookmark');
                OnButtonReload('#bookmark', getBookmarkAjaxResponse);
                showErrorMsg('#homeBookmark');
                OnButtonReload('#homeBookmark', getBookmarkAjaxResponse);
             }

            // refresh iScroll
            pageScrolls[1].refresh();

            // return promise;
            console.log(' === ichibaBookmark: error ===');
            return new $.Deferred().resolve().promise();
        });
        return promise;
    }

})(jQuery);

var feedIchibaRanking = null;

(function($){
    // export loadRanking;
    feedIchibaRanking = loadRanking;

    var layoutData = function(data,len) {
        var itemList = data['Items'],
            len = Math.min(len, itemList.length),
            item,
            itemName,
            imageUrl,
            link,
            splink,
            splink2,
            pclink,
            pclink2,
            itemPrice,
            rank,
            rate,
            url,
            wrapperSize = _imgWrapperSize(),
            ichibaCataID = 'scid=wi_gwa_bmk4_ichiba_ranking_item',
            ichibaCataID2 = 'scid=wi_gwa_bmk4_home_ichiba_ranking_item',
            rankingTag = '',
            itemTag = '<ul class="pickupReview">',
            itemUrl,
            i = 0;

            len = Math.min(30, len);

        for (i; i < len; i++) {
            item = itemList[i].Item;
            itemName = item.itemName;
            imageUrl = item['mediumImageUrls'][0]['imageUrl'];
            imageUrl = imageUrl.split("?");
            imageUrl = imageUrl[0];
            //the first image of three;
            link = item.itemUrl;
            splink = escapeHTML(appendParamToURL(link, ichibaCataID));
            splink = setAffiliateLink(splink);
            pclink = escapeHTML(appendParamToURL(link, 'force-site=pc&'+ichibaCataID));
            pclink = setAffiliateLink(pclink);
            //ABTesting for top contents
            splink2 = escapeHTML(appendParamToURL(link, ichibaCataID2));
            splink2 = setAffiliateLink(splink2);
            pclink2 = escapeHTML(appendParamToURL(link, 'force-site=pc&'+ichibaCataID2));
            pclink2 = setAffiliateLink(pclink2);
            //
            itemPrice = _getComma(item.itemPrice);
            rank = item.rank;
            rate = item.reviewAverage;

            itemUrl = '<li data-id="'+i+'">';
            itemUrl += '<span class="r-order">' + rank + '</span>';
            itemUrl += '<a href="#" class="clickbutton" style="width:'+wrapperSize+'px"';
            itemUrl += 'data-image="'+escapeHTML(imageUrl)+'" ';
            itemUrl += 'data-link="'+ splink +'" ';
            itemUrl += 'data-pclink="'+ pclink +'" ';
            //ABTesting for top contents
            itemUrl += 'data-link2="'+ splink2 +'" ';
            itemUrl += 'data-pclink2="'+ pclink2 +'" ';
            //
            itemUrl += 'data-caption="'+escapeHTML(itemName)+'" ';
            itemUrl += 'data-title="'+escapeHTML(itemName)+'" ';
            itemUrl += 'data-score="'+escapeHTML(rate)+'" ';
            itemUrl += 'data-price="'+escapeHTML(itemPrice)+'" ';
            itemUrl += ' >';
            itemUrl += '<div class="image-wrapper loading" style="width:'+wrapperSize+'px; height:'+wrapperSize+'px">';
            itemUrl += '<img class="image-photo" src="' + imageUrl + '" alt="' + itemName +'"></div>';
            itemUrl += '<div class="description">' + itemName + '</div>';
            itemUrl += '<div class="itemprice">&#165;' + itemPrice + '</div>';
            itemUrl += '</a></li>';
            rankingTag += itemUrl;
        }

        itemTag += rankingTag;
        itemTag += '</ul>';

        return itemTag;
    }

    function loadRanking(genreId, rseData) {
        genreId = genreId || 0;
        console.log(' === ichibaRaking: start ===');

        var dataFetchPromise = null;
        if ( rseData ) {
            dataFetchPromise = new $.Deferred().resolve(rseData).promise();
        }
        else {
            var url = 'https://app.rakuten.co.jp/engine/api/IchibaItem/Ranking/20121201?applicationId=ichiba_ipad&page=1&genreId=' + genreId;
            dataFetchPromise = $.ajax({
                url: url,
                dataType: 'json',
                timeout: 5000,
            });
        }
        var promise = dataFetchPromise.then(function(data) {
            // render and adjust images
            var p,
                q,
                r,
                s,
                t,
                deferredReady,
                len,
                itemTag,
                itemTag2;

            if ( data && data.Items.length > 0 ) {
                itemTag = layoutData(data, 30),
                itemTag2 = layoutData(data, 2);
                $('#ichibaRanking').html('');
                p = adjustImages('square', '#ichibaRanking',
                                    itemTag,
                                    '.pickupReview > li .image-photo');

                // AB Testing - Show IchibaRanking to Home Top
                q = adjustImages('square', '#homeIchibaRanking',
                                    itemTag2,
                                    '.pickupReview > li .image-photo');

                //AB Testing for Home History. Display Ichiba Ranking when logout or no history data.
                if (loginStatus ==='login') {
                    t = new $.Deferred().resolve().promise();
                } else {

                    //AB Testing for Home History. Display Ichiba Ranking when logout or no history data.
                    r = adjustImages('square', '#homeIchibaRanking2',
                                        itemTag2,
                                        '.pickupReview > li .image-photo');
                    $('#ttl-homeIchibaRanking2').show();
                    $('#ttl-homeHistory').hide();
                     //AB Testing for Home Bookmark. Display Ichiba Ranking when logout or no bookmark data.
                     s = adjustImages('square', '#homeIchibaRanking3',
                                         itemTag2,
                                         '.pickupReview > li .image-photo');
                    $('#ttl-homeIchibaRanking3').show();
                    $('#ttl-homeBookmark').hide();
                    t = $.when(r,s);
                }

                $('#ichibaRanking_category').show();
                $('#ttl-homeIchibaRanking').show();

                deferredReady = $.when(p,q,t);
            }
            else {
                deferredReady = new $.Deferred().reject('failed').promise();
            }
            return deferredReady;
        },function(){//fail(second argument)
            new $.Deferred().reject().promise();
        }).then(function() {
                // refresh iScroll
                pageScrolls[1].refresh();
                // return promise;
                console.log(' === ichibaRaking: end ===');
                return new $.Deferred().resolve().promise();
        }, function(error) {
                $('#ichibaRanking_category').hide();
                showErrorMsg('#ichibaRanking');
                OnButtonReload('#ichibaRanking', loadRanking);
                showErrorMsg('#homeIchibaRanking');
                OnButtonReload('#homeIchibaRanking', loadRanking);
                // refresh iScroll
                pageScrolls[1].refresh();

                // return promise;
                console.log(' === ichibaRanking: error ===');
                return new $.Deferred().resolve().promise();
        });
        return promise;
    }

    $(function() {
        // set change event handler
        $('#ichibaRanking_category').on('change', function(){
            var genreId = $('#ichibaRanking_category').val();
            loadRanking(genreId);

        });
        // set popup
        setPopup('#ichibaRanking');
        setPopup('#homeIchibaRanking');
        setPopup('#homeIchibaRanking2');
        setPopup('#homeIchibaRanking3');
    });

    function _getComma(price) {
        var num = ''+price;
        while (num != (num = num.replace(/^(-?\d+)(\d{3})/, "$1,$2")));
        return num;
    }

})(jQuery);

var tabIchiba = function() {
    console.log('### ichibaTab: start ###');
    var feeds = [feedIchibaBookmark(), feedIchibaHistory()];
    return $.when.apply(this, feeds).then(function(result) {
        console.log('### ichibaTab: end ###');
        return new $.Deferred().resolve(result).promise();
    });
};

var feedTravelHistory = null;

(function($){

    feedTravelHistory = _feedTravelHistory;

    function layoutData(historyData) {
        var hotelhisCata = 'scid=wi_gwa_bmk4_travel_browsing_history_hotel',
            wrapperSize = _imgWrapperSize(),
            len = Math.min(4, historyData.length),
            item,
            hotelUrl,
            hotelName,
            hotelID,
            imgUrl,
            itemTag = '';

        itemTag += '<ul class="pickupReview">';

        for (var i = 0; i < len; i++) {
            item = historyData[i].hotelBasicInfo;
            hotelUrl = item['hotelInformationUrl'];
            hotelName = item['hotelName'];
            hotelID = item['hotelNo'];
            imgUrl = 'http://travel.rakuten.co.jp/HOTEL/' + hotelID + '/' + hotelID + '.jpg';

            itemTag += '<li>';
            itemTag += '<a href="'+escapeHTML(appendParamToURL(hotelUrl, hotelhisCata))+'" style="width:'+wrapperSize+'px">';
            itemTag += '<div class="image-wrapper loading" style="width:'+wrapperSize+'px; height:'+wrapperSize+'px"><img class="image-photo" src="' + imgUrl + '" alt="' + hotelName +'"></div>';
            itemTag += '<div class="description">' + hotelName + '</div>';
            itemTag += '</a></li>';
        }

        itemTag += '</ul>';
        return itemTag;
    }

    function _feedTravelHistory() {
        console.log(' === travelHistory: start ===');
        var url = 'http://ashiato.travel.rakuten.co.jp/ashiato/domesticHotelBrowse/take';
        var promise = $.ajax({
            url: url,
            dataType: 'jsonp',
            scriptCharset:'UTF-8',
            timeout: 5000,
        }).then(function(data) {
            var historyData = data.body.contents;
            var p;
            if ( historyData.length > 0 ) {
                itemTag = layoutData(historyData);
                p = adjustImages('square', '#travelHistory',
                                    itemTag,
                                    '.pickupReview > li .image-photo');
            }
            else {
                p = new $.Deferred().reject('failed').promise();
            }
            return p;
        }, function(){//fail(second argument)
            new $.Deferred().reject().promise();
        }).then(function() {
            // refresh iScroll
            pageScrolls[2].refresh();

            // return promise;
            console.log(' === travelHistory: end ===');
            return new $.Deferred().resolve().promise();
        }, function(error) {
             $('#travel__history-more').hide();
             if (error === 'failed') {
                if(loginStatus ==='login') {
                    $('#travelHistory .noData').show();
                } else {
                    $('#travelHistory .noItems').show();
                }
             }
             else {
                showErrorMsg('#travelHistory');
                OnButtonReload('#travelHistory', _feedTravelHistory);
             }
            // refresh iScroll
            pageScrolls[2].refresh();

            // return promise;
            console.log(' === ichibaHistory: error ===');
            return new $.Deferred().resolve().promise();
        });
        return promise;
    }

})(jQuery);

var feedTravelCampaign = null;

(function($){

    feedTravelCampaign = getCampaginAjaxResponse;

    function layoutData(campaignList) {
        var campaignListTag = '',
            travelCampaignCataID = 'scid=wi_gwa_bmk4_travel_campaign_hotel',
            campaignTag = '<ul class="travelCampaignAd">';
            len = Math.min(6, campaignList.length);

        for (var i = 0; i < len; i++) {
            var list = campaignList[i],
            listUrl = '<li>';

            listUrl += '<a href="'+ escapeHTML(appendParamToURL(list['url'], travelCampaignCataID)) +'">';
            listUrl += '<img class="tcampaignBanner" src="' + list['img'] + '" alt=" '+ list['title'] +'">';
            listUrl += '</a></li>';
            campaignListTag += listUrl;
        }
        campaignTag += campaignListTag;
        campaignTag += '</ul>';
        return campaignTag;
    }

    function getCampaginAjaxResponse(rseData) {
        console.log(' === travelCampaign: start ===');
        var dataFetchPromise = null;

        if ( rseData ) {
            dataFetchPromise = new $.Deferred().resolve(rseData).promise();
        }
        else {
            var d = (new Date()).getTime(),
                url = 'http://img.travel.rakuten.co.jp/smart/campaign/campaign.unitA.json?' + d;

            dataFetchPromise = $.ajax({
                url: url,
                dataType: 'json',
                scriptCharset:'UTF-8',
            });
        }

        var promise = dataFetchPromise.then(function(data) {
            var campaignTag = layoutData(data.campaign);
            return adjustImages('banner', '#travelCampaign',
                                campaignTag,
                                '.travelCampaignAd > li a .tcampaignBanner');
        }).then(function() {
            // refresh iScroll
            pageScrolls[2].refresh();
            console.log(' === travelCampaign: end ===');
        }, function(XMLHttpRequest, textStatus, errorThrown){
            showErrorMsg('#travelCampaign');
            OnButtonReload('#travelCampaign', getCampaginAjaxResponse);

            console.log(' === travelCampaign: error ===');
        });
        return promise;
    }

})(jQuery);
var createHotelRanking;
var travelRankingImgWidth;
var feedTravelRanking = null;

(function($){

  // export loadTravelRanking
  feedTravelRanking = loadTravelRanking;

  $(function () {
      $('#hotelCategory').on('change', function(){
          var genreId = $('#hotelCategory').val();
          loadTravelRanking(genreId);
      });
  });

  function _createHotelRanking(d) {
      return new $.Deferred().resolve(d).promise();
  }
  // export for callback
  createHotelRanking = _createHotelRanking;

  function layoutHotelRanking(hotelRanking) {
      var hotelRankingTag = '',
          rankingCata = 'scid=wi_gwa_bmk4_travel_ranking_hotel',
          wrapperSize = _imgWrapperSize(),
          len = Math.min(10, hotelRanking.length),
          i = 0,
          hotelInfo,
          url;

      hotelRankingTag += '<ul class="pickupReview">';

      for(i; i < len; i++) {
              hotelInfo = hotelRanking[i];
              url = hotelInfo.planListUrl;
              url = appendParamToURL(url, rankingCata);

              hotelRankingTag += '<li>';
              hotelRankingTag += '<span class="r-order">' + hotelInfo.rank + '</span>';
              hotelRankingTag += '<a href="'+ url +'" style="width:'+ wrapperSize +'px">';
              hotelRankingTag += '<div class="image-wrapper loading" style="width:'+ wrapperSize +'px; height:'+wrapperSize+'px">';
              hotelRankingTag += '<img class="image-photo" src="' + hotelInfo.hotelImageUrl + '" alt=" '+ hotelInfo.hotelName + '">';
              hotelRankingTag += '</div>';
              hotelRankingTag += '<div class="description">' + hotelInfo.hotelName + '【' + hotelInfo.middleClassName + '】' + '</div>';
              hotelRankingTag += '</a>';
              hotelRankingTag += '</li>';
      }
      hotelRankingTag += '</ul>';
      return hotelRankingTag;
  }

  function loadTravelRanking(genreId, rseData){
    console.log(' === travel ranking start ===');
    var dataFetchPromise = null;

    if ( rseData && !rseData.Body ) {
        dataFetchPromise = new $.Deferred().resolve(rseData).promise();
    }
    else {
      var Id = '1012528979789887227',
          genre = genreId,
          formatVer = '2',
          requestUrl = 'https://app.rakuten.co.jp/services/api/Travel/HotelRanking/20131024?',
          elements = 'genre,title,rank,hotelName,middleClassName,userReview,reviewCount,planListUrl,hotelImageUrl,hotelThumbnailUrl',
          param = [];

      param.push('genre='+ genre);
      param.push('formatVersion='+ formatVer);
      param.push('applicationId='+ Id);
      param.push('elements='+ elements);

      var url = requestUrl + param.join('&');

      dataFetchPromise = $.ajax({
          url: url,
          dataType: 'json',
          timeout: 5000,
      });
    }

    var promise = dataFetchPromise.then(function(data) {
        var elem = data.Rankings[0].hotels;
        if ( data != null  && elem.length > 0 ) {
            var hotelRankingTag = layoutHotelRanking(elem);
            $('#hotelRanking').html('');
            return adjustImages('square', '#hotelRanking', hotelRankingTag,
                                '.pickupReview > li .image-photo');
        }
        else {
            return new $.Deferred().reject().promise();
        }
    },function(){//fail(second argument)
            new $.Deferred().reject().promise();
    }).then(function() {
          // refresh iScroll
          pageScrolls[2].refresh();
          console.log(' === travel ranking end ===');
          return new $.Deferred().resolve().promise();
    }, function(error) {
          $('#hotelCategory').hide();
          showErrorMsg('#hotelRanking');
          OnButtonReload('#hotelRanking', loadTravelRanking);
          // refresh iScroll
          pageScrolls[1].refresh();

          // return promise;
          console.log(' === hotelRanking: error ===');
          return new $.Deferred().resolve().promise();
    });
    return promise;
  }
})(jQuery);

var tabTravel = function() {
    console.log('### travelTab: start ###');
    var feeds = [feedTravelHistory()];
    return $.when.apply(this, feeds).then(function(result) {
        console.log('### travelTab: end ###');
        return new $.Deferred().resolve(result).promise();
    });
};

var feedHotRecipeKeyword = null;

(function($){
    // variables
    var numOfEntries = 5;
    var xmlUrl = "http://static.recipe.rakuten.co.jp/contents/rss/hotkeyword.xml";

    feedHotRecipeKeyword = _feedHotRecipeKeyword;

    function layoutData(feed) {
        var cataID = 'scid=wi_gwa_bmk4_recipe_seasonal_recipe',
            splitChar = '：';
        var len = Math.min(numOfEntries, feed.length);
        var html = '';
        for (var i = 0; i < len; i++) {
            var entry = feed[i];
            var title = entry.title[0];
            var link = entry.link[0];
            title = title.split(splitChar);
            html += '<a class="kw" href="' + escapeHTML(appendParamToURL(link, cataID)) + '">';
            html += '<span>' + title[1] + '</span>';
            html += '</a>';
        }
        return html;
    }

    function _feedHotRecipeKeyword(rseData){
       console.log(' === hotRecipeKeyword: start ===');
       var dataFetchPromise = null;

        if ( rseData ) {
            dataFetchPromise = new $.Deferred().resolve(rseData).promise();
        }
        else {
            dataFetchPromise = loadFeed(
                google,
                xmlUrl,
                numOfEntries
            )
        }

        var promise = dataFetchPromise.then(function(feed) {
            var elem = feed.rss.channel[0].item;

            if(feed != null && elem.length > 0){

                html = layoutData(elem);
                    $('#recipeKeywords').append(html);
                    // page refresh for iScroll
                    pageScrolls[3].refresh();
                    console.log(' === hotRecipeKeyword: end ===');
                    return new $.Deferred().resolve().promise();
            }
            else {
                showErrorMsg('#recipeKeywords');
                OnButtonReload('#recipeKeywords', _feedHotRecipeKeyword);
                console.log(' === hotRecipeKeyword: error ===');
                return new $.Deferred().resolve().promise();
            }
        });
        return promise;
    }

})(jQuery);

var feedRecipePickup = null;

(function($){
    var xmlUrl = "http://static.recipe.rakuten.co.jp/contents/rss/pickup.xml";
    var setNum = 6;

    feedRecipePickup = _initializerecipePickup;

    function layoutData(feed) {
        var recipeTag= '',
        rpLink,
        rpName,
        rpImgUrl,
        rpTag = '<ul class="pickupReview">',
        listTag,
        popupUrl,
        wrapperSize = _imgWrapperSize(),
        cataID = 'scid=wi_gwa_bmk4_recipe_pickup',
        len = Math.min(setNum, feed.length);

        for (var i = 0; i < len; i++) {
            var $item = feed[i];
            if ($item.link[0] === undefined) {
                continue;
            }
            popupUrl = '#';
            rpLink =  $item.link[0];
            rpName = $item.title[0];
            rpImgUrl = $item.image;
            popupUrl += '?' + encodeURIComponent(rpName);
            popupUrl += ',' + encodeURIComponent(rpImgUrl);
            popupUrl += ',' + encodeURIComponent(rpLink);
            listTag = '<li>';
            listTag += '<a href="#" class="clickbutton" style="width:'+wrapperSize+'px"';
            listTag += 'data-image="'+escapeHTML(rpImgUrl)+'" ';
            listTag += 'data-link="'+escapeHTML(appendParamToURL(rpLink, 'vt=sp&'+cataID))+'" ';
            listTag += 'data-pclink="'+escapeHTML(appendParamToURL(rpLink, 'vt=pc&'+cataID))+'" ';
            listTag += 'data-caption="'+escapeHTML(rpName)+'" ';
            listTag += 'data-title="'+escapeHTML(rpName)+'" ';
            listTag += ' >';
            listTag += '<div class="image-wrapper loading" style="width:'+wrapperSize+'px; height:'+wrapperSize+'px"><img class="image-photo" src="' + rpImgUrl + '" alt=" '+ rpName +'"></div>';
            listTag += '<div class="description">' + rpName + '</div>';
            listTag += '</a></li>';
            recipeTag += listTag;
        }
        rpTag += recipeTag;
        rpTag += '</ul>';
        return rpTag;
    }

    function _initializerecipePickup(rseData){
        console.log(' === recipePickup: start ===');
        var dataFetchPromise = null;

        if ( rseData ) {
            dataFetchPromise = new $.Deferred().resolve(rseData).promise();
        }
        else {
            dataFetchPromise = loadFeed(
                google,
                xmlUrl,
                setNum
            )
        }
        var promise = dataFetchPromise.then(function(feed) {
            var elem = feed.rss.channel[0].item;

            if((feed != null) && (elem.length > 0)){
                $('#recipePickup').empty();
                htmlCode = layoutData(elem);
                var p = adjustImages('square', '#recipePickup', htmlCode).then(function() {
                        // refresh for iscroll
                        pageScrolls[3].refresh();
                        // set popup
                        setPopup('#recipePickup');

                        console.log(' === recipePickup: end ===');
                        return new $.Deferred().resolve().promise();
                        return p;
                    })
            }
            else {
                showErrorMsg('#recipePickup');
                OnButtonReload('#recipePickup', _initializerecipePickup);
                console.log('recipepickup network error');
                return new $.Deferred().resolve().promise();
            }
        });
        return promise;
    }
})(jQuery);

var feedRecipeRanking = null;

(function($){

    feedRecipeRanking = getRecipeRankingAjaxResponse;

    function layoutData(itemList) {
        var len = Math.min(10, itemList.length);
            wrapperSize = _imgWrapperSize(),
            cataID = 'scid=wi_gwa_bmk4_recipe_ranking',
            itemTag = '<ul class="pickupReview ranking">';

        for (var i = 0; i < len; ++i) {
            var item = itemList[i],
                ImageUrl = item['food_image_path'],
                url='http://recipe.rakuten.co.jp/recipe/' + item['recipe_id'] + '/';

            itemTag += '<li>';
            itemTag += '<span class="r-order">'+ (i + 1) +'</span>';
            itemTag += '<a href="'+ escapeHTML(appendParamToURL(url, cataID)) + '" style="width:'+wrapperSize+'px">';
            itemTag += '<div class="image-wrapper" style="width:'+wrapperSize+'px; height:'+wrapperSize+'px">';
            itemTag += '<img class="image-photo loading" src="'+ ImageUrl +'" alt=" '+ item['recipe_description'] +'">';
            itemTag += '</div>';
            itemTag += '<div class="description">'+ item['recipe_description'] +'</div>';
            itemTag += '</a></li>';
        }
        itemTag += '</ul>';
        return itemTag;
    }

    function getRecipeRankingAjaxResponse(rseData) {
        console.log(' === recipeRanking: start ===');

        var dataFetchPromise = null;

        if ( rseData ) {
            dataFetchPromise = new $.Deferred().resolve(rseData).promise();
        }
        else {
            var url = 'http://api.recipe.rakuten.co.jp/ext/search/recipe/?developerId=fe4ade9e3b11616d1373318cd58dce345491c0f0&sort=4';
            dataFetchPromise = $.ajax({
                url: url,
                dataType: 'jsonp',
                scriptCharset:'UTF-8',
                timeout: 5000,
            });
        }

        var promise = dataFetchPromise.then(function(data) { // on success
            var itemTag = layoutData(data.result);
            return adjustImages('square', '#recipeRanking', itemTag);
        }, function() { // on error
            $('#recipe__ranking-more').hide();
            showErrorMsg('#recipeRanking');
            OnButtonReload('#recipeRanking', getRecipeRankingAjaxResponse);
            console.log(' === recipeRanking: error ===');
            return new $.Deferred().resolve().promise();
        }).then(function() {
            pageScrolls[3].refresh();
            console.log(' === recipeRanking: end ===');
            return new $.Deferred().resolve().promise();
        });
        return promise;
    }
})(jQuery);

var tabRecipe = function() {
    console.log('### recipeTab: start ###');
    var feeds = [feedHotRecipeKeyword(), feedRecipePickup(), feedRecipeRanking()];
     return $.when.apply(this, feeds).then(function() {
         console.log('### recipeTab: end ###');
    });
};

var feedFBIchiba = null;

(function($){

    feedFBIchiba = getIchibaFBAjaxResponse;

    function layoutData(feed) {
        //img s to q
        var len = feed.length,
        feedTag = '',
        list,
        i = 0,
        j = 0,
        count = 50,
        wrapper = _imgWrapperSize2(),
        message,
        shortUrl,
        msgText,
        picture,
        feedListTag = '<ul class="fanReview">',
        catalystId1 = 'scid=wi_gwa_bmk4_article_ichiba_facebook',
        catalystId2 = '_wi_gwa_bmk4_article_ichiba_facebook';

        len = Math.min(4, len);

        for (i; i < len; i++) {
            if (feed[i].picture &&
                feed[i].link &&
                feed[i].message &&
                feed[i].from.name.indexOf("Rakuten")!=-1){

                picture = feed[i].picture;
                message = feed[i].message;
                shortUrl = _extractUrl(message);
                msgText = _limitCharLength(count, message);
                picture = picture.replace(/_s.jpg/,'_n.jpg');

                j = j+1;
                list = '<li>';
                list += '<a href="#" class="clickbutton pLink" ';
                list += 'data-image="'+escapeHTML(picture)+'" ';
                list += 'data-fblink="'+escapeHTML(feed[i].link)+'"';
                list += 'data-shortlink="'+escapeHTML(shortUrl)+'" ';
                list += 'data-cataid1="'+escapeHTML(catalystId1)+'" ';
                list += 'data-cataid2="'+escapeHTML(catalystId2)+'" ';
                list += 'data-caption="'+escapeHTML(message)+'" ';
                list += '>';
                list += '<div class="image-wrapper loading" style="width:'+wrapper+'px; height:'+wrapper+'px">';
                list += '<img src="'+ picture +'" class="articleImg">';
                list += '</div>';
                list += '<div class="description">'+msgText+'</div>';
                list += '</a>';
                list += '</li>';
                feedListTag += list;
                if (j >= 4) break;
            }
        }
        feedTag += feedListTag;
        feedTag += '</ul>';
        return feedTag;
    }

    function layoutDataforhomeFBIchiba(feed) {
        //img s to q
        var len = feed.length,
            feedTag = '',
            list,
            i = 0,
            j = 0,
            count = 20,
            wrapper = _imgWrapperSize(),
            message,
            shortUrl,
            msgText,
            picture,
            feedListTag = '<ul class="pickupReview">',
            catalystId1 = 'scid=wi_gwa_bmk4_home_ichiba_facebook',
            catalystId2 = '_wi_gwa_bmk4_home_ichiba_facebook';

        len = Math.min(4, len);

        for (i; i < len; i++) {
            if (feed[i].picture &&
                feed[i].link &&
                feed[i].message &&
                feed[i].from.name.indexOf("Rakuten")!=-1){

                picture = feed[i].picture;
                message = feed[i].message;
                shortUrl = _extractUrl(message);
                msgText = _limitCharLength(count, message);
                picture = picture.replace(/_s.jpg/,'_n.jpg');

                j = j+1;
                list = '<li>';
                list += '<a href="#" class="clickbutton" style="width:'+wrapper+'px"';
                list += 'data-image="'+escapeHTML(picture)+'" ';
                list += 'data-fblink="'+escapeHTML(feed[i].link)+'"';
                list += 'data-shortlink="'+escapeHTML(shortUrl)+'" ';
                list += 'data-cataid1="'+escapeHTML(catalystId1)+'" ';
                list += 'data-cataid2="'+escapeHTML(catalystId2)+'" ';
                list += 'data-caption="'+escapeHTML(message)+'" ';
                list += '>';
                list += '<div class="image-wrapper loading" style="width:'+wrapper+'px; height:'+wrapper+'px">';
                list += '<img class="image-photo" src="'+ picture +'">';
                list += '</div>';
                list += '<div class="description">'+msgText+'</div>';
                list += '</a></li>';
                feedListTag += list;
                if (j >= 2) break;
            }
        }
        feedTag += feedListTag;
        feedTag += '</ul>';
        return feedTag;
    }

    function getIchibaFBAjaxResponse(rseData) {
        console.log(' === fbIchiba: start ===');
        var dataFetchPromise = null;

        if ( rseData ) {
            dataFetchPromise = new $.Deferred().resolve(rseData).promise();
        }
        else {
            var d = (new Date()).getTime();
            var url = 'https://graph.facebook.com/RakutenIchiba/feed?access_token=1432699403609176|mtisdyP9_B_f-l7TY5I-6P2zZUo&limit=25?' + d;
            dataFetchPromise = $.ajax({
                url: url,
                dataType: 'jsonp',
                scriptCharset:'UTF-8',
                timeout: 5000,
            });
        }
        var promise = dataFetchPromise.then(function(data) {// on success
            var p,
                q,
                feedTag = layoutData(data.data),
                feedTag2 = layoutDataforhomeFBIchiba(data.data),
                ratio = 4;

              setPopup('#ichibaArticles');
              setPopup('#homeFBIchiba');
              p = adjustImages('square', '#ichibaArticles', feedTag,
                                  '.fanReview > li .articleImg', ratio);
              q = adjustImages('square', '#homeFBIchiba',
                                feedTag2,
                                '.pickupReview > li .image-photo');
              $('#ttl-homeFBIchiba').show();
              return $.when(p,q);
        }, function(){
            // on error
            $('#ichiba__fb--more').hide();
            showErrorMsg('#ichibaArticles');
            OnButtonReload('#ichibaArticles', getIchibaFBAjaxResponse);
            showErrorMsg('#block-homeFBIchiba');
            OnButtonReload('#block-homeFBIchiba', getIchibaFBAjaxResponse);
            console.log(' === fbIchiba: error ===');
            return $.Deferred().resolve().promise();
        }).then(function() {
            pageScrolls[4].refresh();
            console.log(' === fbIchiba: end ===');
            return $.Deferred().resolve().promise();
        });
        return promise;
    }

})(jQuery);

var feedFBTravel = null;

(function($){

    feedFBTravel = getTravelFBAjaxResponse;

    function layoutData(feed) {
        //img s to q
        var len = feed.length,
            feedTag = '',
            count = 50,
            wrapper = _imgWrapperSize2(),
            shortUrl,
            message,
            picture,
            msgText,
            feedListTag = '<ul class="fanReview">',
            catalystId1 = 'scid=wi_gwa_bmk4_article_travel_facebook',
            catalystId2 = '_wi_gwa_bmk4_article_travel_facebook';

        for (var i = 0, j = 0; j < 4 && i < len; i++) {
            if (feed[i].picture &&
                feed[i].link &&
                feed[i].message &&
                feed[i].from.name.indexOf("Rakuten")!=-1){

                message = feed[i].message;
                msgText = _limitCharLength(count, message);
                shortUrl = _extractUrl(message);
                picture = feed[i].picture;
                picture = picture.replace(/_s.jpg/,'_n.jpg');

                list = '<li>';
                list += '<a href="#" class="clickbutton pLink" ';
                list += 'data-image="'+escapeHTML(picture)+'" ';
                list += 'data-fblink="'+escapeHTML(feed[i].link)+'" ';
                list += 'data-shortlink="'+escapeHTML(shortUrl)+'" ';
                list += 'data-cataid1="'+escapeHTML(catalystId1)+'" ';
                list += 'data-cataid2="'+escapeHTML(catalystId2)+'" ';
                list += 'data-caption="'+escapeHTML(message)+'" ';
                list += 'data-title="'+escapeHTML(message)+'" ';
                list += '>';
                list += '<div class="image-wrapper loading" style="width:'+wrapper+'px; height:'+wrapper+'px">';
                list += '<img src="'+ picture +'" class="articleImg">';
                list += '</div>';
                list += '<div class="description">'+msgText+'</div>';
                list += '</a>';
                list += '</li>';
                feedListTag += list;
                j++;
            }
        }

        feedTag += feedListTag;
        feedTag += '</ul>';
        return feedTag;
    }

    function getTravelFBAjaxResponse(rseData) {
        console.log(' === fbTravel: start ===');
        var dataFetchPromise = null;

        if ( rseData ) {
            dataFetchPromise = new $.Deferred().resolve(rseData).promise();
        }
        else {
            var d = (new Date()).getTime();
            var url = 'https://graph.facebook.com/RakutenTravel/feed?access_token=1432699403609176|mtisdyP9_B_f-l7TY5I-6P2zZUo&limit=25?' + d;
            dataFetchPromise = $.ajax({
                url: url,
                dataType: 'jsonp',
                scriptCharset:'UTF-8',
                timeout: 5000,
            });
        }

        var promise = dataFetchPromise.then(function(data) {
            var feedTag = layoutData(data.data);
            setPopup('#travelArticles');
            var ratio = 4;
            return adjustImages('square', '#travelArticles', feedTag,
                                '.fanReview > li .articleImg', ratio);
        }, function() {
            $('#travel__fb--more').hide();
            showErrorMsg('#travelArticles');
            OnButtonReload('#travelArticles', getTravelFBAjaxResponse);
            console.log(' === travelArticles: error ===');
            return $.Deferred().resolve().promise();
        }).then(function() {
            pageScrolls[4].refresh();
            console.log(' === fbTravel: end ===');
            return $.Deferred().resolve().promise();
        });
        return promise;
    }

})(jQuery);

var tabArticle = function() {
    console.log('### articleTab: start ###');
    var feeds = [feedFBIchiba(),feedFBTravel()];
    return $.when.apply(this, feeds).then(function() {
        console.log('### articleTab: end ###');
        return $.Deferred().resolve().promise();
    });
};

/**
 * @author Tsutomu Ogasawara at CWD, Rakuten, inc.
 * @mail tsutomu.ogasawara@mail.rakuten.com
 */
(function($) {
    /**
     * @method swipeTab
     * create swipable tab menu for smartphone
     * @member jQuery
     */
    $.fn.swipeTab = function() {
        // parameters
        var args = Array.prototype.slice.call(arguments),
            defaults = {
                'offset': 20,
                'onChangedTab': null
            };

        return $(this).each(function() {
            var element = this,
                $element = $(element),
                $list = $(element).find('ul'),
                $items = $list.children(),
                isSwipe = false,
                isScrolling = false,
                isTouched = false;

            var iscrollObject;

            // start
            _init(args[0]);

            function _onResize(e) {
                _refresh();
                window.scroll(0, 0);
            }

            function _onPageChange(e, page) {
                //console.log('onpagechange');
                _scrollToPage(page);
            }

            function _scrollStartHandler() {
                //console.log('_scrollStartHandler');
                isScrolling = false;
                isSwipe = false;
            }

            function _scrollMoveHandler() {
                //console.log('_scrollMoveHandler');
                isScrolling = true;
                isSwipe = true;
            }

            function _scrollEndHandler() {
                //console.log('_scrollEndHandler');
                if ( ! isScrolling ) {
                    return;
                }
                isScrolling = false;

                // call changed tab callback
                var index = this.currPageX;
                if ( defaults.onChangedTab ) {
                    defaults.onChangedTab(null, index);
                }

                // color change
                _setFocusClassAtIndex(index);
            }

            /**
             * touch end event handler
             */ 
            function _touchEndHandler(e) {
                //console.log('_touchEndHandler: '+e.type);
                if ( e.type == 'mouseout' ) {
                    // event canceling
                    e.preventDefault();
                    e.stopPropagation();
                    return ;
                }

                // check if swiping
                if ( isSwipe ) {
                    isSwipe = false;
                    e.preventDefault();
                    e.stopPropagation();
                    return ;
                }
                // get clicked item index
                var index = $items.index(e.target.parentElement);
                // call changed tab callback
                if ( defaults.onChangedTab ) {
                    defaults.onChangedTab(e, index);
                }
                // scroll
                if ( index >= 0 ) {
                    _scrollToPage(index, 0);
                }
                // event canceling
                e.preventDefault();
                e.stopPropagation();
            }

            /**
             * show page with hash (ex. "#page1")
             */
            function _showPageWithHash(hash) {
                if ( hash && hash.length > 0 && location.hash != hash ) {
                    location.hash = hash;
                }
            }

            /**
             *
             */
            function _getIndexWithHash(hash) {
                var index = $list.find('a').index($list.find('[href="'+hash+'"]'));
                return index;
            }

            /**
             *
             */
            function _getHashAtIndex(index) {
                var result = '';
                var item = $items[index];
                if ( item ) {
                    result = $(item).find('a').attr('href');
                }
                return result;
            }
            
            // orientation change event
            if ( navigator.userAgent.indexOf('Android 4.') >= 0 ) {
                $(window).on('resize', _onResize);
            }
            else {
                $(window).on('orientationchange', _onResize);
            }

            // refresh when the window focused (workaround for Firefox OS)
            $(window).focus(function() {
                _refresh();
            });

            // page change event
            $element.on('pageChanged', _onPageChange);

            function _init(options) {
                // set options
                defaults = $.extend(defaults, options);

                if ( defaults.iscroll ) {
                    // iscroll
                    var iscrollDefaults = { hScrollbar: false,
                                            vScrollbar: false,
                                            hScroll: true,
                                            vScroll: false,
                                            bounce: false,
                                            snap: 'li',
                                            momentum: false,
                                            // 
			                                onTouchEnd: _touchEndHandler,
			                                onScrollEnd: _scrollEndHandler,
                                            onScrollStart: _scrollStartHandler,
                                            onScrollMove: _scrollMoveHandler,
                                          };
                    var iscrollOptions = $.extend(iscrollDefaults, defaults.iscroll);
                    var widths = _beforeRefresh(defaults.offset);
                    if ( iscrollObject ) {
                        iscrollObject.destroy();
                        iscrollObject = null;
                    }
                    iscrollObject = new iScroll(element.id, iscrollOptions);
                    _afterRefresh(widths);
                }
            }

            function _beforeRefresh(offset) {
                var sumOfItemWidth = 0;
                var widthOfItems = [];
                $items.each(function(){
                    var width = $(this).width();
                    widthOfItems.push(width);
                    sumOfItemWidth += width;
                });
                var visibleWidth = $element.width();
                var firstItemWidth = $items.first().width();
                var firstSpaceWidth = Math.ceil((visibleWidth - firstItemWidth) / 2.0);
                var lastItemWidth = $items.last().width();
                var lastSpaceWidth = Math.ceil((visibleWidth - lastItemWidth) / 2.0);
                var listWidth = sumOfItemWidth + firstSpaceWidth + lastSpaceWidth;
                $list.width(listWidth+offset);
                $items.first().css('padding-left', 0);
                $items.last().css('padding-right', 0);
                return {first: firstSpaceWidth, last: lastSpaceWidth};
            }
            function _afterRefresh(widths) {
                $items.first().css('padding-left', widths.first+'px');
                $items.last().css('padding-right', widths.last+'px');
            }
            function _refresh() {
                var currentIndex = iscrollObject.currPageX;
                _init();
                _scrollToPage(currentIndex, 0, 0);
            }
            function _scrollToPage(pageX, pageY, time) {
                iscrollObject.scrollToPage(pageX, pageY, time);
                setTimeout(function(){
                    _setFocusClassAtIndex(pageX);
                }, 200);
            }
            function _setFocusClassAtIndex(index) {
                _setFocusClassByPageName('page'+(index+1));
            }
            function _setFocusClassByPageName(page) {
                page = (page.charAt(0)=='#') ? page.substr(1) : page;
                $('.cnt-selected')
                    .removeClass('page1 page2 page3 page4 page5')
                    .addClass(page);
            }
        });
    };
}.call(window, jQuery));

var mainScroll,
    pageScrolls = [];
var tapThreshold = 5;
var networkTimeout = 5000;

//set useragent url switching
function _setUrlSwitching(geturl) {
    var ua = navigator.userAgent,
        isAndroid = ua.indexOf("Android") > 0,
        isiPhone =  ua.indexOf("iPhone") > 0,
        isiPad =  ua.indexOf("iPad") > 0,
        mangaElement = $('#manga'),
        mangaUrl = mangaElement.find('a'),
        ichibaAppUrl = $('#ichibaAppLink'),
        travelAppUrl = $('#travelAppLink'),
        recipeAppUrl = $('#recipeAppLink'),
        denwaAppUrl = $('#denwa');
    //rakuten install
    if(!isAndroid){
        $('#rakutenInstall').hide();
    }

    //home manga icon link, footer app link
    if (isiPhone||isiPad){
        mangaUrl.attr('href','https://itunes.apple.com/jp/app/manganyusu-c.i.a-qing-bao/id614157582?mt=8');
        ichibaAppUrl.attr('href','https://itunes.apple.com/jp/app/le-tian-shi-chang/id419267350?mt=8');
        travelAppUrl.attr('href','https://itunes.apple.com/jp/app/id300815151?mt=8');
        recipeAppUrl.attr('href','https://itunes.apple.com/jp/app/le-tianreshipi/id445304598?mt=8');
    }else if (isAndroid) {
        mangaUrl.attr('href','https://play.google.com/store/apps/details?id=jp.co.rakuten.cia');
        ichibaAppUrl.attr('href','https://market.android.com/details?id=jp.co.rakuten.android');
        travelAppUrl.attr('href','https://play.google.com/store/apps/details?id=jp.co.rakuten.travel.andro&hl=ja');
        recipeAppUrl.attr('href','https://play.google.com/store/apps/details?id=jp.co.rakuten.recipe&scid=and_001_bn');
        denwaAppUrl.attr('href', 'https://play.google.com/store/apps/details?id=jp.co.rakuten.denwa');
        if( ua.search(/Android 2/) != -1 ) {
            $('.header-search').css('display', 'none');
            $('.pulldownmenu').css('display', 'none');
        }
    }else {
        mangaElement.hide();
    }
}

function escapeHTML(html) {
    return $('<div>').text(html).html() || '';
}

function appendParamToURL(url, param) {
    var delimiter = (url.indexOf('?') >= 0) ? '&' : '?';
    return url + delimiter + param;
}

/**
 * popup
 */
// popup function
function showPopup(params, element) {
    $('#modal').reveal({
        animation: 'fade',
        animationspeed: 600,
        closeonbackgroundclick: true,
        dismissmodalclass: 'close-reveal-modal'
    });



    var $image = $('#popupImage'),
        $smart = $('.popupLink'),
        $pc = $('.popupLinkPC'),
        $more = $('.popupMore'),
        $title = $('#popupCaption'),
        $updates = $('#information'),
        $detail = $('.detail'),
        $footerNav = $('.popup-fnav'),
        $price = $('#popupPrice'),
        $star = $('#popupStar'),
        $fb = $('.fbLink'),
        $fbWeb = $('.fbLinkweb'),

        pImage = params.image,
        pTitle = params.title,
        pSmart = params.link,
        pPcLink = params.pclink,
        pPrice = params.price,
        pScore = params.score,
        pFblink = params.fblink,
        pFbshort = params.shortlink,
        pCata1 = params.cataid1,
        pCata2 = params.cataid2,
        //ABTesting for home
        pCata3 = params.cataid3,
        pCaption = _limitCharLength(100, params.caption),
        updateMessage = params.message;

    $image
        .attr('src', pImage)
        .attr('alt', pTitle);

    //ABTesting in TopContent - Added new parameters
    if (element === '#homeIchibaRanking') {
        pSmart = params.link2;
        pPcLink = params.pclink2;
    }

    $smart.attr('href', pSmart);
    $pc.attr('href', pPcLink);
    $more.attr('href', pSmart);

    $title.html(pCaption);

    $image.css('display', 'inline');
    $smart.hide();
    $pc.hide();
    $more.hide();
    $detail.hide();
    $fbWeb.hide();
    $fb.hide();
    $updates.hide();

    if ( pSmart && pSmart.length > 0 &&
         pPcLink && pPcLink.length > 0 ) {
        $smart.css('display', 'table-cell');
        $title.css('display', 'block');
        $pc.css('display', 'table-cell');
    }
    else if (pSmart && pSmart.length > 0) {
        $more.css('display', 'block');
        $title.css('display', 'block');
        $fb.attr('href', pFblink);
    }
    else if (updateMessage && updateMessage.length >0) {
        $image.css('display', 'none');
        $title.css('display', 'none');
        $updates.css('display', 'block');
        $updates.html(updateMessage);
    }
    else if (pFblink && pFblink.length > 0) {
        $fb.css('display', 'table-cell');
        $title.css('display', 'block');
        $fb.attr('href', pFblink);

        if (pFbshort && pFbshort.length > 0) {
            $fbWeb.css('display', 'table-cell');
            $fbWeb.attr('href', pFbshort);

            $.ajax({
                url: 'https://api-ssl.bitly.com/v3/expand?access_token=3c791d5cadd575f9210d1cef89ebc77fda03b025&shortUrl='+pFbshort+'',
                dataType: 'jsonp',
                method: 'get',
                success: function(response) {
                    var longUrl = response.data.expand[0].long_url;

                    if (longUrl !== undefined) {
                        if (longUrl.indexOf('scid=') !== -1) {
                            longUrl += escapeHTML(pCata2);
                        }
                        else {
                            longUrl = escapeHTML(appendParamToURL(longUrl, pCata1));
                        }
                        $fbWeb.attr('href', longUrl);
                        //$fb.css('display', 'table-cell');
                    }
                },
                error: function(XMLHttpRequest, textStatus, errorThrown){
                    console.log(pFbshort,'error',XMLHttpRequest, textStatus, errorThrown);
                }
            });
        }
    }
    else {
        $footerNav.css('display', 'none');
    }

    //Display price
    if ( pPrice || pScore ) {
        var locationPath = location.href;
        var imagePath;

        if (locationPath.indexOf('www.rakuten.co.jp/com/gateway/sp')>=0){
            imagePath = '/com/gateway/sp/images/';
        }
        else {
            imagePath = '/images/';
        }
        $price.html(pPrice);
        $star.raty({
                    readOnly: true,
                    path: imagePath,
                    score: pScore,
                });
        $detail.css('display', 'table');
    }
    else {
        $detail.css('display', 'none');
    }
}

function setPopup(element) {

    //set event handler
    $(element)
        .on('touchstart', '.clickbutton', function(e) {
            $(this).data('touchScreenX',
                         e.originalEvent.changedTouches[0].screenX);
            $(this).data('touchScreenY',
                         e.originalEvent.changedTouches[0].screenY);
        })

        .on('touchend', '.clickbutton', function(e) {
            var diffX = Math.abs(e.originalEvent.changedTouches[0].screenX - $(this).data('touchScreenX'));
            var diffY = Math.abs(e.originalEvent.changedTouches[0].screenY - $(this).data('touchScreenY'));
            var isSwiping = ( diffX > tapThreshold || diffY > tapThreshold );
            if ( isSwiping ) {
                return ;
            }
            else {
                var data = $(this).data();
                // show
                showPopup(data, element);
                // event handling
                e.preventDefault();
                e.stopPropagation();
            }
        });
}

function _limitCharLength(num, words) {
        var count = num,
            msgText = words||'',
            msgLength = msgText.length;

        if (msgLength > count) {
            msgText = msgText.substr(0,count);
            msgText += ' ...';
        }
        return msgText;
}

function _extractUrl(string) {
    var urlRegex = /(https?:\/\/)?([\da-z\.-]+)\.([a-z\.]{2,6})([\/\w\.-=?]*)*\/?/,
        shortUrl = string.match(urlRegex);

    if (shortUrl) {
        shortUrl = shortUrl[0];
        return shortUrl;
    }
    else {
        return null;
    }
}

//set imageWrapperSize
function _imgWrapperSize() {
    var bodyWidth = $('body').width();
    var size =  Math.round((bodyWidth-bodyWidth*0.1)/2);
    return size;
}

//set imageWrapperSize2
function _imgWrapperSize2() {
    var bodyWidth = $('body').width();
    var size =  Math.round((bodyWidth-bodyWidth*0.1)/4);
    return size;
}


/**
 * - You should specify type = 'square' && ratio = 2
 *   if you want to call instead of _imgWidth().
 * - You should specify type = 'square' && ratio = 4 and give text object
 *   if you want to call instead of _imgWidth2().
 * - You should specify type = 'banner'
 *   if you want to call instead of _bannerImgWidth().
 */
function _adjustImageWidth(type, photo, ratio, text) {
    var promise;
    if ( type == 'banner' ) {
        promise = _adjustImageWidthBanner(photo, ratio, text);
    }
    else {
        promise = _adjustImageWidthSquare(photo, ratio, text);
    }
    console.log('  *** adjusted image: ');
    return promise;
}

function _adjustImageWidthBanner(photo) {
    var bodyWidth = $('body').width();
    var size =  Math.round((bodyWidth-bodyWidth*0.1)/2);
    var imgLink = photo.parent();
    var deferred = new $.Deferred();

    photo.load(function(){
        imgLink.css('width', size);
        photo.css({width:size, height:'auto'});

        deferred.resolve(photo);
    });
    return deferred.promise();
}

function _adjustImageWidthSquare(photo, ratio, text) {
    ratio = ratio || 2;
    var bodyWidth = $('body').width(),
        size = Math.round((bodyWidth-bodyWidth*0.1)/ratio);
        if (ratio === 2) {
            size = size-10;
        }

    var deferred = new $.Deferred();

    // 1/2 of the body width
    photo.load(function(){
        var originimgWidth = this.width,
            originimgHeight = this.height,
            top = 0,
            left = 0;

        var sizevalue1 = Math.round(originimgWidth*size/originimgHeight);
        var sizevalue2 = Math.round(originimgHeight*size/originimgWidth);

        //landscape
        if (originimgWidth > originimgHeight) {
             // 1/2
            left = Math.round((size - originimgWidth*size/originimgHeight)/2);
            photo.attr({width:sizevalue1, height:size});
            photo.css({top:top, left:left});
        //portrait
        } else {
            // 1/2
            top = Math.round((size - originimgHeight*size/originimgWidth)/2);
            photo.attr({width:size, height:sizevalue2});
            photo.css({top:top, left:0});
        }
        // text
        if ( text ) {
            text.css('height', size);
        }
        deferred.resolve(photo);
    });
    photo.on('error', function(){
        //var locationPath = location.href;
        // if (locationPath.indexOf('www.rakuten.co.jp/com/gateway/sp')>=0){
        //     $(this).attr("src","/com/gateway/sp/images/noimage.gif");
        // }
        // else {
            $(this).attr("src","images/noimage.gif");
        // }
        deferred.resolve(photo);
    });
    return deferred.promise();
}

/**
 *
 */
function adjustImages(type, container, htmlCode, imageSelector,
                      ratio, textSelector, loadingClass) {
    imageSelector = imageSelector || '.pickupReview > li .image-photo';
    ratio = ratio || 2;
    textSelector = textSelector || '';
    loadingClass = loadingClass || 'loading';
    var promises = [];
    $(container)
        //.append(htmlCode)
        .html(htmlCode)
        .show()
        .find(imageSelector).each(function() {
            var photo = $(this);
            var text = null;
            if ( textSelector.length > 0 ) {
                text = photo.find(textSelector);
            }
            var p = _adjustImageWidth(type, photo, ratio, text).then(function(photo) {
                photo.fadeTo(500,1);
                photo.parent().removeClass(loadingClass);
                return (new $.Deferred()).resolve().promise();
            });
            promises.push(p);
        });
    return $.when.apply(this, promises);
}

//set Affiliate Mobile URLs
function createMobileURL(url) {
    var myUrl = url,
        ichibaIC = /^http:\/\/www\.rakuten\.co\.jp\//,
        ichibaRankUrl = /^http:\/\/item\.rakuten\.co\.jp\//;

    if (myUrl.match(ichibaIC)){
        myUrl = myUrl.replace('http://www', 'http://m');
        return myUrl;
    } else if (myUrl.match(ichibaRankUrl)) {
        var arr = [],
            generatedURL = [],
            len,
            i = 0,
            plus = 'n';

        myUrl = myUrl.replace('http://item', 'http://m');
        arr = myUrl.split('/');
        len = arr.length;
        arr.splice(4,0,plus);
        generatedURL = arr.join('/');
        // check the url ends with '/'
        if ( url.charAt(url.length-1) === '/' &&
             generatedURL.charAt(generatedURL.length-1) !== '/' ) {
            generatedURL = generatedURL+'/';
        }
        return generatedURL;
    }
}

//set Affiliate Link
function setAffiliateLink(url){
    var myUrl = url,
        myMobileUrl = createMobileURL(myUrl),
        myUa = navigator.userAgent,
        setUrl,
        ichibaIC = /^http:\/\/www\.rakuten\.co\.jp\//,
        ichibaRankUrl = /^http:\/\/item\.rakuten\.co\.jp\//,
        linktext = '%26scid%3daf_link_urltxt&amp;m=';

    if(myUrl.match(ichibaRankUrl) || myUrl.match(ichibaIC)){
        if(myUa.match('G6-L22')){ // HUAWEI G6-L22 is added on 2014/
            setUrl = 'http://hb.afl.rakuten.co.jp/hgc/12b839ec.6a808f8e.12b839ed.7077328a/?pc=';
        } else if(myUa.match('P7-L10')){ // HUAWEI P7-L10 is added on 2014/7
            setUrl = 'http://hb.afl.rakuten.co.jp/hgc/12e3205c.71bcdf14.12e3205d.b490f39c/?pc=';
        } else if(myUa.match('MT7-J1')){ // HUAWEI MT7-L09 is added on 2014/11/13
            setUrl = 'http://hb.afl.rakuten.co.jp/hgc/135ba2c9.0afc9f33.135ba2ca.11ea9c9a/?pc=';
        } else {
            setUrl = null;
        }
    } else {
        setUrl = null;
    }

    if(setUrl) {
        setUrl += encodeURIComponent(myUrl);
        setUrl += linktext;
        setUrl += encodeURIComponent(myMobileUrl);
        return setUrl;
    } else {
        return myUrl;
    }
}

//set Affiliate to Ichiba Search
function ichibaSearchAffi() {
    var affurls = {
         'G6-L22':'http://pt.afl.rakuten.co.jp/c/12b971ed.9fb3260d/',
         'P7-L10':'http://pt.afl.rakuten.co.jp/c/12e46315.f9c9d85e/',
         'MT7-J1':'http://pt.afl.rakuten.co.jp/c/135c1e0e.5638e64c/'
    };
    var myUa = navigator.userAgent,
        url;

    $.each(affurls, function (device, url) {
        if(myUa.match(device)){
            $('#header-ichiba-search').attr('action', url);
        }
    });
}


//show error message
function showErrorMsg(elem) {

    var errorMsg = $("meta[name=gatewayErrorMessage]").data('message');
    $(elem).html(errorMsg);
}

//reload API
function OnButtonReload(elem, func) {
    $(elem).find('.errorMsg > .reload').on('touchend',function(){
        func();
        $(this).attr("disabled", "disabled");
    });
}

// google feed
function loadFeed(google, url, numOfEntries) {
    var promise = new $.Deferred().resolve().promise();
    promise = promise.then(function() {
        var p;
        if ( google.feeds ) {
            p = new $.Deferred().resolve().promise();
        }
        else {
            var deferred = new $.Deferred();
            var timeoutId = null;
            // load google feeds
            google.load("feeds", "1");
            google.setOnLoadCallback(function() {
                // cancel the timeout
                if ( timeoutId ) {
                    console.log('*** cancel timeout');
                    clearTimeout(timeoutId);
                }
                deferred.resolve();
            });
            // set timeout for network error.
            timeoutId = setTimeout(function() {
                console.log('*** timeout');
                deferred.resolve();
            }, networkTimeout);
            p = deferred.promise();
        }
        return p;
    }).then(function() {
        var deferred = new $.Deferred();
        if (!google.feeds) {
            deferred.resolve(null);
        }
        else {
            var feed = new google.feeds.Feed(url);
            if ( numOfEntries > 0 ) {
                feed.setNumEntries(numOfEntries);
            }
            feed.load(function(result) {
                if ( result.error ) {
                    //deferred.reject(result.error);
                    deferred.resolve(null);
                }
                else {
                    deferred.resolve(result.feed);
                }
            });
        }
        return deferred.promise();
    });
    return promise;
}

(function($){

    var wrapperWidth = 0;
    var swipeTab;

    //set affiliate link
    $('.afflink').each(function(){
        var myUrl = $(this).attr('href');
        myUrl = setAffiliateLink(myUrl);
        $(this).attr('href', myUrl);
    });

    // set height initially
    var setContentHeight = function() {
        var windowHeight = $(window).height();
        var headerHeight = $('#header').height();
        contentHeight =  windowHeight - headerHeight;
        var contentFrame = $('.frame');
        contentFrame.css('height', contentHeight);
        $('#feedbackForm').css('height', contentHeight);
    };


$('input').bind('touchstart', function() {
        $(this).focus();
});

    // set sitecatalyst link
    var setCatalystLink = function() {
        var seturl = $('.ichibaCategoryList > li > a');
        var genreid = '?scid=wi_gwa_bmk4_ichiba_genre';
        seturl.each(function() {
            var url = $(this).attr('href');
            url += genreid;
            $(this).attr('href', url);
        });
    };

    var beforeScrollStart = function(e) {
        // cancel events on text input.
        var tagName = e.target.tagName;

        if (tagName != 'SELECT' && tagName != 'INPUT' && tagName != 'TEXTAREA'){
            e.preventDefault();
        }
    };

    var scrollEnd = function() {
        var currentPage = $(this)[0].currPageX;
        // change tab
        changeTab(currentPage);
        // refresh
        pageScrolls[currentPage].refresh();
    };

    // change tab
    var changeTab = function(page) {
        if ( swipeTab ) {
            swipeTab.trigger('pageChanged', page);
        }
    };

    // event handler from tab
    var changedTab = function(e, page){
        if ( page >= 0 ) {
            mainScroll.scrollToPage(page, 0);
        }
    };

    var updateLayout = function() {
        var currentPage = 0;
        // width
        if (wrapperWidth > 0) {
            currentPage = - Math.ceil( $('#pageScroller').position().left / wrapperWidth);
        }
        wrapperWidth = $('#pageWrapper').width();
        $('#pageScroller').css('width', wrapperWidth * 5); // @todo 4 is the number of tabs???
        $('.page').css('width', wrapperWidth);
        $('.pagewrapper').css('width', wrapperWidth);
        mainScroll.refresh();
        mainScroll.scrollToPage(currentPage, 0, 0);
        // height
        setContentHeight();
        for ( var i = 0, len = pageScrolls.length ; i < len ; i++ ) {
            pageScrolls[i].refresh();
        }
    };

    var setupiScroll = function() {
        // for main
        mainScroll = new iScroll('pageWrapper', {
            snap: true,
            momentum: false,
            zoom: false,
            //useTransform: true,
            useTransform: false,
            hScrollbar: false,
            vScrollbar: false,
            lockDirection: true,
            onBeforeScrollStart: beforeScrollStart,
            onScrollMove: null,
            onScrollEnd: scrollEnd,
            snapThreshold: 100,
        });
        // for each page
        var pageiScrollOption = {
            hScrollbar: false,
            vScrollbar: false,
            lockDirection: true,
            onBeforeScrollStart: beforeScrollStart
        };
        var numberOfPages = $('.page').length;
        for ( var i = 0 ; i < numberOfPages ; i++ ) {
            var iscrollObj = new iScroll('wrapper'+(i+1), pageiScrollOption);
            pageScrolls.push(iscrollObj);
        }
    };

    /**
     * workaround of orientation change event bug
     */
    var isBuggyForOrientationChange = function() {
        var devices = ['Android 2.3', 'Tizen'];
        for ( var i = 0, len = devices.length ; i < len ; i++ ) {
            var result = (navigator.userAgent.indexOf(devices[i]) >= 0);
            if ( result ) {
                return true;
            }
        }
    };
    var windowWidth = window.innerWidth;
    var windowHeight = window.innerHeight;
    var checkOrientationChange = function() {
        var currentWidth = window.innerWidth;
        var currentHeight = window.innerHeight;
        if ( windowWidth != currentWidth ||
             windowHeight != currentHeight ) {
            $(document).trigger('orientationchange');
        }
        windowWidth = currentWidth;
        windowHeight = currentHeight;
    };

    //Removed contents when FirefoxOS
    var hideAppLink_FirefoxOS = function() {
        var ua = navigator.userAgent;
        if (ua.match('Firefox')) {
            $('#ichibaAppLink').parent('li').addClass('hideAppLink').siblings('li').addClass('wider');
            $('#travelAppLink').parent('li').addClass('hideAppLink').siblings('li').addClass('wider');
            $('#recipeAppLink').parent('li').addClass('hideAppLink').siblings('li').addClass('wider');
            $('.header-search-form').attr('target', '_blank');
        }
    };

     //Firefox OS XMLHttpRequest constructor
     // var XMLHttpRequest_FirefoxOS = function() {
     //    $.ajaxSetup( {
     //      xhr: function() {
     //        console.log('xhr firefoxos setting');
     //        return new window.XMLHttpRequest( {
     //          mozSystem: true
     //        } );
     //      }
     //    } );
     // }

    //Updating copyright year
    var printCurrentYear = function () {
        $('.currentYear').html(new Date().getFullYear());
    }

    //Adding target '_blank'
    var addingTarget_blank = function() {

        var touchTarget = $('a');

        touchTarget.on('touchstart', function(e) {
            var ua = navigator.userAgent;
            if (ua.match('Firefox')) {
                $('a[href^="http://"], a[href^="https://"]').each(function() {
                     $(this).attr("target","_blank");
                });
            }
            //sending the tapped url and timing
            window.homeTappedTime = Date.now() - window.startTime;
            var url = $(this).attr('href');
            if ( s.eVar36 === undefined && url  && url.match(/^(http|https):\/\//i) ) {
                s.linkTrackVars="eVar36,eVar37";
                s.eVar36 = ''+window.homeTappedTime;
                s.eVar37 = url;
                s.tl(this,'o','firstTappedEvent');
                console.log('time: '+s.eVar36+'ms / url: '+s.eVar37);
            }
        })
    };


    /**
     * Event handling
     */

    var onOrientationChange = function(e) {
        updateLayout();
    };

    // orientation change
    if ( navigator.userAgent.indexOf('Android 4.') >= 0 ) {
        $(window).on('resize', onOrientationChange);
    }
    else {
        $(window).on('orientationchange', onOrientationChange);
    }

    // document ready
    $(function(){

        //stop orientationchange for firefoxos
        if (window.screen.mozLockOrientation) {
            screen.mozLockOrientation('portrait');
        }

        // handle orientationchange for buggy devices
        if ( isBuggyForOrientationChange() ) {
            setInterval(function() {
                checkOrientationChange();
            }, 1000);
        }

        // iscroll
        setupiScroll();
        // update layout
        updateLayout();
        // set url switching
        _setUrlSwitching();
        // set Affiliate Link
        setCatalystLink();
        // detecting firefoxOS
        hideAppLink_FirefoxOS();

        //XMLHttpRequest_FirefoxOS();
        // adding target '_blank'
        addingTarget_blank();
        // print current year
        printCurrentYear();
        //ichibaSearchAffi
        ichibaSearchAffi();

        // swipe-tab
        var page = location.hash;
        swipeTab = $('#swipe-tab');
        swipeTab.swipeTab({'iscroll': {},
                           'page': page,
                           'onChangedTab': changedTab,});
        // slidemenu
        $('nav#menu').mmenu();
         var isTargetAndroid  =  navigator.userAgent.indexOf('Android 2.3')  !=  -1;

        // setup tabs
        if(!isTargetAndroid) {
            var tabs = [[tabIchiba, tabTravel]];
        }
        else {
            var tabs = [tabIchiba, tabTravel];
        }

        // loading apis
        $.when(loadFromRSE(), loadTabs(tabs)).then(function() {
            console.log('###################### All done ######################');

            // send value to sitecatalyst
            window.totalTime = Date.now() - window.startTime;
            s.linkTrackVars="eVar40";
            s.eVar40 = ''+window.totalTime;
            s.tl(this,'o','TotalTab');
            console.log('total: '+s.eVar40+'ms');

        }, function() {
            console.log('###################### Error (Not all done) ######################');
        });


        // initial dialog
        // var localMsg = localStorage.getItem('jp.co.rakuten.gateway.initial');
        // var message = $("meta[name=gatewayMessage]").data();
        // var currentMsg = JSON.stringify(message);

        // if (localMsg != currentMsg) {
        //     showPopup(message);
        //     localStorage.setItem('jp.co.rakuten.gateway.initial', currentMsg);
        // }
        // if (location.hash == '#reset-initial') {
        //     localStorage.removeItem('jp.co.rakuten.gateway.initial');
        //     location.hash = '';
        // }
    });

    /**
     * for deferred
     */
    var _parallel = function(promises) {
        var funcs = [];
        for ( var i = 0, len = promises.length ; i < len ; i++ ) {
            funcs.push(promises[i]());
        }
        return $.when.apply(this, funcs);
    };
    var _serial = function(promises) {
        var promise = new $.Deferred().resolve().promise();
        for ( var i = 0, len = promises.length ; i < len ; i++ ) {
            (function() {
                var obj = promises[i];
                promise = promise.then(function() {
                    if ( obj instanceof Array ) {
                        return _parallel(obj);
                    }
                    else {
                        return obj();
                    }
                });
            })();
        }
        return promise;
    };


    /**
     * tabs and feeds
     */
    var loadTabs = function(tabs) {
        return _serial(tabs).then(function(result) {
            // success
            console.log('<<< success >>>');
            return new $.Deferred().resolve().promise();
        }, function(error) {
            // error
            console.error('<<< error >>>');
            console.error(error);
            return new $.Deferred().reject(error).promise();
        });
    };

    /**
     * tabs and feeds
     */
    var loadFromRSE = function() {
        // request RSE
        var device = 'sp'; // or 'tb'
        var url = 'https://jp.api.rse.global.rakuten.com/run/web/gateway';
        return $.ajax({
            url: url,
            type: 'GET',
            contentType: 'application/javascript',
            dataType: 'jsonp',
            jsonpCallback: 'callback',
            cache: true,
            data: {
                device: device,
                clientId : 'gateway_web'
            }
        }).then(function(result) {
            var feeds = [
                            tabHome(result.linkshare_timeline.data),
                            feedIchibaRanking(0, result.ichiba_ranking.data),
                            feedTravelCampaign(result.travel_campaign.data),
                            feedTravelRanking('all', result.travel_ranking.data),
                            feedHotRecipeKeyword(result.recipe_keywords.data),
                            feedRecipePickup(result.recipe_pickup.data),
                            feedRecipeRanking(result.recipe_ranking.data),
                            feedFBIchiba(result.facebook_ichiba.data),
                            feedFBTravel(result.facebook_travel.data)
                        ];
            return $.when.apply(this, feeds).then(function() {
                console.log('### RSE Data rendering: end ###');
                return new $.Deferred().resolve().promise();
            });
        }, function(error) {
            // @todo RSE call error
            console.error(error);
            return new $.Deferred().reject(error).promise();
        });
    };

})(jQuery);
