var feedIchibaBookmark = null;

(function($){

    feedIchibaBookmark = getBookmarkAjaxResponse;

     var layoutData = function(items,len) {
        var itemTag = '<ul class="pickupReview">',
            catalystId = 'scid=wi_gwa_bmk4_ichiba_bookmark_item',
            wrapperSize = _imgWrapperSize(),
            len = Math.min(len, items.length);

        for (var i = 0; i < len; ++i) {
            var item = items[i],
            url = items[i].itemurl,
            itemName = items[i].itemname,
            imageUrl = items[i].imageurl;

            url = escapeHTML(appendParamToURL(url, catalystId));
            url = setAffiliateLink(url);

            itemTag += '<li>';
            itemTag += '<a href="'+ escapeHTML(appendParamToURL(url, catalystId)) +'" style="width:'+wrapperSize+'px">';
            itemTag += '<div class="image-wrapper" style="width:'+wrapperSize+'px; height:'+wrapperSize+'px"><img class="image-photo" src="' + imageUrl + '" alt=" '+ itemName +'"></div>';
            itemTag += '<div class="description">' + itemName + '</div>';
            itemTag += '</a></li>';
        }
        itemTag += '</ul>';
        return itemTag;
    }

    function getBookmarkAjaxResponse(){
        console.log(' === ichibaBookmark: start ===');
        var url = 'http://api.bookmark.rakuten.co.jp/ichiba/?param2=20&param7=1&param5=json&callback=jsonp1375423803961&_=1375423804503';
        var promise = $.ajax({
            url: url,
            dataType: 'jsonp',
            scriptCharset: "EUC-JP",
            timeout: 5000,
        }).then(function(data) {//done(first argument)
            var p,
                q,
                deferredReady,
                data = data.items,
                itemTag,
                itemTag2;

            if ( data && data.length > 0) {
                itemTag = layoutData(data, 4);
                itemTag2 = layoutData(data, 2);
                p = adjustImages('square', '#bookmark',
                                 itemTag,
                                 '.pickupReview > li .image-photo');
                if (loginStatus === 'login') {
                    $('#ttl-homeBookmark').show();
                    $('#homeIchibaRanking3').hide();
                    q = adjustImages('square', '#homeBookmark',
                                 itemTag2,
                                 '.pickupReview > li .image-photo');
                } else {
                    q = new $.Deferred().resolve().promise();
                }

                deferredReady = $.when(p,q);
            }
            else {
                deferredReady = new $.Deferred().reject('failed').promise();
            }
            return deferredReady;
        }, function(xhr, statusText, e){//fail(second argument)
            new $.Deferred().reject(statusText).promise();
        }).then(function() {
            // refresh iScroll
            pageScrolls[1].refresh();

            // return promise;
            console.log(' === ichibaBookmark: end ===');
            return new $.Deferred().resolve().promise();

        }, function(error) {
            $('#ichiba__bookmark-more').hide();
             if (error === 'failed') {
                if(loginStatus ==='login') {
                    $('#bookmark .noData').show();
                    $('#homeBookmark .noData').show();
                    $('#ttl-homeBookmark').show();
                } else {
                    $('#bookmark .noItems').show();
                }
             }
             else {
                showErrorMsg('#bookmark');
                OnButtonReload('#bookmark', getBookmarkAjaxResponse);
                showErrorMsg('#homeBookmark');
                OnButtonReload('#homeBookmark', getBookmarkAjaxResponse);
             }

            // refresh iScroll
            pageScrolls[1].refresh();

            // return promise;
            console.log(' === ichibaBookmark: error ===');
            return new $.Deferred().resolve().promise();
        });
        return promise;
    }

})(jQuery);
