var feedFBIchiba = null;

(function($){

    feedFBIchiba = getIchibaFBAjaxResponse;

    function layoutData(feed) {
        //img s to q
        var len = feed.length,
        feedTag = '',
        list,
        i = 0,
        j = 0,
        count = 50,
        wrapper = _imgWrapperSize2(),
        message,
        shortUrl,
        msgText,
        picture,
        feedListTag = '<ul class="fanReview">',
        catalystId1 = 'scid=wi_gwa_bmk4_article_ichiba_facebook',
        catalystId2 = '_wi_gwa_bmk4_article_ichiba_facebook';

        len = Math.min(4, len);

        for (i; i < len; i++) {
            if (feed[i].picture &&
                feed[i].link &&
                feed[i].message &&
                feed[i].from.name.indexOf("Rakuten")!=-1){

                picture = feed[i].picture;
                message = feed[i].message;
                shortUrl = _extractUrl(message);
                msgText = _limitCharLength(count, message);
                picture = picture.replace(/_s.jpg/,'_n.jpg');

                j = j+1;
                list = '<li>';
                list += '<a href="#" class="clickbutton pLink" ';
                list += 'data-image="'+escapeHTML(picture)+'" ';
                list += 'data-fblink="'+escapeHTML(feed[i].link)+'"';
                list += 'data-shortlink="'+escapeHTML(shortUrl)+'" ';
                list += 'data-cataid1="'+escapeHTML(catalystId1)+'" ';
                list += 'data-cataid2="'+escapeHTML(catalystId2)+'" ';
                list += 'data-caption="'+escapeHTML(message)+'" ';
                list += '>';
                list += '<div class="image-wrapper loading" style="width:'+wrapper+'px; height:'+wrapper+'px">';
                list += '<img src="'+ picture +'" class="articleImg">';
                list += '</div>';
                list += '<div class="description">'+msgText+'</div>';
                list += '</a>';
                list += '</li>';
                feedListTag += list;
                if (j >= 4) break;
            }
        }
        feedTag += feedListTag;
        feedTag += '</ul>';
        return feedTag;
    }

    function layoutDataforhomeFBIchiba(feed) {
        //img s to q
        var len = feed.length,
            feedTag = '',
            list,
            i = 0,
            j = 0,
            count = 20,
            wrapper = _imgWrapperSize(),
            message,
            shortUrl,
            msgText,
            picture,
            feedListTag = '<ul class="pickupReview">',
            catalystId1 = 'scid=wi_gwa_bmk4_home_ichiba_facebook',
            catalystId2 = '_wi_gwa_bmk4_home_ichiba_facebook';

        len = Math.min(4, len);

        for (i; i < len; i++) {
            if (feed[i].picture &&
                feed[i].link &&
                feed[i].message &&
                feed[i].from.name.indexOf("Rakuten")!=-1){

                picture = feed[i].picture;
                message = feed[i].message;
                shortUrl = _extractUrl(message);
                msgText = _limitCharLength(count, message);
                picture = picture.replace(/_s.jpg/,'_n.jpg');

                j = j+1;
                list = '<li>';
                list += '<a href="#" class="clickbutton" style="width:'+wrapper+'px"';
                list += 'data-image="'+escapeHTML(picture)+'" ';
                list += 'data-fblink="'+escapeHTML(feed[i].link)+'"';
                list += 'data-shortlink="'+escapeHTML(shortUrl)+'" ';
                list += 'data-cataid1="'+escapeHTML(catalystId1)+'" ';
                list += 'data-cataid2="'+escapeHTML(catalystId2)+'" ';
                list += 'data-caption="'+escapeHTML(message)+'" ';
                list += '>';
                list += '<div class="image-wrapper loading" style="width:'+wrapper+'px; height:'+wrapper+'px">';
                list += '<img class="image-photo" src="'+ picture +'">';
                list += '</div>';
                list += '<div class="description">'+msgText+'</div>';
                list += '</a></li>';
                feedListTag += list;
                if (j >= 2) break;
            }
        }
        feedTag += feedListTag;
        feedTag += '</ul>';
        return feedTag;
    }

    function getIchibaFBAjaxResponse(rseData) {
        console.log(' === fbIchiba: start ===');
        var dataFetchPromise = null;

        if ( rseData ) {
            dataFetchPromise = new $.Deferred().resolve(rseData).promise();
        }
        else {
            var d = (new Date()).getTime();
            var url = 'https://graph.facebook.com/RakutenIchiba/feed?access_token=1432699403609176|mtisdyP9_B_f-l7TY5I-6P2zZUo&limit=25?' + d;
            dataFetchPromise = $.ajax({
                url: url,
                dataType: 'jsonp',
                scriptCharset:'UTF-8',
                timeout: 5000,
            });
        }
        var promise = dataFetchPromise.then(function(data) {// on success
            var p,
                q,
                feedTag = layoutData(data.data),
                feedTag2 = layoutDataforhomeFBIchiba(data.data),
                ratio = 4;

              setPopup('#ichibaArticles');
              setPopup('#homeFBIchiba');
              p = adjustImages('square', '#ichibaArticles', feedTag,
                                  '.fanReview > li .articleImg', ratio);
              q = adjustImages('square', '#homeFBIchiba',
                                feedTag2,
                                '.pickupReview > li .image-photo');
              $('#ttl-homeFBIchiba').show();
              return $.when(p,q);
        }, function(){
            // on error
            $('#ichiba__fb--more').hide();
            showErrorMsg('#ichibaArticles');
            OnButtonReload('#ichibaArticles', getIchibaFBAjaxResponse);
            showErrorMsg('#block-homeFBIchiba');
            OnButtonReload('#block-homeFBIchiba', getIchibaFBAjaxResponse);
            console.log(' === fbIchiba: error ===');
            return $.Deferred().resolve().promise();
        }).then(function() {
            pageScrolls[4].refresh();
            console.log(' === fbIchiba: end ===');
            return $.Deferred().resolve().promise();
        });
        return promise;
    }

})(jQuery);
