var feedFBTravel = null;

(function($){

    feedFBTravel = getTravelFBAjaxResponse;

    function layoutData(feed) {
        //img s to q
        var len = feed.length,
            feedTag = '',
            count = 50,
            wrapper = _imgWrapperSize2(),
            shortUrl,
            message,
            picture,
            msgText,
            feedListTag = '<ul class="fanReview">',
            catalystId1 = 'scid=wi_gwa_bmk4_article_travel_facebook',
            catalystId2 = '_wi_gwa_bmk4_article_travel_facebook';

        for (var i = 0, j = 0; j < 4 && i < len; i++) {
            if (feed[i].picture &&
                feed[i].link &&
                feed[i].message &&
                feed[i].from.name.indexOf("Rakuten")!=-1){

                message = feed[i].message;
                msgText = _limitCharLength(count, message);
                shortUrl = _extractUrl(message);
                picture = feed[i].picture;
                picture = picture.replace(/_s.jpg/,'_n.jpg');

                list = '<li>';
                list += '<a href="#" class="clickbutton pLink" ';
                list += 'data-image="'+escapeHTML(picture)+'" ';
                list += 'data-fblink="'+escapeHTML(feed[i].link)+'" ';
                list += 'data-shortlink="'+escapeHTML(shortUrl)+'" ';
                list += 'data-cataid1="'+escapeHTML(catalystId1)+'" ';
                list += 'data-cataid2="'+escapeHTML(catalystId2)+'" ';
                list += 'data-caption="'+escapeHTML(message)+'" ';
                list += 'data-title="'+escapeHTML(message)+'" ';
                list += '>';
                list += '<div class="image-wrapper loading" style="width:'+wrapper+'px; height:'+wrapper+'px">';
                list += '<img src="'+ picture +'" class="articleImg">';
                list += '</div>';
                list += '<div class="description">'+msgText+'</div>';
                list += '</a>';
                list += '</li>';
                feedListTag += list;
                j++;
            }
        }

        feedTag += feedListTag;
        feedTag += '</ul>';
        return feedTag;
    }

    function getTravelFBAjaxResponse(rseData) {
        console.log(' === fbTravel: start ===');
        var dataFetchPromise = null;

        if ( rseData ) {
            dataFetchPromise = new $.Deferred().resolve(rseData).promise();
        }
        else {
            var d = (new Date()).getTime();
            var url = 'https://graph.facebook.com/RakutenTravel/feed?access_token=1432699403609176|mtisdyP9_B_f-l7TY5I-6P2zZUo&limit=25?' + d;
            dataFetchPromise = $.ajax({
                url: url,
                dataType: 'jsonp',
                scriptCharset:'UTF-8',
                timeout: 5000,
            });
        }

        var promise = dataFetchPromise.then(function(data) {
            var feedTag = layoutData(data.data);
            setPopup('#travelArticles');
            var ratio = 4;
            return adjustImages('square', '#travelArticles', feedTag,
                                '.fanReview > li .articleImg', ratio);
        }, function() {
            $('#travel__fb--more').hide();
            showErrorMsg('#travelArticles');
            OnButtonReload('#travelArticles', getTravelFBAjaxResponse);
            console.log(' === travelArticles: error ===');
            return $.Deferred().resolve().promise();
        }).then(function() {
            pageScrolls[4].refresh();
            console.log(' === fbTravel: end ===');
            return $.Deferred().resolve().promise();
        });
        return promise;
    }

})(jQuery);
