var mainScroll,
    pageScrolls = [];
var tapThreshold = 5;
var networkTimeout = 5000;

//set useragent url switching
function _setUrlSwitching(geturl) {
    var ua = navigator.userAgent,
        isAndroid = ua.indexOf("Android") > 0,
        isiPhone =  ua.indexOf("iPhone") > 0,
        isiPad =  ua.indexOf("iPad") > 0,
        mangaElement = $('#manga'),
        mangaUrl = mangaElement.find('a'),
        ichibaAppUrl = $('#ichibaAppLink'),
        travelAppUrl = $('#travelAppLink'),
        recipeAppUrl = $('#recipeAppLink'),
        denwaAppUrl = $('#denwa');
    //rakuten install
    if(!isAndroid){
        $('#rakutenInstall').hide();
    }

    //home manga icon link, footer app link
    if (isiPhone||isiPad){
        mangaUrl.attr('href','https://itunes.apple.com/jp/app/manganyusu-c.i.a-qing-bao/id614157582?mt=8');
        ichibaAppUrl.attr('href','https://itunes.apple.com/jp/app/le-tian-shi-chang/id419267350?mt=8');
        travelAppUrl.attr('href','https://itunes.apple.com/jp/app/id300815151?mt=8');
        recipeAppUrl.attr('href','https://itunes.apple.com/jp/app/le-tianreshipi/id445304598?mt=8');
    }else if (isAndroid) {
        mangaUrl.attr('href','https://play.google.com/store/apps/details?id=jp.co.rakuten.cia');
        ichibaAppUrl.attr('href','https://market.android.com/details?id=jp.co.rakuten.android');
        travelAppUrl.attr('href','https://play.google.com/store/apps/details?id=jp.co.rakuten.travel.andro&hl=ja');
        recipeAppUrl.attr('href','https://play.google.com/store/apps/details?id=jp.co.rakuten.recipe&scid=and_001_bn');
        denwaAppUrl.attr('href', 'https://play.google.com/store/apps/details?id=jp.co.rakuten.denwa');
        if( ua.search(/Android 2/) != -1 ) {
            $('.header-search').css('display', 'none');
            $('.pulldownmenu').css('display', 'none');
        }
    }else {
        mangaElement.hide();
    }
}

function escapeHTML(html) {
    return $('<div>').text(html).html() || '';
}

function appendParamToURL(url, param) {
    var delimiter = (url.indexOf('?') >= 0) ? '&' : '?';
    return url + delimiter + param;
}

/**
 * popup
 */
// popup function
function showPopup(params, element) {
    $('#modal').reveal({
        animation: 'fade',
        animationspeed: 600,
        closeonbackgroundclick: true,
        dismissmodalclass: 'close-reveal-modal'
    });



    var $image = $('#popupImage'),
        $smart = $('.popupLink'),
        $pc = $('.popupLinkPC'),
        $more = $('.popupMore'),
        $title = $('#popupCaption'),
        $updates = $('#information'),
        $detail = $('.detail'),
        $footerNav = $('.popup-fnav'),
        $price = $('#popupPrice'),
        $star = $('#popupStar'),
        $fb = $('.fbLink'),
        $fbWeb = $('.fbLinkweb'),

        pImage = params.image,
        pTitle = params.title,
        pSmart = params.link,
        pPcLink = params.pclink,
        pPrice = params.price,
        pScore = params.score,
        pFblink = params.fblink,
        pFbshort = params.shortlink,
        pCata1 = params.cataid1,
        pCata2 = params.cataid2,
        //ABTesting for home
        pCata3 = params.cataid3,
        pCaption = _limitCharLength(100, params.caption),
        updateMessage = params.message;

    $image
        .attr('src', pImage)
        .attr('alt', pTitle);

    //ABTesting in TopContent - Added new parameters
    if (element === '#homeIchibaRanking') {
        pSmart = params.link2;
        pPcLink = params.pclink2;
    }

    $smart.attr('href', pSmart);
    $pc.attr('href', pPcLink);
    $more.attr('href', pSmart);

    $title.html(pCaption);

    $image.css('display', 'inline');
    $smart.hide();
    $pc.hide();
    $more.hide();
    $detail.hide();
    $fbWeb.hide();
    $fb.hide();
    $updates.hide();

    if ( pSmart && pSmart.length > 0 &&
         pPcLink && pPcLink.length > 0 ) {
        $smart.css('display', 'table-cell');
        $title.css('display', 'block');
        $pc.css('display', 'table-cell');
    }
    else if (pSmart && pSmart.length > 0) {
        $more.css('display', 'block');
        $title.css('display', 'block');
        $fb.attr('href', pFblink);
    }
    else if (updateMessage && updateMessage.length >0) {
        $image.css('display', 'none');
        $title.css('display', 'none');
        $updates.css('display', 'block');
        $updates.html(updateMessage);
    }
    else if (pFblink && pFblink.length > 0) {
        $fb.css('display', 'table-cell');
        $title.css('display', 'block');
        $fb.attr('href', pFblink);

        if (pFbshort && pFbshort.length > 0) {
            $fbWeb.css('display', 'table-cell');
            $fbWeb.attr('href', pFbshort);

            $.ajax({
                url: 'https://api-ssl.bitly.com/v3/expand?access_token=3c791d5cadd575f9210d1cef89ebc77fda03b025&shortUrl='+pFbshort+'',
                dataType: 'jsonp',
                method: 'get',
                success: function(response) {
                    var longUrl = response.data.expand[0].long_url;

                    if (longUrl !== undefined) {
                        if (longUrl.indexOf('scid=') !== -1) {
                            longUrl += escapeHTML(pCata2);
                        }
                        else {
                            longUrl = escapeHTML(appendParamToURL(longUrl, pCata1));
                        }
                        $fbWeb.attr('href', longUrl);
                        //$fb.css('display', 'table-cell');
                    }
                },
                error: function(XMLHttpRequest, textStatus, errorThrown){
                    console.log(pFbshort,'error',XMLHttpRequest, textStatus, errorThrown);
                }
            });
        }
    }
    else {
        $footerNav.css('display', 'none');
    }

    //Display price
    if ( pPrice || pScore ) {
        var locationPath = location.href;
        var imagePath;

        if (locationPath.indexOf('www.rakuten.co.jp/com/gateway/sp')>=0){
            imagePath = '/com/gateway/sp/images/';
        }
        else {
            imagePath = '/images/';
        }
        $price.html(pPrice);
        $star.raty({
                    readOnly: true,
                    path: imagePath,
                    score: pScore,
                });
        $detail.css('display', 'table');
    }
    else {
        $detail.css('display', 'none');
    }
}

function setPopup(element) {

    //set event handler
    $(element)
        .on('touchstart', '.clickbutton', function(e) {
            $(this).data('touchScreenX',
                         e.originalEvent.changedTouches[0].screenX);
            $(this).data('touchScreenY',
                         e.originalEvent.changedTouches[0].screenY);
        })

        .on('touchend', '.clickbutton', function(e) {
            var diffX = Math.abs(e.originalEvent.changedTouches[0].screenX - $(this).data('touchScreenX'));
            var diffY = Math.abs(e.originalEvent.changedTouches[0].screenY - $(this).data('touchScreenY'));
            var isSwiping = ( diffX > tapThreshold || diffY > tapThreshold );
            if ( isSwiping ) {
                return ;
            }
            else {
                var data = $(this).data();
                // show
                showPopup(data, element);
                // event handling
                e.preventDefault();
                e.stopPropagation();
            }
        });
}

function _limitCharLength(num, words) {
        var count = num,
            msgText = words||'',
            msgLength = msgText.length;

        if (msgLength > count) {
            msgText = msgText.substr(0,count);
            msgText += ' ...';
        }
        return msgText;
}

function _extractUrl(string) {
    var urlRegex = /(https?:\/\/)?([\da-z\.-]+)\.([a-z\.]{2,6})([\/\w\.-=?]*)*\/?/,
        shortUrl = string.match(urlRegex);

    if (shortUrl) {
        shortUrl = shortUrl[0];
        return shortUrl;
    }
    else {
        return null;
    }
}

//set imageWrapperSize
function _imgWrapperSize() {
    var bodyWidth = $('body').width();
    var size =  Math.round((bodyWidth-bodyWidth*0.1)/2);
    return size;
}

//set imageWrapperSize2
function _imgWrapperSize2() {
    var bodyWidth = $('body').width();
    var size =  Math.round((bodyWidth-bodyWidth*0.1)/4);
    return size;
}


/**
 * - You should specify type = 'square' && ratio = 2
 *   if you want to call instead of _imgWidth().
 * - You should specify type = 'square' && ratio = 4 and give text object
 *   if you want to call instead of _imgWidth2().
 * - You should specify type = 'banner'
 *   if you want to call instead of _bannerImgWidth().
 */
function _adjustImageWidth(type, photo, ratio, text) {
    var promise;
    if ( type == 'banner' ) {
        promise = _adjustImageWidthBanner(photo, ratio, text);
    }
    else {
        promise = _adjustImageWidthSquare(photo, ratio, text);
    }
    console.log('  *** adjusted image: ');
    return promise;
}

function _adjustImageWidthBanner(photo) {
    var bodyWidth = $('body').width();
    var size =  Math.round((bodyWidth-bodyWidth*0.1)/2);
    var imgLink = photo.parent();
    var deferred = new $.Deferred();

    photo.load(function(){
        imgLink.css('width', size);
        photo.css({width:size, height:'auto'});

        deferred.resolve(photo);
    });
    return deferred.promise();
}

function _adjustImageWidthSquare(photo, ratio, text) {
    ratio = ratio || 2;
    var bodyWidth = $('body').width(),
        size = Math.round((bodyWidth-bodyWidth*0.1)/ratio);
        if (ratio === 2) {
            size = size-10;
        }

    var deferred = new $.Deferred();

    // 1/2 of the body width
    photo.load(function(){
        var originimgWidth = this.width,
            originimgHeight = this.height,
            top = 0,
            left = 0;

        var sizevalue1 = Math.round(originimgWidth*size/originimgHeight);
        var sizevalue2 = Math.round(originimgHeight*size/originimgWidth);

        //landscape
        if (originimgWidth > originimgHeight) {
             // 1/2
            left = Math.round((size - originimgWidth*size/originimgHeight)/2);
            photo.attr({width:sizevalue1, height:size});
            photo.css({top:top, left:left});
        //portrait
        } else {
            // 1/2
            top = Math.round((size - originimgHeight*size/originimgWidth)/2);
            photo.attr({width:size, height:sizevalue2});
            photo.css({top:top, left:0});
        }
        // text
        if ( text ) {
            text.css('height', size);
        }
        deferred.resolve(photo);
    });
    photo.on('error', function(){
        //var locationPath = location.href;
        // if (locationPath.indexOf('www.rakuten.co.jp/com/gateway/sp')>=0){
        //     $(this).attr("src","/com/gateway/sp/images/noimage.gif");
        // }
        // else {
            $(this).attr("src","images/noimage.gif");
        // }
        deferred.resolve(photo);
    });
    return deferred.promise();
}

/**
 *
 */
function adjustImages(type, container, htmlCode, imageSelector,
                      ratio, textSelector, loadingClass) {
    imageSelector = imageSelector || '.pickupReview > li .image-photo';
    ratio = ratio || 2;
    textSelector = textSelector || '';
    loadingClass = loadingClass || 'loading';
    var promises = [];
    $(container)
        //.append(htmlCode)
        .html(htmlCode)
        .show()
        .find(imageSelector).each(function() {
            var photo = $(this);
            var text = null;
            if ( textSelector.length > 0 ) {
                text = photo.find(textSelector);
            }
            var p = _adjustImageWidth(type, photo, ratio, text).then(function(photo) {
                photo.fadeTo(500,1);
                photo.parent().removeClass(loadingClass);
                return (new $.Deferred()).resolve().promise();
            });
            promises.push(p);
        });
    return $.when.apply(this, promises);
}

//set Affiliate Mobile URLs
function createMobileURL(url) {
    var myUrl = url,
        ichibaIC = /^http:\/\/www\.rakuten\.co\.jp\//,
        ichibaRankUrl = /^http:\/\/item\.rakuten\.co\.jp\//;

    if (myUrl.match(ichibaIC)){
        myUrl = myUrl.replace('http://www', 'http://m');
        return myUrl;
    } else if (myUrl.match(ichibaRankUrl)) {
        var arr = [],
            generatedURL = [],
            len,
            i = 0,
            plus = 'n';

        myUrl = myUrl.replace('http://item', 'http://m');
        arr = myUrl.split('/');
        len = arr.length;
        arr.splice(4,0,plus);
        generatedURL = arr.join('/');
        // check the url ends with '/'
        if ( url.charAt(url.length-1) === '/' &&
             generatedURL.charAt(generatedURL.length-1) !== '/' ) {
            generatedURL = generatedURL+'/';
        }
        return generatedURL;
    }
}

//set Affiliate Link
function setAffiliateLink(url){
    var myUrl = url,
        myMobileUrl = createMobileURL(myUrl),
        myUa = navigator.userAgent,
        setUrl,
        ichibaIC = /^http:\/\/www\.rakuten\.co\.jp\//,
        ichibaRankUrl = /^http:\/\/item\.rakuten\.co\.jp\//,
        linktext = '%26scid%3daf_link_urltxt&amp;m=';

    if(myUrl.match(ichibaRankUrl) || myUrl.match(ichibaIC)){
        if(myUa.match('G6-L22')){ // HUAWEI G6-L22 is added on 2014/
            setUrl = 'http://hb.afl.rakuten.co.jp/hgc/12b839ec.6a808f8e.12b839ed.7077328a/?pc=';
        } else if(myUa.match('P7-L10')){ // HUAWEI P7-L10 is added on 2014/7
            setUrl = 'http://hb.afl.rakuten.co.jp/hgc/12e3205c.71bcdf14.12e3205d.b490f39c/?pc=';
        } else if(myUa.match('MT7-J1')){ // HUAWEI MT7-L09 is added on 2014/11/13
            setUrl = 'http://hb.afl.rakuten.co.jp/hgc/135ba2c9.0afc9f33.135ba2ca.11ea9c9a/?pc=';
        } else {
            setUrl = null;
        }
    } else {
        setUrl = null;
    }

    if(setUrl) {
        setUrl += encodeURIComponent(myUrl);
        setUrl += linktext;
        setUrl += encodeURIComponent(myMobileUrl);
        return setUrl;
    } else {
        return myUrl;
    }
}

//set Affiliate to Ichiba Search
function ichibaSearchAffi() {
    var affurls = {
         'G6-L22':'http://pt.afl.rakuten.co.jp/c/12b971ed.9fb3260d/',
         'P7-L10':'http://pt.afl.rakuten.co.jp/c/12e46315.f9c9d85e/',
         'MT7-J1':'http://pt.afl.rakuten.co.jp/c/135c1e0e.5638e64c/'
    };
    var myUa = navigator.userAgent,
        url;

    $.each(affurls, function (device, url) {
        if(myUa.match(device)){
            $('#header-ichiba-search').attr('action', url);
        }
    });
}


//show error message
function showErrorMsg(elem) {

    var errorMsg = $("meta[name=gatewayErrorMessage]").data('message');
    $(elem).html(errorMsg);
}

//reload API
function OnButtonReload(elem, func) {
    $(elem).find('.errorMsg > .reload').on('touchend',function(){
        func();
        $(this).attr("disabled", "disabled");
    });
}

// google feed
function loadFeed(google, url, numOfEntries) {
    var promise = new $.Deferred().resolve().promise();
    promise = promise.then(function() {
        var p;
        if ( google.feeds ) {
            p = new $.Deferred().resolve().promise();
        }
        else {
            var deferred = new $.Deferred();
            var timeoutId = null;
            // load google feeds
            google.load("feeds", "1");
            google.setOnLoadCallback(function() {
                // cancel the timeout
                if ( timeoutId ) {
                    console.log('*** cancel timeout');
                    clearTimeout(timeoutId);
                }
                deferred.resolve();
            });
            // set timeout for network error.
            timeoutId = setTimeout(function() {
                console.log('*** timeout');
                deferred.resolve();
            }, networkTimeout);
            p = deferred.promise();
        }
        return p;
    }).then(function() {
        var deferred = new $.Deferred();
        if (!google.feeds) {
            deferred.resolve(null);
        }
        else {
            var feed = new google.feeds.Feed(url);
            if ( numOfEntries > 0 ) {
                feed.setNumEntries(numOfEntries);
            }
            feed.load(function(result) {
                if ( result.error ) {
                    //deferred.reject(result.error);
                    deferred.resolve(null);
                }
                else {
                    deferred.resolve(result.feed);
                }
            });
        }
        return deferred.promise();
    });
    return promise;
}

(function($){

    var wrapperWidth = 0;
    var swipeTab;

    //set affiliate link
    $('.afflink').each(function(){
        var myUrl = $(this).attr('href');
        myUrl = setAffiliateLink(myUrl);
        $(this).attr('href', myUrl);
    });

    // set height initially
    var setContentHeight = function() {
        var windowHeight = $(window).height();
        var headerHeight = $('#header').height();
        contentHeight =  windowHeight - headerHeight;
        var contentFrame = $('.frame');
        contentFrame.css('height', contentHeight);
        $('#feedbackForm').css('height', contentHeight);
    };


$('input').bind('touchstart', function() {
        $(this).focus();
});

    // set sitecatalyst link
    var setCatalystLink = function() {
        var seturl = $('.ichibaCategoryList > li > a');
        var genreid = '?scid=wi_gwa_bmk4_ichiba_genre';
        seturl.each(function() {
            var url = $(this).attr('href');
            url += genreid;
            $(this).attr('href', url);
        });
    };

    var beforeScrollStart = function(e) {
        // cancel events on text input.
        var tagName = e.target.tagName;

        if (tagName != 'SELECT' && tagName != 'INPUT' && tagName != 'TEXTAREA'){
            e.preventDefault();
        }
    };

    var scrollEnd = function() {
        var currentPage = $(this)[0].currPageX;
        // change tab
        changeTab(currentPage);
        // refresh
        pageScrolls[currentPage].refresh();
    };

    // change tab
    var changeTab = function(page) {
        if ( swipeTab ) {
            swipeTab.trigger('pageChanged', page);
        }
    };

    // event handler from tab
    var changedTab = function(e, page){
        if ( page >= 0 ) {
            mainScroll.scrollToPage(page, 0);
        }
    };

    var updateLayout = function() {
        var currentPage = 0;
        // width
        if (wrapperWidth > 0) {
            currentPage = - Math.ceil( $('#pageScroller').position().left / wrapperWidth);
        }
        wrapperWidth = $('#pageWrapper').width();
        $('#pageScroller').css('width', wrapperWidth * 5); // @todo 4 is the number of tabs???
        $('.page').css('width', wrapperWidth);
        $('.pagewrapper').css('width', wrapperWidth);
        mainScroll.refresh();
        mainScroll.scrollToPage(currentPage, 0, 0);
        // height
        setContentHeight();
        for ( var i = 0, len = pageScrolls.length ; i < len ; i++ ) {
            pageScrolls[i].refresh();
        }
    };

    var setupiScroll = function() {
        // for main
        mainScroll = new iScroll('pageWrapper', {
            snap: true,
            momentum: false,
            zoom: false,
            //useTransform: true,
            useTransform: false,
            hScrollbar: false,
            vScrollbar: false,
            lockDirection: true,
            onBeforeScrollStart: beforeScrollStart,
            onScrollMove: null,
            onScrollEnd: scrollEnd,
            snapThreshold: 100,
        });
        // for each page
        var pageiScrollOption = {
            hScrollbar: false,
            vScrollbar: false,
            lockDirection: true,
            onBeforeScrollStart: beforeScrollStart
        };
        var numberOfPages = $('.page').length;
        for ( var i = 0 ; i < numberOfPages ; i++ ) {
            var iscrollObj = new iScroll('wrapper'+(i+1), pageiScrollOption);
            pageScrolls.push(iscrollObj);
        }
    };

    /**
     * workaround of orientation change event bug
     */
    var isBuggyForOrientationChange = function() {
        var devices = ['Android 2.3', 'Tizen'];
        for ( var i = 0, len = devices.length ; i < len ; i++ ) {
            var result = (navigator.userAgent.indexOf(devices[i]) >= 0);
            if ( result ) {
                return true;
            }
        }
    };
    var windowWidth = window.innerWidth;
    var windowHeight = window.innerHeight;
    var checkOrientationChange = function() {
        var currentWidth = window.innerWidth;
        var currentHeight = window.innerHeight;
        if ( windowWidth != currentWidth ||
             windowHeight != currentHeight ) {
            $(document).trigger('orientationchange');
        }
        windowWidth = currentWidth;
        windowHeight = currentHeight;
    };

    //Removed contents when FirefoxOS
    var hideAppLink_FirefoxOS = function() {
        var ua = navigator.userAgent;
        if (ua.match('Firefox')) {
            $('#ichibaAppLink').parent('li').addClass('hideAppLink').siblings('li').addClass('wider');
            $('#travelAppLink').parent('li').addClass('hideAppLink').siblings('li').addClass('wider');
            $('#recipeAppLink').parent('li').addClass('hideAppLink').siblings('li').addClass('wider');
            $('.header-search-form').attr('target', '_blank');
        }
    };

     //Firefox OS XMLHttpRequest constructor
     // var XMLHttpRequest_FirefoxOS = function() {
     //    $.ajaxSetup( {
     //      xhr: function() {
     //        console.log('xhr firefoxos setting');
     //        return new window.XMLHttpRequest( {
     //          mozSystem: true
     //        } );
     //      }
     //    } );
     // }

    //Updating copyright year
    var printCurrentYear = function () {
        $('.currentYear').html(new Date().getFullYear());
    }

    //Adding target '_blank'
    var addingTarget_blank = function() {

        var touchTarget = $('a');

        touchTarget.on('touchstart', function(e) {
            var ua = navigator.userAgent;
            if (ua.match('Firefox')) {
                $('a[href^="http://"], a[href^="https://"]').each(function() {
                     $(this).attr("target","_blank");
                });
            }
            //sending the tapped url and timing
            window.homeTappedTime = Date.now() - window.startTime;
            var url = $(this).attr('href');
            if ( s.eVar36 === undefined && url  && url.match(/^(http|https):\/\//i) ) {
                s.linkTrackVars="eVar36,eVar37";
                s.eVar36 = ''+window.homeTappedTime;
                s.eVar37 = url;
                s.tl(this,'o','firstTappedEvent');
                console.log('time: '+s.eVar36+'ms / url: '+s.eVar37);
            }
        })
    };


    /**
     * Event handling
     */

    var onOrientationChange = function(e) {
        updateLayout();
    };

    // orientation change
    if ( navigator.userAgent.indexOf('Android 4.') >= 0 ) {
        $(window).on('resize', onOrientationChange);
    }
    else {
        $(window).on('orientationchange', onOrientationChange);
    }

    // document ready
    $(function(){

        //stop orientationchange for firefoxos
        if (window.screen.mozLockOrientation) {
            screen.mozLockOrientation('portrait');
        }

        // handle orientationchange for buggy devices
        if ( isBuggyForOrientationChange() ) {
            setInterval(function() {
                checkOrientationChange();
            }, 1000);
        }

        // iscroll
        setupiScroll();
        // update layout
        updateLayout();
        // set url switching
        _setUrlSwitching();
        // set Affiliate Link
        setCatalystLink();
        // detecting firefoxOS
        hideAppLink_FirefoxOS();

        //XMLHttpRequest_FirefoxOS();
        // adding target '_blank'
        addingTarget_blank();
        // print current year
        printCurrentYear();
        //ichibaSearchAffi
        ichibaSearchAffi();

        // swipe-tab
        var page = location.hash;
        swipeTab = $('#swipe-tab');
        swipeTab.swipeTab({'iscroll': {},
                           'page': page,
                           'onChangedTab': changedTab,});
        // slidemenu
        $('nav#menu').mmenu();
         var isTargetAndroid  =  navigator.userAgent.indexOf('Android 2.3')  !=  -1;

        // setup tabs
        if(!isTargetAndroid) {
            var tabs = [[tabIchiba, tabTravel]];
        }
        else {
            var tabs = [tabIchiba, tabTravel];
        }

        // loading apis
        $.when(loadFromRSE(), loadTabs(tabs)).then(function() {
            console.log('###################### All done ######################');

            // send value to sitecatalyst
            window.totalTime = Date.now() - window.startTime;
            s.linkTrackVars="eVar40";
            s.eVar40 = ''+window.totalTime;
            s.tl(this,'o','TotalTab');
            console.log('total: '+s.eVar40+'ms');

        }, function() {
            console.log('###################### Error (Not all done) ######################');
        });


        // initial dialog
        // var localMsg = localStorage.getItem('jp.co.rakuten.gateway.initial');
        // var message = $("meta[name=gatewayMessage]").data();
        // var currentMsg = JSON.stringify(message);

        // if (localMsg != currentMsg) {
        //     showPopup(message);
        //     localStorage.setItem('jp.co.rakuten.gateway.initial', currentMsg);
        // }
        // if (location.hash == '#reset-initial') {
        //     localStorage.removeItem('jp.co.rakuten.gateway.initial');
        //     location.hash = '';
        // }
    });

    /**
     * for deferred
     */
    var _parallel = function(promises) {
        var funcs = [];
        for ( var i = 0, len = promises.length ; i < len ; i++ ) {
            funcs.push(promises[i]());
        }
        return $.when.apply(this, funcs);
    };
    var _serial = function(promises) {
        var promise = new $.Deferred().resolve().promise();
        for ( var i = 0, len = promises.length ; i < len ; i++ ) {
            (function() {
                var obj = promises[i];
                promise = promise.then(function() {
                    if ( obj instanceof Array ) {
                        return _parallel(obj);
                    }
                    else {
                        return obj();
                    }
                });
            })();
        }
        return promise;
    };


    /**
     * tabs and feeds
     */
    var loadTabs = function(tabs) {
        return _serial(tabs).then(function(result) {
            // success
            console.log('<<< success >>>');
            return new $.Deferred().resolve().promise();
        }, function(error) {
            // error
            console.error('<<< error >>>');
            console.error(error);
            return new $.Deferred().reject(error).promise();
        });
    };

    /**
     * tabs and feeds
     */
    var loadFromRSE = function() {
        // request RSE
        var device = 'sp'; // or 'tb'
        var url = 'https://jp.api.rse.global.rakuten.com/run/web/gateway';
        return $.ajax({
            url: url,
            type: 'GET',
            contentType: 'application/javascript',
            dataType: 'jsonp',
            jsonpCallback: 'callback',
            cache: true,
            data: {
                device: device,
                clientId : 'gateway_web'
            }
        }).then(function(result) {
            var feeds = [
                            tabHome(result.linkshare_timeline.data),
                            feedIchibaRanking(0, result.ichiba_ranking.data),
                            feedTravelCampaign(result.travel_campaign.data),
                            feedTravelRanking('all', result.travel_ranking.data),
                            feedHotRecipeKeyword(result.recipe_keywords.data),
                            feedRecipePickup(result.recipe_pickup.data),
                            feedRecipeRanking(result.recipe_ranking.data),
                            feedFBIchiba(result.facebook_ichiba.data),
                            feedFBTravel(result.facebook_travel.data)
                        ];
            return $.when.apply(this, feeds).then(function() {
                console.log('### RSE Data rendering: end ###');
                return new $.Deferred().resolve().promise();
            });
        }, function(error) {
            // @todo RSE call error
            console.error(error);
            return new $.Deferred().reject(error).promise();
        });
    };

})(jQuery);
