/**
 * @license [group_template.js] [ver.1.2]
 * Copyright (c) @2012 Rakuten.Inc
 * Date : 2013/02/15
 */
 var loginStatus = 'default';
/**
 * 'default' = error happened before this function
 * 'login'   = login status
 * 'logout'  = logout status
 */


(function($){
  if(typeof jQuery == 'undefined' || typeof jQuery.noConflict != 'function'){
    return;
  }
  var $ = jQuery;

  $(function(){

    var _memberDetail = $('#memberDetail'),
      _close = $('div.close',_memberDetail),
      _memberMenu = $('li.memberMenu',_memberDetail),
      _menuTab = $('#menuTab'),
      _serviceMenu = $('li.serviceMenu',_memberDetail),
      //_container = $('#container'),
      _detailInfo = $('#detailInfo'),
      _serviceInfo = $('#serviceInfo'),
      _statusInfo = $('#statusInfo'),
      //variable for opening feedback form
      _openFBform = $('.feedbackLink'),
      _feedbackForm = $('#feedbackForm'),
      fbUrl = 'https://docs.google.com/forms/d/1qD5ZWDniWkLls0_W-xGKP40YZa-fxoDnCqrZs3Hlf-c/viewform?embedded=true';

    _memberDetail.css('top','500%').hide();
    var viewPoint;
    _close.click(function(){
      //_container.show();
      _memberDetail.animate({
        top: $(window).height()
        },200,function(){$(this).hide()});
    });

    _detailInfo.click(function(){
      viewPoint = $(window).scrollTop();
			_memberMenu.addClass('open');
			_serviceMenu.removeClass('open');
			_serviceInfo.hide();
			_statusInfo.show();
			_menuTab.show();
      _memberDetail.show().animate({
        top: 0
        //}
        //,200,function(){
          //_container.hide();
        });
    });
    _memberMenu.click(function(){
      $(this).addClass('open');
      _serviceMenu.removeClass('open');
      _serviceInfo.hide();
      _statusInfo.show();
    });
    _serviceMenu.click(function(){
      $(this).addClass('open');
      _memberMenu.removeClass('open');
      _statusInfo.hide();
      _serviceInfo.show();
      _feedbackForm.attr('src', fbUrl);
    });

  //open feedback form
  $('#information').on('click', _openFBform, function(){
    $('.close-reveal-modal').trigger('reveal:close');
      _memberDetail.show().animate({
        top: 0
        //},200,function(){
        //_container.hide();
      });
      _serviceMenu.addClass('open');
      _memberMenu.removeClass('open');
      _statusInfo.hide();
      _serviceInfo.show();
      _menuTab.hide();
      _feedbackForm.attr('src', fbUrl);
  });

    _openFBform.on('click', function(){
      _memberDetail.show().animate({
        top: 0
        //},200,function(){
          //_container.hide();
        });
      _serviceMenu.addClass('open');
      _memberMenu.removeClass('open');
      _statusInfo.hide();
      _serviceInfo.show();
      _menuTab.hide();
      _feedbackForm.attr('src', fbUrl);
    });


    var addFigure = function(str) {
      var num = new String(str).replace(/,/g, "");
      while(num != (num = num.replace(/^(-?\d+)(\d{3})/, "$1,$2")));
      return num;
    }

    $.support.cors = true;
    var myTarget = $('#header,#longHeader,#memberDetail');

    $.ajax({
      url: "https://app.rakuten.co.jp/engine/zapi/MemberInformation/GetPointWithRz/20121011",
      type: "GET",
      dataType: "json",
      success: function(data) {
      var myRankClass = '',
          myRankName = '',
          myPointAll = addFigure(data.cash + data.fixedPoint + data.limitedPoint + data.temporaryPoint),
          myPointCash = addFigure(data.cash),
          myPointFixed = addFigure(data.fixedPoint),
          myPointLimited = addFigure(data.limitedPoint);

          loginStatus = 'login';

        switch(data.rank){
          case 1:
            myRankClass = 'normal';
            myRankName = 'レギュラー会員';
            break;
          case 2:
            myRankClass = 'silver';
            myRankName = 'シルバー会員';
            break;
          case 3:
            myRankClass = 'gold';
            myRankName = 'ゴールド会員';
            break;
          case 4:
            myRankClass = 'platinum';
            myRankName = 'プラチナ会員';
            break;
          case 5:
            myRankClass = 'diamond';
            myRankName = 'ダイヤモンド会員';
            break;
        }

        // s.tl send value to sitecatalyst
         s.eVar22 = 'login ' + myRankClass;
        // s.t send value to sitecatalyst
        try {var s_code=s.t();if(s_code)document.write(s_code);} catch(e) {rakutenSC.log(e);}
        // end s.t send value to sitecatalyst

        $('.memberName',myTarget).html(data.username);
        $('.nickName',myTarget).html(data.nickname);
        $('.memberPoint',myTarget).html(myPointAll);
        $('.memberTemporaryPoint',myTarget).html(myPointLimited);
        $('.memberCache',myTarget).html(myPointCash);
        $('.memberRankName',myTarget).html(myRankName);
        $('#statusInfo',myTarget).addClass(myRankClass);
        $('#serviceInfo',myTarget).addClass(myRankClass);

        $('.login',myTarget).css('visibility','visible').show();
        $('.logout',myTarget).hide();
        $('.logoutBtn', '#footer').show();
      },
      error: function(xhr, statusText, e) {
        var message = $.parseJSON(xhr.responseText);

         loginStatus = 'logout';

        // s.tl send value to sitecatalyst
         s.eVar22 = 'logout';
        // s.t send value to sitecatalyst
        try {var s_code=s.t();if(s_code)document.write(s_code);} catch(e) {rakutenSC.log(e);}
        // end of s.t send value to sitecatalyst

        if (xhr.status == 400) {
          $('.login',myTarget).hide();
          $('.logout',myTarget).css('visibility','visible').show();

        } else if ('xhr status', xhr.status == 503) {
          if ("error_description" in message
            && message.error_description.match(/under maintenance/)) {
          } else {
          }
        } else {
        }
      },
      xhrFields: {
        withCredentials: true
      }
    });

  });
})(jQuery);
