var tabHome = null;

(function($){

    tabHome = getAjaxResponse;

    //get response
    function getAjaxResponse(rseData) {
        console.log('### homeTab: start ###');
        var isTargetAndroid  =  navigator.userAgent.indexOf('Android 2.3')  !=  -1;
        var dataFetchPromise = null;
        var promise = null;

        if(!isTargetAndroid) {

            if ( rseData ) {
                dataFetchPromise = new $.Deferred().resolve(rseData).promise();
            }
            else {
                var d = (new Date()).getTime();
                var url = 'http://www.linkshare.ne.jp/ch/rg/timeline.json?'+d;
                dataFetchPromise= $.ajax({
                    url: url,
                    dataType: 'json',
                    timeout: 5000,
                });
            }

            promise = dataFetchPromise.then(function(data) {
                // resolved
                data = sortdata(data);
                var p = selectDataHotBlog(data).then(function() {
                    // refresh
                    pageScrolls[0].refresh();
                    // calcurate loading time
                    window.homeTabTime = Date.now() - window.startTime;
                    // send value to sitecatalyst
                    s.linkTrackVars="eVar39";
                    s.eVar39 = ''+window.homeTabTime;
                    s.tl(this,'o','HomeTab');

                    console.log('home: '+s.eVar39+'ms');
                    console.log(' === hotBlog: end ===');
                    console.log('### homeTab: end ###');
                    return new $.Deferred().resolve().promise();
                },function(){//fail(second argument)
                    new $.Deferred().reject().promise();
                }).then(function() {
                    return selectDataArticleBlog(data).then(function() {
                        pageScrolls[4].refresh();
                        console.log(' === articleBlog: end ===');
                        return new $.Deferred().resolve().promise();
                    });
                });
                return p;
            }, function(error) {
                // rejected
                $('#fan__blog--more').hide();
                showErrorMsg('#hotBlogReviews');
                showErrorMsg('#fanBlogs');
                OnButtonReload('#hotBlogReviews', getAjaxResponse);
                OnButtonReload('#fanBlogs', getAjaxResponse);
                console.error(' === hotBlog: error ===');
                return new $.Deferred().resolve(error);
            });
        }
        else {
            $('#block-homeHotBlogReviews').hide();
            $('#fanReviewContent').hide();

            promise = new $.Deferred().resolve().promise();
        }
        return promise;
    }

    //sorting registered urls
    function isRegisteredURL(url) {
        var regex = /^(http:\/\/35-45\.net\/|http:\/\/blog\.bbi\.boo\.jp\/|http:\/\/luchin\.blog6\.fc2\.com\/|http:\/\/nagomin08\.blog\.fc2\.com\/|http:\/\/sayonnn12\.blog118\.fc2.com\/|http:\/\/syuminokimono\.seesaa\.net\/article\/|http:\/\/techoo\.net\/|http:\/\/www\.web-ryoku\.com\/tuhan\/)/;
        var result = url.match(regex);
        return (result && result.length > 0);
    }

    function layoutDataForHotBlog(itemList) {
        var reviewTag= '',
            len = itemList.length,
            itemTag = '<ul class="pickupReview">',
            wrapperSize = _imgWrapperSize(),
            catalystId_home = 'scid=wi_gwa_bmk4_home',
            item,
            itemUrl;

        len = Math.min(2, len);

        for (var i = 0 ; i < len; i++) {
            item = itemList[i];
            itemUrl = '<li>';
            itemUrl += '<a href="#" class="clickbutton" style="width:'+ wrapperSize +'px"';
            itemUrl += 'data-image="'+escapeHTML(item['image_url'])+'" ';
            itemUrl += 'data-link="'+escapeHTML(appendParamToURL(item['link_url'], catalystId_home))+'" ';
            itemUrl += 'data-caption="'+escapeHTML(item['text'])+'" ';
            itemUrl += 'data-title="'+escapeHTML(item['title'])+'" ';
            itemUrl += '>';
            itemUrl += '<div class="image-wrapper loading" style="width:'+wrapperSize+'px; height:'+wrapperSize+'px">';
            itemUrl += '<img class="image-photo" src="' + item['image_url'] + '" alt="'+ item['title'] +'">';
            itemUrl += '</div>';
            itemUrl += '<div class="description">' + item['title'] + '</div>';
            itemUrl += '</a>';
            itemUrl += '</li>';
            reviewTag += itemUrl;
        }
        itemTag += reviewTag;
        itemTag += '</ul>';
        return itemTag;
    }

    function layoutDataForArticleBlog(itemList) {
        var reviewTag= '',
            reviewTag2= '',
            len2 = itemList.length,
            itemTag2 = '<ul class="fanReview">',
            wrapperSize2 = _imgWrapperSize2(),
            catalystId_article = 'scid=wi_gwa_bmk4_article_ichiba_facebook',
            item2,
            itemUrl2;

        len2 = Math.min(6, len2);  //Article Blogs

        //Article Blogs
        for ( var i = 0 ; i < len2; i++) {
            item2 = itemList[i];
            itemUrl2 = '<li>';
            itemUrl2 += '<a href="#" class="clickbutton pLink" ';
            itemUrl2 += 'data-image="'+escapeHTML(item2['image_url'])+'" ';
            itemUrl2 += 'data-link="'+escapeHTML(appendParamToURL(item2['link_url'], catalystId_article))+'" ';
            itemUrl2 += 'data-caption="'+escapeHTML(item2['text'])+'" ';
            itemUrl2 += 'data-title="'+escapeHTML(item2['title'])+'" ';
            itemUrl2 += '>';
            itemUrl2 += '<div class="image-wrapper loading" style="width:'+wrapperSize2+'px; height:'+wrapperSize2+'px">';
            itemUrl2 += '<img class="articleImg" src="' + item2['image_url'] + '" alt="'+ item2['title'] +'">';
            itemUrl2 += '</div>';
            itemUrl2 += '<div class="description">' + item2['title'] + '</div>';
            itemUrl2 += '</a>';
            itemUrl2 += '</li>';
            reviewTag2 += itemUrl2;
        }
        itemTag2 += reviewTag2;
        itemTag2 += '</ul>';
        return itemTag2;
    }

    function selectDataHotBlog(itemList) {
        console.log(' === hotBlog: start ===');
        var promise;
        // show hotBlog
        var len = Math.min(2, itemList.length); //hotBlogs
        if ( len > 0 ) {
            var itemTag = layoutDataForHotBlog(itemList, len);
            promise = adjustImages('square', '#hotBlogReviews', itemTag);
            setPopup('#hotBlogReviews');
            $('#layoutDataForHotBlog').show();
            $('#ttl-hotBlogReviews').show();
        }
        else {
            promise = (new $.Deferred()).resolve().promise();
        }
        return promise;
    }

    function selectDataArticleBlog(itemList) {
        console.log(' === articleBlog: start ===');
        var promise;
        // show Article Blogs
        var len = Math.min(6, itemList.length);
        if ( len > 0 ) {
            var itemTag = layoutDataForArticleBlog(itemList, len);
            var ratio = 4;
            var textSelector = '.description';
            setPopup('#fanBlogs');
            promise = adjustImages('square', '#fanBlogs', itemTag,
                                   '.fanReview > li .articleImg',
                                   ratio, textSelector);
        }
        else {
            // return vacant
            promise = new $.Deferred().resolve().promise();
        }
        return promise;
    }


    //sorting registered urls and return results
    function sortdata(dataurls){
        var resultdata = [],
            len = dataurls.length,
            i = 0,
            itemLinkUrl;

        for (i; i < len; i++) {
            itemLinkUrl = dataurls[i]['link_url'];
            if (isRegisteredURL(itemLinkUrl)){
                resultdata.push(dataurls[i]);
            }
        }
        return resultdata;
    }

})(jQuery);