var feedHotRecipeKeyword = null;

(function($){
    // variables
    var numOfEntries = 5;
    var xmlUrl = "http://static.recipe.rakuten.co.jp/contents/rss/hotkeyword.xml";

    feedHotRecipeKeyword = _feedHotRecipeKeyword;

    function layoutData(feed) {
        var cataID = 'scid=wi_gwa_bmk4_recipe_seasonal_recipe',
            splitChar = '：';
        var len = Math.min(numOfEntries, feed.length);
        var html = '';
        for (var i = 0; i < len; i++) {
            var entry = feed[i];
            var title = entry.title[0];
            var link = entry.link[0];
            title = title.split(splitChar);
            html += '<a class="kw" href="' + escapeHTML(appendParamToURL(link, cataID)) + '">';
            html += '<span>' + title[1] + '</span>';
            html += '</a>';
        }
        return html;
    }

    function _feedHotRecipeKeyword(rseData){
       console.log(' === hotRecipeKeyword: start ===');
       var dataFetchPromise = null;

        if ( rseData ) {
            dataFetchPromise = new $.Deferred().resolve(rseData).promise();
        }
        else {
            dataFetchPromise = loadFeed(
                google,
                xmlUrl,
                numOfEntries
            )
        }

        var promise = dataFetchPromise.then(function(feed) {
            var elem = feed.rss.channel[0].item;

            if(feed != null && elem.length > 0){

                html = layoutData(elem);
                    $('#recipeKeywords').append(html);
                    // page refresh for iScroll
                    pageScrolls[3].refresh();
                    console.log(' === hotRecipeKeyword: end ===');
                    return new $.Deferred().resolve().promise();
            }
            else {
                showErrorMsg('#recipeKeywords');
                OnButtonReload('#recipeKeywords', _feedHotRecipeKeyword);
                console.log(' === hotRecipeKeyword: error ===');
                return new $.Deferred().resolve().promise();
            }
        });
        return promise;
    }

})(jQuery);
