var feedIchibaBlog = null;

(function($){

    feedIchibaBlog = getIchibaBlogAjaxResponse;

    function layoutData(data) {
        var len = Math.min(5, data.length);
            feedTag = '',
            wrapper = _imgWrapperSize2(),
            feedListTag = '<ul class="fanReview">',
            catalystId = 'scid=wi_gwa_bmk4_article_ichiba_promotion';

        for (var i = 0; i < len; i++) {
            var list = '<li>';
            list += '<a href="#" class="clickbutton pLink" ';
            list += 'data-image="'+escapeHTML(data[i].image_url)+'" ';
            list += 'data-link="'+escapeHTML(appendParamToURL(data[i].link_url, catalystId))+'" ';
            list += 'data-caption="'+escapeHTML(data[i].text)+'" ';
            list += 'data-title="'+escapeHTML(data[i].title)+'" ';
            list += '>';
            list += '<div class="image-wrapper" style="width:'+wrapper+'px; height:'+wrapper+'px">';
            list += '<img src="' + data[i].image_url + '" class="articleImg">';
            list += '</div>';
            list += '<div class="description">'+ data[i].title+'</div>';
            list += '</a></li>';
            feedListTag += list;         
        }
        feedTag += feedListTag;
        feedTag += '</ul>';
        return feedTag;
    }

    function getIchibaBlogAjaxResponse() {
        console.log(' === ichibaBlogs: start ===');

        //var url = 'http://event.rakuten.co.jp/ent/magazine/gateway/timeline.json';
        var url = '/gateway_iscroll/js/ichibaBlogs.json';
        //var url = 'js/ichibaBlogs.json';

        var promise = $.ajax({
            type: "GET",
            url: url,
            dataType: 'json',
            scriptCharset:'UTF-8'
        }).then(function(data) {
            var feedTag = layoutData(data);
            setPopup('#ichibaBlogs');
            var ratio = 4;
            return adjustImages('square', '#ichibaBlogs', feedTag,
                                '.fanReview > li .articleImg', ratio);
        }, function(XMLHttpRequest, textStatus, errorThrown){
            showErrorMsg('#ichibaBlogs');
            OnButtonReload('#ichibaBlogs', getIchibaBlogAjaxResponse);
            return new $.Deferred().resolve().promise();
        }).then(function() {
            pageScrolls[4].refresh();
            console.log(' === ichibaBlogs: end ===');
            return new $.Deferred().resolve().promise();
        });

        return promise;
    }


})(jQuery);
