var feedIchibaRanking = null;

(function($){
    // export loadRanking;
    feedIchibaRanking = loadRanking;

    var layoutData = function(data,len) {
        var itemList = data['Items'],
            len = Math.min(len, itemList.length),
            item,
            itemName,
            imageUrl,
            link,
            splink,
            splink2,
            pclink,
            pclink2,
            itemPrice,
            rank,
            rate,
            url,
            wrapperSize = _imgWrapperSize(),
            ichibaCataID = 'scid=wi_gwa_bmk4_ichiba_ranking_item',
            ichibaCataID2 = 'scid=wi_gwa_bmk4_home_ichiba_ranking_item',
            rankingTag = '',
            itemTag = '<ul class="pickupReview">',
            itemUrl,
            i = 0;

            len = Math.min(30, len);

        for (i; i < len; i++) {
            item = itemList[i].Item;
            itemName = item.itemName;
            imageUrl = item['mediumImageUrls'][0]['imageUrl'];
            imageUrl = imageUrl.split("?");
            imageUrl = imageUrl[0];
            //the first image of three;
            link = item.itemUrl;
            splink = escapeHTML(appendParamToURL(link, ichibaCataID));
            splink = setAffiliateLink(splink);
            pclink = escapeHTML(appendParamToURL(link, 'force-site=pc&'+ichibaCataID));
            pclink = setAffiliateLink(pclink);
            //ABTesting for top contents
            splink2 = escapeHTML(appendParamToURL(link, ichibaCataID2));
            splink2 = setAffiliateLink(splink2);
            pclink2 = escapeHTML(appendParamToURL(link, 'force-site=pc&'+ichibaCataID2));
            pclink2 = setAffiliateLink(pclink2);
            //
            itemPrice = _getComma(item.itemPrice);
            rank = item.rank;
            rate = item.reviewAverage;

            itemUrl = '<li data-id="'+i+'">';
            itemUrl += '<span class="r-order">' + rank + '</span>';
            itemUrl += '<a href="#" class="clickbutton" style="width:'+wrapperSize+'px"';
            itemUrl += 'data-image="'+escapeHTML(imageUrl)+'" ';
            itemUrl += 'data-link="'+ splink +'" ';
            itemUrl += 'data-pclink="'+ pclink +'" ';
            //ABTesting for top contents
            itemUrl += 'data-link2="'+ splink2 +'" ';
            itemUrl += 'data-pclink2="'+ pclink2 +'" ';
            //
            itemUrl += 'data-caption="'+escapeHTML(itemName)+'" ';
            itemUrl += 'data-title="'+escapeHTML(itemName)+'" ';
            itemUrl += 'data-score="'+escapeHTML(rate)+'" ';
            itemUrl += 'data-price="'+escapeHTML(itemPrice)+'" ';
            itemUrl += ' >';
            itemUrl += '<div class="image-wrapper loading" style="width:'+wrapperSize+'px; height:'+wrapperSize+'px">';
            itemUrl += '<img class="image-photo" src="' + imageUrl + '" alt="' + itemName +'"></div>';
            itemUrl += '<div class="description">' + itemName + '</div>';
            itemUrl += '<div class="itemprice">&#165;' + itemPrice + '</div>';
            itemUrl += '</a></li>';
            rankingTag += itemUrl;
        }

        itemTag += rankingTag;
        itemTag += '</ul>';

        return itemTag;
    }

    function loadRanking(genreId, rseData) {
        genreId = genreId || 0;
        console.log(' === ichibaRaking: start ===');

        var dataFetchPromise = null;
        if ( rseData ) {
            dataFetchPromise = new $.Deferred().resolve(rseData).promise();
        }
        else {
            var url = 'https://app.rakuten.co.jp/engine/api/IchibaItem/Ranking/20121201?applicationId=ichiba_ipad&page=1&genreId=' + genreId;
            dataFetchPromise = $.ajax({
                url: url,
                dataType: 'json',
                timeout: 5000,
            });
        }
        var promise = dataFetchPromise.then(function(data) {
            // render and adjust images
            var p,
                q,
                r,
                s,
                t,
                deferredReady,
                len,
                itemTag,
                itemTag2;

            if ( data && data.Items.length > 0 ) {
                itemTag = layoutData(data, 30),
                itemTag2 = layoutData(data, 2);
                $('#ichibaRanking').html('');
                p = adjustImages('square', '#ichibaRanking',
                                    itemTag,
                                    '.pickupReview > li .image-photo');

                // AB Testing - Show IchibaRanking to Home Top
                q = adjustImages('square', '#homeIchibaRanking',
                                    itemTag2,
                                    '.pickupReview > li .image-photo');

                //AB Testing for Home History. Display Ichiba Ranking when logout or no history data.
                if (loginStatus ==='login') {
                    t = new $.Deferred().resolve().promise();
                } else {

                    //AB Testing for Home History. Display Ichiba Ranking when logout or no history data.
                    r = adjustImages('square', '#homeIchibaRanking2',
                                        itemTag2,
                                        '.pickupReview > li .image-photo');
                    $('#ttl-homeIchibaRanking2').show();
                    $('#ttl-homeHistory').hide();
                     //AB Testing for Home Bookmark. Display Ichiba Ranking when logout or no bookmark data.
                     s = adjustImages('square', '#homeIchibaRanking3',
                                         itemTag2,
                                         '.pickupReview > li .image-photo');
                    $('#ttl-homeIchibaRanking3').show();
                    $('#ttl-homeBookmark').hide();
                    t = $.when(r,s);
                }

                $('#ichibaRanking_category').show();
                $('#ttl-homeIchibaRanking').show();

                deferredReady = $.when(p,q,t);
            }
            else {
                deferredReady = new $.Deferred().reject('failed').promise();
            }
            return deferredReady;
        },function(){//fail(second argument)
            new $.Deferred().reject().promise();
        }).then(function() {
                // refresh iScroll
                pageScrolls[1].refresh();
                // return promise;
                console.log(' === ichibaRaking: end ===');
                return new $.Deferred().resolve().promise();
        }, function(error) {
                $('#ichibaRanking_category').hide();
                showErrorMsg('#ichibaRanking');
                OnButtonReload('#ichibaRanking', loadRanking);
                showErrorMsg('#homeIchibaRanking');
                OnButtonReload('#homeIchibaRanking', loadRanking);
                // refresh iScroll
                pageScrolls[1].refresh();

                // return promise;
                console.log(' === ichibaRanking: error ===');
                return new $.Deferred().resolve().promise();
        });
        return promise;
    }

    $(function() {
        // set change event handler
        $('#ichibaRanking_category').on('change', function(){
            var genreId = $('#ichibaRanking_category').val();
            loadRanking(genreId);

        });
        // set popup
        setPopup('#ichibaRanking');
        setPopup('#homeIchibaRanking');
        setPopup('#homeIchibaRanking2');
        setPopup('#homeIchibaRanking3');
    });

    function _getComma(price) {
        var num = ''+price;
        while (num != (num = num.replace(/^(-?\d+)(\d{3})/, "$1,$2")));
        return num;
    }

})(jQuery);
