var feedRecipePickup = null;

(function($){
    var xmlUrl = "http://static.recipe.rakuten.co.jp/contents/rss/pickup.xml";
    var setNum = 6;

    feedRecipePickup = _initializerecipePickup;

    function layoutData(feed) {
        var recipeTag= '',
        rpLink,
        rpName,
        rpImgUrl,
        rpTag = '<ul class="pickupReview">',
        listTag,
        popupUrl,
        wrapperSize = _imgWrapperSize(),
        cataID = 'scid=wi_gwa_bmk4_recipe_pickup',
        len = Math.min(setNum, feed.length);

        for (var i = 0; i < len; i++) {
            var $item = feed[i];
            if ($item.link[0] === undefined) {
                continue;
            }
            popupUrl = '#';
            rpLink =  $item.link[0];
            rpName = $item.title[0];
            rpImgUrl = $item.image;
            popupUrl += '?' + encodeURIComponent(rpName);
            popupUrl += ',' + encodeURIComponent(rpImgUrl);
            popupUrl += ',' + encodeURIComponent(rpLink);
            listTag = '<li>';
            listTag += '<a href="#" class="clickbutton" style="width:'+wrapperSize+'px"';
            listTag += 'data-image="'+escapeHTML(rpImgUrl)+'" ';
            listTag += 'data-link="'+escapeHTML(appendParamToURL(rpLink, 'vt=sp&'+cataID))+'" ';
            listTag += 'data-pclink="'+escapeHTML(appendParamToURL(rpLink, 'vt=pc&'+cataID))+'" ';
            listTag += 'data-caption="'+escapeHTML(rpName)+'" ';
            listTag += 'data-title="'+escapeHTML(rpName)+'" ';
            listTag += ' >';
            listTag += '<div class="image-wrapper loading" style="width:'+wrapperSize+'px; height:'+wrapperSize+'px"><img class="image-photo" src="' + rpImgUrl + '" alt=" '+ rpName +'"></div>';
            listTag += '<div class="description">' + rpName + '</div>';
            listTag += '</a></li>';
            recipeTag += listTag;
        }
        rpTag += recipeTag;
        rpTag += '</ul>';
        return rpTag;
    }

    function _initializerecipePickup(rseData){
        console.log(' === recipePickup: start ===');
        var dataFetchPromise = null;

        if ( rseData ) {
            dataFetchPromise = new $.Deferred().resolve(rseData).promise();
        }
        else {
            dataFetchPromise = loadFeed(
                google,
                xmlUrl,
                setNum
            )
        }
        var promise = dataFetchPromise.then(function(feed) {
            var elem = feed.rss.channel[0].item;

            if((feed != null) && (elem.length > 0)){
                $('#recipePickup').empty();
                htmlCode = layoutData(elem);
                var p = adjustImages('square', '#recipePickup', htmlCode).then(function() {
                        // refresh for iscroll
                        pageScrolls[3].refresh();
                        // set popup
                        setPopup('#recipePickup');

                        console.log(' === recipePickup: end ===');
                        return new $.Deferred().resolve().promise();
                        return p;
                    })
            }
            else {
                showErrorMsg('#recipePickup');
                OnButtonReload('#recipePickup', _initializerecipePickup);
                console.log('recipepickup network error');
                return new $.Deferred().resolve().promise();
            }
        });
        return promise;
    }
})(jQuery);
