var feedRecipeRanking = null;

(function($){

    feedRecipeRanking = getRecipeRankingAjaxResponse;

    function layoutData(itemList) {
        var len = Math.min(10, itemList.length);
            wrapperSize = _imgWrapperSize(),
            cataID = 'scid=wi_gwa_bmk4_recipe_ranking',
            itemTag = '<ul class="pickupReview ranking">';

        for (var i = 0; i < len; ++i) {
            var item = itemList[i],
                ImageUrl = item['food_image_path'],
                url='http://recipe.rakuten.co.jp/recipe/' + item['recipe_id'] + '/';

            itemTag += '<li>';
            itemTag += '<span class="r-order">'+ (i + 1) +'</span>';
            itemTag += '<a href="'+ escapeHTML(appendParamToURL(url, cataID)) + '" style="width:'+wrapperSize+'px">';
            itemTag += '<div class="image-wrapper" style="width:'+wrapperSize+'px; height:'+wrapperSize+'px">';
            itemTag += '<img class="image-photo loading" src="'+ ImageUrl +'" alt=" '+ item['recipe_description'] +'">';
            itemTag += '</div>';
            itemTag += '<div class="description">'+ item['recipe_description'] +'</div>';
            itemTag += '</a></li>';
        }
        itemTag += '</ul>';
        return itemTag;
    }

    function getRecipeRankingAjaxResponse(rseData) {
        console.log(' === recipeRanking: start ===');

        var dataFetchPromise = null;

        if ( rseData ) {
            dataFetchPromise = new $.Deferred().resolve(rseData).promise();
        }
        else {
            var url = 'http://api.recipe.rakuten.co.jp/ext/search/recipe/?developerId=fe4ade9e3b11616d1373318cd58dce345491c0f0&sort=4';
            dataFetchPromise = $.ajax({
                url: url,
                dataType: 'jsonp',
                scriptCharset:'UTF-8',
                timeout: 5000,
            });
        }

        var promise = dataFetchPromise.then(function(data) { // on success
            var itemTag = layoutData(data.result);
            return adjustImages('square', '#recipeRanking', itemTag);
        }, function() { // on error
            $('#recipe__ranking-more').hide();
            showErrorMsg('#recipeRanking');
            OnButtonReload('#recipeRanking', getRecipeRankingAjaxResponse);
            console.log(' === recipeRanking: error ===');
            return new $.Deferred().resolve().promise();
        }).then(function() {
            pageScrolls[3].refresh();
            console.log(' === recipeRanking: end ===');
            return new $.Deferred().resolve().promise();
        });
        return promise;
    }
})(jQuery);
