/**
 * @author Tsutomu Ogasawara at CWD, Rakuten, inc.
 * @mail tsutomu.ogasawara@mail.rakuten.com
 */
(function($) {
    /**
     * @method swipeTab
     * create swipable tab menu for smartphone
     * @member jQuery
     */
    $.fn.swipeTab = function() {
        // parameters
        var args = Array.prototype.slice.call(arguments),
            defaults = {
                'offset': 20,
                'onChangedTab': null
            };

        return $(this).each(function() {
            var element = this,
                $element = $(element),
                $list = $(element).find('ul'),
                $items = $list.children(),
                isSwipe = false,
                isScrolling = false,
                isTouched = false;

            var iscrollObject;

            // start
            _init(args[0]);

            function _onResize(e) {
                _refresh();
                window.scroll(0, 0);
            }

            function _onPageChange(e, page) {
                //console.log('onpagechange');
                _scrollToPage(page);
            }

            function _scrollStartHandler() {
                //console.log('_scrollStartHandler');
                isScrolling = false;
                isSwipe = false;
            }

            function _scrollMoveHandler() {
                //console.log('_scrollMoveHandler');
                isScrolling = true;
                isSwipe = true;
            }

            function _scrollEndHandler() {
                //console.log('_scrollEndHandler');
                if ( ! isScrolling ) {
                    return;
                }
                isScrolling = false;

                // call changed tab callback
                var index = this.currPageX;
                if ( defaults.onChangedTab ) {
                    defaults.onChangedTab(null, index);
                }

                // color change
                _setFocusClassAtIndex(index);
            }

            /**
             * touch end event handler
             */ 
            function _touchEndHandler(e) {
                //console.log('_touchEndHandler: '+e.type);
                if ( e.type == 'mouseout' ) {
                    // event canceling
                    e.preventDefault();
                    e.stopPropagation();
                    return ;
                }

                // check if swiping
                if ( isSwipe ) {
                    isSwipe = false;
                    e.preventDefault();
                    e.stopPropagation();
                    return ;
                }
                // get clicked item index
                var index = $items.index(e.target.parentElement);
                // call changed tab callback
                if ( defaults.onChangedTab ) {
                    defaults.onChangedTab(e, index);
                }
                // scroll
                if ( index >= 0 ) {
                    _scrollToPage(index, 0);
                }
                // event canceling
                e.preventDefault();
                e.stopPropagation();
            }

            /**
             * show page with hash (ex. "#page1")
             */
            function _showPageWithHash(hash) {
                if ( hash && hash.length > 0 && location.hash != hash ) {
                    location.hash = hash;
                }
            }

            /**
             *
             */
            function _getIndexWithHash(hash) {
                var index = $list.find('a').index($list.find('[href="'+hash+'"]'));
                return index;
            }

            /**
             *
             */
            function _getHashAtIndex(index) {
                var result = '';
                var item = $items[index];
                if ( item ) {
                    result = $(item).find('a').attr('href');
                }
                return result;
            }
            
            // orientation change event
            if ( navigator.userAgent.indexOf('Android 4.') >= 0 ) {
                $(window).on('resize', _onResize);
            }
            else {
                $(window).on('orientationchange', _onResize);
            }

            // refresh when the window focused (workaround for Firefox OS)
            $(window).focus(function() {
                _refresh();
            });

            // page change event
            $element.on('pageChanged', _onPageChange);

            function _init(options) {
                // set options
                defaults = $.extend(defaults, options);

                if ( defaults.iscroll ) {
                    // iscroll
                    var iscrollDefaults = { hScrollbar: false,
                                            vScrollbar: false,
                                            hScroll: true,
                                            vScroll: false,
                                            bounce: false,
                                            snap: 'li',
                                            momentum: false,
                                            // 
			                                onTouchEnd: _touchEndHandler,
			                                onScrollEnd: _scrollEndHandler,
                                            onScrollStart: _scrollStartHandler,
                                            onScrollMove: _scrollMoveHandler,
                                          };
                    var iscrollOptions = $.extend(iscrollDefaults, defaults.iscroll);
                    var widths = _beforeRefresh(defaults.offset);
                    if ( iscrollObject ) {
                        iscrollObject.destroy();
                        iscrollObject = null;
                    }
                    iscrollObject = new iScroll(element.id, iscrollOptions);
                    _afterRefresh(widths);
                }
            }

            function _beforeRefresh(offset) {
                var sumOfItemWidth = 0;
                var widthOfItems = [];
                $items.each(function(){
                    var width = $(this).width();
                    widthOfItems.push(width);
                    sumOfItemWidth += width;
                });
                var visibleWidth = $element.width();
                var firstItemWidth = $items.first().width();
                var firstSpaceWidth = Math.ceil((visibleWidth - firstItemWidth) / 2.0);
                var lastItemWidth = $items.last().width();
                var lastSpaceWidth = Math.ceil((visibleWidth - lastItemWidth) / 2.0);
                var listWidth = sumOfItemWidth + firstSpaceWidth + lastSpaceWidth;
                $list.width(listWidth+offset);
                $items.first().css('padding-left', 0);
                $items.last().css('padding-right', 0);
                return {first: firstSpaceWidth, last: lastSpaceWidth};
            }
            function _afterRefresh(widths) {
                $items.first().css('padding-left', widths.first+'px');
                $items.last().css('padding-right', widths.last+'px');
            }
            function _refresh() {
                var currentIndex = iscrollObject.currPageX;
                _init();
                _scrollToPage(currentIndex, 0, 0);
            }
            function _scrollToPage(pageX, pageY, time) {
                iscrollObject.scrollToPage(pageX, pageY, time);
                setTimeout(function(){
                    _setFocusClassAtIndex(pageX);
                }, 200);
            }
            function _setFocusClassAtIndex(index) {
                _setFocusClassByPageName('page'+(index+1));
            }
            function _setFocusClassByPageName(page) {
                page = (page.charAt(0)=='#') ? page.substr(1) : page;
                $('.cnt-selected')
                    .removeClass('page1 page2 page3 page4 page5')
                    .addClass(page);
            }
        });
    };
}.call(window, jQuery));
