var feedTravelCampaign = null;

(function($){

    feedTravelCampaign = getCampaginAjaxResponse;

    function layoutData(campaignList) {
        var campaignListTag = '',
            travelCampaignCataID = 'scid=wi_gwa_bmk4_travel_campaign_hotel',
            campaignTag = '<ul class="travelCampaignAd">';
            len = Math.min(6, campaignList.length);

        for (var i = 0; i < len; i++) {
            var list = campaignList[i],
            listUrl = '<li>';

            listUrl += '<a href="'+ escapeHTML(appendParamToURL(list['url'], travelCampaignCataID)) +'">';
            listUrl += '<img class="tcampaignBanner" src="' + list['img'] + '" alt=" '+ list['title'] +'">';
            listUrl += '</a></li>';
            campaignListTag += listUrl;
        }
        campaignTag += campaignListTag;
        campaignTag += '</ul>';
        return campaignTag;
    }

    function getCampaginAjaxResponse(rseData) {
        console.log(' === travelCampaign: start ===');
        var dataFetchPromise = null;

        if ( rseData ) {
            dataFetchPromise = new $.Deferred().resolve(rseData).promise();
        }
        else {
            var d = (new Date()).getTime(),
                url = 'http://img.travel.rakuten.co.jp/smart/campaign/campaign.unitA.json?' + d;

            dataFetchPromise = $.ajax({
                url: url,
                dataType: 'json',
                scriptCharset:'UTF-8',
            });
        }

        var promise = dataFetchPromise.then(function(data) {
            var campaignTag = layoutData(data.campaign);
            return adjustImages('banner', '#travelCampaign',
                                campaignTag,
                                '.travelCampaignAd > li a .tcampaignBanner');
        }).then(function() {
            // refresh iScroll
            pageScrolls[2].refresh();
            console.log(' === travelCampaign: end ===');
        }, function(XMLHttpRequest, textStatus, errorThrown){
            showErrorMsg('#travelCampaign');
            OnButtonReload('#travelCampaign', getCampaginAjaxResponse);

            console.log(' === travelCampaign: error ===');
        });
        return promise;
    }

})(jQuery);