var feedTravelHistory = null;

(function($){

    feedTravelHistory = _feedTravelHistory;

    function layoutData(historyData) {
        var hotelhisCata = 'scid=wi_gwa_bmk4_travel_browsing_history_hotel',
            wrapperSize = _imgWrapperSize(),
            len = Math.min(4, historyData.length),
            item,
            hotelUrl,
            hotelName,
            hotelID,
            imgUrl,
            itemTag = '';

        itemTag += '<ul class="pickupReview">';

        for (var i = 0; i < len; i++) {
            item = historyData[i].hotelBasicInfo;
            hotelUrl = item['hotelInformationUrl'];
            hotelName = item['hotelName'];
            hotelID = item['hotelNo'];
            imgUrl = 'http://travel.rakuten.co.jp/HOTEL/' + hotelID + '/' + hotelID + '.jpg';

            itemTag += '<li>';
            itemTag += '<a href="'+escapeHTML(appendParamToURL(hotelUrl, hotelhisCata))+'" style="width:'+wrapperSize+'px">';
            itemTag += '<div class="image-wrapper loading" style="width:'+wrapperSize+'px; height:'+wrapperSize+'px"><img class="image-photo" src="' + imgUrl + '" alt="' + hotelName +'"></div>';
            itemTag += '<div class="description">' + hotelName + '</div>';
            itemTag += '</a></li>';
        }

        itemTag += '</ul>';
        return itemTag;
    }

    function _feedTravelHistory() {
        console.log(' === travelHistory: start ===');
        var url = 'http://ashiato.travel.rakuten.co.jp/ashiato/domesticHotelBrowse/take';
        var promise = $.ajax({
            url: url,
            dataType: 'jsonp',
            scriptCharset:'UTF-8',
            timeout: 5000,
        }).then(function(data) {
            var historyData = data.body.contents;
            var p;
            if ( historyData.length > 0 ) {
                itemTag = layoutData(historyData);
                p = adjustImages('square', '#travelHistory',
                                    itemTag,
                                    '.pickupReview > li .image-photo');
            }
            else {
                p = new $.Deferred().reject('failed').promise();
            }
            return p;
        }, function(){//fail(second argument)
            new $.Deferred().reject().promise();
        }).then(function() {
            // refresh iScroll
            pageScrolls[2].refresh();

            // return promise;
            console.log(' === travelHistory: end ===');
            return new $.Deferred().resolve().promise();
        }, function(error) {
             $('#travel__history-more').hide();
             if (error === 'failed') {
                if(loginStatus ==='login') {
                    $('#travelHistory .noData').show();
                } else {
                    $('#travelHistory .noItems').show();
                }
             }
             else {
                showErrorMsg('#travelHistory');
                OnButtonReload('#travelHistory', _feedTravelHistory);
             }
            // refresh iScroll
            pageScrolls[2].refresh();

            // return promise;
            console.log(' === ichibaHistory: error ===');
            return new $.Deferred().resolve().promise();
        });
        return promise;
    }

})(jQuery);
