var createHotelRanking;
var travelRankingImgWidth;
var feedTravelRanking = null;

(function($){

  // export loadTravelRanking
  feedTravelRanking = loadTravelRanking;

  $(function () {
      $('#hotelCategory').on('change', function(){
          var genreId = $('#hotelCategory').val();
          loadTravelRanking(genreId);
      });
  });

  function _createHotelRanking(d) {
      return new $.Deferred().resolve(d).promise();
  }
  // export for callback
  createHotelRanking = _createHotelRanking;

  function layoutHotelRanking(hotelRanking) {
      var hotelRankingTag = '',
          rankingCata = 'scid=wi_gwa_bmk4_travel_ranking_hotel',
          wrapperSize = _imgWrapperSize(),
          len = Math.min(10, hotelRanking.length),
          i = 0,
          hotelInfo,
          url;

      hotelRankingTag += '<ul class="pickupReview">';

      for(i; i < len; i++) {
              hotelInfo = hotelRanking[i];
              url = hotelInfo.planListUrl;
              url = appendParamToURL(url, rankingCata);

              hotelRankingTag += '<li>';
              hotelRankingTag += '<span class="r-order">' + hotelInfo.rank + '</span>';
              hotelRankingTag += '<a href="'+ url +'" style="width:'+ wrapperSize +'px">';
              hotelRankingTag += '<div class="image-wrapper loading" style="width:'+ wrapperSize +'px; height:'+wrapperSize+'px">';
              hotelRankingTag += '<img class="image-photo" src="' + hotelInfo.hotelImageUrl + '" alt=" '+ hotelInfo.hotelName + '">';
              hotelRankingTag += '</div>';
              hotelRankingTag += '<div class="description">' + hotelInfo.hotelName + '【' + hotelInfo.middleClassName + '】' + '</div>';
              hotelRankingTag += '</a>';
              hotelRankingTag += '</li>';
      }
      hotelRankingTag += '</ul>';
      return hotelRankingTag;
  }

  function loadTravelRanking(genreId, rseData){
    console.log(' === travel ranking start ===');
    var dataFetchPromise = null;

    if ( rseData && !rseData.Body ) {
        dataFetchPromise = new $.Deferred().resolve(rseData).promise();
    }
    else {
      var Id = '1012528979789887227',
          genre = genreId,
          formatVer = '2',
          requestUrl = 'https://app.rakuten.co.jp/services/api/Travel/HotelRanking/20131024?',
          elements = 'genre,title,rank,hotelName,middleClassName,userReview,reviewCount,planListUrl,hotelImageUrl,hotelThumbnailUrl',
          param = [];

      param.push('genre='+ genre);
      param.push('formatVersion='+ formatVer);
      param.push('applicationId='+ Id);
      param.push('elements='+ elements);

      var url = requestUrl + param.join('&');

      dataFetchPromise = $.ajax({
          url: url,
          dataType: 'json',
          timeout: 5000,
      });
    }

    var promise = dataFetchPromise.then(function(data) {
        var elem = data.Rankings[0].hotels;
        if ( data != null  && elem.length > 0 ) {
            var hotelRankingTag = layoutHotelRanking(elem);
            $('#hotelRanking').html('');
            return adjustImages('square', '#hotelRanking', hotelRankingTag,
                                '.pickupReview > li .image-photo');
        }
        else {
            return new $.Deferred().reject().promise();
        }
    },function(){//fail(second argument)
            new $.Deferred().reject().promise();
    }).then(function() {
          // refresh iScroll
          pageScrolls[2].refresh();
          console.log(' === travel ranking end ===');
          return new $.Deferred().resolve().promise();
    }, function(error) {
          $('#hotelCategory').hide();
          showErrorMsg('#hotelRanking');
          OnButtonReload('#hotelRanking', loadTravelRanking);
          // refresh iScroll
          pageScrolls[1].refresh();

          // return promise;
          console.log(' === hotelRanking: error ===');
          return new $.Deferred().resolve().promise();
    });
    return promise;
  }
})(jQuery);
