
var divs = "";
var btns = [];
var go_dom, menu_dom, down, end, show_dom, result_dom, show_val = "", result_val = "", calc = "";
var clear_show;     //清空show的显示setTimeout
onload = function () {
    //IE6-9 禁止选择按钮的文字
    document.body.onselectstart = document.body.ondrag = function (e) {
        e = e || window.event;
        var t = e.target || e.srcElement;
        if (t.tagName && t.tagName.toLowerCase() != "input") {
            return false;
        }
    };
    down = "mousedown";
    end = "mouseup";
    if(window.TouchEvent && document.hasOwnProperty("ontouchstart")){
        down = "touchstart";
        end = "touchend";
    }

    if (!divs) {
        divs = document.getElementsByTagName("div");
    }

    document.onkeypress = keypress;         //绑定键盘输入
    document.onkeydown = keydown;           //绑定键盘功能键

    for (var i in divs) {
        if (divs[i]) {
            //绑定按键的事件
            if (divs[i].className == "table") {
                addEvent(divs[i], down, click_down_btn, false);
                addEvent(divs[i], end, click_end_btn, false);
                btns[btns.length] = divs[i];
                continue;
            }

            //绑定go按钮事件
            if (divs[i].className == "go" || divs[i].className == "go radius") {
                addEvent(divs[i], down, click_go, false);
                go_dom = divs[i];
                continue;
            }

            //绑定menu菜单按钮事件
            if (divs[i].className == "menu" || divs[i].className == "menu radius") {
                addEvent(divs[i], down, click_menu, false);
                go_dom = divs[i];
                continue;
            }

            //绑定录入显示栏菜单按钮事件
            if (divs[i].className == "show" || divs[i].className == "show radius") {
                show_dom = divs[i];
                continue;
            }
        }
    }

    result_dom = document.getElementById("show_result");
	/*
    result_dom = document.getElementsByTagName("input")[0];
    //绑定result_dom的点击事件
    addEvent(result_dom, end, function (e) {
        e = e || window.event;
        var t = e.target || e.srcElement;
        t.select();
    }, false);
	*/
	
	
	//还原上次输入的记录
	var last_info = info_storage("show_val");
	if(last_info){
		show_val = last_info;
		show_dom.innerHTML = to_html(show_val);
	}

	link_rotation();		//顶部右侧的轮播
};

//按下按钮：改变按钮样式并触发按键
function click_down_btn(e) {
    e = e || window.event;
    var t = e.target || e.srcElement;
    if (!t.getAttribute("btn-data")) {
        t = t.parentNode;
        if (!t.getAttribute("btn-data")) {
            t = t.parentNode;
			if (!t.getAttribute("btn-data")) {
				t = t.parentNode;
			}
        }
    }
    t.className = "table click-down";

    var btn_val = t.getAttribute("btn-data");
    if (!btn_val) {
        btn_val = t.parentNode.getAttribute("btn-data");
        if (!btn_val) {
            btn_val = t.parentNode.parentNode.getAttribute("btn-data");
        }
    }
    if(btn_val == "d" || btn_val == "dele"){
        clear_show = setTimeout(function(){     //清空show内容
            show_val = "";
            show_dom.innerHTML = "";
            result_dom.value = "";
        }, 500);
    }
    add_write(btn_val);
}

//放开按钮：复原按钮样式
function click_end_btn(e) {
    e = e || window.event;
    var t = e.target || e.srcElement;
    if (!t.getAttribute("btn-data")) {
        t = t.parentNode;
        if (!t.getAttribute("btn-data")) {
            t = t.parentNode;
			if (!t.getAttribute("btn-data")) {
				t = t.parentNode;
			}
        }
    }
    t.className = "table";
    try{
        clearTimeout(clear_show);
    }catch(e){}
}

//键盘输入事件
function keypress(e) {
    var currKey = 0, CapsLock = 0, e = e || event;
    currKey = e.keyCode || e.which || e.charCode;
    CapsLock = currKey >= 65 && currKey <= 90;
    switch (currKey) {
        //屏蔽了退格、制表、回车、空格、方向键、删除键
        case 8:
        case 9:
        case 13:
        case 32:
        case 37:
        case 38:
        case 39:
        case 40:
        case 46:
            keyName = "";
            break;
        default:
            keyName = String.fromCharCode(currKey);
            break;
    }
    add_write(keyName);
}

//键盘功能键按下事件
function keydown(e) {
    var e = e || event;
    var currKey = e.keyCode || e.which || e.charCode;
    if (currKey == 8 || currKey == 32 || currKey == 37) {
        //退格、空格、方向键左
        add_write("d");
    } else if (currKey == 46 ) {
        //删除 = 清空show内容
        show_val = "";
        show_dom.innerHTML = "";
    } else if (currKey == 13) {
        add_write("=");
    } else {
    }
}

//追加数学式录入
function add_write(btn_val) {
    if (btn_val !== "") {
        result_dom.style.color = "#999999";
        btn_val = btn_val.toLowerCase();
        if (btn_val == "=") {
            try {
                result_val = eval(to_formula(show_val));
				
				// 非e- 且小数位超过10位
				result_val = String(result_val);
				if( result_val.indexOf("e") == -1 
					|| result_val.indexOf("e-") != -1 ){		
					var point_num = result_val.indexOf(".");
					if( (result_val.substring(point_num)).length > 10){
						var temp = result_val.substr(point_num+10, 4);
						if(temp.length == 4){
							var temp_first = temp.substr(0, 1);
							if( temp == temp_first+temp_first+temp_first+temp_first ){
								if(result_val.indexOf("e-") != -1){
									temp = result_val.split("e-");
									result_val = Math.round(1000000000*temp[0])/1000000000;
									result_val = String(result_val) + "e-" + temp[1];
								}else{
									result_val = Math.round(1000000000*result_val)/1000000000;
								}
							}
						}
					}
				}
				
                if(result_val == "Infinity" || result_val == "NaN" ){     //为 NaN
                    result_dom.value = "";
                    show_dom.style.color = "red";
                    setTimeout(function () {
                        show_dom.style.color = "";
                    }, 1000);
                } else {
                    result_dom.style.color = "#ffffff";
                    result_dom.value = result_val;
                }
            } catch (e) {
                result_dom.value = "";
                show_dom.style.color = "red";
                setTimeout(function () {
                    show_dom.style.color = "";
                }, 1000);
                return false;
            }
            return true;
        } else if (btn_val == "x" || btn_val == "X" || btn_val == "×" || btn_val == "*") {
            btn_val = "*";
        } else if (btn_val == "/" || btn_val == "÷") {
            btn_val = "/";
        } else if (btn_val == "i" || btn_val == "inverse") {        // 1/x
            btn_val = "i";
        } else if (btn_val == "p" || btn_val == "pow") {            // x2
            btn_val = "p";
        } else if (btn_val == "s" || btn_val == "sqrt") {           // v— √
            btn_val = "s";
        } else if (btn_val == "d" || btn_val == "dele") {           // <-
            btn_val = "";
            show_val = show_val.substring(0, show_val.length - 1);
        } else if (btn_val == "." || btn_val == "," || btn_val == "，" || btn_val == "。") {
            btn_val = ".";
        } else if (/[\d\-\+]/.test(btn_val)) {
            btn_val = btn_val;
        } else {
            return false;
        }
        if(btn_val !== ""){
            if(!check_write(btn_val)){
                show_dom.style.color = "red";
                setTimeout(function () {
                    show_dom.style.color = "";
                }, 1000);
                return false;
            }
            show_val += btn_val;
        }
		
		info_storage("show_val", show_val);		//记录输入记录
		
        show_dom.innerHTML = to_html(show_val);
    }
}

//按键输入前判断规则
function check_write(val) {
    if (show_val === "") {      //首字符只能是数字或减号
        if (/[\d\-]/.test(val)) {
            return true;
        } else {
            return false;
        }
    } else {                    //非首字符
        var last = show_val.substr(-1, 1);
        var exp = "";

        if (val == ".") {      // 点号 前只能：\d 且前面的整个数字不能含有\.
            if( /[\+\-\*\/]?\d+\.\d+$/.test(show_val) ){
                exp = /false/;
            } else {
                exp = /\d/;
            }

        } else if (val == "-") {                // 减号 前只能：+ || - || * || / || \d || i || p || s 且不能是连续2个[+-*/]
            var last2 = show_val.substr(-2, 2);
            if (/^[\+\-\*\/]?\-$/.test(last2) ){
                exp = /false/;      //return false;
            } else {
                exp = /[\+\-\*\/\dips]/;
            }

        } else if (val == "/") {                // 除号 前只能：\d || i || q || s
            exp = /[\dips]/;

        } else if (val == "s") {                // s 前只能：\d || i || q || s 且不能作用负数
            if (/[\+\-\*\/]\-\d+(\.\d+)?i*$/.test(show_val) ){
                exp = /false/;      //return false;
            } else if(/^\-\d+(.\d+)?i*$/.test(show_val) ){
                exp = /false/;      //return false;
            } else {
                exp = /[\dips]/;
            }

        } else if (/^\d/.test(val)) {           // 数字前只能：+ || - || * || / || \d || . 且前2个不能为[\+\-\*\/]0||0
            exp = /[\+\-\*\/\d\.]/;

        } else if (/^[\+\*]/.test(val)) {       // +× 前只能：\d || i || q || s
            exp = /[\dips]/;

        } else if (/^[ip]/.test(val)) {         // i p 前只能：\d || i || q || s
            exp = /[\dips]/;

        } else {
            exp = /false/;
        }
        return exp.test(last);
    }
}

//点击go按钮
function click_go() {
    show_val = result_dom.value;
    show_dom.innerHTML = result_dom.value;
    result_dom.value = "";
}

//将show_val转成数学式
function to_formula(sval) {
    if (typeof(sval) == "undefined") {
        sval = show_val;
    }
    if (sval.length < 2) {
        return sval;
    }
    sval = sval.replace(/^\-(\d+\.?\d*)/g, "$1m");                      //整理负数格式
    sval = sval.replace(/([\+\-\*\/])\-(\d+\.?\d*)/g, "$1$2m");       //整理负数格式

    var while_limit = 0;                                         //预防意外无限循环
    while ((sval.indexOf("i") != -1 || sval.indexOf("s") != -1 || sval.indexOf("p") != -1 || sval.indexOf("m") != -1) && while_limit < 999) {
        while_limit++;
        sval = sval.replace(/[^\+\-\*\/\(misp\d\.]?([misp\d\.]+)([misp])/g, function (mate, inner, symbol, start, full) {
                    switch (symbol) {
                        case "i":
                            return "(1/" + inner + ")";
                            break;
                        case "s":
                            return "MATH.SQRT(" + inner + ")";
                            break;
                        case "p":
                            return "(" + inner + "*" + inner + ")";
                            break;
                        case "m":
                            return "(-" + inner + ")";
                            break;
                        default :
                            return mate;
                    }
                }
        );
    }
    sval = sval.replace(/MATH\.SQRT/g, "Math.sqrt");       //整理Math的函数名为小写
    return sval;
}

//将数学式转成html代码
function to_html(sval) {
    if (typeof(sval) == "undefined") {
        sval = show_val;
    }
    if (sval.length < 2) {
        return sval;
    }
    sval = sval.replace(/^\-(\d+\.?\d*)/g, "$1m");                      //整理负数格式
    sval = sval.replace(/([\+\-\*\/])\-(\d+\.?\d*)/g, "$1$2m");       //整理负数格式

    sval = sval.replace(/\*/g, "×");            //替换乘号
    sval = sval.replace(/\//g, "÷");            //替换除号
    var while_limit = 0;                                         //预防意外无限循环
    while ((sval.indexOf("i") != -1 || sval.indexOf("s") != -1 || sval.indexOf("p") != -1 || sval.indexOf("m") != -1) && while_limit < 999) {
        while_limit++;
        sval = sval.replace(/[^×÷>\+\-\*\/\(misp\d\.]?([misp\d\.]+)([misp])/g, function (mate, inner, symbol, start, full) {
                    switch (symbol) {
                        case "i":
                            return "(1/" + inner + ")";
                            break;
                        case "s":
                            return "√<SPAN CLASS=\"SQRT\">" + inner + "</SPAN>";
                            break;
                        case "p":
                            return "(" + inner + ")<SUP>2</SUP>";
                            break;
                        case "m":
                            return "(-" + inner + ")";
                            break;
                        default :
                            return mate;
                    }
                }
        );
    }
    sval = sval.toLocaleLowerCase();            //全部转成小写
    //sval = sval.replace(/#/g, "/");              //替换分号
    return sval;
}

//通用的添加事件函数，支持浏览器兼容
function addEvent(elm, evType, fn, useCapture) {
    if (elm.addEventListener) {
        elm.addEventListener(evType, fn, useCapture);//DOM2.0
        return true;
    }
    else if (elm.attachEvent) {
        var r = elm.attachEvent("on" + evType, fn);//IE5+
        return r;
    }
    else {
        elm["on" + evType] = fn;//DOM 0
    }
}

//剔除字符串两端空格
function js_trim(str){
	return str.replace(/(^\s*)|(\s*$)/g,"");
}


var storage_type = "";
//储存、读取信息
function info_storage(name, value){
	if(!storage_type){
		if(localStorageSupported()){
			storage_type = "local";
			use_local("storage_type", "local");
			return use_local(name, value);
		}else{
			storage_type = "cookie";
			use_local("storage_type", "cookie");
			return use_cookie(name, value);
		}
	}else{
		if(storage_type == "cookie"){
			return use_cookie(name, value);
		}else{
			return use_local(name, value);
		}
	}
}
//判断是否支持本地存储（local storage）
function localStorageSupported() { 
	try { 
		return ('localStorage' in window && window['localStorage'] != null);
	} catch(e) {} 
	return false;
}

//使用cookie方式记录和获取记录
function use_cookie(name, value, options) {
    if (typeof value != 'undefined') {
        options = options || {};
        if (value === null) {
            value = '';
            options.expires = -1;
        } else {
            options.expires = 9000;     //有效天数，默认设置
        }
        var expires = '';
        if (options.expires && (typeof options.expires == 'number' || options.expires.toUTCString)) {
            var date;
            if (typeof options.expires == 'number') {
                date = new Date();
                date.setTime(date.getTime() + (options.expires * 24 * 60 * 60 * 1000));
            } else {
                date = options.expires;
            }
            expires = '; expires=' + date.toUTCString();
        }
        var path = options.path ? '; path=' + options.path : '';
        var domain = options.domain ? '; domain=' + options.domain : '';
        var secure = options.secure ? '; secure' : '';
        try {
            document.cookie = [name, '=', encodeURIComponent(value), expires, path, domain, secure].join('');
        } catch (e) {
            return false;
        }
        return true;
    } else {
        var cookieValue = null;
        if (document.cookie && document.cookie != '') {
            var cookies = document.cookie.split(';');
            for (var i = 0; i < cookies.length; i++) {
                var cookie = js_trim(cookies[i]);
                if (cookie.substring(0, name.length + 1) == (name + '=')) {
                    cookieValue = decodeURIComponent(cookie.substring(name.length + 1));
                    break;
                }
            }
        }
        return cookieValue;
    }
}

//使用localStorage方式记录和获取记录
function use_local(name, value, options) {
    if (typeof value != 'undefined') {
        try {
            if (value === null) {
                localStorage.removeItem(name);
            } else {
                localStorage.setItem(name, value);
            }
        } catch (e) {
            return false;
        }
        return true;
    } else {
        var getValue = localStorage.getItem(name);
        return getValue;
    }
}


//顶部右侧的轮播
var link = "",link_num = 0;
var link_content = [
	"如意盒 ruyihe.com", 
	"创造如意 分享如意",
	"Create luck Share luck"
];
function link_rotation(){
	if(!link){
		link = document.getElementById("link_show");
		if(!link){
			return false;
		}
	}else{
		link.innerHTML = link_content[link_num];
		link_num++;
		if(link_num >= link_content.length){
			link_num = 0;
		}
	}
	setTimeout(function(){link_rotation()}, 5000);
}
