/*
* Copyright (c) 2014 Luke Montalvo <lukemontalvo@gmail.com>
*
* This file is part of Really Great Balloons.
* Really Great Balloons is free software and comes with ABSOLUTELY NO WARANTY.
* See LICENSE for more details.
*/

// Load resources
function draw() {} // This will be defined later in main.js
var logo = new Image();
logo.src = "sprites/loading.png";
logo.z = 16;
function drawLoading()
{
	drawImage(logo, windowWidth/2-logo.width/2*logo.z, windowHeight/2-logo.height/2*logo.z, logo.z, logo.z);
}
sprlnum = sprnum = 0;
function Sprite(src, zx, zy)
{
	sprnum++;
	var img = new Image();
	img.src = src;
	
	img.zoom = function(zx, zy) {
		this.zx = zx || this.zx || 1;
		this.zy = zy || this.zy || 1;
		this.w = this.width*this.zx;
		this.h = this.height*this.zy;
	}
	img.zoom(zx, zy);
	
	img.onload = function() {
		sprlnum++;
		ifloaded();
	}
	return img;
}
function loadSprites()
{
	spr_nozzle = new Sprite("sprites/nozzle.png");
	spr_red_balloon = new Sprite("sprites/red_balloon.png");
	spr_green_balloon = new Sprite("sprites/green_balloon.png");
	spr_blue_balloon = new Sprite("sprites/blue_balloon.png");
}

// Handle resources
if (!window.requestAnimationFrame)
{
	window.requestAnimationFrame = (function() {
			return window.mozRequestAnimationFrame ||
				window.webkitRequestAnimationFrame ||
				window.oRequestAnimationFrame ||
				function () {
					setTimeout(draw, 1000/60);
				};
		})();
}
function requestAnimFrame()
{
	return window.requestAnimationFrame(draw);
}
function drawImage(spr, x, y, zx, zy)
{
	if (!zx)
	{
		zx = spr.zx || 1;
	}
	if (!zy)
	{
		zy = spr.zy || 1;
	}
	if (zx < 0) {zx = 1;}
	if (zy < 0) {zy = 1;}
	
	var w = spr.width, h = spr.height;
	context.drawImage(spr, 0, 0, w, h, x, y, w*zx, h*zy);
}
