/*
* Copyright (c) 2014 Luke Montalvo <lukemontalvo@gmail.com>
*
* This file is part of Really Great Balloons.
* Really Great Balloons is free software and comes with ABSOLUTELY NO WARANTY.
* See LICENSE for more details.
*/

var windowWidth = window.innerWidth, windowHeight = window.innerHeight;
var canvas, context;
var spr_nozzle, spr_red_balloon, spr_green_balloon, spr_blue_balloon;

// Define all game variables
var rbtime, gbtime, bbtime;
var rbrelease, gbrelease, bbrelease;
var rbscore, gbscore, bbscore;
var rbcur, gbcur, bbcur;
var score, starttime, blurstart;
var timelimit = 20, timeleft = timelimit, blurtime = 0;
resetgame();
var showinstructions = true, hasfocus = true;
function resetgame()
{
	rbtime = new Array([(new Date()).getTime()]);
	gbtime = new Array([(new Date()).getTime()]);
	bbtime = new Array([(new Date()).getTime()]);
	rbrelease = gbrelease = bbrelease = false;
	
	rbscore = new Array([0]);
	gbscore = new Array([0]);
	bbscore = new Array([0]);
	rbcur = gbcur = bbcur = 0;
	
	score = 0;
	starttime = (new Date()).getTime();
	blurstart = 0;
	blurtime = 0;
	timeleft = timelimit;
	
	showinstructions = false; // Only show the instructions the first time
	hasfocus = true;
}

function resize()
{
	// Reset all width- and height-related variables
	windowWidth = window.innerWidth;
	windowHeight = window.innerHeight;
	canvas.setAttribute("width", windowWidth);
	canvas.setAttribute("height", windowHeight);
	
	// Reset all other variables that are affected by the resize
	context.ImageSmoothingEnabled = context.mozImageSmoothingEnabled = 
		context.webkitImageSmoothingEnabled = context.oImageSmoothingEnabled = false;
}
function draw()
{
	if (!hasfocus)
	{
		return;
	}
	
	// Clear screen
	context.clearRect(0, 0, canvas.width, canvas.height);
	
	// Draw instructions
	if (showinstructions)
	{
		context.fillStyle = "#666666"; // Set color to gray
		context.font = "2em Courier New Bold";
		var t = "Click each balloon to release it and earn points!";
		var mt = context.measureText(t);
		context.fillText(t, windowWidth/2-mt.width/2, 300);
		context.fillStyle = "#000000"; // Reset color to black
	}
	
	// Draw nozzles at bottom of screen
	drawImage(spr_nozzle, 1*windowWidth/4-spr_nozzle.width/2, windowHeight-spr_nozzle.height);
	drawImage(spr_nozzle, 2*windowWidth/4-spr_nozzle.width/2, windowHeight-spr_nozzle.height);
	drawImage(spr_nozzle, 3*windowWidth/4-spr_nozzle.width/2, windowHeight-spr_nozzle.height);
	
	// Calculate possible scores and draw balloons
	if (timeleft > 0)
	{
		// Each score decreases logaritmically but at different rates
		rbscore[rbcur] = ((new Date()).getTime() - rbtime[rbcur])*5;
		rbscore[rbcur] = Math.log(rbscore[rbcur]);
		gbscore[gbcur] = ((new Date()).getTime() - gbtime[gbcur])/40;
		gbscore[gbcur] = Math.log(gbscore[gbcur])*2;
		bbscore[bbcur] = ((new Date()).getTime() - bbtime[bbcur])/60;
		bbscore[bbcur] = Math.log(bbscore[bbcur])*3;
	}
	else // Time's up, deflate balloons
	{
		if (!rbrelease) // if rb's not released, decrease until insignificant
		{
			rbscore[rbcur] = ((new Date()).getTime() - rbtime[rbcur]);
			rbscore[rbcur] = spr_red_balloon.w/Math.log(rbscore[rbcur])/Math.E;
			if (rbscore[rbcur]*10 < 1)
			{
				rbscore[rbcur] = 0;
			}
		}
		else // if rb's already released, continue the flight upward
		{
			rbscore[rbcur] = ((new Date()).getTime() - rbtime[rbcur])*5;
			rbscore[rbcur] = Math.log(rbscore[rbcur]);
			drawImage(spr_red_balloon, 1*windowWidth/4-spr_red_balloon.w/2, windowHeight-spr_red_balloon.h-spr_nozzle.h-rbscore[rbcur]*75);
		}
		if (!gbrelease) // if gb's not released, decrease until insignificant
		{
			gbscore[gbcur] = ((new Date()).getTime() - gbtime[gbcur]);
			gbscore[gbcur] = spr_green_balloon.w/Math.log(gbscore[gbcur])/Math.E;
			if (gbscore[gbcur]*10 < 1)
			{
				gbscore[gbcur] = 0;
			}
		}
		else // if rb's already released, continue the flight upward
		{
			gbscore[gbcur] = ((new Date()).getTime() - gbtime[gbcur])/40;
			gbscore[gbcur] = Math.log(gbscore[gbcur])*2;
			drawImage(spr_green_balloon, 2*windowWidth/4-spr_green_balloon.w/2, windowHeight-spr_green_balloon.h-spr_nozzle.h-gbscore[gbcur]*75);
		}
		if (!bbrelease) // if bb's not released, decrease until insignificant
		{
			bbscore[bbcur] = ((new Date()).getTime() - bbtime[bbcur]);
			bbscore[bbcur] = spr_blue_balloon.w/Math.log(bbscore[bbcur])/Math.E;
			if (bbscore[bbcur]*10 < 1)
			{
				bbscore[bbcur] = 0;
			}
		}
		else // if bb's already released, continue the flight upward
		{
			bbscore[bbcur] = ((new Date()).getTime() - bbtime[bbcur])/40;
			bbscore[bbcur] = Math.log(bbscore[bbcur])*2;
			drawImage(spr_blue_balloon, 3*windowWidth/4-spr_blue_balloon.w/2, windowHeight-spr_blue_balloon.h-spr_nozzle.h-bbscore[bbcur]*75);
		}
	}
	
	if (!rbrelease) // if rb's not released, draw it above the nozzle
	{
		spr_red_balloon.zoom(rbscore[rbcur], rbscore[rbcur]); // Inflate the balloon
		drawImage(spr_red_balloon, 1*windowWidth/4-spr_red_balloon.w/2, windowHeight-spr_red_balloon.h-spr_nozzle.h);
	}
	else if (timeleft > 0) // if rb's released, draw it on an upward path
	{
		drawImage(spr_red_balloon, 1*windowWidth/4-spr_red_balloon.w/2, windowHeight-spr_red_balloon.h-spr_nozzle.h-rbscore[rbcur]*75);
		if (windowHeight-spr_nozzle.h-rbscore[rbcur]*75 <= 0) // if rb's offscreen, reset it
		{
			rbtime[rbcur] = (new Date()).getTime();
			rbscore[rbcur] = 0;
			rbrelease = false;
		}
	}
	if (!gbrelease) // if gb's not released, draw it above the nozzle
	{
		spr_green_balloon.zoom(gbscore[gbcur], gbscore[gbcur]); // Inflate the balloon
		drawImage(spr_green_balloon, 2*windowWidth/4-spr_green_balloon.w/2, windowHeight-spr_green_balloon.h-spr_nozzle.h);
	}
	else if (timeleft > 0) // if gb's released, draw it on an upward path
	{
		drawImage(spr_green_balloon, 2*windowWidth/4-spr_green_balloon.w/2, windowHeight-spr_green_balloon.h-spr_nozzle.h-gbscore[gbcur]*75);
		if (windowHeight-spr_nozzle.h-gbscore[gbcur]*75 <= 0) // if gb's offscreen, reset it
		{
			gbtime[gbcur] = (new Date()).getTime();
			gbscore[gbcur] = 0;
			gbrelease = false;
		}
	}
	if (!bbrelease) // if bb's not released, draw it above the nozzle
	{
		spr_blue_balloon.zoom(bbscore[bbcur], bbscore[bbcur]); // Inflate the balloon
		drawImage(spr_blue_balloon, 3*windowWidth/4-spr_blue_balloon.w/2, windowHeight-spr_blue_balloon.h-spr_nozzle.h);
	}
	else if (timeleft > 0) // if bb's released, draw it on an upward path
	{
		drawImage(spr_blue_balloon, 3*windowWidth/4-spr_blue_balloon.w/2, windowHeight-spr_blue_balloon.h-spr_nozzle.h-bbscore[bbcur]*75);
		if (windowHeight-spr_nozzle.h-bbscore[bbcur]*75 <= 0) // if bb's offscreen, reset it
		{
			bbtime[bbcur] = (new Date()).getTime();
			bbscore[bbcur] = 0;
			bbrelease = false;
		}
	}
	
	// Draw scores on top of all balloons
	if (timeleft > 0) // only draw scores if the game is currently running
	{
		context.font = "3em Courier New Bold";
		if (!rbrelease) // red balloon
		{
			var t = Math.round(rbscore[rbcur]), mt = context.measureText(t);
			context.fillText(t, 1*windowWidth/4-mt.width/2, windowHeight-spr_red_balloon.h/2-24);
		}
		if (!gbrelease) // green balloon
		{
			var t = Math.round(gbscore[gbcur]), mt = context.measureText(t);
			context.fillText(t, 2*windowWidth/4-mt.width/2, windowHeight-spr_green_balloon.h/2-24);
		}
		if (!bbrelease) // blue balloon
		{
			var t = Math.round(bbscore[bbcur]), mt = context.measureText(t);
			context.fillText(t, 3*windowWidth/4-mt.width/2, windowHeight-spr_blue_balloon.h/2-24);
		}
	}
	else // Time's up, draw retry text
	{
		context.font = "4em Courier New Bold";
		var t = "Try again?", mt = context.measureText(t);
		context.fillText(t, windowWidth/2-mt.width/2, 300);
		showinstructions = false;
	}
	
	// Draw score
	context.font = "5em Courier New Bold";
	var t = "Score: "+score, mt = context.measureText(t);
	context.fillText(t, windowWidth/2-mt.width/2, 100);
	
	// Draw time
	timeleft = timelimit - Math.round(((new Date()).getTime() - starttime - blurtime)/1000); // Adjust remaining time
	if (timeleft < 0)
	{
		timeleft = 0;
	}
	if (timeleft < timelimit/3)
	{
		context.fillStyle = "#FF9900"; // Set color to orange
	}
	if (timeleft < timelimit/5)
	{
		context.fillStyle = "#FF0000"; // Set color to red
	}
	t = "Time: "+timeleft, mt = context.measureText(t);
	context.fillText(t, windowWidth/2-mt.width/2, 200);
	context.fillStyle = "#000000"; // Reset color to black
	
	// Continue drawing
	requestAnimFrame();
}
function ifloaded()
{
	if (sprlnum == sprnum) // if all sprites are loaded, start animating
	{
		requestAnimFrame();
	}
	else // otherwise, continue drawing the loading logo
	{
		drawLoading();
	}
}

function handleKeyUp(e)
{
	switch (String.fromCharCode(e.which))
	{
		case "1": // Release rb
			if (!rbrelease)
			{
				rbrelease = true;
				score += Math.round(rbscore[rbcur]);
				rbcur++;
				rbtime[rbcur] = (new Date()).getTime();
				rbscore[rbcur] = 0;
			}
			break;
		case "2": // Release gb
			if (!gbrelease)
			{
				gbrelease = true;
				score += Math.round(gbscore[gbcur]);
				gbcur++;
				gbtime[gbcur] = (new Date()).getTime();
				gbscore[gbcur] = 0;
			}
			break;
		case "3": // Release bb
			if (!bbrelease)
			{
				bbrelease = true;
				score += Math.round(bbscore[bbcur]);
				bbcur++;
				bbtime[bbcur] = (new Date()).getTime();
				bbscore[bbcur] = 0;
			}
			break;
		case " ": // Reset the game
			resetgame();
			break;
	}
}
function handleMouseMove(e)
{
	// Define coordinates
	var x = e.clientX, y = e.clientY;
	var rx = 1*windowWidth/4-spr_red_balloon.w/2, ry = windowHeight-spr_red_balloon.h-spr_nozzle.h;
	var rw = spr_red_balloon.w, rh = spr_red_balloon.h;
	var gx = 2*windowWidth/4-spr_green_balloon.w/2, gy = windowHeight-spr_green_balloon.h-spr_nozzle.h;
	var gw = spr_green_balloon.w, gh = spr_green_balloon.h;
	var bx = 3*windowWidth/4-spr_blue_balloon.w/2, by = windowHeight-spr_blue_balloon.h-spr_nozzle.h;
	var bw = spr_blue_balloon.w, bh = spr_blue_balloon.h;
	
	var cursor = "auto";
	
	if ((x >= rx)&&(y >= ry)&&(x <= rx+rw)&&(y <= ry+rh)) // if within rb, set pointing cursor
	{
		cursor = "pointer";
	}
	if ((x >= gx)&&(y >= gy)&&(x <= gx+gw)&&(y <= gy+gh)) // if within gb, set poiting cursor
	{
		cursor = "pointer";
	}
	if ((x >= bx)&&(y >= by)&&(x <= bx+bw)&&(y <= by+bh)) // if within bb, set pointing cursor
	{
		cursor = "pointer";
	}
	
	if (timeleft == 0)
	{
		var t = "Try again?", mt = context.measureText(t);
		var tx = windowWidth/2-mt.width/2, ty = 200;
		var tw = mt.width, th = 100;
		if ((x >= tx)&&(y >= ty)&&(x <= tx+tw)&&(y <= ty+th)) // if within try again box, set pointing cursor
		{
			cursor = "pointer";
		}
	}
	
	document.body.style.cursor = cursor; // Officially set the cursor style
}
function handleMouseDown(e)
{
	// Define coordinates
	var x = e.clientX, y = e.clientY;
	var rx = 1*windowWidth/4-spr_red_balloon.w/2, ry = windowHeight-spr_red_balloon.h-spr_nozzle.h;
	var rw = spr_red_balloon.w, rh = spr_red_balloon.h;
	var gx = 2*windowWidth/4-spr_green_balloon.w/2, gy = windowHeight-spr_green_balloon.h-spr_nozzle.h;
	var gw = spr_green_balloon.w, gh = spr_green_balloon.h;
	var bx = 3*windowWidth/4-spr_blue_balloon.w/2, by = windowHeight-spr_blue_balloon.h-spr_nozzle.h;
	var bw = spr_blue_balloon.w, bh = spr_blue_balloon.h;
	
	if ((x >= rx)&&(y >= ry)&&(x <= rx+rw)&&(y <= ry+rh)) // if within rb, release it
	{
		if ((!rbrelease)&&(timeleft > 0))
		{
			rbrelease = true;
			score += Math.round(rbscore[rbcur]);
			rbcur++;
			rbtime[rbcur] = (new Date()).getTime();
			rbscore[rbcur] = 0;
		}
	}
	if ((x >= gx)&&(y >= gy)&&(x <= gx+gw)&&(y <= gy+gh)) // if within gb, release it
	{
		if ((!gbrelease)&&(timeleft > 0))
		{
			gbrelease = true;
			score += Math.round(gbscore[gbcur]);
			gbcur++;
			gbtime[gbcur] = (new Date()).getTime();
			gbscore[gbcur] = 0;
		}
	}
	if ((x >= bx)&&(y >= by)&&(x <= bx+bw)&&(y <= by+bh)) // if within bb, release it
	{
		if ((!bbrelease)&&(timeleft > 0))
		{
			bbrelease = true;
			score += Math.round(bbscore[bbcur]);
			bbcur++;
			bbtime[bbcur] = (new Date()).getTime();
			bbscore[bbcur] = 0;
		}
	}
	
	if (timeleft == 0)
	{
		var t = "Try again?", mt = context.measureText(t);
		var tx = windowWidth/2-mt.width/2, ty = 200;
		var tw = mt.width, th = 100;
		if ((x >= tx)&&(y >= ty)&&(x <= tx+tw)&&(y <= ty+th)) // if within try again box, reset game
		{
			resetgame();
		}
	}
}

function handleBlur(e)
{
	blurstart = (new Date()).getTime() - blurtime; // Set new blur start with previous blur time
	hasfocus = false;
}
function handleFocus(e)
{
	if (!hasfocus)
	{
		blurtime = (new Date()).getTime() - blurstart; // Set blur time
		hasfocus = true;
		requestAnimFrame(); // Continue drawing
	}
}

function main()
{
	// Define canvas-related variables
	canvas = document.getElementById("maincan");
	context = canvas.getContext("2d");
	resize();
	window.addEventListener("resize", resize);
	
	// Load resources
	drawLoading();
	loadSprites();
	
	window.addEventListener("keyup", handleKeyUp);
	window.addEventListener("mousemove", handleMouseMove);
	window.addEventListener("mousedown", handleMouseDown);

	window.addEventListener("blur", handleBlur);
	window.addEventListener("focus", handleFocus);
	
	// Draw everything
	ifloaded();
}

main();
