var markers = [];

function localizame() {
    if (navigator.geolocation) { /* Si el navegador tiene geolocalizacion */
        navigator.geolocation.getCurrentPosition(coordenadas, errores, { maximumAge: 5000, timeout: 4000 });
    } else {
        //Navegador sin localización
        getMap();
        //loadBranches();
    }
}

//Si se pudo obtener la posición
function coordenadas(position) {
    latitud = position.coords.latitude; /*Guardamos nuestra latitud*/
    longitud = position.coords.longitude; /*Guardamos nuestra longitud*/
    getMapLocalized();
    //loadBranches();
} 

//Si no se pudo obtener la posición  
function errores(err) {
    getMap();
    //loadBranches();
}

function deleteMarkers() {
    for (var i = 0; i < markers.length; i++) {
        markers[i].setMap(null);
    }
    markers = [];
}

//Agrega un punto (una sucursal)
function addMarker(latitude, longitude, title, description, attentionTime)
{
        var markerLatLng = new google.maps.LatLng(latitude, longitude);

        //Globo que muestra información al hacerle click
        var contentString = "<div style='color:Black;overflow: hidden;'>"+description+"<BR>"+title+"<BR>"+attentionTime+"</div>";              
        var infowindow = new google.maps.InfoWindow({ content: contentString });

        var marker = new google.maps.Marker({
            position: markerLatLng,
            title: title,
            map: map,
            draggable: false
        });

        markers.push(marker);

        google.maps.event.addListener(marker, 'click', function () { infowindow.open(map, marker); });
}

var map;
//Mapa sin mi ubicación
function getMap()
{
    //Lo centro inicialmente. TODO: Dónde?
    var latlon = new google.maps.LatLng(-34.894872,-56.164955); 

    /*Configuramos una serie de opciones como el zoom del mapa y el tipo. */
    var myOptions = {
        zoom: 12,
        center: latlon, /* Definimos la posicion del mapa en mi posición actual */
        mapTypeId: google.maps.MapTypeId.ROADMAP
    };

    /*Creamos el mapa y lo situamos en su capa */
    map = new google.maps.Map(document.getElementById("map_canvas"), myOptions);

//    google.maps.event.addListenerOnce(map, 'tilesloaded', function () {
//        loadBranches();
//    });
}

//Mapa centrado en mi ubicación
function getMapLocalized()
{
    /* Creamos un punto con nuestras coordenadas */
    var latlon = new google.maps.LatLng(latitud, longitud); 

    /*Configuramos una serie de opciones como el zoom del mapa y el tipo. */
    var myOptions = {
        zoom: 14,
        center: latlon, /* Definimos la posicion del mapa en mi posición actual */
        mapTypeId: google.maps.MapTypeId.ROADMAP
    };

    /*Creamos el mapa y lo situamos en su capa */
    map = new google.maps.Map(document.getElementById("map_canvas"), myOptions);

    google.maps.event.addListenerOnce(map, 'tilesloaded', function () {
        loadBranches();
    });

    //Color del globito con mi posición
    var pinColor = "90EE90"; //Verde
    var pinImage = new google.maps.MarkerImage(
        "http://chart.apis.google.com/chart?chst=d_map_pin_letter&chld=%E2%80%A2|" + pinColor,
        new google.maps.Size(21, 34),
        new google.maps.Point(0,0),
        new google.maps.Point(10, 34));

    //Agrego mi ubicación actual
    var marcador = new google.maps.Marker({                
        position: new google.maps.LatLng(latitud, longitud),  /*Lo situamos en nuestro punto */
        map: map, /* Lo vinculamos a nuestro mapa */
        icon: pinImage,
        title: "Mi ubicación actual"
    });
}