﻿// tabpage
function setTab(name, cursel, n) {
	for (i = 1; i <= n; i++) {
		var menu = document.getElementById(name + i);
		var con = document.getElementById("con_" + name + "_" + i);
		menu.className = i == cursel ? "hover" : "";
		con.style.display = i == cursel ? "block" : "none";
	}
}

var APP_NAME = 'CSP';

var STATIC_DATA = {
	SOURCE : { // 博文类型
		"":"全部",
		"1" : "新浪微博",
		"2" : "腾讯微博",
		"3" : "网易微博",
		"4" : "搜狐微博",
		"5": "凤凰微博"
	}

}
STATIC_DATA.need_btn = "no";
STATIC_DATA.is_overlay ="no";
STATIC_DATA.fans_count = 5;
STATIC_DATA.friends_count = 5;

function downLoadSelectDatas() {
	$("select[attr_code]").each(function() {
		var attr_code = $(this).attr("attr_code")
		var sub_code=$(this).attr("sub_code");//级联关系
		if(sub_code){
			var me = this;
			(function(me){
				$(me).change(function(){//级联关系，绑定
					$("#"+sub_code).empty();//删除子节点选项
					var sub_attr_code = $("#"+sub_code).attr("attr_code");
					var sub_values = STATIC_DATA[sub_attr_code][$(me).val()];
					if(sub_values){
						for (p in sub_values)
						$("#"+sub_code).append("<option value='" + p + "'>" + sub_values[p] + "</option>");
					}
				})
			})(me);
		};
		var values = STATIC_DATA[attr_code];
		for (p in values){
			if(typeof values[p]=='object')continue;
			$(this).append("<option value='" + p + "'>" + values[p] + "</option>");
		}
	})
}



// 绑定事件名称
function addEventByName(name, parentJq, event_name, call_back) {
	$("[name='" + name + "']", parentJq || document).bind(event_name, call_back);
	return false;
}
// id绑定事件
function addEventById(name, parentJq, event_name, call_back) {
	$("[id='" + name + "']", parentJq || document).bind(event_name, call_back);
	return false;
}
function addEventByExpr(name, parentJq, event_name, call_back) {
	$(name, parentJq || document).bind(event_name, call_back);
	return false;
}
function addClassByName(express,currJq,className) {
	$(express).removeClass(className);
	currJq.addClass(className);
}

function getDayTime(curr_day,type){
	var day = curr_day.substring(0,10);
	var hhmmss  = curr_day.substring(10,19);
	var today =new Date();
	var yyymmdd =today.getYear()+"-"+today.getMonth()+"-"+today.getDate();
	if(type =="J")
		return "今天"+hhmmss;
	else if(type =="Z")
		return "昨天"+hhmmss;
	return curr_day.substring(0,curr_day.length-1);
}

function getChineseDayTime(curr_day){
	
	var today =new Date();
	var curr_year =today.getYear();
	var year = curr_day.substring(0,4);
	var month = curr_day.substring(5,7);
	var day =curr_day.substring(8,10);
	var hour = curr_day.substring(11,13);
	var min =curr_day.substring(14,16);
	var chinese_day='';
	if(curr_year ==year)
		chinese_day =month+'月'+day+'日'+"<br>"+hour+":"+min;
	else
		chinese_day =year+"年"+month+'月'+day+'日'+"<br>"+hour+":"+min;

	return chinese_day;
}

function dealBlogTextinfo(blog_text){
	var html =blog_text;//'// @zaesoftscs: ....额 兄台~~淡定 淡定呀@已支付！仁兄，不要自欺欺人了，你听说过联通、移动收过手机的停机保号费没有';//'|| @zA1esoftscs: ....额 兄台~~淡定 淡定呀@zsoftscs！仁兄，不要自欺欺人了，你听说过联通、移动收过手机的停机保号费没有（未申请的情况下）！';
	
    var arr = html.match(/@[A-Za-z0-9_\u4e00-\u9fa5]+/ig);   // 尝试去匹配搜索字符串。
	var add_br = false;
	
	if(arr!=null)
	{	
		add_br = true;
		for(var i=0;i<arr.length;i++){
			html = html.replace(arr[i],"<span style='color:#0099CC;'>"+arr[i]+"</span>");
		}
	}
	return (add_br ?"&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;":'')+html;
}


//对象字段克隆
function cloneByFields(s,fields){
	s = s || {};
	var cloneData  ={},fields_arr = fields.split(",");
	for(var i=0,field_name;field_name=fields_arr[i++];){
		if(s.length>0){
			s.attr(field_name) &&(cloneData[field_name] = s.attr(field_name) || '');
		}else{
			s[field_name] && (cloneData[field_name] = s[field_name] || '');
		}
	}
	return cloneData;
}

function initEvent(bindMenus){
	for(var i=0,bindMenu;bindMenu=bindMenus[i++];){
		(function(bindMenu){
			addEventById(bindMenu['id'],null,"click",function(){
				bindMenu['click_func']($(this));
			});
		}(bindMenu))
	}
}
	
function correctPNG()  
{  
	   for(var i=0; i<document.images.length; i++) 
	   {
	    var img = document.images[i]
	    var imgName = img.src.toUpperCase()
	    if (imgName.substring(imgName.length-3, imgName.length) == "PNG")
	    {
		    var imgID = (img.id) ? "id='" + img.id + "' " : ""
		    var imgClass = (img.className) ? "class='" + img.className + "' " : "" 
		    var imgTitle = (img.title) ? "title='" + img.title + "' " : "title='" + img.alt + "' "
		    var imgStyle = "display:inline-block;" + img.style.cssText  
		    if (img.align == "left") imgStyle = "float:left;" + imgStyle 
		    if (img.align == "right") imgStyle = "float:right;" + imgStyle  
		    if (img.parentElement.href) imgStyle = "cursor:hand;" + imgStyle 
		    var strNewHTML = "<span " + imgID + imgClass + imgTitle 
		    + " style=\"" + "width:" + img.width + "px; height:" + img.height + "px;" + imgStyle + ";"
		    + "filter:progid:DXImageTransform.Microsoft.AlphaImageLoader"
		    + "(src=\'" + img.src + "\', sizingMethod='scale');\"></span>"
		    img.outerHTML = strNewHTML
		    i = i-1 
	    }; 
	   }; 
 };  
 
// 焦点离开事件
function validateTALen(expressions, parentJq, max_len) {
	
	$(expressions, parentJq).bind("keyup", function() {
		
		var realLength = 0, len = $(this).val().length, charCode = -1;
		for (var i = 0; i < len; i++) {
			charCode = $(this).val().charCodeAt(i);
			if (charCode >= 0 && charCode <= 128)
				realLength += 1;
			else
				realLength += 2;
		}
		if (realLength > max_len) {
			pop({
						"text" : "已超出输入最大限制，不允许再输入，请检查！"
					});
			return;
		}
		$("[name='" + $(this).attr("name") + "_max_len']")
				.text(new Number(max_len) - new Number(realLength));
	})
}




function setTab(attr_name,clickJq,className,context){
	
	var attr_name_value = clickJq.attr(attr_name);
	$("div["+attr_name+"][tab!='li']",context).hide();
	//关联tab页
	if(clickJq.attr("ref_tab")){
		$("div["+attr_name+"='"+clickJq.attr("ref_tab")+"'][tab!='li']",context).show();
	}else
		$("div["+attr_name+"='"+attr_name_value+"'][tab!='li']",context).show();
	
	
	$("li["+attr_name+"],div[tab='li']["+attr_name+"]",context).removeClass(className ? className : 'current');
	clickJq.addClass(className ? className : 'current');
}

function initTab(attr_name,callBack,className,context,intiCallBack){
	context =context || $("body");
	if(typeof(context) =="string")
		context =$("#"+context);
	$("li["+attr_name+"],div[tab='li']["+attr_name+"]",context).bind("click",function(){
		setTab(attr_name,$(this),className,context);
		callBack && callBack($(this)); //回调函数处理
	})
	if (intiCallBack) {
		intiCallBack();
	} else {
		if (attr_name == "rel_tab_icon_w" || attr_name == "rel_tab_icon_hh") return;
		$("li[" + attr_name + "],div[tab='li'][" + attr_name + "]", context).eq(0).trigger("click");
	}
}

//setTabSelected("rel_tab","attention",body)
function setTabSelected(rel_tab_name,rel_tab_value,context){
	context =context || $("body");
	if(typeof(context) =="string")
		context =$("#"+context);
    var attr_name = "["+rel_tab_name+"='"+rel_tab_value+"']";
	$("li"+attr_name+",div[tab='li']"+attr_name+"",context).trigger("click");
}


function bindAnimateEvent(express,aminate_panel_id,event_name,cssparam,context){
	var params = jQuery.extend({"top":0,"left":0} ,cssparam || {});
		context =context || $("body");
	if(typeof(context) =="string")
		context =$("#"+context);
	var timer = null;
	if(event_name =="hover"){
		$(express,context).hover(function(){
			var currJq = $(this);
			var offset = currJq.offset();
			var inputTop = offset.top - document.documentElement.scrollTop;
			var inputLeft = currJq.position().left;
			$("#"+aminate_panel_id).css({top : inputTop+params['top'],left:inputLeft+params['left']});
			$("#"+aminate_panel_id).show();
			//alert($("#"+aminate_panel_id).get(0).outerHTML)
		},function(){
			delay(aminate_panel_id);
		})
		$("#"+aminate_panel_id).hover(function(){
			window.clearTimeout(timer);
		},function(){
			$(this).hide();
		})
	}
	function delay(panel_id){
		timer = window.setTimeout(function(){
			$("[id='"+panel_id+"']").hide();
		},200);
	}
}

function bindEvent(obj, type, fn) {
	if (obj.attachEvent) {
		obj['e' + type + fn] = fn;
		obj[type + fn] = function() {
			obj['e' + type + fn](window.event);
		}
		obj.attachEvent('on' + type, obj[type + fn]);
	} else {
		obj.addEventListener(type, fn, false);
	}
}

//编辑框长度限制 汉字算两个字符长度
function lenLimitValid(str,maxLen,cname)
{
    var len=getStrLen(str);
    if(len > maxLen){
        alert(cname+" 长度不能超过"+maxLen+"个字符,(汉字算两个字符长),请检查!");
        return false;
    }
    return true;
}

function getStrLen(str){
	var len=0;
	for (var i=0;i<str.length;i++){
      if (str.charCodeAt(i)>255)
          len+=2;
      else
          len++;
    }
	return len;
}

VTypes = function() {
	var alpha = /^[a-zA-Z_]+/;
	var numOnly = /^[0-9]+$/;
	var alphanum = /^[a-zA-Z0-9_]+$/;
	var email = /^(\w+)([-+.][\w]+)*@(\w[-\w]*\.){1,5}([A-Za-z]){2,4}$/;
	var url = /(((https?)|(ftp)):\/\/([\-\w]+\.)+\w{2,3}(\/[%\-\w]+(\.\w{2,})?)*(([\w\-\.\?\\\/+@&#;`~=%!]*)(\.\w{2,})?)*\/?)/i;
	var time = /^([1-9]|1[0-9]):([0-5][0-9])(\s[a|p]m)$/i;
	var require = /.+/;
	var number = /^\d+$/;
	var integer = /^[-\+]?\d+$/;
	var double = /^[-\+]?\d+(\.\d+)?$/;
	var alphachinese = /^[a-zA-Z_\u4E00-\u9FA5]+/;
	var isExistNum = /^[a-zA-Z0-9@]*[0-9]+[a-zA-Z0-9@]*$/;
	var mobile = /^1[3|4|5|8][0-9]\d{8}$/;  //手机号码
	var isMixNum = /^[a-zA-Z@]+[0-9]+[a-zA-Z0-9@]*$/;
	var ct_mobile = /^(133|153|180|189)\d{8}$/;
	return {
		'ct_mobile':function(v){
			return ct_mobile.test(v);
		},
	    'mobile' : function(v) {
	        return mobile.test(v);
	    },
	    'mobileText' : '请输入正确的手机号码，如：1890731****',
	    
		'ip' : function(v) {
			return /^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/.test(v)
		},
		'ipText' : '必须为数字IP地址格式:如127.0.0.1',

		'chinese' : function(v) {
			var regix = eval('/[^\u4e00-\u9fa5]/');
			return !regix.test(v + "");

		},
		'chineseText' : '只能输入汉字!',

		'require' : function(v) {
			return require.test(v)
		},
		'requireText' : '必填内容不能为空!',
		'datetime' : function(v) {
			var a = v
					.match(/^(\d{0,4})-(\d{0,2})-(\d{0,2}) (\d{0,2}):(\d{0,2}):(\d{0,2})$/);
			if (a == null) {
				return false;
			}
			if (a[2] >= 13 || a[3] >= 32 || a[4] >= 24 || a[5] >= 60
					|| a[6] >= 60) {
				return false;
			}
			return true;
		},
		'datetimeText' : '日期时间格式必须为0000-00-00 00:00:00 例如1999-11-10 20:30:29.',

		'date' : function(v) {
			var a = v.match(/^(\d{0,4})-(\d{0,2})-(\d{0,2})$/);
			if (a == null) {
				return false;
			}
			if (a[2] >= 13 || a[3] >= 32 || a[4] >= 24 || a[5] >= 60
					|| a[6] >= 60) {
				return false;
			}
			return true;
		},
		'dateText' : '日期时间格式必须为0000-00-00  例如1999-11-10',

		'number' : function(v) {
			return number.test(v);
		},
		'numberText' : '数字格式不正确',

		'integer' : function(v) {
			return integer.test(v);
		},
		'integerText' : '整数格式不正确',

		'double' : function(v) {
			return double.test(v);
		},
		'doubleText' : '小数填写不正确',
		'time' : function(v) {
			var a = v.match(/^(\d{0,2}):(\d{0,2}):(\d{0,2})$/);
			if (a == null) {
				return false;
			}
			if (a[1].length < 2 || a[2].length < 2 || a[3].length < 2) {
				return false;
			}
			if (a[1] >= 24 || a[2] >= 60 || a[3] >= 60) {
				return false;
			}
			return true;
		},
		'timeText' : '时间的格式必须处于00:00:00和23:59:59之间（时间中的:必须为半角格式）.',

		'email' : function(v) {
			return email.test(v);
		},
		'emailText' : '输入格式必须为emal如:"user@example.com"',
		'emailMask' : /[a-z0-9_\.\-@]/i,
		'url' : function(v) {
			return url.test(v);
		},
		'urlText' : '输入格式必须为url 如:"http:/' + '/www.example.com"',

		'alpha' : function(v) {
			return alpha.test(v);
		},
		'numOnly': function(v) {
			return numOnly.test(v);
		},
		'alphaText' : '只能包含字母或 _',
		'alphaMask' : /[a-z_]/i,
		'alphanum' : function(v) {
			return alphanum.test(v);
		},
		'alphachinese' : function(v) {
			return alphachinese.test(v);
		},
		'isExistNum': function(v) {
			return isExistNum.test(v);
		},
		'isMixNum': function(v) {
			return isMixNum.test(v);
		},
		'alphachineseText' : '只能包含字母或汉字或 _ ',
		'idCard' : function(idcard) {

			var Errors = ["验证通过!", "身份证号码位数不对!", "身份证号码出生日期超出范围或含有非法字符!",
					"身份证号码校验错误!", "身份证地区非法!"];

			var area = {
				11 : "北京",
				12 : "天津",
				13 : "河北",
				14 : "山西",
				15 : "内蒙古",
				21 : "辽宁",
				22 : "吉林",
				23 : "黑龙江",
				31 : "上海",
				32 : "江苏",
				33 : "浙江",
				34 : "安徽",
				35 : "福建",
				36 : "江西",
				37 : "山东",
				41 : "河南",
				42 : "湖北",
				43 : "湖南",
				44 : "广东",
				45 : "广西",
				46 : "海南",
				50 : "重庆",
				51 : "四川",
				52 : "贵州",
				53 : "云南",
				54 : "西藏",
				61 : "陕西",
				62 : "甘肃",
				63 : "青海",
				64 : "宁夏",
				65 : "新疆",
				71 : "台湾",
				81 : "香港",
				82 : "澳门",
				91 : "国外"
			}

			var idcard, Y, JYM;
			var S, M;
			var idcard_array = [];
			idcard_array = idcard.split("");
			// 地区检验

			if (area[parseInt(idcard.substr(0, 2))] == null) {
				return Errors[4];
			}

			// 身份号码位数及格式检验
			switch (idcard.length) {
				case 15 :
					if ((parseInt(idcard.substr(6, 2)) + 1900) % 4 == 0
							|| ((parseInt(idcard.substr(6, 2)) + 1900) % 100 == 0 && (parseInt(idcard
									.substr(6, 2)) + 1900)
									% 4 == 0)) {
						Ereg = /^[1-9][0-9]{5}[0-9]{2}((01|03|05|07|08|10|12)(0[1-9]|[1-2][0-9]|3[0-1])|(04|06|09|11)(0[1-9]|[1-2][0-9]|30)|02(0[1-9]|[1-2][0-9]))[0-9]{3}$/;// 测试出生日期的合法性
					} else {
						Ereg = /^[1-9][0-9]{5}[0-9]{2}((01|03|05|07|08|10|12)(0[1-9]|[1-2][0-9]|3[0-1])|(04|06|09|11)(0[1-9]|[1-2][0-9]|30)|02(0[1-9]|1[0-9]|2[0-8]))[0-9]{3}$/;// 测试出生日期的合法性
					}
					if (Ereg.test(idcard))

						return Errors[0];
					else
						return Errors[2];
					break;

				case 18 :
					// 18位身份号码检测
					// 出生日期的合法性检查
					// 闰年月日:((01|03|05|07|08|10|12)(0[1-9]|[1-2][0-9]|3[0-1])|(04|06|09|11)(0[1-9]|[1-2][0-9]|30)|02(0[1-9]|[1-2][0-9]))
					// 平年月日:((01|03|05|07|08|10|12)(0[1-9]|[1-2][0-9]|3[0-1])|(04|06|09|11)(0[1-9]|[1-2][0-9]|30)|02(0[1-9]|1[0-9]|2[0-8]))
					if (parseInt(idcard.substr(6, 4)) % 4 == 0
							|| (parseInt(idcard.substr(6, 4)) % 100 == 0 && parseInt(idcard
									.substr(6, 4))
									% 4 == 0)) {
						Ereg = /^[1-9][0-9]{5}19[0-9]{2}((01|03|05|07|08|10|12)(0[1-9]|[1-2][0-9]|3[0-1])|(04|06|09|11)(0[1-9]|[1-2][0-9]|30)|02(0[1-9]|[1-2][0-9]))[0-9]{3}[0-9Xx]$/;// 闰年出生日期的合法性正则表达式
					} else {
						Ereg = /^[1-9][0-9]{5}19[0-9]{2}((01|03|05|07|08|10|12)(0[1-9]|[1-2][0-9]|3[0-1])|(04|06|09|11)(0[1-9]|[1-2][0-9]|30)|02(0[1-9]|1[0-9]|2[0-8]))[0-9]{3}[0-9Xx]$/;// 平年出生日期的合法性正则表达式
					}
					if (Ereg.test(idcard)) {// 测试出生日期的合法性
						// 计算校验位
						S = (parseInt(idcard_array[0]) + parseInt(idcard_array[10]))
								* 7
								+ (parseInt(idcard_array[1]) + parseInt(idcard_array[11]))
								* 9
								+ (parseInt(idcard_array[2]) + parseInt(idcard_array[12]))
								* 10
								+ (parseInt(idcard_array[3]) + parseInt(idcard_array[13]))
								* 5
								+ (parseInt(idcard_array[4]) + parseInt(idcard_array[14]))
								* 8
								+ (parseInt(idcard_array[5]) + parseInt(idcard_array[15]))
								* 4
								+ (parseInt(idcard_array[6]) + parseInt(idcard_array[16]))
								* 2
								+ parseInt(idcard_array[7])
								* 1
								+ parseInt(idcard_array[8])
								* 6
								+ parseInt(idcard_array[9]) * 3;
						Y = S % 11;
						M = "F";
						JYM = "10X98765432";
						M = JYM.substr(Y, 1);// 判断校验位
						if (M == idcard_array[17] || (idcard_array[17]  && idcard_array[17].toUpperCase() =="X"))
							return Errors[0]; // 检测ID的校验位
						else{
							
							return Errors[3];
						}
					} else
						return Errors[2];
					break;

				default :
					return Errors[1];
					break;

			}
		},
		'alphanumText' : '只能包含字母，数字或 _',
		'alphanumMask' : /[a-z0-9_]/i
	};
}();

var app_type="website";//website,android,ios
(function(scope) {
	var CommonJS = Base.extend({
		constructor : function() {
		},
		validate : function(context) {
			var result = true;
			context =context || $("body");
			if(typeof(context) =="string")
				context =$("#"+context);
			$("[fieldType='db']:visible",context).each(function() {
						var is_null = $(this).attr("is_null");
						var value = $(this).val();
						var vtype_code = $(this).attr("vtype");
						var cname = $(this).attr("cname");
						var length = $(this).attr("length");
						if ("F" == is_null && !value) {
							pop({
										text : cname + "不能为空！"
									});
							result = false;
							return false;
						}
						if (vtype_code && !VTypes[vtype_code](value)) {
							pop({
										text : cname + "输入格式非法！"
									});
							result = false;
							return false;
						}
						if(length){
							if (!lenLimitValid(value,length,cname)){
								result = false;
								return false;
							}
						}
					});
				return result;
		},
		validateCertify:function(id){
				var value =$("#"+id).val();
				var vTypes =VTypes;
				var cardValMess = vTypes['idCard'](value);
				if (cardValMess && !(cardValMess.indexOf("验证通过") > -1)) {
	
					pop({text:cardValMess});
					return false;
				}
				return true;
			},
		validateCheckBox:function(check_box_name,element_id,tip_msg){
			if($("[id='"+check_box_name+"']").attr("checked") && !$("#"+element_id).val()){
				pop({text:tip_msg});
				return false;
			}
			return true;
		},
		validateConfirm:function(id,confirm_id,tip_msg){
			if($("#"+id).val() !=$("#"+confirm_id).val()){
				pop({text:tip_msg});
				return false;
			}
			return true;
		},
		/**
		 * 将json对象里的值填到context里
		 */
	   setInputDomain : function(json,context) {
			context =context || $("body");
			if(typeof(context) =="string")
				context =$("#"+context);
			for(p in json){
				var currJq =$("[dbField='"+p+"']",context);
				if(currJq && currJq.length>0){
					if((currJq[0].tagName=='INPUT' && currJq[0].type !='radio' ) || currJq[0].tagName=='SELECT' || currJq[0].tagName=='TEXTAREA'){
						currJq.val(json[p]);
						if(currJq[0].tagName=='SELECT'){
							//currJq[0].selectmenu('refresh');
//							$("[dbField='"+p+"']",context).selectmenu('refresh',true);
							//currJq[0].selectmenu('refresh',true);
//							$("select").selectmenu('refresh',true);
						}
					}else if(currJq[0].tagName=='INPUT' && currJq[0].type =='radio'   ){
							var currJq2=$("[dbField='"+p+"'][fieldType='db'][type='radio'][value='"+json[p]+"']",context);
							currJq2.attr("checked","checked");
					}else if(currJq[0].tagName=='IMG'){
							if(json[p]){
								currJq.attr({"src":json[p],"title":json["username"],"alt":json["username"]});
							}
					}else
						currJq.html(json[p]);
				}
			}
		},
		disabled:function(context){
			context =context || $("body");
			if(typeof(context) =="string")
				context =$("#"+context);
			//$("select",context).attr("disabled","disabled");
			$("select",context).selectmenu("disable");
			$("input",context).attr("disabled",true);
			$("textarea",context).attr("readOnly",true);
		},
		enable:function(context){
			context =context || $("body");
			if(typeof(context) =="string")
				context =$("#"+context);
			$("[fieldType='db']",context).removeAttr("disabled")
		},
		retValues:function(context){
			context =context || $("body");
			if(typeof(context) =="string")
				context =$("#"+context);
			$("[fieldType='db'][type!='radio']",context).val("");
		},
		/**
		 * 获取上下文里有dbField的容器的值，封装成map，格式是{dbField:value}
		 */
		getInputDomain : function(context) {
			var map = {};
			context =context || $("body");
			if(typeof(context) =="string")
				context =$("#"+context);
			$("input[type='checkbox']:checked",context).each(
				function() {
					var $obj = $(this);
					if ($obj.attr("dbField")) {
						var ivId = $obj.attr("dbField")
								|| $obj.attr("name");
						// 真值
						var ivVal = $obj.val();
						map[ivId] = ivVal;
					}
					
			});

			// text
			$("input[type='text']",context).each(function() {
					var $obj = $(this);
					if ($obj.attr("dbField")) {
						var ivId = $obj.attr("dbField")
								|| $obj.attr("id");
						var ivVal = $obj.val();
						map[ivId] = ivVal;
					}
					
					
				});
			
			// text
			$("input[type='email']",context).each(function() {
					var $obj = $(this);
					if ($obj.attr("dbField")) {
						var ivId = $obj.attr("dbField")
								|| $obj.attr("id");
						var ivVal = $obj.val();
						map[ivId] = ivVal;
					}
					
					
				});
			
			
			// number
			$("input[type='number']",context).each(function() {
				var $obj = $(this);
				if ($obj.attr("dbField")) {
					var ivId = $obj.attr("dbField")
					|| $obj.attr("id");
					var ivVal = $obj.val();
					map[ivId] = ivVal;
				}
				
				
			});
			$("input[type='password']",context).each(function() {
				var $obj = $(this);
				if ($obj.attr("dbField")) {
					var ivId = $obj.attr("dbField")
					|| $obj.attr("id");
					var ivVal = $obj.val();
					map[ivId] = ivVal;
				}
				
			});
			
			// hidden
			$("input[type='hidden']",context).each(
					function() {
						var $obj = $(this);
						if ($obj.attr("dbField")) {
							var ivId = $obj.attr("dbField")
							|| $obj.attr("id");
							var ivVal = $obj.val();
							map[ivId] = ivVal;
						}
					});

			// select
			$("select option:selected",context).each(
					function() {
						var $obj = $(this);
						if ($obj.parent().attr("dbField")) {
							var ivId = $obj.parent().attr("dbField")
							|| $obj.parent().attr("id");
							// 真值
							var ivVal = $obj.val();
							var text=$obj.text();
							var valObj={};
							valObj.id=ivVal;
							valObj.name= text;
							valObj.type="combobox";
							map[ivId] = valObj;
						}

					});
			// textarea
			$("textarea",context).each(function() {
						var $obj = $(this);
						if ($obj.attr("dbField")) {
							var ivId = $obj.attr("dbField")
							|| $obj.attr("id");
							// 真值
							var ivVal = $obj.val();
							map[ivId] = ivVal;
						}

					});

			$("span",context).each(function() {
				var $obj = $(this);
				if ($obj.attr("dbField")) {
					var ivId = $obj.attr("dbField")|| $obj.attr("id");
					// 真值
					var ivVal = $obj.text();
					map[ivId] = ivVal;
				}
			});
			$("a",context).each(function() {
				var $obj = $(this);
				if ($obj.attr("dbField")) {
					var ivId = $obj.attr("dbField")|| $obj.attr("name");
					// 真值
					var ivVal = $obj.attr("value");
					map[ivId] = ivVal;
				}

			});
			// radio
			$("input[type='radio']:checked",context).each(
					function() {
						var $obj = $(this);
						if ($obj.attr("dbField")) {
							var ivId = $obj.attr("dbField")|| $obj.attr("name");
							var ivVal = $obj.val();
							map[ivId] = ivVal;
						}
					});

			// 将span的值也封装进map
			$("span", context).each(function() {
				var $obj = $(this);
				if ($obj.attr("dbField")) {
					var ivId = $obj.attr("dbField") || $obj.attr("id");
					var ivVal = $obj.text();
					map[ivId] = ivVal;
				}
			});

			return map;
		},
		setObjVal : function(obj, id, val) {
			if (obj == "undefined" || null == obj || null == id
					|| '' == id)
				return;
			//if (!obj.hasOwnProperty(id)) {
				obj[id] = val;
			//} else {
				//obj[id] = obj[id] + "," + val;
			//}
		},
		setSrcById:function(id,value){
			$("#"+id).attr("src",value);
		},
		setInnerTextById:function(id,value){
			$("#"+id).html(value);
		},
		getDataFromJson:function(json){
			json = json.replace(new RegExp("\"","gm"),"'");
			if(typeof(json) =="string"){
				if(json==""){
					return {};
				}
				return eval("("+json+")");
			}else{
				return json;
			}
		},
		translateListDataToMap:function(datas){
			var result={};
			for(var n=0; n<datas.length; n++) {
				var fieldData = datas[n];
				var code ='';
				var value ='';
				if(fieldData.field_label) {
					code = fieldData.field_label;
				}else if (fieldData.field_code){
					code = fieldData.field_code;
				}
				if(fieldData.field_value) {
					value = fieldData.field_value;
				}else if (fieldData.field_name){
					value = fieldData.field_name;
				}
				result[code]=value;
			}
			return result;
		},
		//适合这种格式的数据转为下拉选项  {"3126":"给主管审核","3127":"给人事审核"}
		setSelectOptionsFromMap:function(context,map_data,hasSelectDeafultOption){
			if(typeof(context) =="string")
				context =$("#"+context);
			context.get(0).options.length = 0; 
			if(hasSelectDeafultOption && hasSelectDeafultOption ==true){
				context.append("<option>请选择</option>");
			}
			for (var key in map_data) {
				context.append("<option value='"+key+"' >"+map_data[key]+"</option>");
			}
			context.selectmenu("refresh");
		},
		//适合这种格式的数据转为下拉选项  [{"staff_name":"root","staff_code":"root"},{"staff_name":"dgw67q","staff_code":"dgsayu"}]
		setSelectOptionsFromList:function(context,dataList,textLabel,valLabel,hasSelectDeafultOption){
			if(typeof(context) =="string")
				context =$("#"+context);
			context.get(0).options.length = 0; 
			if(hasSelectDeafultOption && hasSelectDeafultOption ==true){
				context.append("<option>请选择</option>");
			}
			for (var i = 0; i < dataList.length; i++) {
				var map=dataList[i];
				context.append("<option value='"+map[valLabel]+"' >"+map[textLabel]+"</option>");
			}
			context.selectmenu("refresh");
		},
		getIp:function(){
			if( !window.localStorage.oa_ip){
				return '';
			}else {
				return window.localStorage.oa_ip;
			}
			
		},
		queryStaticDataFromAttrCode:function(attr_code,call_back){
			$.ajax({
					type: "post",
					async:false,
					url: top.rootPath
						+ "/smmodule/sm/AttributeAction.ou?method=listAttrDataListByAttrCode",
					data:{
						attrCode : attr_code
					},
					success: function(responseText, textStatus){
						if (responseText == 'failed') {
							alert("不存在相应流程！ ");
						}
						result=commonJS.getDataFromJson(responseText); 
						if(typeof call_back == 'function'){
							call_back(result);
						}
					},
					error: function(XMLHttpRequest, textStatus, errorThrown){
						$('<div>').simpledialog2({
						    mode: 'blank',
						    headerText: '错误提示',
						    headerClose: true,
						    blankContent : 
						      "<p text-align='center'>服 务 器 系 统  错误 " + textStatus+"</p>"+
						      "<a rel='close' data-role='button' href='#'>我知道了</a>"
						      
						  });
					}
			});
		},
		getUrlParms:function ()    
		{
		    var args=new Object();   
		    var query=location.search.substring(1);//获取查询串   
		    var pairs=query.split("&");//在逗号处断开   
		    for(var   i=0;i<pairs.length;i++)   
		    {   
		        var pos=pairs[i].indexOf('=');//查找name=value   
		            if(pos==-1)   continue;//如果没有找到就跳过   
		            var argname=pairs[i].substring(0,pos);//提取name   
		            var value=pairs[i].substring(pos+1);//提取value   
		            args[argname]=unescape(value);//存为属性   
		    }
		    return args;
		},
		getContextPath:function(){
			if(!window.localStorage.oa_ip){
				return "http://"+location.host+"/RedseaOAMobile";
			}else {
				return window.localStorage.oa_ip;
			}
		},
		formatDate:function (dateStr) {
			var year = dateStr.substring(0,4);
			var month = dateStr.substring(4,6);
			var day = dateStr.substring(6,8);
			var hour = dateStr.substring(8,10);
			var minutes = dateStr.substring(10,12);
			var seconds = dateStr.substring(12,14);
			var date = year+"/"+month+"/"+day+" "+hour+":"+minutes+":"+seconds
			return date;
		},
		getToday:function(format){
			if(!format){
				format='yyyy-MM-dd';
			}
			var date = new Date();
			var year=date.getFullYear();
			var month=date.getMonth() + 1;
			var day=date.getDate();
			var hour=date.getHours();
			var minute=date.getMinutes();
			var str=format;
			
			if(month<10){
				month="0"+month;
			}
			if(day<10){
				day="0"+day;
			}
			str=str.replace('yyyy', year).replace('MM', month).replace('dd', day);
			return str;

		},
		getTimeNow:function(format){
			if(!format){
				format='yyyy-MM-dd HH:mm:ss';
			}
			var date = new Date();
			var year=date.getFullYear();
			var month=date.getMonth() + 1;
			var day=date.getDate();
			var hour=date.getHours();
			var minute=date.getMinutes();
			var second=date.getSeconds();
			var str=format;
			
			if(month<10){
				month="0"+month;
			}
			if(day<10){
				day="0"+day;
			}
			if(hour<10){
				hour="0"+hour;
			}
			if(minute<10){
				minute="0"+minute;
			}
			if(day<10){
				day="0"+day;
			}
			if(second<10){
				second="0"+second;
			}
			
			str=str.replace('yyyy', year).replace('MM', month).replace('dd', day).replace('HH', hour).replace('mm', minute).replace('ss', second);
			return str;

		},
		showSimpledialog:function(headerText,contentText,firstBtnFunc,SecondBtnFunc){
			if(!headerText){
				headerText="提示";
			}
			if(!contentText){
				contentText="内容";
			}
			var me=this;
			if(typeof(SecondBtnFunc) == "function"){
				$('<div>').simpledialog2({
				    mode: 'button',
				    headerText: headerText,
				    headerClose: true,
				    buttonPrompt: contentText,
				    buttons : {
						'确定': {
					        click: function () { 
								firstBtnFunc();
					        }
					    },
					    '取消': {
					        click: function () { 
					    	SecondBtnFunc();
					        }
					    }
				    }
				  })
			}else if(typeof(firstBtnFunc) == "function"){
				$('<div>').simpledialog2({
				    mode: 'button',
				    headerText: headerText,
				    headerClose: true,
				    buttonPrompt: contentText,
				    buttons : {
						'确定': {
					        click: function () { 
								firstBtnFunc();
					        }
					    }
				    }
				  })
			}else{
				$('<div>').simpledialog2({
				    mode: 'button',
				    headerText: headerText,
				    headerClose: true,
				    buttonPrompt: contentText,
				    buttons : {
						"我知道了": {
					        click: function () { 
					        }
					    }
				    }
				  })
			}
			
		},
		invokeInterface:function (method,params,successFunc,errorFunc){
			var flag=2;//确定使用哪种方法调用：1.通过自身服务端java调用外部接口；2.直接调用外接口
			var rootPath=this.getContextPath();
			var paramsStr=JSON.stringify(params);
			var url="";
			if(flag==1){
				url=rootPath+'/invokeInterface?type='+method;
			}else if(flag == 2){
				url=rootPath+'/Interface/Android.ashx?type='+method;
			}
			paramsStr=paramsStr.replace(new RegExp("\"","gm"),"'");
//			alert(url+"\n"+paramsStr);
			$.mobile.showPageLoadingMsg( 'a', "加载中，请稍候..." ); 
			$.ajax( {
				type : "post",
				url:url,
				data : {params:paramsStr},
				success : function(responseText, textStatus,jqXHR ) {
					$.mobile.hidePageLoadingMsg(); 
					if(typeof successFunc =='function'){
						successFunc(jqXHR.responseText,textStatus);
					}
				},
				error: function(XMLHttpRequest, textStatus, errorThrown){
					$.mobile.hidePageLoadingMsg(); 
					if(typeof successFunc =='function'){
						errorFunc(XMLHttpRequest,textStatus,errorThrown);
					}
				}
			});
		
		},
		file_download:function(url,type){//type:CommonStaticData.file_download_type
			if(!type){
				if(app_type){
					type=app_type;
				}
			}
			var rootPath=this.getContextPath();
			switch(type){
				case "website":					
					window.open(url);
					break;
				case "android":
					var file_name=url.substr(url.lastIndexOf('/')+1);
					var suffix=file_name.substr(file_name.lastIndexOf('.'));
					var type=CommonStaticData.android_file_type[suffix];
					var fileTransfer=new FileTransfer();
					$().toastmessage('showToast', {
					    text     : '正在下载中，请稍候',
					    sticky   : false,
					    type     : 'notice',
					    position:'bottom-center'
					});
//					commonJS.showSimpledialog('提示','正在下载中，请稍候');
					fileTransfer.download(url,"/mnt/sdcard/oa/"+file_name,
					function (fileEntry){
						window.plugins.webintent.startActivity({
						    action: "android.intent.action.VIEW",//window.plugins.WebIntent.ACTION_VIEW,
						    url: fileEntry.fullPath,
						    type:type}, 
						    function() {console.log('211111111111');}, 
						    function() {commonJS.showSimpledialog('提示','请先安装好下载文件对应的阅读应用，文件保存位置：'+'/mnt/sdcard/oa/'+file_name);}
						);
					},null);
					break;
				case "ios":
					downloadFileOnIOS(url);
					break;
			}
		}
	})
	window.commonJS = new CommonJS();
}(window));

function downloadFileOnIOS(url){
    var file_name=url.substr(url.lastIndexOf('/')+1);
    var suffix=file_name.substr(file_name.lastIndexOf('.'));
    var type=CommonStaticData.android_file_type[suffix];
    window.requestFileSystem(
                             LocalFileSystem.PERSISTENT, 0,
                             function onFileSystemSuccess(fileSystem) {
                             fileSystem.root.getFile(
                                 "dummy.html", {create: true, exclusive: false},
                                 function gotFileEntry(fileEntry){
                                 var sPath = fileEntry.fullPath.replace("dummy.html","");
                                 var fileTransfer = new FileTransfer();
                                 fileEntry.remove();
                                 fileTransfer.download(
                                                       url,
                                                       sPath + file_name,
                                                       function(theFile) {
                                                       console.log("download complete: " + theFile.toURI());
//                                                       alert('downloadFile 4');
                                                       
//                                                       var str1 = theFile.fullPath;
                                                       var str1 = file_name;
//                                                       alert(str1);
                                                       $.mobile.hidePageLoadingMsg();
                                                       var str2 = "str2";
                                                       window.plugins.myPGPlugin.addStr(function(){}, function() {commonJS.showSimpledialog('提示','请先安装好下载文件对应的阅读应用，文件保存位置：'+'/oa/'+file_name);}, str1, str2);
                                       
                                                       
                                                       
                                                       },
                                                       function(error) {
                                                       console.log("download error source " + error.source);
                                                       console.log("download error target " + error.target);
                                                       console.log("upload error code: " + error.code);
                                                       }
                                                       );
                                 }, 
                                                     function (evt) {
													    console.log(evt.target.error.code);
													});
                             }, 
                             function (evt) {
							    console.log(evt.target.error.code);
							});
    
}

function showRed(x){
	var w = "releaseTextarea2", n = 2;
	var r = 0, p = x.attr("class") + " ", u = "";
	var v = setInterval(function() {
				r++;
				u = r % 2 ? p + w : p;
				x.attr("class", u);
				if (r == 2 * n) {
					clearInterval(v);
					x.removeClass(w)
				}
			}, 300);
	x.focus();
}
function formatDate(dateStr) {
	var year = dateStr.substring(0,4);
	var month = dateStr.substring(4,6);
	var day = dateStr.substring(6,8);
	var hour = dateStr.substring(8,10);
	var minutes = dateStr.substring(10,12);
	var seconds = dateStr.substring(12,14);
	var date = year+"/"+month+"/"+day+" "+hour+":"+minutes+":"+seconds
	return date;
}
$.support.cors = true;
$.mobile.allowCrossDomainPages =true;
//$.mobile.defaultPageTransition = 'none';
