function getFormDataMap(formId, context) {
	var map = {};
	context =context || $("body");
	if(typeof(context) =="string")
		context =$("#"+context);
	$("input[type='checkbox']:checked",context).each(
		function() {
			var $obj = $(this);
			if ($obj.attr("dbField")) {
				var ivId = $obj.attr("dbField")
						|| $obj.attr("name");
				// 真值
				var ivVal = $obj.val();
				map[ivId] = ivVal;
			}
			
	});

	// text
	$("input[type='text']",context).each(function() {
			var $obj = $(this);
			if ($obj.attr("dbField")) {
				var ivId = $obj.attr("dbField")
						|| $obj.attr("id");
				var ivVal = $obj.val();
				map[ivId] = ivVal;
			}
			
			
		});
	
	// number
	$("input[type='number']",context).each(function() {
		var $obj = $(this);
		if ($obj.attr("dbField")) {
			var ivId = $obj.attr("dbField")
			|| $obj.attr("id");
			var ivVal = $obj.val();
			map[ivId] = ivVal;
		}
		
		
	});
	$("input[type='password']",context).each(function() {
		var $obj = $(this);
		if ($obj.attr("dbField")) {
			var ivId = $obj.attr("dbField")
			|| $obj.attr("id");
			var ivVal = $obj.val();
			map[ivId] = ivVal;
		}
		
	});
	
	// hidden
	$("input[type='hidden']",context).each(
			function() {
				var $obj = $(this);
				if ($obj.attr("dbField")) {
					var ivId = $obj.attr("dbField")
					|| $obj.attr("id");
					var ivVal = $obj.val();
					map[ivId] = ivVal;
				}
			});

	// select
	$("select option:selected",context).each(
			function() {
				var $obj = $(this);
				if ($obj.parent().attr("dbField")) {
					var ivId = $obj.parent().attr("dbField")
					|| $obj.parent().attr("id");
					// 真值
					var ivVal = $obj.val();
					var text=$obj.text();
					var valObj={};
					valObj.id=ivVal;
					valObj.name= text;
					valObj.type="combobox";
					map[ivId] = valObj;
				}

			});
	// textarea
	$("textarea",context).each(function() {
				var $obj = $(this);
				if ($obj.attr("dbField")) {
					var ivId = $obj.attr("dbField")
					|| $obj.attr("id");
					// 真值
					var ivVal = $obj.val();
					map[ivId] = ivVal;
				}

			});

	$("span",context).each(function() {
		var $obj = $(this);
		if ($obj.attr("dbField")) {
			var ivId = $obj.attr("dbField")|| $obj.attr("id");
			// 真值
			var ivVal = $obj.text();
			map[ivId] = ivVal;
		}
	});
	$("a",context).each(function() {
		var $obj = $(this);
		if ($obj.attr("dbField")) {
			var ivId = $obj.attr("dbField")|| $obj.attr("name");
			// 真值
			var ivVal = $obj.attr("value");
			map[ivId] = ivVal;
		}

	});
	// radio
	$("input[type='radio']:checked",context).each(
			function() {
				var $obj = $(this);
				if ($obj.attr("dbField")) {
					var ivId = $obj.attr("dbField")|| $obj.attr("name");
					var ivVal = $obj.val();
					map[ivId] = ivVal;
				}
			});

	// 将span的值也封装进map
	$("span", context).each(function() {
		var $obj = $(this);
		if ($obj.attr("dbField")) {
			var ivId = $obj.attr("dbField") || $obj.attr("id");
			var ivVal = $obj.text();
			map[ivId] = ivVal;
		}
	});

	return map;

}

function getDataFromJson(json){
	if(typeof(json) =="string"){
		return eval("("+json+")");
	}else{
		return json;
	}
}

function translateListDataToMap(datas){
	var result={};
	for(var n=0; n<datas.length; n++) {
		var fieldData = datas[n];
		var code ='';
		var value ='';
		if(fieldData.field_label) {
			code = fieldData.field_label;
		}else if (fieldData.field_code){
			code = fieldData.field_code;
		}
		if(fieldData.field_value) {
			value = fieldData.field_value;
		}else if (fieldData.field_name){
			value = fieldData.field_name;
		}
		result[code]=value;
	}
	return result;
}