﻿/**
 * 分页对象核心js
 * @wu.i
 */
var qryPager;
(function(scope) {
	var PageTpl = Base.extend({
		staticData : new Object(),
		constructor : function(attribute) {
			attribute= attribute || {};
			this.page_index=1;
			this.set_attr(attribute);
			this.def_page_size =10;
			this.action="";
			this.pageSize=attribute['page_size'] || this.def_page_size;
			this.page_nav=attribute['page_nav'];
			this.ul_lists=attribute['ul_lists'];
			this.comment_li_tpl=attribute['comment_li_tpl'];
			this.param = {"pageSize":attribute['page_size'] || this.pageSize};

		},
		set_attr:function(attribute){
			attribute= attribute || {};
			this.tplEle = attribute.clone_scope_Jq;
			this.clone_elt_type=attribute.clone_elt_type || "li";
			this.qry_scope_id =attribute['qry_scope_id'] || '';
		},

		getParam :function(){ //获取参数
			return this.param;
		},
		setParam : function(currJq,json_data) {
			jQuery.extend(this.param, json_data);
		},
		query_info : function(t_param) {
			
		},
		//渲染分页组件
		render_page:function(data){
			if(!this.page_nav){
				return ;
			}
			var context=this.page_nav|| $("body");
			if(typeof(context) =="string")
				context =$("#"+context);
			var page=$("select",context)[0];
			page=$(page);
			var totalProperty=data.total;
			var page_nums=((totalProperty-1) / this.pageSize  +1)|0 ;
			var page_index=data.page_index;
			jQuery(page).get(0).options.length = 0; 

			//page.append("<option >"+page_index+"/"+page_nums+"</option>");
			
			//添加每页的下拉选择
			if(page_nums<1){
				page.selectmenu("disable");
			}else{
				page.selectmenu("enable");
			}
			for (var i=1;i<=page_nums;i++){
				page.append("<option value='"+i+"' >第"+i+"页</option>");
			}
			
			if(page_index<=1){
				$("#pre_page",context).button("disable");
			}else{
				$("#pre_page",context).button("enable");
			}
			if(page_index>=page_nums){
				$("#next_page",context).button("disable");
			}else{
				$("#next_page",context).button("enable");
			}
			
			//选中所在页
			page.val(page_index);
			page.selectmenu('refresh',true);
			//页面滚到顶部
			$.mobile.silentScroll(0);
		},
		render_info : function(reply) {
			var me = this;
			if(typeof(this.render_info_before) =="function")
				this.render_info_before();
		
			if (reply)
			{
				this.gettplUl().children("li:gt(0)").remove();
				var list=reply.list||[];
				var page_index=reply.page_index;
				if(list.length>0){
					for (var i = 0, liData; liData = list[i++];) {
						this.bind_event(liData,i);
					}
					//重新渲染分页组件
					this.render_page(reply);
				}else if(list.length==0 && page_index>1){
					this.query_info({page_index:1});
				}else{
					//重新渲染分页组件
					this.render_page(reply);
				}
				
				
			} else 
			{
				this.gettplUl().children(this.comment_li_tpl+":gt(0)").fadeIn("fast",function() {me.gettplUl().children("li:gt(0)").remove();})
			}
			
			
			
			this.after_data_handle(reply);
		},
		bind_event : function(jsonData,index) {
			var cloneLi = this.gettplLi().clone(), me = this;
			cloneLi.data("qry_data", jsonData || {});
			(function(cloneLi) {
				var qry_data = cloneLi.data("qry_data");
				me.gettplUl().append(cloneLi.attr("id", "").show());
				me.record_event(qry_data,cloneLi,index);
				
			}(cloneLi));
		},
		record_event:function(qry_data,cloneLi){},////TODO 子类实现}
		after_data_handle:function(reply){},////TODO 子类实现}
		gettplUl:function(){
			return  $("#"+this.ul_lists);
		},
		gettplLi:function(){
			return $("#"+this.comment_li_tpl);
		},
		resetValues:function(){//重置所有值
			$("[fieldType='db'][type!='radio']").val("");
		},
		init_page:function(v_pre_page,v_current_page,v_next_page){
			var pre_page=v_pre_page||'pre_page';
			var current_page=v_current_page||'current_page';
			var next_page=v_next_page||'next_page';
			var page=$("#"+current_page,$("#"+this.page_nav));
			page.selectmenu("disable");
			page.get(0).options.length = 0; 
			$("#"+pre_page,$("#"+this.page_nav)).button("disable");
			$("#"+next_page,$("#"+this.page_nav)).button("disable");
			var me=this;
			page.change(function(){ 
				var page_index=$(this).val();
				me.query_info({'page':page_index});
			});
			var pre_page=$("#"+pre_page,$("#"+this.page_nav));
			pre_page.bind('click',function(){
				var page_index=$("select",$("#"+me.page_nav)).val();
				var new_page_index=parseInt(page_index)-1;
				me.query_info({'page':new_page_index});
			});
			var next_page=$("#"+next_page,$("#"+this.page_nav));
			next_page.bind('click',function(){
				var page_index=$("select",$("#"+me.page_nav)).val();
				var new_page_index=parseInt(page_index)+1;
				me.query_info({'page':new_page_index});
			});
		},
		renderStaticData:function(data,currJq){
			var me = this;
			$("[attr_code]",currJq).each(function(){
//			$("span",currJq).each(function(){
				var obj=$(this);
				if(obj.attr("attr_code")){
					var attr_code=obj.attr("attr_code");
					var dbfield=obj.attr("dbfield");
					var val=obj.html();
					if(me.staticData[attr_code]){
						$("[dbfield='"+dbfield+"_desc']",currJq).html(me.staticData[attr_code][val]);
					}else{
						commonJS.queryStaticDataFromAttrCode(attr_code,function(result){
							var aStaticData={};
							for (var i = 0; i < result.length; i++) {
								var map=result[i];
								var label=map.attr_value_name;
								var value=map.attr_value_code;
								aStaticData[value]=label;
							}
							me.staticData[attr_code]=aStaticData;
							$("[dbfield='"+dbfield+"_desc']",currJq).html(me.staticData[attr_code][val]);
						});
					}
				}
			});
		}
	})
	window.PageTpl =PageTpl;
}(window));


