/*
 * canvg.js - Javascript SVG parser and renderer on Canvas
 * MIT Licensed 
 * Gabe Lerner (gabelerner@gmail.com)
 * http://code.google.com/p/canvg/
 */
(function() {
  this.canvg = function(q, r, t) {
    if(null == q && null == r && null == t) {
      r = document.getElementsByTagName("svg");
      for(q = 0;q < r.length;q++) {
        var t = r[q], u = document.createElement("canvas");
        u.width = t.clientWidth;
        u.height = t.clientHeight;
        t.parentNode.insertBefore(u, t);
        t.parentNode.removeChild(t);
        var v = document.createElement("div");
        v.appendChild(t);
        canvg(u, v.innerHTML)
      }
    }else {
      t = t || {};
      "string" == typeof q && (q = document.getElementById(q));
      null != q.svg && q.svg.stop();
      var u = q, a = {FRAMERATE:30, MAX_VIRTUAL_PIXELS:3E4, init:function(b) {
        a.Definitions = {};
        a.Styles = {};
        a.Animations = [];
        a.Images = [];
        a.ctx = b;
        a.ViewPort = new function() {
          this.viewPorts = [];
          this.Clear = function() {
            this.viewPorts = []
          };
          this.SetCurrent = function(c, a) {
            this.viewPorts.push({width:c, height:a})
          };
          this.RemoveCurrent = function() {
            this.viewPorts.pop()
          };
          this.Current = function() {
            return this.viewPorts[this.viewPorts.length - 1]
          };
          this.width = function() {
            return this.Current().width
          };
          this.height = function() {
            return this.Current().height
          };
          this.ComputeSize = function(a) {
            return null != a && "number" == typeof a ? a : "x" == a ? this.width() : "y" == a ? this.height() : Math.sqrt(Math.pow(this.width(), 2) + Math.pow(this.height(), 2)) / Math.sqrt(2)
          }
        }
      }};
      a.init();
      a.ImagesLoaded = function() {
        for(var b = 0;b < a.Images.length;b++) {
          if(!a.Images[b].loaded) {
            return!1
          }
        }
        return!0
      };
      a.trim = function(a) {
        return a.replace(/^\s+|\s+$/g, "")
      };
      a.compressSpaces = function(a) {
        return a.replace(/[\s\r\t\n]+/gm, " ")
      };
      a.ajax = function(a) {
        var c;
        return(c = window.XMLHttpRequest ? new XMLHttpRequest : new ActiveXObject("Microsoft.XMLHTTP")) ? (c.open("GET", a, !1), c.send(null), c.responseText) : null
      };
      a.parseXml = function(a) {
        if(window.DOMParser) {
          return(new DOMParser).parseFromString(a, "text/xml")
        }
        var a = a.replace(/<!DOCTYPE svg[^>]*>/, ""), c = new ActiveXObject("Microsoft.XMLDOM");
        c.async = "false";
        c.loadXML(a);
        return c
      };
      a.Property = function(a, c) {
        this.name = a;
        this.value = c
      };
      a.Property.prototype.getValue = function() {
        return this.value
      };
      a.Property.prototype.hasValue = function() {
        return null != this.value && "" !== this.value
      };
      a.Property.prototype.numValue = function() {
        if(!this.hasValue()) {
          return 0
        }
        var a = parseFloat(this.value);
        (this.value + "").match(/%$/) && (a /= 100);
        return a
      };
      a.Property.prototype.valueOrDefault = function(a) {
        return this.hasValue() ? this.value : a
      };
      a.Property.prototype.numValueOrDefault = function(a) {
        return this.hasValue() ? this.numValue() : a
      };
      a.Property.prototype.addOpacity = function(b) {
        var c = this.value;
        if(null != b && "" != b && "string" == typeof this.value) {
          var d = new RGBColor(this.value);
          d.ok && (c = "rgba(" + d.r + ", " + d.g + ", " + d.b + ", " + b + ")")
        }
        return new a.Property(this.name, c)
      };
      a.Property.prototype.getDefinition = function() {
        var b = this.value.replace(/^(url\()?#([^\)]+)\)?$/, "$2");
        return a.Definitions[b]
      };
      a.Property.prototype.isUrlDefinition = function() {
        return 0 == this.value.indexOf("url(")
      };
      a.Property.prototype.getFillStyleDefinition = function(b) {
        var c = this.getDefinition();
        return null != c && c.createGradient ? c.createGradient(a.ctx, b) : null != c && c.createPattern ? c.createPattern(a.ctx, b) : null
      };
      a.Property.prototype.getDPI = function() {
        return 96
      };
      a.Property.prototype.getEM = function(b) {
        var c = 12, d = new a.Property("fontSize", a.Font.Parse(a.ctx.font).fontSize);
        d.hasValue() && (c = d.toPixels(b));
        return c
      };
      a.Property.prototype.getUnits = function() {
        return(this.value + "").replace(/[0-9\.\-]/g, "")
      };
      a.Property.prototype.toPixels = function(b) {
        if(!this.hasValue()) {
          return 0
        }
        var c = this.value + "";
        return c.match(/em$/) ? this.numValue() * this.getEM(b) : c.match(/ex$/) ? this.numValue() * this.getEM(b) / 2 : c.match(/px$/) ? this.numValue() : c.match(/pt$/) ? this.numValue() * this.getDPI(b) * (1 / 72) : c.match(/pc$/) ? 15 * this.numValue() : c.match(/cm$/) ? this.numValue() * this.getDPI(b) / 2.54 : c.match(/mm$/) ? this.numValue() * this.getDPI(b) / 25.4 : c.match(/in$/) ? this.numValue() * this.getDPI(b) : c.match(/%$/) ? this.numValue() * a.ViewPort.ComputeSize(b) : this.numValue()
      };
      a.Property.prototype.toMilliseconds = function() {
        if(!this.hasValue()) {
          return 0
        }
        var a = this.value + "";
        if(a.match(/s$/)) {
          return 1E3 * this.numValue()
        }
        a.match(/ms$/);
        return this.numValue()
      };
      a.Property.prototype.toRadians = function() {
        if(!this.hasValue()) {
          return 0
        }
        var a = this.value + "";
        return a.match(/deg$/) ? this.numValue() * (Math.PI / 180) : a.match(/grad$/) ? this.numValue() * (Math.PI / 200) : a.match(/rad$/) ? this.numValue() : this.numValue() * (Math.PI / 180)
      };
      a.Font = new function() {
        this.Styles = "normal|italic|oblique|inherit";
        this.Variants = "normal|small-caps|inherit";
        this.Weights = "normal|bold|bolder|lighter|100|200|300|400|500|600|700|800|900|inherit";
        this.CreateFont = function(c, d, b, e, f, g) {
          g = null != g ? this.Parse(g) : this.CreateFont("", "", "", "", "", a.ctx.font);
          return{fontFamily:f || g.fontFamily, fontSize:e || g.fontSize, fontStyle:c || g.fontStyle, fontWeight:b || g.fontWeight, fontVariant:d || g.fontVariant, toString:function() {
            return[this.fontStyle, this.fontVariant, this.fontWeight, this.fontSize, this.fontFamily].join(" ")
          }}
        };
        var b = this;
        this.Parse = function(c) {
          for(var d = {}, c = a.trim(a.compressSpaces(c || "")).split(" "), h = !1, e = !1, f = !1, g = !1, k = "", j = 0;j < c.length;j++) {
            !e && -1 != b.Styles.indexOf(c[j]) ? ("inherit" != c[j] && (d.fontStyle = c[j]), e = !0) : !g && -1 != b.Variants.indexOf(c[j]) ? ("inherit" != c[j] && (d.fontVariant = c[j]), e = g = !0) : !f && -1 != b.Weights.indexOf(c[j]) ? ("inherit" != c[j] && (d.fontWeight = c[j]), e = g = f = !0) : h ? "inherit" != c[j] && (k += c[j]) : ("inherit" != c[j] && (d.fontSize = c[j].split("/")[0]), e = g = f = h = !0)
          }
          "" != k && (d.fontFamily = k);
          return d
        }
      };
      a.ToNumberArray = function(b) {
        for(var b = a.trim(a.compressSpaces((b || "").replace(/,/g, " "))).split(" "), c = 0;c < b.length;c++) {
          b[c] = parseFloat(b[c])
        }
        return b
      };
      a.Point = function(a, c) {
        this.x = a;
        this.y = c
      };
      a.Point.prototype.angleTo = function(a) {
        return Math.atan2(a.y - this.y, a.x - this.x)
      };
      a.Point.prototype.applyTransform = function(a) {
        var c = this.x * a[1] + this.y * a[3] + a[5];
        this.x = this.x * a[0] + this.y * a[2] + a[4];
        this.y = c
      };
      a.CreatePoint = function(b) {
        b = a.ToNumberArray(b);
        return new a.Point(b[0], b[1])
      };
      a.CreatePath = function(b) {
        for(var b = a.ToNumberArray(b), c = [], d = 0;d < b.length;d += 2) {
          c.push(new a.Point(b[d], b[d + 1]))
        }
        return c
      };
      a.BoundingBox = function(a, c, d, h) {
        this.y2 = this.x2 = this.y1 = this.x1 = Number.NaN;
        this.x = function() {
          return this.x1
        };
        this.y = function() {
          return this.y1
        };
        this.width = function() {
          return this.x2 - this.x1
        };
        this.height = function() {
          return this.y2 - this.y1
        };
        this.addPoint = function(a, c) {
          if(null != a) {
            if(isNaN(this.x1) || isNaN(this.x2)) {
              this.x2 = this.x1 = a
            }
            a < this.x1 && (this.x1 = a);
            a > this.x2 && (this.x2 = a)
          }
          if(null != c) {
            if(isNaN(this.y1) || isNaN(this.y2)) {
              this.y2 = this.y1 = c
            }
            c < this.y1 && (this.y1 = c);
            c > this.y2 && (this.y2 = c)
          }
        };
        this.addX = function(a) {
          this.addPoint(a, null)
        };
        this.addY = function(a) {
          this.addPoint(null, a)
        };
        this.addBoundingBox = function(a) {
          this.addPoint(a.x1, a.y1);
          this.addPoint(a.x2, a.y2)
        };
        this.addQuadraticCurve = function(a, c, d, h, b, l) {
          d = a + 2 / 3 * (d - a);
          h = c + 2 / 3 * (h - c);
          this.addBezierCurve(a, c, d, d + 1 / 3 * (b - a), h, h + 1 / 3 * (l - c), b, l)
        };
        this.addBezierCurve = function(a, c, d, h, b, l, n, m) {
          var p = [a, c], o = [d, h], s = [b, l], q = [n, m];
          this.addPoint(p[0], p[1]);
          this.addPoint(q[0], q[1]);
          for(i = 0;1 >= i;i++) {
            if(a = function(a) {
              return Math.pow(1 - a, 3) * p[i] + 3 * Math.pow(1 - a, 2) * a * o[i] + 3 * (1 - a) * Math.pow(a, 2) * s[i] + Math.pow(a, 3) * q[i]
            }, c = 6 * p[i] - 12 * o[i] + 6 * s[i], d = -3 * p[i] + 9 * o[i] - 9 * s[i] + 3 * q[i], h = 3 * o[i] - 3 * p[i], 0 == d) {
              0 != c && (c = -h / c, 0 < c && 1 > c && (0 == i && this.addX(a(c)), 1 == i && this.addY(a(c))))
            }else {
              if(h = Math.pow(c, 2) - 4 * h * d, !(0 > h) && (b = (-c + Math.sqrt(h)) / (2 * d), 0 < b && 1 > b && (0 == i && this.addX(a(b)), 1 == i && this.addY(a(b))), c = (-c - Math.sqrt(h)) / (2 * d), 0 < c && 1 > c)) {
                0 == i && this.addX(a(c)), 1 == i && this.addY(a(c))
              }
            }
          }
        };
        this.isPointInBox = function(a, c) {
          return this.x1 <= a && a <= this.x2 && this.y1 <= c && c <= this.y2
        };
        this.addPoint(a, c);
        this.addPoint(d, h)
      };
      a.Transform = function(b) {
        var c = this;
        this.Type = {};
        this.Type.translate = function(c) {
          this.p = a.CreatePoint(c);
          this.apply = function(a) {
            a.translate(this.p.x || 0, this.p.y || 0)
          };
          this.applyToPoint = function(a) {
            a.applyTransform([1, 0, 0, 1, this.p.x || 0, this.p.y || 0])
          }
        };
        this.Type.rotate = function(c) {
          c = a.ToNumberArray(c);
          this.angle = new a.Property("angle", c[0]);
          this.cx = c[1] || 0;
          this.cy = c[2] || 0;
          this.apply = function(a) {
            a.translate(this.cx, this.cy);
            a.rotate(this.angle.toRadians());
            a.translate(-this.cx, -this.cy)
          };
          this.applyToPoint = function(a) {
            var c = this.angle.toRadians();
            a.applyTransform([1, 0, 0, 1, this.p.x || 0, this.p.y || 0]);
            a.applyTransform([Math.cos(c), Math.sin(c), -Math.sin(c), Math.cos(c), 0, 0]);
            a.applyTransform([1, 0, 0, 1, -this.p.x || 0, -this.p.y || 0])
          }
        };
        this.Type.scale = function(c) {
          this.p = a.CreatePoint(c);
          this.apply = function(a) {
            a.scale(this.p.x || 1, this.p.y || this.p.x || 1)
          };
          this.applyToPoint = function(a) {
            a.applyTransform([this.p.x || 0, 0, 0, this.p.y || 0, 0, 0])
          }
        };
        this.Type.matrix = function(c) {
          this.m = a.ToNumberArray(c);
          this.apply = function(a) {
            a.transform(this.m[0], this.m[1], this.m[2], this.m[3], this.m[4], this.m[5])
          };
          this.applyToPoint = function(a) {
            a.applyTransform(this.m)
          }
        };
        this.Type.SkewBase = function(d) {
          this.base = c.Type.matrix;
          this.base(d);
          this.angle = new a.Property("angle", d)
        };
        this.Type.SkewBase.prototype = new this.Type.matrix;
        this.Type.skewX = function(a) {
          this.base = c.Type.SkewBase;
          this.base(a);
          this.m = [1, 0, Math.tan(this.angle.toRadians()), 1, 0, 0]
        };
        this.Type.skewX.prototype = new this.Type.SkewBase;
        this.Type.skewY = function(a) {
          this.base = c.Type.SkewBase;
          this.base(a);
          this.m = [1, Math.tan(this.angle.toRadians()), 0, 1, 0, 0]
        };
        this.Type.skewY.prototype = new this.Type.SkewBase;
        this.transforms = [];
        this.apply = function(a) {
          for(var c = 0;c < this.transforms.length;c++) {
            this.transforms[c].apply(a)
          }
        };
        this.applyToPoint = function(a) {
          for(var c = 0;c < this.transforms.length;c++) {
            this.transforms[c].applyToPoint(a)
          }
        };
        for(var b = a.trim(a.compressSpaces(b)).split(/\s(?=[a-z])/), d = 0;d < b.length;d++) {
          var h = b[d].split("(")[0], e = b[d].split("(")[1].replace(")", ""), h = new this.Type[h](e);
          this.transforms.push(h)
        }
      };
      a.AspectRatio = function(b, c, d, h, e, f, g, k, j, l) {
        var c = a.compressSpaces(c), c = c.replace(/^defer\s/, ""), n = c.split(" ")[0] || "xMidYMid", c = c.split(" ")[1] || "meet", m = d / h, p = e / f, o = Math.min(m, p), s = Math.max(m, p);
        "meet" == c && (h *= o, f *= o);
        "slice" == c && (h *= s, f *= s);
        j = new a.Property("refX", j);
        l = new a.Property("refY", l);
        j.hasValue() && l.hasValue() ? b.translate(-o * j.toPixels("x"), -o * l.toPixels("y")) : (n.match(/^xMid/) && ("meet" == c && o == p || "slice" == c && s == p) && b.translate(d / 2 - h / 2, 0), n.match(/YMid$/) && ("meet" == c && o == m || "slice" == c && s == m) && b.translate(0, e / 2 - f / 2), n.match(/^xMax/) && ("meet" == c && o == p || "slice" == c && s == p) && b.translate(d - h, 0), n.match(/YMax$/) && ("meet" == c && o == m || "slice" == c && s == m) && b.translate(0, e - f));
        "none" == n ? b.scale(m, p) : "meet" == c ? b.scale(o, o) : "slice" == c && b.scale(s, s);
        b.translate(null == g ? 0 : -g, null == k ? 0 : -k)
      };
      a.Element = {};
      a.EmptyProperty = new a.Property("EMPTY", "");
      a.Element.ElementBase = function(b) {
        this.attributes = {};
        this.styles = {};
        this.children = [];
        this.attribute = function(c, d) {
          var h = this.attributes[c];
          if(null != h) {
            return h
          }
          !0 == d && (h = new a.Property(c, ""), this.attributes[c] = h);
          return h || a.EmptyProperty
        };
        this.style = function(c, d) {
          var h = this.styles[c];
          if(null != h) {
            return h
          }
          var b = this.attribute(c);
          if(null != b && b.hasValue()) {
            return this.styles[c] = b
          }
          b = this.parent;
          if(null != b && (b = b.style(c), null != b && b.hasValue())) {
            return b
          }
          !0 == d && (h = new a.Property(c, ""), this.styles[c] = h);
          return h || a.EmptyProperty
        };
        this.render = function(a) {
          if("none" != this.style("display").value && "hidden" != this.attribute("visibility").value) {
            a.save();
            this.setContext(a);
            if(this.attribute("mask").hasValue()) {
              var c = this.attribute("mask").getDefinition();
              null != c && c.apply(a, this)
            }else {
              this.style("filter").hasValue() ? (c = this.style("filter").getDefinition(), null != c && c.apply(a, this)) : this.renderChildren(a)
            }
            this.clearContext(a);
            a.restore()
          }
        };
        this.setContext = function() {
        };
        this.clearContext = function() {
        };
        this.renderChildren = function(a) {
          for(var c = 0;c < this.children.length;c++) {
            this.children[c].render(a)
          }
        };
        this.addChild = function(c, d) {
          var h = c;
          d && (h = a.CreateElement(c));
          h.parent = this;
          this.children.push(h)
        };
        if(null != b && 1 == b.nodeType) {
          for(var c = 0;c < b.childNodes.length;c++) {
            var d = b.childNodes[c];
            1 == d.nodeType && this.addChild(d, !0)
          }
          for(c = 0;c < b.attributes.length;c++) {
            d = b.attributes[c], this.attributes[d.nodeName] = new a.Property(d.nodeName, d.nodeValue)
          }
          d = a.Styles[b.nodeName];
          if(null != d) {
            for(var h in d) {
              this.styles[h] = d[h]
            }
          }
          if(this.attribute("class").hasValue()) {
            for(var c = a.compressSpaces(this.attribute("class").value).split(" "), e = 0;e < c.length;e++) {
              d = a.Styles["." + c[e]];
              if(null != d) {
                for(h in d) {
                  this.styles[h] = d[h]
                }
              }
              d = a.Styles[b.nodeName + "." + c[e]];
              if(null != d) {
                for(h in d) {
                  this.styles[h] = d[h]
                }
              }
            }
          }
          if(this.attribute("id").hasValue() && (d = a.Styles["#" + this.attribute("id").value], null != d)) {
            for(h in d) {
              this.styles[h] = d[h]
            }
          }
          if(this.attribute("style").hasValue()) {
            d = this.attribute("style").value.split(";");
            for(c = 0;c < d.length;c++) {
              "" != a.trim(d[c]) && (b = d[c].split(":"), h = a.trim(b[0]), b = a.trim(b[1]), this.styles[h] = new a.Property(h, b))
            }
          }
          this.attribute("id").hasValue() && null == a.Definitions[this.attribute("id").value] && (a.Definitions[this.attribute("id").value] = this)
        }
      };
      a.Element.RenderedElementBase = function(b) {
        this.base = a.Element.ElementBase;
        this.base(b);
        this.setContext = function(c) {
          if(this.style("fill").isUrlDefinition()) {
            var d = this.style("fill").getFillStyleDefinition(this);
            null != d && (c.fillStyle = d)
          }else {
            this.style("fill").hasValue() && (d = this.style("fill"), "currentColor" == d.value && (d.value = this.style("color").value), c.fillStyle = "none" == d.value ? "rgba(0,0,0,0)" : d.value)
          }
          this.style("fill-opacity").hasValue() && (d = new a.Property("fill", c.fillStyle), d = d.addOpacity(this.style("fill-opacity").value), c.fillStyle = d.value);
          this.style("stroke").isUrlDefinition() ? (d = this.style("stroke").getFillStyleDefinition(this), null != d && (c.strokeStyle = d)) : this.style("stroke").hasValue() && (d = this.style("stroke"), "currentColor" == d.value && (d.value = this.style("color").value), c.strokeStyle = "none" == d.value ? "rgba(0,0,0,0)" : d.value);
          this.style("stroke-opacity").hasValue() && (d = new a.Property("stroke", c.strokeStyle), d = d.addOpacity(this.style("stroke-opacity").value), c.strokeStyle = d.value);
          this.style("stroke-width").hasValue() && (c.lineWidth = this.style("stroke-width").toPixels());
          this.style("stroke-linecap").hasValue() && (c.lineCap = this.style("stroke-linecap").value);
          this.style("stroke-linejoin").hasValue() && (c.lineJoin = this.style("stroke-linejoin").value);
          this.style("stroke-miterlimit").hasValue() && (c.miterLimit = this.style("stroke-miterlimit").value);
          "undefined" != typeof c.font && (c.font = a.Font.CreateFont(this.style("font-style").value, this.style("font-variant").value, this.style("font-weight").value, this.style("font-size").hasValue() ? this.style("font-size").toPixels() + "px" : "", this.style("font-family").value).toString());
          this.attribute("transform").hasValue() && (new a.Transform(this.attribute("transform").value)).apply(c);
          this.attribute("clip-path").hasValue() && (d = this.attribute("clip-path").getDefinition(), null != d && d.apply(c));
          this.style("opacity").hasValue() && (c.globalAlpha = this.style("opacity").numValue())
        }
      };
      a.Element.RenderedElementBase.prototype = new a.Element.ElementBase;
      a.Element.PathElementBase = function(b) {
        this.base = a.Element.RenderedElementBase;
        this.base(b);
        this.path = function(c) {
          null != c && c.beginPath();
          return new a.BoundingBox
        };
        this.renderChildren = function(c) {
          this.path(c);
          a.Mouse.checkPath(this, c);
          "" != c.fillStyle && c.fill();
          "" != c.strokeStyle && c.stroke();
          var d = this.getMarkers();
          if(null != d) {
            if(this.style("marker-start").isUrlDefinition()) {
              var h = this.style("marker-start").getDefinition();
              h.render(c, d[0][0], d[0][1])
            }
            if(this.style("marker-mid").isUrlDefinition()) {
              for(var h = this.style("marker-mid").getDefinition(), b = 1;b < d.length - 1;b++) {
                h.render(c, d[b][0], d[b][1])
              }
            }
            this.style("marker-end").isUrlDefinition() && (h = this.style("marker-end").getDefinition(), h.render(c, d[d.length - 1][0], d[d.length - 1][1]))
          }
        };
        this.getBoundingBox = function() {
          return this.path()
        };
        this.getMarkers = function() {
          return null
        }
      };
      a.Element.PathElementBase.prototype = new a.Element.RenderedElementBase;
      a.Element.svg = function(b) {
        this.base = a.Element.RenderedElementBase;
        this.base(b);
        this.baseClearContext = this.clearContext;
        this.clearContext = function(c) {
          this.baseClearContext(c);
          a.ViewPort.RemoveCurrent()
        };
        this.baseSetContext = this.setContext;
        this.setContext = function(c) {
          c.strokeStyle = "rgba(0,0,0,0)";
          c.lineCap = "butt";
          c.lineJoin = "miter";
          c.miterLimit = 4;
          this.baseSetContext(c);
          this.attribute("x").hasValue() || (this.attribute("x", !0).value = 0);
          this.attribute("y").hasValue() || (this.attribute("y", !0).value = 0);
          c.translate(this.attribute("x").toPixels("x"), this.attribute("y").toPixels("y"));
          var d = a.ViewPort.width(), h = a.ViewPort.height();
          this.attribute("width").hasValue() || (this.attribute("width", !0).value = "100%");
          this.attribute("height").hasValue() || (this.attribute("height", !0).value = "100%");
          if("undefined" == typeof this.root) {
            var d = this.attribute("width").toPixels("x"), h = this.attribute("height").toPixels("y"), b = 0, f = 0;
            this.attribute("refX").hasValue() && this.attribute("refY").hasValue() && (b = -this.attribute("refX").toPixels("x"), f = -this.attribute("refY").toPixels("y"));
            c.beginPath();
            c.moveTo(b, f);
            c.lineTo(d, f);
            c.lineTo(d, h);
            c.lineTo(b, h);
            c.closePath();
            c.clip()
          }
          a.ViewPort.SetCurrent(d, h);
          if(this.attribute("viewBox").hasValue()) {
            var b = a.ToNumberArray(this.attribute("viewBox").value), f = b[0], g = b[1], d = b[2], h = b[3];
            a.AspectRatio(c, this.attribute("preserveAspectRatio").value, a.ViewPort.width(), d, a.ViewPort.height(), h, f, g, this.attribute("refX").value, this.attribute("refY").value);
            a.ViewPort.RemoveCurrent();
            a.ViewPort.SetCurrent(b[2], b[3])
          }
        }
      };
      a.Element.svg.prototype = new a.Element.RenderedElementBase;
      a.Element.rect = function(b) {
        this.base = a.Element.PathElementBase;
        this.base(b);
        this.path = function(c) {
          var d = this.attribute("x").toPixels("x"), b = this.attribute("y").toPixels("y"), e = this.attribute("width").toPixels("x"), f = this.attribute("height").toPixels("y"), g = this.attribute("rx").toPixels("x"), k = this.attribute("ry").toPixels("y");
          this.attribute("rx").hasValue() && !this.attribute("ry").hasValue() && (k = g);
          this.attribute("ry").hasValue() && !this.attribute("rx").hasValue() && (g = k);
          null != c && (c.beginPath(), c.moveTo(d + g, b), c.lineTo(d + e - g, b), c.quadraticCurveTo(d + e, b, d + e, b + k), c.lineTo(d + e, b + f - k), c.quadraticCurveTo(d + e, b + f, d + e - g, b + f), c.lineTo(d + g, b + f), c.quadraticCurveTo(d, b + f, d, b + f - k), c.lineTo(d, b + k), c.quadraticCurveTo(d, b, d + g, b), c.closePath());
          return new a.BoundingBox(d, b, d + e, b + f)
        }
      };
      a.Element.rect.prototype = new a.Element.PathElementBase;
      a.Element.circle = function(b) {
        this.base = a.Element.PathElementBase;
        this.base(b);
        this.path = function(c) {
          var d = this.attribute("cx").toPixels("x"), b = this.attribute("cy").toPixels("y"), e = this.attribute("r").toPixels();
          null != c && (c.beginPath(), c.arc(d, b, e, 0, 2 * Math.PI, !0), c.closePath());
          return new a.BoundingBox(d - e, b - e, d + e, b + e)
        }
      };
      a.Element.circle.prototype = new a.Element.PathElementBase;
      a.Element.ellipse = function(b) {
        this.base = a.Element.PathElementBase;
        this.base(b);
        this.path = function(c) {
          var d = 4 * ((Math.sqrt(2) - 1) / 3), b = this.attribute("rx").toPixels("x"), e = this.attribute("ry").toPixels("y"), f = this.attribute("cx").toPixels("x"), g = this.attribute("cy").toPixels("y");
          null != c && (c.beginPath(), c.moveTo(f, g - e), c.bezierCurveTo(f + d * b, g - e, f + b, g - d * e, f + b, g), c.bezierCurveTo(f + b, g + d * e, f + d * b, g + e, f, g + e), c.bezierCurveTo(f - d * b, g + e, f - b, g + d * e, f - b, g), c.bezierCurveTo(f - b, g - d * e, f - d * b, g - e, f, g - e), c.closePath());
          return new a.BoundingBox(f - b, g - e, f + b, g + e)
        }
      };
      a.Element.ellipse.prototype = new a.Element.PathElementBase;
      a.Element.line = function(b) {
        this.base = a.Element.PathElementBase;
        this.base(b);
        this.getPoints = function() {
          return[new a.Point(this.attribute("x1").toPixels("x"), this.attribute("y1").toPixels("y")), new a.Point(this.attribute("x2").toPixels("x"), this.attribute("y2").toPixels("y"))]
        };
        this.path = function(c) {
          var d = this.getPoints();
          null != c && (c.beginPath(), c.moveTo(d[0].x, d[0].y), c.lineTo(d[1].x, d[1].y));
          return new a.BoundingBox(d[0].x, d[0].y, d[1].x, d[1].y)
        };
        this.getMarkers = function() {
          var a = this.getPoints(), d = a[0].angleTo(a[1]);
          return[[a[0], d], [a[1], d]]
        }
      };
      a.Element.line.prototype = new a.Element.PathElementBase;
      a.Element.polyline = function(b) {
        this.base = a.Element.PathElementBase;
        this.base(b);
        this.points = a.CreatePath(this.attribute("points").value);
        this.path = function(c) {
          var d = new a.BoundingBox(this.points[0].x, this.points[0].y);
          null != c && (c.beginPath(), c.moveTo(this.points[0].x, this.points[0].y));
          for(var b = 1;b < this.points.length;b++) {
            d.addPoint(this.points[b].x, this.points[b].y), null != c && c.lineTo(this.points[b].x, this.points[b].y)
          }
          return d
        };
        this.getMarkers = function() {
          for(var a = [], d = 0;d < this.points.length - 1;d++) {
            a.push([this.points[d], this.points[d].angleTo(this.points[d + 1])])
          }
          a.push([this.points[this.points.length - 1], a[a.length - 1][1]]);
          return a
        }
      };
      a.Element.polyline.prototype = new a.Element.PathElementBase;
      a.Element.polygon = function(b) {
        this.base = a.Element.polyline;
        this.base(b);
        this.basePath = this.path;
        this.path = function(a) {
          var d = this.basePath(a);
          null != a && (a.lineTo(this.points[0].x, this.points[0].y), a.closePath());
          return d
        }
      };
      a.Element.polygon.prototype = new a.Element.polyline;
      a.Element.path = function(b) {
        this.base = a.Element.PathElementBase;
        this.base(b);
        b = this.attribute("d").value;
        b = b.replace(/,/gm, " ");
        b = b.replace(/([MmZzLlHhVvCcSsQqTtAa])([MmZzLlHhVvCcSsQqTtAa])/gm, "$1 $2");
        b = b.replace(/([MmZzLlHhVvCcSsQqTtAa])([MmZzLlHhVvCcSsQqTtAa])/gm, "$1 $2");
        b = b.replace(/([MmZzLlHhVvCcSsQqTtAa])([^\s])/gm, "$1 $2");
        b = b.replace(/([^\s])([MmZzLlHhVvCcSsQqTtAa])/gm, "$1 $2");
        b = b.replace(/([0-9])([+\-])/gm, "$1 $2");
        b = b.replace(/(\.[0-9]*)(\.)/gm, "$1 $2");
        b = b.replace(/([Aa](\s+[0-9]+){3})\s+([01])\s*([01])/gm, "$1 $3 $4 ");
        b = a.compressSpaces(b);
        b = a.trim(b);
        this.PathParser = new function(c) {
          this.tokens = c.split(" ");
          this.reset = function() {
            this.i = -1;
            this.previousCommand = this.command = "";
            this.start = new a.Point(0, 0);
            this.control = new a.Point(0, 0);
            this.current = new a.Point(0, 0);
            this.points = [];
            this.angles = []
          };
          this.isEnd = function() {
            return this.i >= this.tokens.length - 1
          };
          this.isCommandOrEnd = function() {
            return this.isEnd() ? !0 : null != this.tokens[this.i + 1].match(/^[A-Za-z]$/)
          };
          this.isRelativeCommand = function() {
            switch(this.command) {
              case "m":
              ;
              case "l":
              ;
              case "h":
              ;
              case "v":
              ;
              case "c":
              ;
              case "s":
              ;
              case "q":
              ;
              case "t":
              ;
              case "a":
              ;
              case "z":
                return!0
            }
            return!1
          };
          this.getToken = function() {
            this.i++;
            return this.tokens[this.i]
          };
          this.getScalar = function() {
            return parseFloat(this.getToken())
          };
          this.nextCommand = function() {
            this.previousCommand = this.command;
            this.command = this.getToken()
          };
          this.getPoint = function() {
            var c = new a.Point(this.getScalar(), this.getScalar());
            return this.makeAbsolute(c)
          };
          this.getAsControlPoint = function() {
            var a = this.getPoint();
            return this.control = a
          };
          this.getAsCurrentPoint = function() {
            var a = this.getPoint();
            return this.current = a
          };
          this.getReflectedControlPoint = function() {
            return"c" != this.previousCommand.toLowerCase() && "s" != this.previousCommand.toLowerCase() ? this.current : new a.Point(2 * this.current.x - this.control.x, 2 * this.current.y - this.control.y)
          };
          this.makeAbsolute = function(a) {
            this.isRelativeCommand() && (a.x += this.current.x, a.y += this.current.y);
            return a
          };
          this.addMarker = function(a, c, b) {
            null != b && (0 < this.angles.length && null == this.angles[this.angles.length - 1]) && (this.angles[this.angles.length - 1] = this.points[this.points.length - 1].angleTo(b));
            this.addMarkerAngle(a, null == c ? null : c.angleTo(a))
          };
          this.addMarkerAngle = function(a, c) {
            this.points.push(a);
            this.angles.push(c)
          };
          this.getMarkerPoints = function() {
            return this.points
          };
          this.getMarkerAngles = function() {
            for(var a = 0;a < this.angles.length;a++) {
              if(null == this.angles[a]) {
                for(var c = a + 1;c < this.angles.length;c++) {
                  if(null != this.angles[c]) {
                    this.angles[a] = this.angles[c];
                    break
                  }
                }
              }
            }
            return this.angles
          }
        }(b);
        this.path = function(c) {
          var d = this.PathParser;
          d.reset();
          var b = new a.BoundingBox;
          for(null != c && c.beginPath();!d.isEnd();) {
            switch(d.nextCommand(), d.command) {
              case "M":
              ;
              case "m":
                var e = d.getAsCurrentPoint();
                d.addMarker(e);
                b.addPoint(e.x, e.y);
                null != c && c.moveTo(e.x, e.y);
                for(d.start = d.current;!d.isCommandOrEnd();) {
                  e = d.getAsCurrentPoint(), d.addMarker(e, d.start), b.addPoint(e.x, e.y), null != c && c.lineTo(e.x, e.y)
                }
                break;
              case "L":
              ;
              case "l":
                for(;!d.isCommandOrEnd();) {
                  var f = d.current, e = d.getAsCurrentPoint();
                  d.addMarker(e, f);
                  b.addPoint(e.x, e.y);
                  null != c && c.lineTo(e.x, e.y)
                }
                break;
              case "H":
              ;
              case "h":
                for(;!d.isCommandOrEnd();) {
                  e = new a.Point((d.isRelativeCommand() ? d.current.x : 0) + d.getScalar(), d.current.y), d.addMarker(e, d.current), d.current = e, b.addPoint(d.current.x, d.current.y), null != c && c.lineTo(d.current.x, d.current.y)
                }
                break;
              case "V":
              ;
              case "v":
                for(;!d.isCommandOrEnd();) {
                  e = new a.Point(d.current.x, (d.isRelativeCommand() ? d.current.y : 0) + d.getScalar()), d.addMarker(e, d.current), d.current = e, b.addPoint(d.current.x, d.current.y), null != c && c.lineTo(d.current.x, d.current.y)
                }
                break;
              case "C":
              ;
              case "c":
                for(;!d.isCommandOrEnd();) {
                  var g = d.current, f = d.getPoint(), k = d.getAsControlPoint(), e = d.getAsCurrentPoint();
                  d.addMarker(e, k, f);
                  b.addBezierCurve(g.x, g.y, f.x, f.y, k.x, k.y, e.x, e.y);
                  null != c && c.bezierCurveTo(f.x, f.y, k.x, k.y, e.x, e.y)
                }
                break;
              case "S":
              ;
              case "s":
                for(;!d.isCommandOrEnd();) {
                  g = d.current, f = d.getReflectedControlPoint(), k = d.getAsControlPoint(), e = d.getAsCurrentPoint(), d.addMarker(e, k, f), b.addBezierCurve(g.x, g.y, f.x, f.y, k.x, k.y, e.x, e.y), null != c && c.bezierCurveTo(f.x, f.y, k.x, k.y, e.x, e.y)
                }
                break;
              case "Q":
              ;
              case "q":
                for(;!d.isCommandOrEnd();) {
                  g = d.current, k = d.getAsControlPoint(), e = d.getAsCurrentPoint(), d.addMarker(e, k, k), b.addQuadraticCurve(g.x, g.y, k.x, k.y, e.x, e.y), null != c && c.quadraticCurveTo(k.x, k.y, e.x, e.y)
                }
                break;
              case "T":
              ;
              case "t":
                for(;!d.isCommandOrEnd();) {
                  g = d.current, k = d.getReflectedControlPoint(), d.control = k, e = d.getAsCurrentPoint(), d.addMarker(e, k, k), b.addQuadraticCurve(g.x, g.y, k.x, k.y, e.x, e.y), null != c && c.quadraticCurveTo(k.x, k.y, e.x, e.y)
                }
                break;
              case "A":
              ;
              case "a":
                for(;!d.isCommandOrEnd();) {
                  var g = d.current, j = d.getScalar(), l = d.getScalar(), f = d.getScalar() * (Math.PI / 180), n = d.getScalar(), k = d.getScalar(), e = d.getAsCurrentPoint(), m = new a.Point(Math.cos(f) * (g.x - e.x) / 2 + Math.sin(f) * (g.y - e.y) / 2, -Math.sin(f) * (g.x - e.x) / 2 + Math.cos(f) * (g.y - e.y) / 2), p = Math.pow(m.x, 2) / Math.pow(j, 2) + Math.pow(m.y, 2) / Math.pow(l, 2);
                  1 < p && (j *= Math.sqrt(p), l *= Math.sqrt(p));
                  n = (n == k ? -1 : 1) * Math.sqrt((Math.pow(j, 2) * Math.pow(l, 2) - Math.pow(j, 2) * Math.pow(m.y, 2) - Math.pow(l, 2) * Math.pow(m.x, 2)) / (Math.pow(j, 2) * Math.pow(m.y, 2) + Math.pow(l, 2) * Math.pow(m.x, 2)));
                  isNaN(n) && (n = 0);
                  var o = new a.Point(n * j * m.y / l, n * -l * m.x / j), g = new a.Point((g.x + e.x) / 2 + Math.cos(f) * o.x - Math.sin(f) * o.y, (g.y + e.y) / 2 + Math.sin(f) * o.x + Math.cos(f) * o.y), s = function(a, c) {
                    return(a[0] * c[0] + a[1] * c[1]) / (Math.sqrt(Math.pow(a[0], 2) + Math.pow(a[1], 2)) * Math.sqrt(Math.pow(c[0], 2) + Math.pow(c[1], 2)))
                  }, q = function(a, c) {
                    return(a[0] * c[1] < a[1] * c[0] ? -1 : 1) * Math.acos(s(a, c))
                  }, n = q([1, 0], [(m.x - o.x) / j, (m.y - o.y) / l]), p = [(m.x - o.x) / j, (m.y - o.y) / l], o = [(-m.x - o.x) / j, (-m.y - o.y) / l], m = q(p, o);
                  -1 >= s(p, o) && (m = Math.PI);
                  1 <= s(p, o) && (m = 0);
                  0 == k && 0 < m && (m -= 2 * Math.PI);
                  1 == k && 0 > m && (m += 2 * Math.PI);
                  p = new a.Point(g.x + j * Math.cos((n + (n + m)) / 2), g.y + l * Math.sin((n + (n + m)) / 2));
                  d.addMarkerAngle(p, (n + (n + m)) / 2 + (0 == k ? -1 : 1) * Math.PI / 2);
                  d.addMarkerAngle(e, n + m + (0 == k ? -1 : 1) * Math.PI / 2);
                  b.addPoint(e.x, e.y);
                  null != c && (s = j > l ? j : l, e = j > l ? 1 : j / l, j = j > l ? l / j : 1, c.translate(g.x, g.y), c.rotate(f), c.scale(e, j), c.arc(0, 0, s, n, n + m, 1 - k), c.scale(1 / e, 1 / j), c.rotate(-f), c.translate(-g.x, -g.y))
                }
                break;
              case "Z":
              ;
              case "z":
                null != c && c.closePath(), d.current = d.start
            }
          }
          return b
        };
        this.getMarkers = function() {
          for(var a = this.PathParser.getMarkerPoints(), d = this.PathParser.getMarkerAngles(), b = [], e = 0;e < a.length;e++) {
            b.push([a[e], d[e]])
          }
          return b
        }
      };
      a.Element.path.prototype = new a.Element.PathElementBase;
      a.Element.pattern = function(b) {
        this.base = a.Element.ElementBase;
        this.base(b);
        this.createPattern = function(c) {
          var d = new a.Element.svg;
          d.attributes.viewBox = new a.Property("viewBox", this.attribute("viewBox").value);
          d.attributes.x = new a.Property("x", this.attribute("x").value);
          d.attributes.y = new a.Property("y", this.attribute("y").value);
          d.attributes.width = new a.Property("width", this.attribute("width").value);
          d.attributes.height = new a.Property("height", this.attribute("height").value);
          d.children = this.children;
          var b = document.createElement("canvas");
          document.body.appendChild(b);
          b.width = this.attribute("width").toPixels("x") + this.attribute("x").toPixels("x");
          b.height = this.attribute("height").toPixels("y") + this.attribute("y").toPixels("y");
          d.render(b.getContext("2d"));
          return c.createPattern(b, "repeat")
        }
      };
      a.Element.pattern.prototype = new a.Element.ElementBase;
      a.Element.marker = function(b) {
        this.base = a.Element.ElementBase;
        this.base(b);
        this.baseRender = this.render;
        this.render = function(c, d, b) {
          c.translate(d.x, d.y);
          "auto" == this.attribute("orient").valueOrDefault("auto") && c.rotate(b);
          "strokeWidth" == this.attribute("markerUnits").valueOrDefault("strokeWidth") && c.scale(c.lineWidth, c.lineWidth);
          c.save();
          var e = new a.Element.svg;
          e.attributes.viewBox = new a.Property("viewBox", this.attribute("viewBox").value);
          e.attributes.refX = new a.Property("refX", this.attribute("refX").value);
          e.attributes.refY = new a.Property("refY", this.attribute("refY").value);
          e.attributes.width = new a.Property("width", this.attribute("markerWidth").value);
          e.attributes.height = new a.Property("height", this.attribute("markerHeight").value);
          e.attributes.fill = new a.Property("fill", this.attribute("fill").valueOrDefault("black"));
          e.attributes.stroke = new a.Property("stroke", this.attribute("stroke").valueOrDefault("none"));
          e.children = this.children;
          e.render(c);
          c.restore();
          "strokeWidth" == this.attribute("markerUnits").valueOrDefault("strokeWidth") && c.scale(1 / c.lineWidth, 1 / c.lineWidth);
          "auto" == this.attribute("orient").valueOrDefault("auto") && c.rotate(-b);
          c.translate(-d.x, -d.y)
        }
      };
      a.Element.marker.prototype = new a.Element.ElementBase;
      a.Element.defs = function(b) {
        this.base = a.Element.ElementBase;
        this.base(b);
        this.render = function() {
        }
      };
      a.Element.defs.prototype = new a.Element.ElementBase;
      a.Element.GradientBase = function(b) {
        this.base = a.Element.ElementBase;
        this.base(b);
        this.gradientUnits = this.attribute("gradientUnits").valueOrDefault("objectBoundingBox");
        this.stops = [];
        for(b = 0;b < this.children.length;b++) {
          this.stops.push(this.children[b])
        }
        this.getGradient = function() {
        };
        this.createGradient = function(c, d) {
          var b = this;
          this.attribute("xlink:href").hasValue() && (b = this.attribute("xlink:href").getDefinition());
          var e = this.getGradient(c, d);
          if(null == e) {
            return b.stops[b.stops.length - 1].color
          }
          for(var f = 0;f < b.stops.length;f++) {
            e.addColorStop(b.stops[f].offset, b.stops[f].color)
          }
          if(this.attribute("gradientTransform").hasValue()) {
            b = a.ViewPort.viewPorts[0];
            f = new a.Element.rect;
            f.attributes.x = new a.Property("x", -a.MAX_VIRTUAL_PIXELS / 3);
            f.attributes.y = new a.Property("y", -a.MAX_VIRTUAL_PIXELS / 3);
            f.attributes.width = new a.Property("width", a.MAX_VIRTUAL_PIXELS);
            f.attributes.height = new a.Property("height", a.MAX_VIRTUAL_PIXELS);
            var g = new a.Element.g;
            g.attributes.transform = new a.Property("transform", this.attribute("gradientTransform").value);
            g.children = [f];
            f = new a.Element.svg;
            f.attributes.x = new a.Property("x", 0);
            f.attributes.y = new a.Property("y", 0);
            f.attributes.width = new a.Property("width", b.width);
            f.attributes.height = new a.Property("height", b.height);
            f.children = [g];
            g = document.createElement("canvas");
            g.width = b.width;
            g.height = b.height;
            b = g.getContext("2d");
            b.fillStyle = e;
            f.render(b);
            return b.createPattern(g, "no-repeat")
          }
          return e
        }
      };
      a.Element.GradientBase.prototype = new a.Element.ElementBase;
      a.Element.linearGradient = function(b) {
        this.base = a.Element.GradientBase;
        this.base(b);
        this.getGradient = function(a, d) {
          var b = d.getBoundingBox(), e = "objectBoundingBox" == this.gradientUnits ? b.x() + b.width() * this.attribute("x1").numValue() : this.attribute("x1").toPixels("x"), f = "objectBoundingBox" == this.gradientUnits ? b.y() + b.height() * this.attribute("y1").numValue() : this.attribute("y1").toPixels("y"), g = "objectBoundingBox" == this.gradientUnits ? b.x() + b.width() * this.attribute("x2").numValue() : this.attribute("x2").toPixels("x"), b = "objectBoundingBox" == this.gradientUnits ? 
          b.y() + b.height() * this.attribute("y2").numValue() : this.attribute("y2").toPixels("y");
          return e == g && f == b ? null : a.createLinearGradient(e, f, g, b)
        }
      };
      a.Element.linearGradient.prototype = new a.Element.GradientBase;
      a.Element.radialGradient = function(b) {
        this.base = a.Element.GradientBase;
        this.base(b);
        this.getGradient = function(a, d) {
          var b = d.getBoundingBox();
          this.attribute("cx").hasValue() || (this.attribute("cx", !0).value = "50%");
          this.attribute("cy").hasValue() || (this.attribute("cy", !0).value = "50%");
          this.attribute("r").hasValue() || (this.attribute("r", !0).value = "50%");
          var e = "objectBoundingBox" == this.gradientUnits ? b.x() + b.width() * this.attribute("cx").numValue() : this.attribute("cx").toPixels("x"), f = "objectBoundingBox" == this.gradientUnits ? b.y() + b.height() * this.attribute("cy").numValue() : this.attribute("cy").toPixels("y"), g = e, k = f;
          this.attribute("fx").hasValue() && (g = "objectBoundingBox" == this.gradientUnits ? b.x() + b.width() * this.attribute("fx").numValue() : this.attribute("fx").toPixels("x"));
          this.attribute("fy").hasValue() && (k = "objectBoundingBox" == this.gradientUnits ? b.y() + b.height() * this.attribute("fy").numValue() : this.attribute("fy").toPixels("y"));
          b = "objectBoundingBox" == this.gradientUnits ? (b.width() + b.height()) / 2 * this.attribute("r").numValue() : this.attribute("r").toPixels();
          return a.createRadialGradient(g, k, 0, e, f, b)
        }
      };
      a.Element.radialGradient.prototype = new a.Element.GradientBase;
      a.Element.stop = function(b) {
        this.base = a.Element.ElementBase;
        this.base(b);
        this.offset = this.attribute("offset").numValue();
        b = this.style("stop-color");
        this.style("stop-opacity").hasValue() && (b = b.addOpacity(this.style("stop-opacity").value));
        this.color = b.value
      };
      a.Element.stop.prototype = new a.Element.ElementBase;
      a.Element.AnimateBase = function(b) {
        this.base = a.Element.ElementBase;
        this.base(b);
        a.Animations.push(this);
        this.duration = 0;
        this.begin = this.attribute("begin").toMilliseconds();
        this.maxDuration = this.begin + this.attribute("dur").toMilliseconds();
        this.getProperty = function() {
          var a = this.attribute("attributeType").value, d = this.attribute("attributeName").value;
          return"CSS" == a ? this.parent.style(d, !0) : this.parent.attribute(d, !0)
        };
        this.initialValue = null;
        this.initialUnits = "";
        this.removed = !1;
        this.calcValue = function() {
          return""
        };
        this.update = function(a) {
          null == this.initialValue && (this.initialValue = this.getProperty().value, this.initialUnits = this.getProperty().getUnits());
          if(this.duration > this.maxDuration) {
            if("indefinite" == this.attribute("repeatCount").value) {
              this.duration = 0
            }else {
              return"remove" == this.attribute("fill").valueOrDefault("remove") && !this.removed ? (this.removed = !0, this.getProperty().value = this.initialValue, !0) : !1
            }
          }
          this.duration += a;
          a = !1;
          this.begin < this.duration && (a = this.calcValue(), this.attribute("type").hasValue() && (a = this.attribute("type").value + "(" + a + ")"), this.getProperty().value = a, a = !0);
          return a
        };
        this.from = this.attribute("from");
        this.to = this.attribute("to");
        this.values = this.attribute("values");
        this.values.hasValue() && (this.values.value = this.values.value.split(";"));
        this.progress = function() {
          var c = {progress:(this.duration - this.begin) / (this.maxDuration - this.begin)};
          if(this.values.hasValue()) {
            var d = c.progress * (this.values.value.length - 1), b = Math.floor(d), e = Math.ceil(d);
            c.from = new a.Property("from", parseFloat(this.values.value[b]));
            c.to = new a.Property("to", parseFloat(this.values.value[e]));
            c.progress = (d - b) / (e - b)
          }else {
            c.from = this.from;
            c.to = this.to
          }
          return c
        }
      };
      a.Element.AnimateBase.prototype = new a.Element.ElementBase;
      a.Element.animate = function(b) {
        this.base = a.Element.AnimateBase;
        this.base(b);
        this.calcValue = function() {
          var a = this.progress();
          return a.from.numValue() + (a.to.numValue() - a.from.numValue()) * a.progress + this.initialUnits
        }
      };
      a.Element.animate.prototype = new a.Element.AnimateBase;
      a.Element.animateColor = function(b) {
        this.base = a.Element.AnimateBase;
        this.base(b);
        this.calcValue = function() {
          var a = this.progress(), d = new RGBColor(a.from.value), b = new RGBColor(a.to.value);
          if(d.ok && b.ok) {
            var e = d.g + (b.g - d.g) * a.progress, f = d.b + (b.b - d.b) * a.progress;
            return"rgb(" + parseInt(d.r + (b.r - d.r) * a.progress, 10) + "," + parseInt(e, 10) + "," + parseInt(f, 10) + ")"
          }
          return this.attribute("from").value
        }
      };
      a.Element.animateColor.prototype = new a.Element.AnimateBase;
      a.Element.animateTransform = function(b) {
        this.base = a.Element.animate;
        this.base(b)
      };
      a.Element.animateTransform.prototype = new a.Element.animate;
      a.Element.font = function(b) {
        this.base = a.Element.ElementBase;
        this.base(b);
        this.horizAdvX = this.attribute("horiz-adv-x").numValue();
        this.isArabic = this.isRTL = !1;
        this.missingGlyph = this.fontFace = null;
        this.glyphs = [];
        for(b = 0;b < this.children.length;b++) {
          var c = this.children[b];
          "font-face" == c.type ? (this.fontFace = c, c.style("font-family").hasValue() && (a.Definitions[c.style("font-family").value] = this)) : "missing-glyph" == c.type ? this.missingGlyph = c : "glyph" == c.type && ("" != c.arabicForm ? (this.isArabic = this.isRTL = !0, "undefined" == typeof this.glyphs[c.unicode] && (this.glyphs[c.unicode] = []), this.glyphs[c.unicode][c.arabicForm] = c) : this.glyphs[c.unicode] = c)
        }
      };
      a.Element.font.prototype = new a.Element.ElementBase;
      a.Element.fontface = function(b) {
        this.base = a.Element.ElementBase;
        this.base(b);
        this.ascent = this.attribute("ascent").value;
        this.descent = this.attribute("descent").value;
        this.unitsPerEm = this.attribute("units-per-em").numValue()
      };
      a.Element.fontface.prototype = new a.Element.ElementBase;
      a.Element.missingglyph = function(b) {
        this.base = a.Element.path;
        this.base(b);
        this.horizAdvX = 0
      };
      a.Element.missingglyph.prototype = new a.Element.path;
      a.Element.glyph = function(b) {
        this.base = a.Element.path;
        this.base(b);
        this.horizAdvX = this.attribute("horiz-adv-x").numValue();
        this.unicode = this.attribute("unicode").value;
        this.arabicForm = this.attribute("arabic-form").value
      };
      a.Element.glyph.prototype = new a.Element.path;
      a.Element.text = function(b) {
        this.base = a.Element.RenderedElementBase;
        this.base(b);
        if(null != b) {
          this.children = [];
          for(var c = 0;c < b.childNodes.length;c++) {
            var d = b.childNodes[c];
            1 == d.nodeType ? this.addChild(d, !0) : 3 == d.nodeType && this.addChild(new a.Element.tspan(d), !1)
          }
        }
        this.baseSetContext = this.setContext;
        this.setContext = function(a) {
          this.baseSetContext(a);
          this.style("dominant-baseline").hasValue() && (a.textBaseline = this.style("dominant-baseline").value);
          this.style("alignment-baseline").hasValue() && (a.textBaseline = this.style("alignment-baseline").value)
        };
        this.renderChildren = function(a) {
          for(var c = this.style("text-anchor").valueOrDefault("start"), d = this.attribute("x").toPixels("x"), b = this.attribute("y").toPixels("y"), k = 0;k < this.children.length;k++) {
            var j = this.children[k];
            j.attribute("x").hasValue() ? j.x = j.attribute("x").toPixels("x") : (this.attribute("dx").hasValue() && (b += this.attribute("dx").toPixels("x")), j.attribute("dx").hasValue() && (d += j.attribute("dx").toPixels("x")), j.x = d);
            d = j.measureText(a);
            if("start" != c && (0 == k || j.attribute("x").hasValue())) {
              for(var l = d, n = k + 1;n < this.children.length;n++) {
                var m = this.children[n];
                if(m.attribute("x").hasValue()) {
                  break
                }
                l += m.measureText(a)
              }
              j.x -= "end" == c ? l : l / 2
            }
            d = j.x + d;
            j.attribute("y").hasValue() ? j.y = j.attribute("y").toPixels("y") : (this.attribute("dy").hasValue() && (b += this.attribute("dy").toPixels("y")), j.attribute("dy").hasValue() && (b += j.attribute("dy").toPixels("y")), j.y = b);
            b = j.y;
            j.render(a)
          }
        }
      };
      a.Element.text.prototype = new a.Element.RenderedElementBase;
      a.Element.TextElementBase = function(b) {
        this.base = a.Element.RenderedElementBase;
        this.base(b);
        this.getGlyph = function(a, d, b) {
          var e = d[b], f = null;
          if(a.isArabic) {
            var g = "isolated";
            if((0 == b || " " == d[b - 1]) && b < d.length - 2 && " " != d[b + 1]) {
              g = "terminal"
            }
            0 < b && (" " != d[b - 1] && b < d.length - 2 && " " != d[b + 1]) && (g = "medial");
            if(0 < b && " " != d[b - 1] && (b == d.length - 1 || " " == d[b + 1])) {
              g = "initial"
            }
            "undefined" != typeof a.glyphs[e] && (f = a.glyphs[e][g], null == f && "glyph" == a.glyphs[e].type && (f = a.glyphs[e]))
          }else {
            f = a.glyphs[e]
          }
          null == f && (f = a.missingGlyph);
          return f
        };
        this.renderChildren = function(c) {
          var b = this.parent.style("font-family").getDefinition();
          if(null != b) {
            var h = this.parent.style("font-size").numValueOrDefault(a.Font.Parse(a.ctx.font).fontSize), e = this.parent.style("font-style").valueOrDefault(a.Font.Parse(a.ctx.font).fontStyle), f = this.getText();
            b.isRTL && (f = f.split("").reverse().join(""));
            for(var g = a.ToNumberArray(this.parent.attribute("dx").value), k = 0;k < f.length;k++) {
              var j = this.getGlyph(b, f, k), l = h / b.fontFace.unitsPerEm;
              c.translate(this.x, this.y);
              c.scale(l, -l);
              var n = c.lineWidth;
              c.lineWidth = c.lineWidth * b.fontFace.unitsPerEm / h;
              "italic" == e && c.transform(1, 0, 0.4, 1, 0, 0);
              j.render(c);
              "italic" == e && c.transform(1, 0, -0.4, 1, 0, 0);
              c.lineWidth = n;
              c.scale(1 / l, -1 / l);
              c.translate(-this.x, -this.y);
              this.x += h * (j.horizAdvX || b.horizAdvX) / b.fontFace.unitsPerEm;
              "undefined" != typeof g[k] && !isNaN(g[k]) && (this.x += g[k])
            }
          }else {
            "" != c.strokeStyle && c.strokeText(a.compressSpaces(this.getText()), this.x, this.y), "" != c.fillStyle && c.fillText(a.compressSpaces(this.getText()), this.x, this.y)
          }
        };
        this.getText = function() {
        };
        this.measureText = function(c) {
          var b = this.parent.style("font-family").getDefinition();
          if(null != b) {
            var c = this.parent.style("font-size").numValueOrDefault(a.Font.Parse(a.ctx.font).fontSize), h = 0, e = this.getText();
            b.isRTL && (e = e.split("").reverse().join(""));
            for(var f = a.ToNumberArray(this.parent.attribute("dx").value), g = 0;g < e.length;g++) {
              var k = this.getGlyph(b, e, g), h = h + (k.horizAdvX || b.horizAdvX) * c / b.fontFace.unitsPerEm;
              "undefined" != typeof f[g] && !isNaN(f[g]) && (h += f[g])
            }
            return h
          }
          b = a.compressSpaces(this.getText());
          if(!c.measureText) {
            return 10 * b.length
          }
          c.save();
          this.setContext(c);
          b = c.measureText(b).width;
          c.restore();
          return b
        }
      };
      a.Element.TextElementBase.prototype = new a.Element.RenderedElementBase;
      a.Element.tspan = function(b) {
        this.base = a.Element.TextElementBase;
        this.base(b);
        this.text = 3 == b.nodeType ? b.nodeValue : 0 < b.childNodes.length ? b.childNodes[0].nodeValue : b.text;
        this.getText = function() {
          return this.text
        }
      };
      a.Element.tspan.prototype = new a.Element.TextElementBase;
      a.Element.tref = function(b) {
        this.base = a.Element.TextElementBase;
        this.base(b);
        this.getText = function() {
          var a = this.attribute("xlink:href").getDefinition();
          if(null != a) {
            return a.children[0].getText()
          }
        }
      };
      a.Element.tref.prototype = new a.Element.TextElementBase;
      a.Element.a = function(b) {
        this.base = a.Element.TextElementBase;
        this.base(b);
        this.hasText = !0;
        for(var c = 0;c < b.childNodes.length;c++) {
          3 != b.childNodes[c].nodeType && (this.hasText = !1)
        }
        this.text = this.hasText ? b.childNodes[0].nodeValue : "";
        this.getText = function() {
          return this.text
        };
        this.baseRenderChildren = this.renderChildren;
        this.renderChildren = function(c) {
          if(this.hasText) {
            this.baseRenderChildren(c);
            var b = new a.Property("fontSize", a.Font.Parse(a.ctx.font).fontSize);
            a.Mouse.checkBoundingBox(this, new a.BoundingBox(this.x, this.y - b.toPixels("y"), this.x + this.measureText(c), this.y))
          }else {
            b = new a.Element.g, b.children = this.children, b.parent = this, b.render(c)
          }
        };
        this.onclick = function() {
          window.open(this.attribute("xlink:href").value)
        };
        this.onmousemove = function() {
          a.ctx.canvas.style.cursor = "pointer"
        }
      };
      a.Element.a.prototype = new a.Element.TextElementBase;
      a.Element.image = function(b) {
        this.base = a.Element.RenderedElementBase;
        this.base(b);
        var c = this.attribute("xlink:href").value, d = c.match(/\.svg$/);
        a.Images.push(this);
        this.loaded = !1;
        if(d) {
          this.img = a.ajax(c), this.loaded = !0
        }else {
          this.img = document.createElement("img");
          var h = this;
          this.img.onload = function() {
            h.loaded = !0
          };
          this.img.onerror = function() {
            console && console.log('ERROR: image "' + c + '" not found');
            h.loaded = !0
          };
          this.img.src = c
        }
        this.renderChildren = function(c) {
          var b = this.attribute("x").toPixels("x"), h = this.attribute("y").toPixels("y"), k = this.attribute("width").toPixels("x"), j = this.attribute("height").toPixels("y");
          0 == k || 0 == j || (c.save(), d ? c.drawSvg(this.img, b, h, k, j) : (c.translate(b, h), a.AspectRatio(c, this.attribute("preserveAspectRatio").value, k, this.img.width, j, this.img.height, 0, 0), c.drawImage(this.img, 0, 0)), c.restore())
        }
      };
      a.Element.image.prototype = new a.Element.RenderedElementBase;
      a.Element.g = function(b) {
        this.base = a.Element.RenderedElementBase;
        this.base(b);
        this.getBoundingBox = function() {
          for(var c = new a.BoundingBox, b = 0;b < this.children.length;b++) {
            c.addBoundingBox(this.children[b].getBoundingBox())
          }
          return c
        }
      };
      a.Element.g.prototype = new a.Element.RenderedElementBase;
      a.Element.symbol = function(b) {
        this.base = a.Element.RenderedElementBase;
        this.base(b);
        this.baseSetContext = this.setContext;
        this.setContext = function(c) {
          this.baseSetContext(c);
          if(this.attribute("viewBox").hasValue()) {
            var b = a.ToNumberArray(this.attribute("viewBox").value), h = b[0], e = b[1];
            width = b[2];
            height = b[3];
            a.AspectRatio(c, this.attribute("preserveAspectRatio").value, this.attribute("width").toPixels("x"), width, this.attribute("height").toPixels("y"), height, h, e);
            a.ViewPort.SetCurrent(b[2], b[3])
          }
        }
      };
      a.Element.symbol.prototype = new a.Element.RenderedElementBase;
      a.Element.style = function(b) {
        this.base = a.Element.ElementBase;
        this.base(b);
        for(var b = b.childNodes[0].nodeValue + (1 < b.childNodes.length ? b.childNodes[1].nodeValue : ""), b = b.replace(/(\/\*([^*]|[\r\n]|(\*+([^*\/]|[\r\n])))*\*+\/)|(^[\s]*\/\/.*)/gm, ""), b = a.compressSpaces(b), b = b.split("}"), c = 0;c < b.length;c++) {
          if("" != a.trim(b[c])) {
            for(var d = b[c].split("{"), h = d[0].split(","), d = d[1].split(";"), e = 0;e < h.length;e++) {
              var f = a.trim(h[e]);
              if("" != f) {
                for(var g = {}, k = 0;k < d.length;k++) {
                  var j = d[k].indexOf(":"), l = d[k].substr(0, j), j = d[k].substr(j + 1, d[k].length - j);
                  null != l && null != j && (g[a.trim(l)] = new a.Property(a.trim(l), a.trim(j)))
                }
                a.Styles[f] = g;
                if("@font-face" == f) {
                  f = g["font-family"].value.replace(/"/g, "");
                  g = g.src.value.split(",");
                  for(k = 0;k < g.length;k++) {
                    if(0 < g[k].indexOf('format("svg")')) {
                      l = g[k].indexOf("url");
                      j = g[k].indexOf(")", l);
                      l = g[k].substr(l + 5, j - l - 6);
                      l = a.parseXml(a.ajax(l)).getElementsByTagName("font");
                      for(j = 0;j < l.length;j++) {
                        var n = a.CreateElement(l[j]);
                        a.Definitions[f] = n
                      }
                    }
                  }
                }
              }
            }
          }
        }
      };
      a.Element.style.prototype = new a.Element.ElementBase;
      a.Element.use = function(b) {
        this.base = a.Element.RenderedElementBase;
        this.base(b);
        this.baseSetContext = this.setContext;
        this.setContext = function(a) {
          this.baseSetContext(a);
          this.attribute("x").hasValue() && a.translate(this.attribute("x").toPixels("x"), 0);
          this.attribute("y").hasValue() && a.translate(0, this.attribute("y").toPixels("y"))
        };
        this.getDefinition = function() {
          var a = this.attribute("xlink:href").getDefinition();
          this.attribute("width").hasValue() && (a.attribute("width", !0).value = this.attribute("width").value);
          this.attribute("height").hasValue() && (a.attribute("height", !0).value = this.attribute("height").value);
          return a
        };
        this.path = function(a) {
          var b = this.getDefinition();
          null != b && b.path(a)
        };
        this.renderChildren = function(a) {
          var b = this.getDefinition();
          if(null != b) {
            var h = b.parent;
            b.parent = null;
            b.render(a);
            b.parent = h
          }
        }
      };
      a.Element.use.prototype = new a.Element.RenderedElementBase;
      a.Element.mask = function(b) {
        this.base = a.Element.ElementBase;
        this.base(b);
        this.apply = function(a, b) {
          var h = this.attribute("x").toPixels("x"), e = this.attribute("y").toPixels("y"), f = this.attribute("width").toPixels("x"), g = this.attribute("height").toPixels("y"), k = b.attribute("mask").value;
          b.attribute("mask").value = "";
          var j = document.createElement("canvas");
          j.width = h + f;
          j.height = e + g;
          var l = j.getContext("2d");
          this.renderChildren(l);
          var n = document.createElement("canvas");
          n.width = h + f;
          n.height = e + g;
          var m = n.getContext("2d");
          b.render(m);
          m.globalCompositeOperation = "destination-in";
          m.fillStyle = l.createPattern(j, "no-repeat");
          m.fillRect(0, 0, h + f, e + g);
          a.fillStyle = m.createPattern(n, "no-repeat");
          a.fillRect(0, 0, h + f, e + g);
          b.attribute("mask").value = k
        };
        this.render = function() {
        }
      };
      a.Element.mask.prototype = new a.Element.ElementBase;
      a.Element.clipPath = function(b) {
        this.base = a.Element.ElementBase;
        this.base(b);
        this.apply = function(a) {
          for(var b = 0;b < this.children.length;b++) {
            this.children[b].path && (this.children[b].path(a), a.clip())
          }
        };
        this.render = function() {
        }
      };
      a.Element.clipPath.prototype = new a.Element.ElementBase;
      a.Element.filter = function(b) {
        this.base = a.Element.ElementBase;
        this.base(b);
        this.apply = function(a, b) {
          var h = b.getBoundingBox(), e = this.attribute("x").toPixels("x"), f = this.attribute("y").toPixels("y");
          if(0 == e || 0 == f) {
            e = h.x1, f = h.y1
          }
          var g = this.attribute("width").toPixels("x"), k = this.attribute("height").toPixels("y");
          if(0 == g || 0 == k) {
            g = h.width(), k = h.height()
          }
          h = b.style("filter").value;
          b.style("filter").value = "";
          var j = 0.2 * g, l = 0.2 * k, n = document.createElement("canvas");
          n.width = g + 2 * j;
          n.height = k + 2 * l;
          var m = n.getContext("2d");
          m.translate(-e + j, -f + l);
          b.render(m);
          for(var p = 0;p < this.children.length;p++) {
            this.children[p].apply(m, 0, 0, g + 2 * j, k + 2 * l)
          }
          a.drawImage(n, 0, 0, g + 2 * j, k + 2 * l, e - j, f - l, g + 2 * j, k + 2 * l);
          b.style("filter", !0).value = h
        };
        this.render = function() {
        }
      };
      a.Element.filter.prototype = new a.Element.ElementBase;
      a.Element.feGaussianBlur = function(b) {
        function c(a, b, c, f, g) {
          for(var k = 0;k < g;k++) {
            for(var j = 0;j < f;j++) {
              for(var l = a[4 * k * f + 4 * j + 3] / 255, n = 0;4 > n;n++) {
                for(var m = c[0] * (0 == l ? 255 : a[4 * k * f + 4 * j + n]) * (0 == l || 3 == n ? 1 : l), p = 1;p < c.length;p++) {
                  var o = Math.max(j - p, 0), q = a[4 * k * f + 4 * o + 3] / 255, o = Math.min(j + p, f - 1), o = a[4 * k * f + 4 * o + 3] / 255, t = c[p], r;
                  0 == q ? r = 255 : (r = Math.max(j - p, 0), r = a[4 * k * f + 4 * r + n]);
                  q = r * (0 == q || 3 == n ? 1 : q);
                  0 == o ? r = 255 : (r = Math.min(j + p, f - 1), r = a[4 * k * f + 4 * r + n]);
                  m += t * (q + r * (0 == o || 3 == n ? 1 : o))
                }
                b[4 * j * g + 4 * k + n] = m
              }
            }
          }
        }
        this.base = a.Element.ElementBase;
        this.base(b);
        this.apply = function(a, b, e, f, g) {
          var e = this.attribute("stdDeviation").numValue(), b = a.getImageData(0, 0, f, g), e = Math.max(e, 0.01), k = Math.ceil(4 * e) + 1;
          mask = [];
          for(var j = 0;j < k;j++) {
            mask[j] = Math.exp(-0.5 * (j / e) * (j / e))
          }
          e = mask;
          k = 0;
          for(j = 1;j < e.length;j++) {
            k += Math.abs(e[j])
          }
          k = 2 * k + Math.abs(e[0]);
          for(j = 0;j < e.length;j++) {
            e[j] /= k
          }
          tmp = [];
          c(b.data, tmp, e, f, g);
          c(tmp, b.data, e, g, f);
          a.clearRect(0, 0, f, g);
          a.putImageData(b, 0, 0)
        }
      };
      a.Element.filter.prototype = new a.Element.feGaussianBlur;
      a.Element.title = function() {
      };
      a.Element.title.prototype = new a.Element.ElementBase;
      a.Element.desc = function() {
      };
      a.Element.desc.prototype = new a.Element.ElementBase;
      a.Element.MISSING = function(a) {
        console && console.log("ERROR: Element '" + a.nodeName + "' not yet implemented.")
      };
      a.Element.MISSING.prototype = new a.Element.ElementBase;
      a.CreateElement = function(b) {
        var c = b.nodeName.replace(/^[^:]+:/, ""), c = c.replace(/\-/g, ""), d = null, d = "undefined" != typeof a.Element[c] ? new a.Element[c](b) : new a.Element.MISSING(b);
        d.type = b.nodeName;
        return d
      };
      a.load = function(b, c) {
        a.loadXml(b, a.ajax(c))
      };
      a.loadXml = function(b, c) {
        a.loadXmlDoc(b, a.parseXml(c))
      };
      a.loadXmlDoc = function(b, c) {
        a.init(b);
        var d = function(a) {
          for(var c = b.canvas;c;) {
            a.x -= c.offsetLeft, a.y -= c.offsetTop, c = c.offsetParent
          }
          window.scrollX && (a.x += window.scrollX);
          window.scrollY && (a.y += window.scrollY);
          return a
        };
        !0 != a.opts.ignoreMouse && (b.canvas.onclick = function(b) {
          b = d(new a.Point(null != b ? b.clientX : event.clientX, null != b ? b.clientY : event.clientY));
          a.Mouse.onclick(b.x, b.y)
        }, b.canvas.onmousemove = function(b) {
          b = d(new a.Point(null != b ? b.clientX : event.clientX, null != b ? b.clientY : event.clientY));
          a.Mouse.onmousemove(b.x, b.y)
        });
        var h = a.CreateElement(c.documentElement), e = h.root = !0, f = function() {
          a.ViewPort.Clear();
          b.canvas.parentNode && a.ViewPort.SetCurrent(b.canvas.parentNode.clientWidth, b.canvas.parentNode.clientHeight);
          if(a.opts.ignoreDimensions != true) {
            if(h.style("width").hasValue()) {
              b.canvas.width = h.style("width").toPixels("x");
              b.canvas.style.width = b.canvas.width + "px"
            }
            if(h.style("height").hasValue()) {
              b.canvas.height = h.style("height").toPixels("y");
              b.canvas.style.height = b.canvas.height + "px"
            }
          }
          var c = b.canvas.clientWidth || b.canvas.width, d = b.canvas.clientHeight || b.canvas.height;
          if(a.opts.ignoreDimensions == true && h.style("width").hasValue() && h.style("height").hasValue()) {
            c = h.style("width").toPixels("x");
            d = h.style("height").toPixels("y")
          }
          a.ViewPort.SetCurrent(c, d);
          if(a.opts.offsetX != null) {
            h.attribute("x", true).value = a.opts.offsetX
          }
          if(a.opts.offsetY != null) {
            h.attribute("y", true).value = a.opts.offsetY
          }
          if(a.opts.scaleWidth != null && a.opts.scaleHeight != null) {
            var f = 1, g = 1, m = a.ToNumberArray(h.attribute("viewBox").value);
            h.attribute("width").hasValue() ? f = h.attribute("width").toPixels("x") / a.opts.scaleWidth : isNaN(m[2]) || (f = m[2] / a.opts.scaleWidth);
            h.attribute("height").hasValue() ? g = h.attribute("height").toPixels("y") / a.opts.scaleHeight : isNaN(m[3]) || (g = m[3] / a.opts.scaleHeight);
            h.attribute("width", true).value = a.opts.scaleWidth;
            h.attribute("height", true).value = a.opts.scaleHeight;
            h.attribute("viewBox", true).value = "0 0 " + c * f + " " + d * g;
            h.attribute("preserveAspectRatio", true).value = "none"
          }
          a.opts.ignoreClear != true && b.clearRect(0, 0, c, d);
          h.render(b);
          if(e) {
            e = false;
            typeof a.opts.renderCallback == "function" && a.opts.renderCallback()
          }
        }, g = !0;
        a.ImagesLoaded() && (g = !1, f());
        a.intervalID = setInterval(function() {
          var b = false;
          if(g && a.ImagesLoaded()) {
            g = false;
            b = true
          }
          a.opts.ignoreMouse != true && (b = b | a.Mouse.hasEvents());
          if(a.opts.ignoreAnimation != true) {
            for(var c = 0;c < a.Animations.length;c++) {
              b = b | a.Animations[c].update(1E3 / a.FRAMERATE)
            }
          }
          typeof a.opts.forceRedraw == "function" && a.opts.forceRedraw() == true && (b = true);
          if(b) {
            f();
            a.Mouse.runEvents()
          }
        }, 1E3 / a.FRAMERATE)
      };
      a.stop = function() {
        a.intervalID && clearInterval(a.intervalID)
      };
      a.Mouse = new function() {
        this.events = [];
        this.hasEvents = function() {
          return 0 != this.events.length
        };
        this.onclick = function(a, c) {
          this.events.push({type:"onclick", x:a, y:c, run:function(a) {
            if(a.onclick) {
              a.onclick()
            }
          }})
        };
        this.onmousemove = function(a, c) {
          this.events.push({type:"onmousemove", x:a, y:c, run:function(a) {
            if(a.onmousemove) {
              a.onmousemove()
            }
          }})
        };
        this.eventElements = [];
        this.checkPath = function(a, c) {
          for(var d = 0;d < this.events.length;d++) {
            var h = this.events[d];
            c.isPointInPath && c.isPointInPath(h.x, h.y) && (this.eventElements[d] = a)
          }
        };
        this.checkBoundingBox = function(a, c) {
          for(var d = 0;d < this.events.length;d++) {
            var h = this.events[d];
            c.isPointInBox(h.x, h.y) && (this.eventElements[d] = a)
          }
        };
        this.runEvents = function() {
          a.ctx.canvas.style.cursor = "";
          for(var b = 0;b < this.events.length;b++) {
            for(var c = this.events[b], d = this.eventElements[b];d;) {
              c.run(d), d = d.parent
            }
          }
          this.events = [];
          this.eventElements = []
        }
      };
      u.svg = svg = a;
      svg.opts = t;
      q = q.getContext("2d");
      "undefined" != typeof r.documentElement ? svg.loadXmlDoc(q, r) : "<" == r.substr(0, 1) ? svg.loadXml(q, r) : svg.load(q, r)
    }
  }
})();
CanvasRenderingContext2D && (CanvasRenderingContext2D.prototype.drawSvg = function(q, r, t, u, v) {
  canvg(this.canvas, q, {ignoreMouse:!0, ignoreAnimation:!0, ignoreDimensions:!0, ignoreClear:!0, offsetX:r, offsetY:t, scaleWidth:u, scaleHeight:v})
});
