var timezone = Array();
var zoneList = Array();
$(document).ready(function(){
    startTime();
    //localStorage["zoneList"] = JSON.stringify(zoneList);
    $.getJSON( "timezone.json", function(r) {
        timezone = r;
        updateNames();
        console.log(r);
        strOption = '<option value="none">Add Location</option>';
        $.each(r, function(key, val) {
            strOption += '<option value="' + key + '">' + val['Name'] + '</option>';
        });
        $('#OptionGMT').html(strOption);
    });
    if (typeof localStorage["zoneList"] != 'undefined') {
        zoneList = JSON.parse(localStorage["zoneList"]);
    }
    $('#OptionGMT').change(function(){
        zone = $('#' + this.id).val();
        if(zoneList.indexOf(zone) < 0) {
            zoneList.push(zone);
            localStorage["zoneList"] = JSON.stringify(zoneList);
            updateNames();
        }
        else {
            alert('Ya existe esta zona horaria');
        }
    });
});

function updateNames() {
    $.each(zoneList, function(key, val) {
        console.log(val);
        console.log(timezone[val]);
    });
}

function startTime() {
    var today=new Date();
    var h=today.getHours();
    var m=today.getMinutes();
    var s=today.getSeconds();
    // add a zero in front of numbers<10
    m=checkTime(m);
    s=checkTime(s);
    $('#localTime').text(h+":"+m+":"+s);
    
    strList = '';
    
    $.each(zoneList, function(key, val) {
        var dateUTC=new Date(today.getUTCFullYear(), today.getUTCMonth(), today.getUTCDate(), today.getUTCHours(), today.getUTCMinutes(), today.getUTCSeconds());
        var tz=parseFloat(timezone[val]['GMT']);
        var seconds=(tz*60*60)*1000;
        dateUTC.setTime(dateUTC.getTime()+seconds);
        var hUTC=dateUTC.getHours();
        var mUTC=dateUTC.getMinutes();
        var sUTC=dateUTC.getSeconds();
        mUTC=checkTime(mUTC);
        sUTC=checkTime(sUTC);
        strList += '<li class="lstZone" id="' + val + '"><p>'+hUTC + ":" + mUTC + ":" + sUTC + '</p><p>' + timezone[val]['Name'] + ' (GMT ' + timezone[val]['GMT'] + ')</p></li>';
    });
    $('#externTime').html(strList);
    $('.lstZone').click(function(){
        console.log(this.id);
        if (confirm('¿Desea eliminar esta fecha de la lista?')) { 
            var i = zoneList.indexOf(this.id);
            if(i != -1) zoneList.splice(i, 1);
            localStorage["zoneList"] = JSON.stringify(zoneList);
            updateNames
        }
    });
    t=setTimeout(function(){startTime()},500);
}

function checkTime(i) {
    if (i<10) {
        i="0" + i;
    }
    return i;
}
