
var L10N = {
	'_lang': 'en_US',
	'get': function(id) {
		var str = this[this._lang]['id'];
		return str || '??';
	},
	'load': function(lang) {
		this._lang = typeof lang != 'undefined'? lang : this._lang;
		
		for(var id in this[this._lang]) {
			var elem = $(id);
			var obj = this[this._lang][id];
			
			if (elem) {
				if(typeof obj == 'string') {
					elem.set('html', obj);
				}
				else if (typeof obj == 'object') {
					for (var attr in obj) {
						elem.setAttribute(attr, obj[attr]);
					}
				}
			}
		}
	},
	'extract': function (lang) {
		lang = typeof lang != 'undefined' ? lang : this._lang;
		var output = '';
		for(var id in this[lang]) {
			var obj = this[lang][id];
			if (typeof obj == 'string') {
				output += '"'+id+'"'+"\r\n";
				output += '"'+obj+'"'+"\r\n";
				output += "\r\n";
			}
			else if (typeof obj == 'object') {
				for(var attr in obj) {
					output += '"'+id+'":"'+attr+'"'+"\r\n";
					output += '"'+obj[attr]+'"'+"\r\n";
					output += "\r\n";
				}
			}
		}
		return output;
	}/*,
	'merge': function(from, to, string) {
		var output = "\r\nL10N['"+to+"'] = {\r\n";
		var strings = string.split("\n");
		var i=0;
		for(var id in this[from]) {
			var obj = this[from][id];
			if (typeof obj == 'string') {
				if (i in strings) {
					output += "\t'"+id+"': '"+strings[i++]+"',\r\n";
				}
			}
			else if (typeof obj == 'object') {
				output += "\t'"+id+"': {\r\n";
				for (var attr in obj) {
					if (i in strings) {
						output += "\t\t'"+attr+"': '"+strings[i++]+"',\r\n";
					}
				}
				output += "\t},\r\n";
			}
		}
		output += "};\r\n";
		return output;
	}*/
};
