
var Options = null;

var Lists = {
	'data': null,
	'load': function() {
		this.data = new HTML5.storage({
			'storageName': 'lists',
			'storageType': 'local'
		}).load();
		
		// v3.0 For compatibility with previous versions
		this.each(function(list){
			if (typeof(list.settings) == 'undefined') {
				list.settings = {
					'settings-action-delete': Options.get('settings-action-delete'),
					'settings-action-move': Options.get('settings-action-move'),
					'settings-suggestitems': Options.get('settings-suggestitems'),
					'settings-alphaorder': Options.get('settings-alphaorder')
				};
			}
			return true;
		});
		
		window.fireEvent('ListChange', {});
		return this;
	},
	'each': function (callback) {
		this.data.each(callback);
	},
	'size': function() {
		var count = 0;
		this.data.each(function(){
			count++;
		});
		return count;
	},
	'get': function(key) {
		return this.data.get(key);
	},
	'getFirst': function() {
		var list = null;
		var data = null;
		this.data.each(function(item, key){
			var has_items = false;
			for(var i in item.items) {
				has_items = true;
				break;
			}
			if (!list || has_items) {
				list = key;
				return !has_items;
			}
			else {
				return true;
			}
		});
		
		return list;
	},
	'getCurrent': function() {
		return this.get(Options.get('active-list'));
	},
	'getItem': function(key, itemKey) {
		var list = this.data.get(key);
		return list.items[itemKey];
	},
	'set': function(key, value, options) {
		options = options || {};
		this.data.set(key, value);
		if(!options['do-not-fire']) {
			window.fireEvent('ListChange', {});
		}
		return this;
	},
	'setItemProperty': function(key, itemKey, property, value){
		var list = this.get(key);
		list.items[itemKey][property] = value;
		this.set(key, list);
		return this;
	},
	'newList': function(name) {
		if (name == '') {
			return false
		}
		
		var key = Base64.encode(name);
		Options.set('active-list', key);
		
		if (this.get(key)) {
			window.fireEvent('ListChange', {});
		}
		else {
			var position = 1;
			Lists.each(function(item){
				if (item.position >= position) {
					position = item.position +1;
				}
			});
			
			this.set(key, {
				'name': name,
				'position': position,
				'items': {},
				'settings': {
					'settings-action-delete': Options.get('settings-action-delete'),
					'settings-action-move': Options.get('settings-action-move'),
					'settings-suggestitems': Options.get('settings-suggestitems'),
					'settings-alphaorder': Options.get('settings-alphaorder')
				}
			});
		}
		
		return true;
	},
	'newItem': function(key, value) {
		if (value == '') {
			return false;
		}
		
		var list = this.get(key);
		if (!list) {
			return false;
		}
		var itemKey = Base64.encode(value);
		var position = 1;
		
		var item = this.getItem(key, itemKey);
		if (item) {
			item.done = false;
		}
		else {
			for(var i in list.items) {
				var item = list.items[i];
				if (item.position >= position) {
					position = item.position +1;
				}
			}
			
			list.items[itemKey] = {
				'name': value,
				'position': position,
				'done': false
			};
		}
		this.set(key, list);
		
		return true;
	},
	'delete': function(key) {
		this.data.remove(key);
		Options.set('active-list', Lists.getFirst());
		window.fireEvent('ListChange', {});
	},
	'deleteItem': function(key, itemKey) {
		var list = this.get(key);
		delete(list.items[itemKey]);
		this.set(key, list);
	},
	'swap': function(id1, id2) {
		var list1 = this.get(id1);
		var list2 = this.get(id2);
		var tmp = list1.editPosition;
		list1.editPosition = list2.editPosition;
		list2.editPosition = tmp;
		this.set(id1, list1, {'do-not-fire': true});
		this.set(id2, list2, {'do-not-fire': true});
	},
	'swapItems': function(key, id1, id2) {
		var list = this.get(key);
		var tmp = list.items[id1].editPosition;
		list.items[id1].editPosition = list.items[id2].editPosition;
		list.items[id2].editPosition = tmp;
		this.set(key, list, {'do-not-fire': true});
	}
};

var Views = {
	'views': {
		'index-drawer-list': {
			'events': {
				'ListChange': function (event) {
					if (event._element) {
						event._element.set('html', '');
						var sorted = [];
						var position = 1;
						Lists.each(function(item, key) {
							var count = 0;
							var done = 0;
							for (var i in item.items) {
								count++;
								if (item.items[i].done) {
									done++;
								}
							}
							var count_s = '';
							if (done>0) {
								count_s = (count-done)+'/'+count
							}
							else {
								count_s = count;
							}
							
							sorted[item.position || position++] = new Element('li', {
								'html': '<span>'+item.name+' <em>('+count_s+')</em></span>',
								'onclick': '',
								'data-id': key
							}).addEvent('click', function(event){
								var li = event.target.getParent('li');
								Options.set('active-list', li.get('data-id'));
								window.fireEvent('ListChange', {});
								location.href = '#index';
							});
						});
						sorted.each(function(item){
							item.inject(event._element);
						});
					}
				}
			}
		},
		'index-drawer-listnumber': {
			'events': {
				'ListChange': function(event) {
					if (event._element) {
						event._element.set('html', Lists.size());
					}
				}
			}
		},
		'index-activelist': {
			'events': {
				'ListChange': function(event) {
					if (event._element) {
						event._element.set('html', '');
						
						var list = Lists.get(Options.get('active-list'));
						// if (Options.get('settings-action-delete')) {
						if (list && list.settings['settings-action-delete']) {
							event._element.set('data-class', 'checkasdone');
						}
						else {
							event._element.set('data-class', '');
						}
						
						if (list) {
							var sorted = [];
							var done_list = [];
							var position = 1;
							for (var i in list.items) {
								var li = new Element('li', {
									'html': '<span class="title">'+list.items[i].name+'</span>'
										+'<span class="list-button list-button-delete"></span>'
										+'<span class="list-button list-button-done"></span>',
									'data-id': i,
									'data-done': list.items[i].done
								});
								
								if (list.items[i].done && list.settings['settings-action-move']) {
									done_list[list.items[i].position || position++] = {
										'name': list.items[i].name,
										'li': li
									};
								}
								else {
									sorted[list.items[i].position || position++] = {
										'name': list.items[i].name,
										'li': li
									};
								}
							}
							
							// Alphabetical ordering
							if (list.settings['settings-alphaorder']) {
								sorted.sort(function(a,b){
									return a.name.toLowerCase() == b.name.toLowerCase() ? a.name > b.name : a.name.toLowerCase() > b.name.toLowerCase();
								});
								done_list.sort(function(a,b){
									return a.name.toLowerCase() == b.name.toLowerCase() ? a.name > b.name : a.name.toLowerCase() > b.name.toLowerCase();
								});
							}
							
							sorted.each(function(item){
								item.li.inject(event._element);
							});
							done_list.each(function(item){
								item.li.inject(event._element);
							});
							
							$('index-nolist').setStyle('display', 'none');
							
							var expanded = Options.get('expanded');
							if (expanded && expanded.list == Options.get('active-list')) {
								var expanded_item = event._element.getElement('li[data-id="'+expanded.item+'"] .title');
								if(expanded_item) {
									expanded_item.addClass('expanded');
								}
							}
							
							Array.each($$('#index-activelist .title'), function(item){
								item.addEvent('click', function(event){
									// var li = event.target.getParent('li');
									if(event.target.hasClass('expanded')) {
										event.target.removeClass('expanded');
										Options.set('expanded', {
											'list': '',
											'item': ''
										});
									}
									else {
										Array.each($$('.expanded'), function(item){
											item.removeClass('expanded');
										});
										event.target.addClass('expanded');
										Options.set('expanded', {
											'list': Options.get('active-list'),
											'item': event.target.getParent('li').get('data-id')
										});
									}
								});
							});
							
							Array.each($$('#index-activelist .list-button-done'), function(item){
								item.addEvent('click', function(event) {
									var li = event.target.getParent('li');
									var id = li.get('data-id');
									Lists.setItemProperty(Options.get('active-list'), id, 'done', li.get('data-done')!='true');
								});
							});
							Array.each($$('#index-activelist .list-button-delete'), function(item){
								item.addEvent('click', function(event) {
									var li = event.target.getParent('li');
									var id = li.get('data-id');
									Lists.deleteItem(Options.get('active-list'), id);
								});
							});
						}
						else {
							$('index-nolist').setStyle('display', 'block');
						}
					}
				}
			}
		},
		'index-activelisttitle': {
			'events': {
				'ListChange': function(event) {
					if (event._element) {
						var list = Lists.get(Options.get('active-list'));
						if (list) {
							event._element.set('html', list.name);
							event._element.setStyle('display', 'block');
						}
						else {
							event._element.set('html', '');
							event._element.setStyle('display', 'none');
						}
					}
				}
			}
		},
		'index-itemsuggestion': {
			'events': {
				'ListChange': function(event) {
					if (event._element) {
						event._element.set('html', '');
					}
				},
				'Suggest': function(event) {
					// if (event._element && Options.get('settings-suggestitems')) {
					if (event._element && Lists.getCurrent().settings['settings-suggestitems']) {
						event._element.set('html', '');
						var test = $('index-itemname').value.replace(/^\s+|\s+$/g, '').replace(/\s\s+/g, ' ').toLowerCase();
						if (test) {
							var list = Lists.getCurrent();
							if (list) {
								var sorted = [];
								for (var i in list.items) {
									var key = list.items[i].name.toLowerCase().search(test);
									if (list.items[i].done && key != -1) {
										sorted.push({
											'li': new Element('li', {
													'html': list.items[i].name,
													'data-value': list.items[i].name
												}).addEvent('click', function(event){
													$('index-itemname').value = event.target.get('data-value');
													$('index-itemsuggestion').set('html', '');
												}),
											'key': key
										});
									}
								}
								sorted.sort(function(a, b){
									return a.key > b.key;
								});
								sorted.each(function(item){
									item.li.inject(event._element);
								});
							}
						}
					}
				}
			}
		},
		'edit-list-listname': {
			'events': {
				'ListChange': function(event){
					if (event._element) {
						var list = Lists.get(Options.get('active-list'));
						if (list) {
							event._element.set('html', list.name);
						}
						else {
							event._element.set('html', '');
						}
					}
				}
			}
		},
		'edit-list-list': {
			'events': {
				'ListChange': function(event) {
					var list = Lists.get(Options.get('active-list'));
					if (list) {
						var position = 1;
						for(var i in list.items) {
							list.items[i].editPosition = list.items[i].position || position++;
						}
						Lists.set(Options.get('active-list'), list, {'do-not-fire': true});
						
						window.fireEvent('ListPositionChange', event);
					}
				},
				'ListPositionChange': function(event) {
					if (event._element) {
						event._element.set('html', '');
						var list = Lists.get(Options.get('active-list'));
						if (list) {
							var sorted = [];
							var position = 1;
							for (var i in list.items) {
								sorted[list.items[i].editPosition || position++] = {
									'name': list.items[i].name,
									'li': new Element('li', {
										'html': '<input type="checkbox" class="hide"><span class="list-button list-button-move"></span>'
											+'<input value="'+list.items[i].name+'" required="required" type="text"/>'
											+'<span class="list-button list-button-delete"></span>',
										'data-id': i
									})
								};
							}
							
							// Alphabetical ordering
							if ($('edit-list-alphaorder').checked) {
								sorted.sort(function(a,b){
									return a.name.toLowerCase() == b.name.toLowerCase() ? a.name > b.name : a.name.toLowerCase() > b.name.toLowerCase();
								});
							}
							
							sorted.each(function(item){
								item.li.inject(event._element);
							});
							Array.each($$('#edit-list-list .list-button-delete'), function(item){
								item.addEvent('click', function(event){
									var input = event.target.getPrevious('input');
									input.disabled = !input.disabled;
								});
							});
							Array.each($$('#edit-list-list .list-button-move'), function(item){
								var dsbld = Lists.getCurrent().settings['settings-alphaorder'];
								item.getPrevious('input[type="checkbox"]').disabled = dsbld;
								
								item.addEvents({
									'click': function(event) {
										var li = event.target.getParent('li');
										var checkbox = event.target.getPrevious('input[type="checkbox"]');
										
										if (checkbox.disabled) {
											return;
										}
										
										// 1. this button is checked
										if (checkbox.checked) {
											checkbox.checked = false;
										}
										else {
											var checked = false;
											Array.each($$('#edit-list-list .list-button-move'), function(item){
												if (!checked && item.getPrevious('input[type="checkbox"]').checked) {
													checked = item.getParent('li');
													return;
												}
											});
											if (checked) {
												Lists.swapItems(Options.get('active-list'), li.get('data-id'), checked.get('data-id'));
												
												Array.each($$('#edit-list-list .list-button-move'), function(item) {
													if (item.getPrevious('input[type="checkbox"]').checked) {
														item.getPrevious('input[type="checkbox"]').checked = false;
													}
												});
												
												window.fireEvent('ListPositionChange');
											}
											else {
												// Check
												checkbox.checked = true;
											}
										}
									}
								});
							});
						}
						else {
							// No list message
						}
					}
				}
			}
		},
		'edit-list-edittitle': {
			'events': {
				'ListChange': function(event){
					if (event._element) {
						var list = Lists.get(Options.get('active-list'));
						if (list) {
							event._element.value = list.name;
							event._element.setStyle('visibility', 'visible');
						}
						else {
							event._element.value = '';
							event._element.setStyle('visibility', 'hidden');
						}
					}
				}
			}
		},
		'edit-list-checkasdone': {
			'events': {
				'ListChange': function(event) {
					var list = Lists.getCurrent();
					if (list) {
						event._element.checked = Lists.getCurrent().settings['settings-action-delete'];
					}
				}
			}
		},
		'edit-list-movetobottom': {
			'events': {
				'ListChange': function(event) {
					var list = Lists.getCurrent();
					if (list) {
						event._element.checked = Lists.getCurrent().settings['settings-action-move'];
						event._element.disabled = !Lists.getCurrent().settings['settings-action-delete'];
					}
				}
			}
		},
		'edit-list-suggestitems': {
			'events': {
				'ListChange': function(event) {
					var list = Lists.getCurrent();
					if (list) {
						event._element.checked = Lists.getCurrent().settings['settings-suggestitems'];
					}
				}
			}
		},
		'edit-list-alphaorder': {
			'events': {
				'ListChange': function(event) {
					var list = Lists.getCurrent();
					if (list) {
						event._element.checked = Lists.getCurrent().settings['settings-alphaorder'];
					}
				},
				'click': function(event){
					//alert('click')
					Array.each($$('#edit-list-list .list-button-move'), function(item){
						var checkbox = item.getPrevious('input[type="checkbox"]');
						checkbox.disabled = event._element.checked;
					});
				}
			}
		},
		'edit-lists-list': {
			'events': {
				'ListChange': function(event){
					var position = 1;
					Lists.each(function(item, key) {
						item.editPosition = item.position || position++;
						Lists.set(key, item, {'do-not-fire': true});
					});
					
					window.fireEvent('ListsPositionChange', event)
				},
				'ListsPositionChange': function(event) {
					if (event._element) {
						event._element.set('html', '');
						var sorted = [];
						var position = 1;
						Lists.each(function(item, key) {
							sorted[item.editPosition || position++] = new Element('li', {
								'html': '<input type="checkbox" class="hide"/><span class="list-button list-button-move"></span>'
									+'<input value="'+item.name+'" required="required" type="text"/>'
									+'<span class="list-button list-button-delete"></span>',
								'data-id': key
							});
						});
						sorted.each(function(item){
							item.inject(event._element);
						});
						Array.each($$('#edit-lists-list .list-button-delete'), function(item){
							item.addEvent('click', function(event){
								var input = event.target.getPrevious('input');
								input.disabled = !input.disabled;
							});
						});
						Array.each($$('#edit-lists-list .list-button-move'), function(item){
							item.addEvents({
								'click': function(event) {
									var li = event.target.getParent('li');
									var checkbox = event.target.getPrevious('input[type="checkbox"]');
									// 1. this button is checked
									if (checkbox.checked) {
										checkbox.checked = false;
									}
									else {
										var checked = false;
										Array.each($$('#edit-lists-list .list-button-move'), function(item){
											if (!checked && item.getPrevious('input[type="checkbox"]').checked) {
												checked = item.getParent('li');
												return;
											}
										});
										if (checked) {
											Lists.swap(li.get('data-id'), checked.get('data-id'));
											
											Array.each($$('#edit-lists-list .list-button-move'), function(item) {
												if (item.getPrevious('input[type="checkbox"]').checked) {
													item.getPrevious('input[type="checkbox"]').checked = false;
												}
											});
											
											window.fireEvent('ListsPositionChange');
										}
										else {
											// Check
											checkbox.checked = true;
										}
									}
									
								}
							});
						});
					}
				}
			}
		}
	},
	'load': function() {
		for (var id in this.views) {
			var view = this.views[id];
			(function(view){
				view.element = $(id);
				for (var e in view.events) {
					(function(view, e) {
						window.addEvent(e, function(event) {
							event = event || {};
							event._element = view.element;
							view.events[e](event);
						});
					})(view, e);
				}
			})(view);
		}
		return this;
	}
};

/* Load config */
window.addEvent('domready', function(){
	// Load options from storage
	Options = new HTML5.storage({
		'storageName': 'options',
		'storageType': 'local'
	}, {
		'settings-font-size': '12px',
		'settings-font-family': 'MozTT, sans-serif',
		'settings-pagestyle': 'default',
		'settings-action-delete': true,
		'settings-action-move': false,
		'settings-suggestitems': false,
		'settings-alphaorder': false
	}).load();
	
	// Load views
	Views.load();
	
	// Load lists
	Lists.load();
	
	// L10N
	// L10N.load('fr_FR');
	
	// Initialize settings fields
	// Settings font size
	$('settings-fontsize').value = Options.get('settings-font-size');
	document.html.setStyle('font-size', Options.get('settings-font-size'));
	// Settings font family
	$('settings-fontfamily').value = Options.get('settings-font-family');
	document.html.setStyle('font-family', Options.get('settings-font-family'));
	// Check as 'done'
	$('settings-checkasdone').checked = Options.get('settings-action-delete');
	// Move to bottom
	$('settings-movetobottom').checked = Options.get('settings-action-move');
	$('settings-movetobottom').disabled = !Options.get('settings-action-delete');
	// Suggest item
	$('settings-suggestitems').checked = Options.get('settings-suggestitems');
	// Alphabetic order
	$('settings-alphaorder').checked = Options.get('settings-alphaorder');
	
	// Page style
	$('settings-pagestyle').value = Options.get('settings-pagestyle');
	// Also apply style
	document.getElement('[role="application"]').set('data-style', Options.get('settings-pagestyle'));
	
	// Load active list if not saved
	if (!Options.get('active-list')) {
		Options.set('active-list', Lists.getFirst());
	}
	
	// Events
	// Submit new list
	$('add-list').addEvent('submit', function(){
		var name = $('index-drawer-listname').value.replace(/^\s+|\s+$/g, '').replace(/\s\s+/g, ' ');
		if(Lists.newList(name)) {
			$('index-drawer-listname').value = '';
			$('index-itemname').value = '';
			
			location.href = '#index';
		}
	});
	// Submit new list with + button
	$('index-drawer-addlist-button').addEvent('click', function(){
		$('add-list').fireEvent('submit');
	});
	// Submit new item
	$('index-additem').addEvent('submit', function(){
		var name = $('index-itemname').value.replace(/^\s+|\s+$/g, '').replace(/\s\s+/g, ' ');
		var key = Options.get('active-list');
		Lists.newItem(key, name);
		$('index-itemname').value = '';
	});
	//
	$('index-additemreset').addEvent('click', function(){
		$('index-itemsuggestion').set('html', '');
	})
	// Submit new item with + button
	$('index-additem-button').addEvent('click', function(){
		$('index-additem').fireEvent('submit');
	});
	// Item name
	$('index-itemname').addEvent('keyup', function(){
		window.fireEvent('Suggest');
	});
	// Nav to settings
	$('index-navto-settings').addEvent('click', function(){
		location.href = '#settings';
	});
	// Nav to edit lists
	$('index-navto-editlists').addEvent('click', function(){
		location.href = '#edit-lists';
	});
	// Nav to edit active list
	$('index-navto-editlist').addEvent('click', function(){
		location.href = '#edit-list';
	});
	// Nav to info
	$('settings-navto-info').addEvent('click', function(){
		location.href = '#info';
	});
	// Save settings
	$('settings-done-button').addEvent('click', function(){
		// Font size
		Options.set('settings-font-size', $('settings-fontsize').value);
		document.html.setStyle('font-size', Options.get('settings-font-size'));
		// Font family
		Options.set('settings-font-family', $('settings-fontfamily').value);
		document.html.setStyle('font-family', Options.get('settings-font-family'));
		// Check as 'done'
		Options.set('settings-action-delete', $('settings-checkasdone').checked);
		// Move to bottom
		Options.set('settings-action-move', $('settings-movetobottom').checked);
		//
		Options.set('settings-suggestitems', $('settings-suggestitems').checked);
		//
		Options.set('settings-alphaorder', $('settings-alphaorder').checked);
		// Page style
		Options.set('settings-pagestyle', $('settings-pagestyle').value);
		
		// Apply on-the-fly settings
		document.getElement('[role="application"]').set('data-style', Options.get('settings-pagestyle'));
		
		window.fireEvent('ListChange', {});
		
		location.href = '#index';
	});
	// Save edit lists
	$('edit-lists-done-button').addEvent('click', function(){
		var position = 1;
		Array.each($$('#edit-lists-list input[type="text"]'), function(item){
			var li = item.getParent('li');
			var id = li.get('data-id');
			if (item.disabled) {
				// Delete item
				Lists.delete(id);
			}
			else if(item.value != '') {
				var list = Lists.get(id);
				// Remove before, after and consecutive spaces
				list.name = item.value.replace(/^\s+|\s+$/g, '').replace(/\s\s+/g, ' ');
				list.position = position++;
				Lists.set(id, list);
			}
		});
		location.href = '#index';
	});
	// Save edit list
	$('edit-list-done-button').addEvent('click', function(){
		var key = Options.get('active-list');
		var list = Lists.get(key);
		list.name = $('edit-list-edittitle').value.replace(/^\s+|\s+$/g, '').replace(/\s\s+/g, ' ');
		list.settings = {
			'settings-action-delete': $('edit-list-checkasdone').checked,
			'settings-action-move': $('edit-list-movetobottom').checked,
			'settings-suggestitems': $('edit-list-suggestitems').checked,
			'settings-alphaorder': $('edit-list-alphaorder').checked
		}
		var position = 1;
		Array.each($$('#edit-list-list input[type="text"]'), function(item){
			var li = item.getParent('li');
			var id = li.get('data-id');
			if (item.disabled) {
				// Delete item
				delete(list.items[id]);
			}
			else if (item.value != ''){
				list.items[id].name = item.value.replace(/^\s+|\s+$/g, '').replace(/\s\s+/g, ' ');
				list.items[id].position = position++;
			}
		});
		Lists.set(key, list);
		
		location.href = '#index';
	});
	// Align 'done' and 'move' checkboxed
	// if !done => !move
	$('settings-donelabel').addEvent('click', function(){
		var done = $('settings-donelabel').getElement('input');
		var move = $('settings-movelabel').getElement('input');
		
		if (done.checked) {
			move.disabled = false;
		}
		else {
			move.checked = false;
			move.disabled = true;
		}
	});
	
	$('edit-list-donelabel').addEvent('click', function(){
		var done = $('edit-list-donelabel').getElement('input');
		var move = $('edit-list-movelabel').getElement('input');
		
		if (done.checked) {
			move.disabled = false;
		}
		else {
			move.checked = false;
			move.disabled = true;
		}
	});
});

// Display Add or Settings icon
window.addEvent('domready', function(){
	var elem = $('index-itemname');
	var settings = $('index-navto-settings');
	var add = $('index-additem-button');
	setInterval(function(){
		if (elem.value == '') {
			// Display Settings
			settings.setStyle('display', 'block');
			add.setStyle('display', 'none');
		}
		else {
			// Display Add
			settings.setStyle('display', 'none');
			add.setStyle('display', 'block');
		}
	}, 100);
});

/* Startup operations */
window.addEvent('domready', function() {
	/* Start page */
	if(location.hash == '') {
		location.href = '#index';
	}
	
	/* Textarea.oneline */
	Array.each($$('[role="application"] textarea.oneline'), function(item){
		item.addEvent('keypress', function(event) {
			if (event.key == 'enter') {
				var form = event.target.getParent('form');
				if (form) {
					form.fireEvent('submit');
				}
				return false;
			}
			return true;
		});
	});
	
	/* Toolbar */
	(function(){
		// timeout variable
		var timeout = null;
		
		Array.each($$('[role="toolbar"]'), function(toolbar){
			toolbar.addEvents({
				'cover': function(event){
					// If can use Fx make a transition
					// Otherwise set style
					if (typeof(Fx) != 'undefined' && typeof(Fx.Morph) != 'undefined') {
						new Fx.Morph(event.target, {
							'unit': 'rem',
							'duration': 250,
							'onComplete': function(){
								// Remove uncover class
								event.target.removeClass('uncover');
							}
						}).start({
							'height': 1
						});
					}
					else {
						event.target.setStyle('height', '1rem');
					}
					// Clear timeout
					if (timeout) {
						clearTimeout(timeout);
					}
				},
				'uncover': function(event){
					// If can use Fx make a transition
					// Otherwise set style
					if (typeof(Fx) != 'undefined' && typeof(Fx.Morph) != 'undefined') {
						new Fx.Morph(toolbar, {
							'unit': 'rem',
							'duration': 250,
							'onComplete': function(){
								// Add class uncover
								event.target.addClass('uncover');
							}
						}).start({
							'height': 4
						});
					}
					else {
						event.target.setStyle('height', '4rem');
					}
					// Clear timeout
					if (timeout) {
						clearTimeout(timeout);
					}
					// Add timeout for auto cover
					(function(event){
						timeout = setTimeout(function(){
							event.target.fireEvent('cover', event);
						}, 10000);
					})(event);
				}
			});
			toolbar.getElement('.cover').addEvent('click', function(event){
				var toolbar = event.target.getParent('[role="toolbar"]');
				toolbar.fireEvent('cover', {
					'target': toolbar
				});
			});
			toolbar.getElement('.uncover').addEvent('mousedown', function(event){
				var toolbar = event.target.getParent('[role="toolbar"]');
				toolbar.fireEvent('uncover', {
					'target': toolbar
				});
			});
		});
	})();
});