/*
 * jQuery File Upload Plugin Angular JS Example 1.0
 * https://github.com/blueimp/jQuery-File-Upload
 *
 * Copyright 2013, Sebastian Tschan
 * https://blueimp.net
 *
 * Licensed under the MIT license:
 * http://www.opensource.org/licenses/MIT
 */

/*global window, angular */
var url = 'server/php/';
var User = {};
var last_page = 'page_home';
var queue = [];

function refresh_theme(selectedTheme, currentTheme) {
//    var currentTheme = $('#home').attr('data-theme');
//    var selectedTheme = $(this).val();

//    alert('CT ' + currentTheme + ' ST ' + selectedTheme);

    $('.order_theme').each(function () {
        $(this).removeClass('ui-body-' + currentTheme).addClass('ui-body-' + selectedTheme);
    });

    $('.order_theme').each(function () {
        $(this).removeClass('ui-btn-up-' + currentTheme).addClass('ui-btn-up-' + selectedTheme);
    });

    $('.order_theme').each(function () {
        $(this).removeClass('ui-btn-down-' + currentTheme).addClass('ui-btn-down-' + selectedTheme);
    });

//    $('#sortview').find('*[data-theme]').each(function (index) {
//        $(this).attr('data-theme', selectedTheme);
//    });
//
//    $('#sortview').attr('data-theme', selectedTheme).removeClass('ui-body-' + currentTheme).addClass('ui-body-' + selectedTheme).trigger('create');
}


(function () {
    'use strict';

    var app = angular.module('demo', [
        'blueimp.fileupload'
    ]);
    app.config([
        '$httpProvider', 'fileUploadProvider',
        function ($httpProvider, fileUploadProvider) {
            delete $httpProvider.defaults.headers.common['X-Requested-With'];
            angular.extend(fileUploadProvider.defaults, {
                disableImageResize: false,
                maxFileSize: 8000000,
                acceptFileTypes: /(\.|\/)(gif|jpe?g|png)$/i
            });
        }
    ]);


    app.controller('SlipScanController', ['$scope', '$http', 'fileUpload',
        function ($scope, $http, fileUpload) {

            $scope.User = User;
            $scope.logging_in = false;
            $scope.login_message = '';
            $scope.registering = false;
            $scope.register_message = '';
            $scope.login_class = '';
            $scope.register_class = '';


            $scope.slip_value_total = function (result) {
                if (!result.results) {
                    return 0;
                }
                return parseFloat(result.results['slip_total']);
            }
            $scope.slip_value_date_scanned = function (result) {
                if (!result.results){
                    return 0;
                }
                return parseFloat(result.results['slip_date_scanned_unix']);
            }
            $scope.slip_value_date = function (result) {
                if (!result.results) {
                    return 0;
                }
                return parseFloat(result.results['slip_date_unix']);
            }
            $scope.listview_sort = $scope.slip_value_date_scanned;
            $scope.listview_sort_reverse = true;

            $scope.sort_modes = [
                {name: 'Scan Date', theme: 'b', icon: 'home'},
                {name: 'Company', theme: 'a', icon: 'home'},
                {name: 'Category', theme: 'a', icon: 'home'},
                {name: 'Total', theme: 'a', icon: 'home'},
                {name: 'Date', theme: 'a', icon: 'home'}
            ];

            $scope.sort = {mode: $scope.sort_modes[0]}


            $scope.set_sort_mode = function (index) {
                return;
                $(this).buttonMarkup({ icon: "edit" });
//                refresh_theme('a', 'a');
                return;
                for (var i = 0; i < $scope.sort_modes.length; i++) {
                    $scope.sort_modes[i].theme = 'a';
//                    $scope.sort_modes[i].icon = 'list';

                }
//                refresh_theme('a', 'a');

//                $scope.sort_modes.each(function (m) {
//                    m.theme = 'a';
//                });
                $("#yourButtonId .ui-icon").removeClass("ui-icon-home").addClass("ui-icon-delete");
                $scope.sort_modes[index].icon = 'plus';

            }

            $scope.$evalAsync(function () {
                $(".orderby").tap(function () {

                    $(".orderby").buttonMarkup({ icon: "" });
                    var new_order = '';
                    switch ($(this).attr('id')) {
                        case 'slip_date_scanned_unix':
                            new_order = $scope.slip_value_date_scanned;
                            break;
                        case 'slip_date_unix':
                            new_order = $scope.slip_value_date;
                            break;
                        case 'slip_company':
                            new_order = 'results.slip_company_name';
                            break;
                        case 'slip_category':
                            new_order = 'results.slip_category.category_title';
                            break;
                        case 'slip_total':
                            new_order = $scope.slip_value_total;
                            break;
                    }

                    if ($scope.listview_sort == new_order){

                        $scope.listview_sort_reverse = !$scope.listview_sort_reverse;
                    }
                    else{
                        $scope.listview_sort_reverse = true;
                    }
                    if ($scope.listview_sort_reverse){
                        $(this).buttonMarkup({ icon: "chevron-down" });
                    }
                    else{
                        $(this).buttonMarkup({ icon: "chevron-up" });
                    }
                    $scope.listview_sort = new_order;

                    $scope.$apply();
                });

//                $(".orderby").buttonMarkup({ icon: "" });
//                $("#slip_date_scanned_unix").buttonMarkup({ icon: "arrow-down" });
//                $('#sortview').listview('refresh')
            });
            /*            $scope.$watch('sort', function(newval, oldval){
             if (newval === oldval){
             return;
             }
             $scope.sort_modes.each(function(m){
             m.theme = 'a';
             });
             console.log($scope.sort.mode)
             $scope.sort.mode.theme = 'b';

             $scope.$evalAsync(function () {
             $('#sortview').listview('refresh')
             });

             }, true);*/


            $scope.logout = function () {

                $.mobile.loading('show', {
                    text: 'Logging out..',
                    textVisible: true,
                    theme: 'b',
                    textonly: false,
                    html: ''
                });
                $.post(url + '?s=logout', {}, '', 'json').then(function (r) {
                    $.mobile.loading('hide');
                    document.location.reload();
                    $scope.$apply();
                });
            }

            $scope.login = function () {
                $scope.logging_in = true;
                $scope.login_class = 'ui-disabled';
                $scope.login_message = '';
                $.mobile.loading('show', {
                    text: 'Signing in..',
                    textVisible: true,
                    theme: 'b',
                    textonly: false,
                    html: ''
                });
                $.post(url + '?s=login', {email: $scope.login_email, password: $scope.login_password}, '', 'json').then(function (r) {

                    $scope.login_message = r.reason;
                    $scope.logging_in = false;
                    $scope.login_class = '';

                    if (r.ok) {
                        document.location.hash = '';
                        document.location.reload();
                    }
                    else {
                        $.mobile.loading('hide');
                        $scope.$apply();
                    }
                }).fail(function (e) {
                        $scope.login_message = 'Could not log in: ' + e.responseText;
                        $.mobile.loading('hide');
                        $scope.logging_in = false;
                        $scope.login_class = '';
                        console.log(e);
                        $scope.$apply();
                    });
            }
            $scope.register = function () {
                $scope.registering = true;
                $scope.register_message = '';
                $scope.register_class = 'ui-disabled';
                $.mobile.loading('show', {
                    text: 'Creating Account..',
                    textVisible: true,
                    theme: 'b',
                    textonly: false,
                    html: ''
                });
                $.post(url + '?s=register', {email: $scope.register_email, password_a: $scope.register_password_a, password_b: $scope.register_password_b}, '', 'json').then(function (r) {

                    $scope.register_message = r.reason;
                    $scope.registering = false;
                    $scope.register_class = '';

                    if (r.ok) {
                        document.location.hash = '';
                        document.location.reload();
                    }
                    else {
                        $.mobile.loading('hide');
                        $scope.$apply();
                    }

                }).fail(function (e) {
                        $.mobile.loading('hide');
                        console.log(e);
                    });
                ;
            }

            $scope.edit_file = {};

            $scope.save_slip = function () {
                $.mobile.loading('show', {
                    text: 'Saving..',
                    textVisible: true,
                    theme: 'b',
                    textonly: false,
                    html: ''
                });
                $scope.edit_file.results.slip_category_id = $scope.edit_file.results.slip_category.category_id;

                $.post(url + '?s=save_slip', $scope.edit_file.results, '', 'json').then(function (r) {
                    $scope.edit_file.results.slip_review_state = 1;
                    $scope.edit_file.results.slip_state = 2;
                    $.mobile.loading('hide');
                    $.mobile.changePage("#" + last_page);
                    $scope.$apply();

                }).fail(function (e) {
                        $.mobile.loading('hide');
                        console.log(e);

                    });

            }

            $scope.loadingFiles = true;
            $scope.options = {
                url: url,
                autoUpload: true,
                disableImageResize: false
            };

            $scope.queue = queue;

            $scope.queue.each(function (r) {
                r.results.slip_category = $scope.User.categories.filter(function (v) {
                    return (v.category_id == r.results.slip_category_id);
                })[0] || $scope.User.categories[6];
            });

            $scope.loadingFiles = false;




            $scope.delete = function () {
                $.mobile.loading('show', {
                    text: 'Removing..',
                    textVisible: true,
                    theme: 'b',
                    textonly: false,
                    html: ''
                });
                var file = $scope.edit_file.file,
                    state;
                if (file.url) {
                    state = 'pending';
                    return $http({
                        url: file.delete_url,
                        method: file.delete_type,
                        params: {slip_id: file.results.slip_id}
                    }).then(
                        function () {
                            state = 'resolved';
                            $scope.clear(file);

                            $.mobile.loading('hide');
                            $.mobile.changePage("#" + last_page);
                        },
                        function () {
                            state = 'rejected';
                            $.mobile.loading('hide');
                            $.mobile.changePage("#" + last_page);
                        }
                    );
                }
            }


        }
    ]);


    app.controller('SingleController', [
        '$scope', '$http', 'fileUpload',
        function ($scope, $http, fileUpload) {
            var file = $scope.file,
                state;

            file.preview_url = file.thumbnail_url;
            if (!file.results) {
                file.preview_url = 'img/placeholder.jpg';
            }

            function refresh_listviews() {
                try {
                    $('#id_listview_list').listview('refresh');
                }
                catch (e) {
                }
                try {
                    $('#id_listview_list_home').listview('refresh');
                }
                catch (e) {

                }
            }

            $scope.company_listing = function () {

                if (!file.results) {
                    return '';
                }

                if (file.results.slip_company_name) {
                    return file.results.slip_company_name;
                }
                if (file.results.slip_phone) {
                    return '(' + file.results.slip_phone + ')';
                }
                if (file.results.slip_vat_number) {
                    return '(' + file.results.slip_vat_number + ')';
                }

                return '(id: ' + file.results.slip_id + ')';
            }

            $scope.edit = function () {

                $scope.edit_file.file = file;
                $scope.edit_file.results = file.results;
                $scope.edit_file.image_url = file.url;

                if (file.results['slip_state'] > 1) {
                    $.mobile.changePage("#page_edit");
                }

            }

            file.bloulug = 'blouerug';

            var r = function (newval, oldval) {
                refresh_listviews();

                if (file.results && file.results['slip_state'] == 1) { //if active, but not yet processed
                    $.post(url + '?get_slip_data=1', {'slip_id': file.results['slip_id']}, '', 'json').then(function (r) {
                        file.results = r;
                        file.results.slip_category = $scope.User.categories.filter(function (v) {
                            return (v.category_id == file.results.slip_category_id);
                        })[0] || $scope.User.categories[6];
                        $scope.$apply();
                        refresh_listviews();

                    }).fail(function (v) {
                            console.log('fail', v);
                        });
                }

            }

            $scope.$watch('file', r)

        }
    ]);

    app.controller('FileDestroyController', [
        '$scope', '$http',
        function ($scope, $http) {
            var file = $scope.file,
                state;
            if (file.url) {
                file.$state = function () {
                    return state;
                };
                file.$destroy = function () {
                    state = 'pending';
                    return $http({
                        url: file.delete_url,
                        method: file.delete_type
                    }).then(
                        function () {
                            state = 'resolved';
                            $scope.clear(file);
                        },
                        function () {
                            state = 'rejected';
                        }
                    );
                };
            }
        }
    ]);

}());

$(document).ready(function () {


    $.get(url + '?s=auth', '', '', 'json').then(function (r) {

        if (!r.ok) {
            User = {user_name: 'guest'}
            $.mobile.changePage("#page_login");
        }
        else {
            User = r.User;
            if ($.mobile.activePage.attr("id") == "page_login" || $.mobile.activePage.attr("id") == "page_register") {
                $.mobile.changePage("#page_home");
            }
        }

        $.get(url, '', '', 'json')
            .then( function (response) {
                queue = response.files || [];
                angular.bootstrap(document, ['demo']);
            })
            .fail( function (r) {
                console.warn('could not load');
            }
        );


    }).fail(function (r) {

        });

    $("#id_summary_period").selectmenu('refresh', true);

//    data - ng - app = "demo"
});

$("#page_home").live(
    "pageshow",
    function (event) {
        //check for the existence of HTML within the container element
        last_page = 'page_home';
    }
);

$("#page_edit").live(
    "pageshow",
    function (event) {
        //check for the existence of HTML within the container element
        $("#id_category").selectmenu('refresh', true);
    }
);
$("#page_list").live(
    "pageshow",
    function (event) {


        //check for the existence of HTML within the container element
        last_page = 'page_list';
        $('#id_listview_list').listview('refresh');
        $('#sortview').listview('refresh');
    }
);
