$.mobile.defaultPageTransition = 'none';
$.mobile.defaultDialogTransition = 'none';
$.mobile.buttonMarkup.hoverDelay = 0;
(function () {
    'use strict';
    var AMAZON_STORE = 1;

    var app = angular.module('demo', []).
        filter('truncate',function () {
            return function (text, length, end) {
                if (isNaN(length))
                    length = 10;

                if (end === undefined)
                    end = "...";

                if (!text) {
                    text = '';
                }
                if (text.length <= length || text.length - end.length <= length) {
                    return text;
                }
                else {
                    return String(text).substring(0, length - end.length) + end;
                }

            };
        }).
        filter('format_prefix', function () {
            return function (val, length, end) {
                val = parseFloat(val)
                var prefix = '';
                if (val < 1) {
                    prefix = 'm';
                    val = val * 1000;
                }
                if (val < 1) {
                    prefix = 'µ';
                    val = val * 1000
                }
                if (val < 1) {
                    prefix = 'n';
                    val = val * 1000;
                }
                if (val < 1) {
                    prefix = 'p';
                    val = val * 1000;
                }
                if (val >= 1000) {
                    val = val / 1000;
                    prefix = 'K';
                }
                if (val >= 1000) {
                    val = val / 1000;
                    prefix = 'M';
                }
                if (val >= 1000) {
                    val = val / 1000;
                    prefix = 'G';
                }

                return Math.round(val * 100) / 100 + prefix;

            };
        });
    ;


    app.controller('MainController', ['$scope', '$timeout',
            function ($scope, $timeout) {
                var holder = $("#holder");
                var id_img_resistor = $("#id_img_resistor");
                var div_band_1 = $("#div_band_1");
                var div_band_1_capacitor = $("#div_band_1_capacitor");
                var div_band_1_capacitor_4 = $("#div_band_1_capacitor_4");
                var div_band_1_capacitor_5 = $("#div_band_1_capacitor_5");
                var div_band_2 = $("#div_band_2");
                var div_band_2_capacitor = $("#div_band_2_capacitor");
                var div_band_2_capacitor_4 = $("#div_band_2_capacitor_4");
                var div_band_2_capacitor_5 = $("#div_band_2_capacitor_5");
                var div_band_3 = $("#div_band_3");
                var div_band_3_capacitor = $("#div_band_3_capacitor");
                var div_band_3_capacitor_4 = $("#div_band_3_capacitor_4");
                var div_band_3_capacitor_5 = $("#div_band_3_capacitor_5");
                var div_band_4 = $("#div_band_4");
                var div_band_4_capacitor = $("#div_band_4_capacitor");
                var div_band_4_capacitor_4 = $("#div_band_4_capacitor_4");
                var div_band_4_capacitor_5 = $("#div_band_4_capacitor_5");
                var div_band_5 = $("#div_band_5");
                var div_band_5_capacitor = $("#div_band_5_capacitor");
                var div_band_5_capacitor_4 = $("#div_band_5_capacitor_4");
                var div_band_5_capacitor_5 = $("#div_band_5_capacitor_5");
                var div_band_6 = $("#div_band_6");
                var div_band_6_capacitor = $("#div_band_6_capacitor");
                $scope.color_view = 'resistor';

                var w, h, r, connections;
                $scope.bands = 4;
                $scope.cols = [];


                $scope.rate_app = function () {

                    navigator.notification.confirm(
                        'If you have any questions, suggestions or bug reports feel free to contact us!\n' +
                            'If you find this app useful please consider rating it at the app store',
                        function (button) {
                            // yes = 1, no = 2, later = 3
                            if (button == '2000') {    // XXX Not used


                                if (device.platform != 'Android') {
                                    window.open(encodeURI('http://www.loftie.com'), '_blank', 'location=yes');
                                } else if (device.platform == 'Android') {
                                    if (AMAZON_STORE){
                                        document.location.href = "http://www.amazon.com/gp/mas/dl/android?p=com.lpellis.rcalc";
                                    }
                                    else{
                                        document.location.href = "market://details?id=com.lpellis.rcalc";
                                    }
//                                    window.open('market://details?id=com.google.android.apps.maps');
//                                    window.open('https://play.google.com/store/apps/details?id=com.google.android.apps.maps');
                                } else if (device.platform == 'BlackBerry') {
                                    window.open('http://appworld.blackberry.com/webstore/content/<applicationid>');
                                }

                            } else if (button == '1') { // Later


                            } else if (button == '2') { // No
                                window.open('http://www.loftie.com/apps/rcalc.html', '_system');
                            }
                        }, 'About', 'Cancel, Contact');
                }

                var shapes = [];
                var rw = id_img_resistor.width();
                var rh = id_img_resistor.height();
                $scope.colorlist = [];
                var tolerance = [20, 1, 2, 0, 5, 0.5, 0.25, 0.1, 0.05, 0, 5, 10];
                var capcitor_tolerance = [20, 1, 2, 3, 4, 5, 0, 0, 0, 0, 5, 10];
                var capacitor_voltage = [0, 100, 250, 0, 400, 630, 0, 0, 0, 0, 0, 0];
                var inductor_tolerance = [20, 1, 2, 3, 4, 0, 0, 0, 0, 0, 5, 10];
                var multiplier = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -2];
                var temp = [250, 100, 50, 15, 25, 20, 10, 5, 1, 0, 0, 0];
                var temp_capacitor = [1000, 500, 200, 100, '(60)', '(35)', 0, 0, 0];
                var temp_capacitor_display = ['±1000', '±500', '±200', '±100', '-20..100', '0..70', 0, 0, 0];
                $scope.resitor = {ohm: 12, tol: '±2%', 'temp': '15ppm/K'};

                $scope.cols = [1, 2, 5, 1, 1, 1];

                function reset_shapes() {

                    if (!h) {
                        return
                    }
                    connections = [];
                    shapes = [];
                    r.clear();

                    $scope.selected_band_color = {
                        3: '',
                        4: '',
                        5: '',
                        6: ''
                    };

                    $scope.selected_band_color[$scope.bands] = '#4E6D8D';

                    var colors = {
                        black: ['#292929', '#404040', '#dbdbdb'],
                        brown: ['#7d5d3b', '#634b30', '#ffffff'],
                        red: ['#d0451b', '#bc3315', '#ffffff'],
                        orange: ['#fbb450', '#f89306', '#ffffff'],
                        yellow: ['#ffec64', '#ffab23', '#333333'],
                        green: ['#77b55a', '#72b352', '#ffffff'],
                        blue: ['#599bb3', '#408c99', '#ffffff'],
                        violet: ['#fcabfc', '#ee82ee', '#ffffff'],
                        gray: ['#d6d6d6', '#8f8f8f', '#454545'],
                        white: ['#ffffff', '#f6f6f6', '#666666'],
                        gold: ['#f0d55b', '#d1b536', '#454545'],
                        silver: ['#ededed', '#bab1ba', '#3a8a9e']
                    };

                    var colorlist = [];
                    var i = 0;
                    $.each(colors, function (index, value) {

                        colorlist.push({text: i, colors: value});
                        i++;
                    });
                    $scope.colorlist = colorlist;

                    var bands = $scope.bands;

                    var top_offset = 0;
                    var v_spacing = 5;
                    var height = (h - top_offset - 130) / 12 - v_spacing;

                    var h_spacing = 10;
                    var h_offset = 10;
                    var width = (w - h_offset * 2) / bands;

                    var attr = {opacity: 0.0, stroke: 'gray'};

                    var t = 34 + 59;

                    shapes.push(r.rect(parseFloat($("#div_band_1").css('left')), t, 5, 6).attr(attr));
                    shapes.push(r.rect(parseFloat($("#div_band_2").css('left')) + 3, t, 5, 6).attr(attr));
                    shapes.push(r.rect(parseFloat($("#div_band_3").css('left')) + 1, t, 5, 6).attr(attr));
                    shapes.push(r.rect(parseFloat($("#div_band_4").css('left')), t, 5, 6).attr(attr));
                    shapes.push(r.rect(parseFloat($("#div_band_5").css('left')) + 1, t, 5, 6).attr(attr));
                    shapes.push(r.rect(parseFloat($("#div_band_6").css('left')) + 3, t, 5, 6).attr(attr));

                    $scope.buttons = [];
                    $scope.band_labels = [];
                    var band_labels = ['1', '2', 'Mul', 'Tol', 'ppm/K'];
                    var band_labels_5 = ['1', '2', '3', 'Mul', 'Tol'];
                    var band_labels_6 = ['1', '2', '3', 'Mul', 'Tol', 'ppm/K'];
                    var band_labels_capacitor_postage = ['Type', '1', '2', 'Mul', 'Tol', 'Temp'];
                    var band_labels_capacitor_4 = ['1', '2', 'Mul', 'Voltage'];
                    var band_labels_capacitor_5 = ['1', '2', 'Mul', 'Tol', 'Voltage'];
                    if ($scope.color_view == 'capacitor') {
                        band_labels_6 = band_labels_capacitor_postage;
                        band_labels_5 = band_labels_capacitor_5;
                        band_labels = band_labels_capacitor_4;
                    }

                    for (var b = 0; b < bands; b++) {
                        if (bands == 5) {
                            $scope.band_labels.push({left: b * width + h_offset + width / 2 - band_labels_5[b].length * 2 - 5, text: band_labels_5[b]});
                            var rect = r.rect(b * (w - 2 * h_offset) / bands + h_offset + width / 2 - 4, 88 + 30, 4, 5);
                            rect.attr({opacity: 0.0});
                            shapes.push(rect);

                        }
                        else if (bands < 6) {
                            $scope.band_labels.push({left: b * width + h_offset + width / 2 - band_labels[b].length * 2 - 5, text: band_labels[b]});
                            var rect = r.rect(b * (w - 2 * h_offset) / bands + h_offset + width / 2 - 4, 88 + 30, 4, 5);
                            rect.attr({opacity: 0.0});
                            shapes.push(rect);
                        }
                        else {
                            $scope.band_labels.push({left: b * width + h_offset + width / 2 - band_labels_6[b].length * 2 - 5, text: band_labels_6[b]});
                            var rect = r.rect(b * (w - 2 * h_offset) / bands + h_offset + width / 2 - 4, 88 + 34, 4, 5);
                            rect.attr({opacity: 0.0});
                            shapes.push(rect);
                        }

                        for (var i = 1; i <= 12; i++) {
                            h_offset = 10;
                            var text = colorlist[i - 1]['text'];
                            var supertext = '';
                            var padding_sub = 0;
                            var height_sub = 0;

                            if ($scope.bands == 5) {
                                if (b <= 2 && i > 10 && $scope.color_view != 'capacitor') {
                                    continue
                                }
                                if (b <= 1 && i > 10) {
                                    continue
                                }
                                if ((b == 2) && ($scope.color_view == 'capacitor')) {
                                    text = 'x10';
                                    supertext = multiplier[(i - 1) % 12];
                                    padding_sub = 8;
                                    if (supertext < 0) {
                                        padding_sub = 10;
                                    }
                                    height_sub = 0.5;
                                }

                                if (b == 3) {

                                    if ($scope.color_view == 'capacitor') {

                                        if (!capcitor_tolerance[(i - 1) % 12]) {
                                            continue
                                        }
                                        text = '±' + capcitor_tolerance[(i - 1) % 12] + '%';
                                        padding_sub = (text.length - 1) * 3;
                                    }
                                    else {

                                        text = 'x10';
                                        supertext = multiplier[(i - 1) % 12];
                                        padding_sub = 8;
                                        if (supertext < 0) {
                                            padding_sub = 10;
                                        }
                                        height_sub = 0.5;
                                    }
                                }
                                else if (b == 4) {

                                    if ($scope.color_view == 'capacitor') {

                                        if (!capacitor_voltage[(i - 1) % 12]) {
                                            continue
                                        }
                                        text = '' + capacitor_voltage[(i - 1) % 12] + '';
                                        padding_sub = (text.length - 1) * 3;
                                    }
                                    else {


                                        if (i == 10 || i == 4 || i == 1) {
                                            continue
                                        }
                                        text = '±' + tolerance[(i - 1) % 12] + '%';
                                        padding_sub = (text.length - 1) * 3;
                                        if (tolerance[(i - 1) % 12] < 1) {
                                            padding_sub -= 1;
                                        }
                                    }
                                }

                            }
                            else if ($scope.bands == 6) {
                                if ($scope.color_view == 'capacitor') {

                                    var color_start = colorlist[i - 1]['colors'][0];
                                    var color_end = colorlist[i - 1]['colors'][1];
                                    var color_text = colorlist[i - 1]['colors'][2];
                                    if (b == 0 && i > 2) {
                                        continue
                                    }
                                    if (b <= 2 && i > 10) {
                                        continue
                                    }

                                    if (b == 0) {
                                        if (i == 1) {
                                            text = 'JAN'
                                        }
                                        else {
                                            color_start = colors.silver[0];
                                            color_end = colors.silver[1];
                                            color_text = colors.silver[2];
                                            text = 'AWS'
                                        }
                                        padding_sub = 8;

                                    }

                                    if (b == 3) {
                                        if (i > 6) {
                                            continue
                                        }
                                        text = 'x10';
                                        supertext = multiplier[(i - 1) % 12];
                                        padding_sub = 8;
                                        if (supertext < 0) {
                                            padding_sub = 10;
                                        }
                                        height_sub = 0.5;
                                    }
                                    else if (b == 4) {
                                        if (i == 4 || i == 5 || i == 7 || i == 8 || i == 9 || i == 10) {
                                            continue
                                        }
                                        text = '±' + tolerance[(i - 1) % 12] + '%';
                                        padding_sub = (text.length - 1) * 3;
                                        if (tolerance[(i - 1) % 12] < 1) {
                                            padding_sub -= 1;
                                        }
                                    }
                                    else if (b == 5) {
                                        if (i > 6) {
                                            continue
                                        }
                                        text = '' + temp_capacitor[(i - 1) % 12];
                                        padding_sub = parseFloat(text.length - 1) * 3;
                                    }


                                    $scope.buttons.push(
                                        {height: height - 12 - height_sub - 1, top: top_offset + (i - 1) * (v_spacing + height),
                                            padding: (width - h_spacing) / 2 - padding_sub,
                                            left: b * width + h_offset,
                                            color_start: color_start,
                                            color_end: color_end,
                                            color_text: color_text,
                                            text: text,
                                            supertext: supertext,
                                            col: b,
                                            row_id: i - 1,
                                            font_weight: 'normal'
                                        }
                                    );
                                    continue;

                                }
                                else {


                                    if (b <= 2 && i > 10) {
                                        continue
                                    }

                                    if (b == 3) {
                                        text = 'x10';
                                        supertext = multiplier[(i - 1) % 12];
                                        padding_sub = 8;
                                        if (supertext < 0) {
                                            padding_sub = 10;
                                        }
                                        height_sub = 0.5;
                                    }
                                    else if (b == 4) {
                                        if (i == 10 || i == 4 || i == 1) {
                                            continue
                                        }
                                        text = '±' + tolerance[(i - 1) % 12] + '%';
                                        padding_sub = (text.length - 1) * 3;
                                        if (tolerance[(i - 1) % 12] < 1) {
                                            padding_sub -= 1;
                                        }
                                    }
                                    else if (b == 5) {
                                        if (i > 9) {
                                            continue
                                        }
                                        text = '' + temp[(i - 1) % 12];
                                        padding_sub = parseFloat(text.length - 1) * 3;
                                    }
                                }
                            }
                            else {
                                if (b <= 1 && i > 10) {  //skip the gold/silver for the first 2 bands
                                    continue
                                }

                                if (b == 2) {

                                    if ($scope.color_view == 'inductor' && i > 5 && i <= 10) {
                                        continue
                                    }
                                    text = 'x10';
                                    supertext = multiplier[(i - 1) % 12];
                                    padding_sub = 8;
                                    if (supertext < 0) {
                                        padding_sub = 10;
                                    }
                                    height_sub = 0.5;
                                }
                                else if (b == 3) {
                                    if ($scope.color_view == 'inductor' && i > 5 && i <= 10) {
                                        continue

                                    }
                                    else if ($scope.color_view == 'resistor' && (i == 10 || i == 4 || i == 1)) {
                                        continue
                                    }
                                    if ($scope.color_view == 'inductor') {
                                        text = '±' + inductor_tolerance[(i - 1) % 12] + '%';
                                    }
                                    else if ($scope.color_view == 'capacitor') {

                                        if (!capacitor_voltage[(i - 1) % 12]) {
                                            continue
                                        }
                                        text = '' + capacitor_voltage[(i - 1) % 12];
                                    }
                                    else {
                                        text = '±' + tolerance[(i - 1) % 12] + '%';
                                    }

                                    padding_sub = (text.length - 1) * 3;
                                    if (tolerance[(i - 1) % 12] < 1) {
                                        padding_sub -= 1;
                                    }

                                }
                                else if (b == 4) {
                                    if (i > 9) {
                                        continue
                                    }
                                    text = '' + temp[(i - 1) % 12];
                                    padding_sub = parseFloat(text.length - 1) * 3;
                                }

                            }

                            $scope.buttons.push(
                                {height: height - 12 - height_sub - 1, top: top_offset + (i - 1) * (v_spacing + height),
                                    padding: (width - h_spacing) / 2 - padding_sub,
                                    left: b * width + h_offset,
                                    color_start: colorlist[i - 1]['colors'][0],
                                    color_end: colorlist[i - 1]['colors'][1],
                                    color_text: colorlist[i - 1]['colors'][2],
                                    text: text,
                                    supertext: supertext,
                                    col: b,
                                    row_id: i - 1,
                                    font_weight: 'normal'
                                }
                            );
                        }
                    }

                    if ($scope.color_view != 'capacitor') {
                        var color = "lightgray";
                        connections.push(r.connection(shapes[0], shapes[6], color));
                        connections.push(r.connection(shapes[1], shapes[7], color));
                        connections.push(r.connection(shapes[2], shapes[8], color));
                        if ($scope.bands == 4) {
                            connections.push(r.connection(shapes[4], shapes[9], color));
                        }
                        else if ($scope.bands == 5) {
                            connections.push(r.connection(shapes[3], shapes[9], color));
                            connections.push(r.connection(shapes[4], shapes[10], color));
                        }
                        else if ($scope.bands == 6) {
                            connections.push(r.connection(shapes[3], shapes[9], color));
                            connections.push(r.connection(shapes[4], shapes[10], color));
                            connections.push(r.connection(shapes[5], shapes[11], color));
                        }
                    }
                    else {
                        shapes = []
                    }
                    draw_cols();
                }

                function setup_scene(force) {

                    var new_w = window.innerWidth;
                    var new_h = window.innerHeight - 40;
                    if ($scope.color_view == 'capacitor') {
                        new_h = window.innerHeight - 80;
                    }

                    new_h = Math.max(380, new_h);

                    if (new_h == h && new_w == w) {

                        if (force !== true) {
                            //   if (!myScroll.scrollerH){
                            myScroll.refresh()
                            //     }
                            return;
                        }
                    }
                    w = new_w;
                    h = new_h;

                    connections = [];

                    holder.css('height', h - 130);
                    if ($scope.color_view == 'capacitor') {
                        holder.css('height', h - 90);
                    }
                    holder.css('opacity', 1);

                    r.setSize(w, 130);

                    $timeout(function () {
                        myScroll.refresh()
                    }, 0);

                    rw = 146;
                    rh = 40;
                    var rl = 10;
                    var rt = 60;

                    div_band_1.css('top', rt);
                    div_band_1.css('height', rh);
                    div_band_1.css('left', rl + rw * 0.29);
                    div_band_1.css('width', rw / 12);

                    id_img_resistor.css('left', '10px');
                    id_img_resistor.css('top', '60px');
                    $(".div_band_resistor").show();
                    $(".div_band_capacitor").hide();
                    $(".div_band_capacitor_4").hide();
                    $(".div_band_capacitor_5").hide();

                    if ($scope.color_view == 'resistor') {
                        div_band_2.css('top', rt);
                        div_band_2.css('height', rh);
                        div_band_2.css('left', rl + rw * 0.36);
                        div_band_2.css('width', rw / 14);

                        div_band_3.css('top', rt);
                        div_band_3.css('height', rh);
                        div_band_3.css('left', rl + rw * 0.455);
                        div_band_3.css('width', rw / 14);

                        div_band_4.css('top', rt);
                        div_band_4.css('height', rh);
                        div_band_4.css('left', rl + rw * 0.53);
                        div_band_4.css('width', rw / 12);

                        div_band_5.css('top', rt);
                        div_band_5.css('height', rh);
                        div_band_5.css('left', rl + rw * 0.65);
                        div_band_5.css('width', rw / 12);

                        div_band_6.css('top', rt);
                        div_band_6.css('height', rh);
                        div_band_6.css('left', rl + rw * 0.72);
                        div_band_6.css('width', rw / 14);
                    }
                    else if ($scope.color_view == 'inductor') {
                        div_band_2.css('top', rt);
                        div_band_2.css('height', rh);
                        div_band_2.css('left', rl + rw * 0.41);
                        div_band_2.css('width', rw / 10);

                        div_band_3.css('top', rt);
                        div_band_3.css('height', rh);
                        div_band_3.css('left', rl + rw * 0.53);
                        div_band_3.css('width', rw / 14);

                        div_band_4.css('top', rt);
                        div_band_4.css('height', rh);
                        div_band_4.css('left', rl + rw * 0.1);
                        div_band_4.css('width', 0);

                        div_band_5.css('top', rt);
                        div_band_5.css('height', rh);
                        div_band_5.css('left', rl + rw * 0.65);
                        div_band_5.css('width', rw / 12);

                        div_band_6.css('top', rt);
                        div_band_6.css('height', rh);
                        div_band_6.css('left', rl + rw * 0.72);
                        div_band_6.css('width', rw / 14);
                    }
                    else if ($scope.color_view == 'capacitor') {
                        $(".div_band_resistor").hide();

                        if ($scope.bands == 6) {
                            $(".div_band_capacitor").show();
                            id_img_resistor.css('top', '53px');

                            div_band_1_capacitor.css('top', rt * 1.02);
                            div_band_1_capacitor.css('height', rh / 2);
                            div_band_1_capacitor.css('width', rh / 2);
                            div_band_1_capacitor.css('left', rl + rw * 0.17);

                            div_band_2_capacitor.css('top', rt * 1.02);
                            div_band_2_capacitor.css('height', rh / 2);
                            div_band_2_capacitor.css('width', rh / 2);
                            div_band_2_capacitor.css('left', rl + rw * 0.31);

                            div_band_3_capacitor.css('top', rt * 1.02);
                            div_band_3_capacitor.css('height', rh / 2);
                            div_band_3_capacitor.css('width', rh / 2);
                            div_band_3_capacitor.css('left', rl + rw * 0.46);

                            div_band_6_capacitor.css('top', rt * 1.46);
                            div_band_6_capacitor.css('height', rh / 2);
                            div_band_6_capacitor.css('width', rh / 2);
                            div_band_6_capacitor.css('left', rl + rw * 0.17);

                            div_band_5_capacitor.css('top', rt * 1.46);
                            div_band_5_capacitor.css('height', rh / 2);
                            div_band_5_capacitor.css('width', rh / 2);
                            div_band_5_capacitor.css('left', rl + rw * 0.31);

                            div_band_4_capacitor.css('top', rt * 1.46);
                            div_band_4_capacitor.css('height', rh / 2);
                            div_band_4_capacitor.css('width', rh / 2);
                            div_band_4_capacitor.css('left', rl + rw * 0.46);
                        }
                        else if ($scope.bands == 5) {
                            id_img_resistor.css('left', '17px');
                            id_img_resistor.css('top', '53px');

                            $(".div_band_capacitor_5").show();
                            rt = 50

                        }
                        else if ($scope.bands == 4) {
                            id_img_resistor.css('left', '17px');
                            id_img_resistor.css('top', '53px');

                            $(".div_band_capacitor_4").show();
                            rt = 50

                        }
                    }
                    reset_shapes();

                    $scope.show_full = 1;
                };
                myScroll = new iScroll('wrapper', { zoom: false, lockDirection: true, bounce: false });

                r = {setSize: function () {
                }, clear: function () {
                }, rect: function () {
                    return {attr: function () {
                    }}
                }, connection: function () {
                }}
                if (typeof Raphael != 'undefined') {
                    r = Raphael("topwrapper", w, h);
                }

                function set_footer(id) {
                    $("#id_footer").html($('#' + id).html()).trigger('create');
                    $(".button_define").on('click', function () {
                        $scope.define();
                        $scope.$apply();
                    })
                }

                function draw_cols() {
                    if (!h) {
                        return
                    }

                    for (var i = 0; i < $scope.bands; i++) {

                        var b = $scope.buttons.filter(function (v) {
                            return v.col == i && v.row_id == $scope.cols[i]
                        })
                        if (!b[0]) {
                            console.log('missing')
                            $scope.cols[i] = 1;
                            b = $scope.buttons.filter(function (v) {
                                return v.col == i && v.row_id == $scope.cols[i]
                            })
                        }
                        var all = $scope.buttons.filter(function (v) {
                            return v.col == i
                        })

                        all.each(function (b) {
                            b.font_weight = 'normal';
                        })
                        b[0].font_weight = 'bold';
                    }

                    $scope.resitor.temp = '';
                    if ($scope.bands > 4) {
                        var pow = $scope.cols[3]
                        if (pow > 9) {
                            pow = 9 - pow;
                        }
                        $scope.resitor.ohm = ($scope.cols[0] * 100 + $scope.cols[1] * 10 + $scope.cols[2]) * Math.pow(10, pow)
                        $scope.resitor.tol = tolerance[$scope.cols[4]]


                        if ($scope.bands == 6) {
                            $scope.resitor.temp = temp[$scope.cols[5]] + 'ppm/K';


                            if ($scope.color_view == 'capacitor') {

                                $scope.resitor.ohm = ($scope.cols[1] * 10 + $scope.cols[2]) * Math.pow(10, pow) * Math.pow(10, -12)
                                $scope.resitor.temp = temp_capacitor_display[$scope.cols[5]] + 'ppm/°C';
                                if ($scope.cols[0] == 0) {
                                    $scope.resitor.type = 'Joint Army Navy (JAN) ';
                                }
                                else {
                                    $scope.resitor.type = 'American War Standard (AWS) ';
                                }

                            }
                        }
                        else if ($scope.bands == 5) {
                            if ($scope.color_view == 'capacitor') {
                                pow = $scope.cols[2]
                                if (pow > 9) {
                                    pow = 9 - pow;
                                }
                                $scope.resitor.ohm = ($scope.cols[0] * 10 + $scope.cols[1]) * Math.pow(10, pow) * Math.pow(10, -12)
                                $scope.resitor.tol = capcitor_tolerance[$scope.cols[3]]

                                $scope.resitor.temp = '(' + capacitor_voltage[$scope.cols[4]] + 'V)';
                            }
                        }
                    }
                    else {
                        var pow = $scope.cols[2];
                        if (pow > 9) {
                            pow = 9 - pow;
                        }

                        if ($scope.color_view == 'capacitor') {
                            pow = $scope.cols[2]
                            if (pow > 9) {
                                pow = 9 - pow;
                            }
                            $scope.resitor.ohm = ($scope.cols[0] * 10 + $scope.cols[1]) * Math.pow(10, pow) * Math.pow(10, -12)
                            $scope.resitor.tol = 20

                            $scope.resitor.temp = '(' + capacitor_voltage[$scope.cols[3]] + 'V)';
                        }
                        else {

                            $scope.resitor.ohm = ($scope.cols[0] * 10 + $scope.cols[1] * 1) * Math.pow(10, pow);
                            if ($scope.color_view == 'inductor') {
                                $scope.resitor.ohm = $scope.resitor.ohm / Math.pow(10, 6)
                            }

                            if ($scope.bands > 3) {
                                $scope.resitor.tol = tolerance[$scope.cols[3]]
                                if ($scope.color_view == 'inductor') {
                                    $scope.resitor.tol = inductor_tolerance[$scope.cols[3]]
                                }

                            }
                            else {
                                $scope.resitor.tol = 20;
                            }
                        }
                    }

                    div_band_1.css('background-color', $scope.colorlist[$scope.cols[0]].colors[0]);
                    if ($scope.color_view == 'capacitor') {
                        if ($scope.cols[0] == 1) {
                            div_band_1_capacitor.css('background-color', $scope.colorlist[11].colors[0]);

                        }
                        else {
                            if ($scope.bands == 6) {
                                $scope.cols[0] = 0;
                            }
                            div_band_1_capacitor.css('background-color', $scope.colorlist[$scope.cols[0]].colors[0]);
                        }
                    }
                    div_band_1_capacitor_4.css('background-color', $scope.colorlist[$scope.cols[0]].colors[0])
                    div_band_2_capacitor_4.css('background-color', $scope.colorlist[$scope.cols[1]].colors[0])
                    div_band_3_capacitor_4.css('background-color', $scope.colorlist[$scope.cols[2]].colors[0])
                    div_band_4_capacitor_4.css('background-color', $scope.colorlist[$scope.cols[3]].colors[0])

                    div_band_1_capacitor_5.css('background-color', $scope.colorlist[$scope.cols[0]].colors[0])
                    div_band_2_capacitor_5.css('background-color', $scope.colorlist[$scope.cols[1]].colors[0])
                    div_band_3_capacitor_5.css('background-color', $scope.colorlist[$scope.cols[2]].colors[0])
                    div_band_4_capacitor_5.css('background-color', $scope.colorlist[$scope.cols[3]].colors[0])
                    div_band_5_capacitor_5.css('background-color', $scope.colorlist[$scope.cols[4]].colors[0])

                    div_band_2.css('background-color', $scope.colorlist[$scope.cols[1]].colors[0]);
                    div_band_2_capacitor.css('background-color', $scope.colorlist[$scope.cols[1]].colors[0]);
                    div_band_3.css('background-color', $scope.colorlist[$scope.cols[2]].colors[0]);
                    div_band_3_capacitor.css('background-color', $scope.colorlist[$scope.cols[2]].colors[0]);
                    var background_color = '#51967A';
                    if ($scope.color_view == 'resistor') {
                        background_color = '#D6A56B';
                    }
                    div_band_4.css('background-color', background_color);
                    div_band_5.css('background-color', background_color);
                    div_band_6.css('background-color', background_color);

                    if ($scope.bands == 4) {
                        div_band_5.css('background-color', $scope.colorlist[$scope.cols[3]].colors[0])
                    }
                    else if ($scope.bands == 5) {
                        div_band_4.css('background-color', $scope.colorlist[$scope.cols[3]].colors[0])
                        div_band_5.css('background-color', $scope.colorlist[$scope.cols[4]].colors[0])
                    }
                    else if ($scope.bands == 6) {
                        div_band_4.css('background-color', $scope.colorlist[$scope.cols[3]].colors[0])
                        div_band_4_capacitor.css('background-color', $scope.colorlist[$scope.cols[3]].colors[0])
                        div_band_5.css('background-color', $scope.colorlist[$scope.cols[4]].colors[0])
                        div_band_5_capacitor.css('background-color', $scope.colorlist[$scope.cols[4]].colors[0])
                        div_band_6.css('background-color', $scope.colorlist[$scope.cols[5]].colors[0])
                        div_band_6_capacitor.css('background-color', $scope.colorlist[$scope.cols[5]].colors[0])
                    }

                }

                $scope.on_color_view = function (new_view) {

                    $scope.resitor.type = '';
                    $scope.color_view = new_view;
                    console.log('on_color_view')

                    $("#footer_tabs_resistor").hide()
                    $("#footer_tabs_inductor").hide()
                    $("#footer_tabs_capacitor").hide()

                    id_img_resistor.css('width', '146px');
                    id_img_resistor.css('height', '40px');
                    id_img_resistor.css('top', '60px');
                    id_img_resistor.css('left', '170px');
                    $("#id_resitor_values").css('left', '170px');

                    if ($scope.color_view == 'resistor') {
                        $scope.unit_prefix = 'Ω'
                        $("#footer_tabs_resistor").show()
                        $("#id_h1_resistor").html('Resistance')
                        id_img_resistor.attr('src', 'images/resistor.png');
                    }
                    else if ($scope.color_view == 'inductor') {
                        $scope.unit_prefix = 'H'
                        if ($scope.bands > 4) {
                            $scope.bands = 4;
                        }
                        if ($scope.cols[2] > 3) {
                            $scope.cols[2] = 3;
                        }
                        $scope.cols[3] = 2;

                        $("#footer_tabs_inductor").show()
                        $("#id_h1_resistor").html('Inductance')
                        id_img_resistor.attr('src', 'images/inductor.png');
                    }
                    else if ($scope.color_view == 'capacitor') {
                        $("#footer_tabs_capacitor").show()

                        if ($scope.bands < 4) {
                            $scope.bands = 6;
                        }
                        $("#id_resitor_values").css('left', '140px');

                        $scope.unit_prefix = 'F'
                        $("#id_h1_resistor").html('Capacitance')
                        id_img_resistor.css('width', '60px');
                        id_img_resistor.css('height', '60px');
                        id_img_resistor.css('top', '50px');
                        if ($scope.bands == 4) {
//                            console.log('4')
                            id_img_resistor.attr('src', 'images/capacitor_polyester_4.png');
                        }
                        else if ($scope.bands == 5) {
//                            console.log('5')
                            id_img_resistor.attr('src', 'images/capacitor_polyester_5.png');
                        }
                        else {
                            id_img_resistor.css('width', '112px');

                            id_img_resistor.attr('src', 'images/capacitor_colored.png');
                        }

                    }
                    setup_scene(true);
                    reset_shapes();
                }

                $scope.choose_capacitor_bands = function (bands) {
                    $scope.bands = bands;
                    $scope.on_color_view('capacitor')
                }

                $scope.$watch('bands', reset_shapes);
                $scope.$watch('bands', setup_scene);
                $scope.$watch('cols', draw_cols, true);

                $("#page_resitor").on('pageshow', setup_scene);

                window.addEventListener("orientationchange", function () {
                    $timeout(setup_scene, 400);
                }, true);

                setInterval(function () {
                    setup_scene();
                }, 1000)

            }
        ]).controller('SMD_Controller', ['$scope', '$timeout',
            function ($scope, $timeout) {

                $scope.raw_code = '102';
                $scope.code = $scope.raw_code;
                $scope.underlined = false;
                $scope.underline_style = 'none';
                $scope.valid = true;
                $scope.resistance = 1000;
                $scope.tol = 5;

                var EIA_Mul = {'Z': 0.001,
                    'Y': 0.01,
                    'R': 0.01,
                    'X': 0.1,
                    'S': 0.1,
                    'A': 1,
                    'B': 10,
                    'H': 10,
                    'C': 100,
                    'D': 1000,
                    'E': 10000,
                    'F': 100000
                }

                var EIA_Table = {'01': '100', '02': '102', '03': '105', '04': '107', '05': '110',
                    '06': '113', '07': '115', '08': '118', '09': '121', '10': '124', '11': '127',
                    '12': '130', '13': '133', '14': '137', '15': '140', '16': '143', '17': '147',
                    '18': '150', '19': '154', '20': '158', '21': '162', '22': '165', '23': '169',
                    '24': '174', '25': '178', '26': '182', '27': '187', '28': '191', '29': '196',
                    '30': '200', '31': '205', '32': '210', '33': '215', '34': '221', '35': '226',
                    '36': '232', '37': '237', '38': '243', '39': '249', '40': '255', '41': '261',
                    '42': '267', '43': '274', '44': '280', '45': '287', '46': '294', '47': '301',
                    '48': '309', '49': '316', '50': '324', '51': '332', '52': '340', '53': '348',
                    '54': '357', '55': '365', '56': '374', '57': '383', '58': '392', '59': '402',
                    '60': '412', '61': '422', '62': '432', '63': '442', '64': '453', '65': '464',
                    '66': '475', '67': '487', '68': '499', '69': '511', '70': '523', '71': '536',
                    '72': '549', '73': '562', '74': '576', '75': '590', '76': '604', '77': '619',
                    '78': '634', '79': '649', '80': '665', '81': '681', '82': '698', '83': '715',
                    '84': '732', '85': '750', '86': '768', '87': '787', '88': '806', '89': '825',
                    '90': '845', '91': '866', '92': '887', '93': '909', '94': '931', '95': '953',
                    '96': '976'
                };

                function eia_resistance(s) {

                }

                $scope.calculate = function () {
                    $scope.raw_code = $scope.raw_code.toUpperCase();
                    $scope.smd_code_type = '';

                    $("#id_invalid_code").html("")

                    var code = $scope.raw_code;
                    if (code.length < 1 || code.length > 4) {
                        $("#id_invalid_code").html("Invalid Code")
                        $scope.valid = false;
                        return;
                    }
                    var r = new RegExp("^[0-9R]{3,4}$");
                    var r_1 = new RegExp("^[0-9]R?$"); //1 digit long
                    var r_R1 = new RegExp("^R[0-9]$"); //1 digit long, starts with R
                    var r_2 = new RegExp("^[0-9]{2}$"); //2 digits long
                    var r_m = new RegExp("^[0-9M]{3,4}$");
                    var r_96 = new RegExp("^[0-9]{2}[ZYRXSABHCDEF]$"); //EIA-96

                    $scope.resistance_alt = 0;


                    if (r_1.test(code) || r_2.test(code)) {
                        $scope.code = $scope.raw_code;
                        if (code.indexOf('R') > -1) {
                            $scope.underlined = false;
                            $scope.resistance = parseFloat('0' + code.replace('R', '.'))
                        }
                        else {
                            if ($scope.underlined) {
                                $scope.resistance = parseFloat('0.' + code)
                            }
                            else {
                                $scope.resistance = parseFloat(code)
                            }
                        }
                    }
                    else if (r_R1.test(code)) {
                        $scope.code = $scope.raw_code;
                        $scope.underlined = false;
                        $scope.resistance = parseFloat('0' + code.replace('R', '.'))
                    }
                    else if (r.test(code) && (code.split('R').length - 1 < 2)) {  //if a valid 'normal' 3 or 4 digit code
                        $scope.valid = true;
                        $scope.tol = 5;
                        $scope.code = $scope.raw_code;
                        if (code.indexOf('R') > -1) {
                            $scope.underlined = false;
                            $scope.resistance = parseFloat('0' + code.replace('R', '.'))
                            if (r_96.test(code)) {  //if it can also be EIA code

                                if (EIA_Table[code[0] + code[1]] && EIA_Mul[code[2]]) {
//                                    $scope.smd_code_type = '(EIA-96)';

                                 //   $scope.tol = 1;
                                //    $scope.underlined = false;
//                                    $scope.code = $scope.raw_code;
                                    $scope.resistance_alt = parseFloat(EIA_Table[code[0] + code[1]]) * parseFloat(EIA_Mul[code[2]])
                                }
                            }

                        }
                        else {
                            if ($scope.underlined) {
                                $scope.resistance = parseFloat('0.' + code)
                            }
                            else {
                                if (code.length == 3) {
                                    $scope.resistance = parseFloat(code[0] + code[1]) * Math.pow(10, parseFloat(code[2]))
                                }
                                else {
                                    $scope.resistance = parseFloat(code[0] + code[1] + code[2]) * Math.pow(10, parseFloat(code[3]))
                                }
                            }
                        }
                    }
                    else if (r_m.test(code) && (code.split('M').length - 1 < 2)) {  //if a valid 'normal' 3 or 4 digit code
                        $scope.valid = true;
                        $scope.tol = 5;
                        $scope.code = $scope.raw_code;
                        if (code.indexOf('M') > -1) {
                            $scope.underlined = false;
                            $scope.resistance = parseFloat('0' + code.replace('M', '.')) / 1000
                        }
                        else {
                            $scope.resistance = parseFloat(code[0] + code[1]) * Math.pow(10, parseFloat(code[2]))
                        }

                    }

                    else if (r_96.test(code)) { //EIA-96
                        if (EIA_Table[code[0] + code[1]] && EIA_Mul[code[2]]) {
                            $scope.smd_code_type = '(EIA-96)';
                            $scope.tol = 1;
                            $scope.underlined = false;
                            $scope.code = $scope.raw_code;
                            $scope.resistance = parseFloat(EIA_Table[code[0] + code[1]]) * parseFloat(EIA_Mul[code[2]])
                        }

                    }
                    else {  //invalid code
                        $("#id_invalid_code").html("Invalid Code");
                    }

                    if ($scope.underlined) {
                        $scope.underline_style = 'underline';
                    }
                    else {
                        $scope.underline_style = 'none';
                    }

                    $("#id_smd_underlined").attr("checked", $scope.underlined).checkboxradio('refresh');

                }
                ;
            }]).controller('Capacitor_Printed_Controller', ['$scope', '$timeout',
            function ($scope, $timeout) {
                $scope.capacitor_value = 'nothing yet..';
                $scope.capacitor_mode = 'electrolytic';
                $scope.electrolytic_raw = '54MF';
                $scope.ceramic_raw = '121K';
                $scope.electrolytic_display = '54MF';
                $scope.electrolytic_display_tol = '';
                $scope.capacitance_electrolytic = 54;

                $scope.reset_capacitor_mode = function () {

                    $scope.color_electrolytic = '';
                    $scope.color_ceramic = '';

                    switch ($scope.capacitor_mode) {
                        case 'electrolytic':
                            $scope.calculate_electrolytic();
                            break;
                        case 'ceramic':
                            $scope.calculate_ceramic();
                            break;
                        default:
                            break;
                    }
                }


                $scope.calculate_electrolytic = function () {

                    $scope.color_electrolytic = '#4E6D8D';
                    var tol_table = {
                        '0': [20, ''],
                        'M': [20, '(M)'],
                        'K': [10, '(K)'],
                        'J': [5, '(J)'],
                        'G': [2, '(G)']
                    };

                    $("#id_capacitor_electrolytic_invalid_code").html("");

                    $scope.tol_electrolytic = tol_table[$("#id_tolerance_electrolytic").val()][0];
                    $scope.electrolytic_display_tol = tol_table[$("#id_tolerance_electrolytic").val()][1];
//                    console.log($("#id_tolerance_electrolytic").val())
                    var v = $scope.electrolytic_raw.trim();
                    v = v.replace('m', 'M').replace('MMF', 'pF').replace('MF', 'µF').replace('MM', 'p').replace('M', 'µ');


                    var r = new RegExp("^[0-9\.]{1,6}[µpnm]?F?$");
                    if (!r.test(v)) {
                        $("#id_capacitor_electrolytic_invalid_code").html("Invalid Code");
                        return;
                    }

                    if (v[v.length - 1] == 'F') {
                        v = v.substring(0, v.length - 1);
                    }
                    if (!isNaN(parseFloat(v[v.length - 1]))) {
                        v = v + 'µ';
                    }
                    var mul = Math.pow(10, -6);

                    switch (v[v.length - 1]) {
                        case 'm':
                            mul = Math.pow(10, -3);
                            break;
                        case 'µ':
                            mul = Math.pow(10, -6);
                            break;
                        case 'n':
                            mul = Math.pow(10, -9);
                            break;
                        case 'p':
                            mul = Math.pow(10, -12);
                            break;
                        default:
                            $("#id_capacitor_electrolytic_invalid_code").html("Unknown Code");
                            return;
                    }

                    $scope.capacitance_electrolytic = parseFloat(v.substring(0, v.length - 1)) * mul;
                    $scope.electrolytic_display = $scope.electrolytic_raw.replace('m', 'M');

                }

                $scope.calculate_ceramic = function () {

                    $scope.color_ceramic = '#4E6D8D';
                    var capacitance_ceramic;
                    var tol_ceramic;
                    var tol_table = {
                        '0': [20, ''],
                        'M': [20, '(M)'],
                        'K': [10, '(K)'],
                        'J': [5, '(J)'],
                        'G': [2, '(G)'],
                        'F': [1, 'F'],
                        'D': [0.5, 'D'],
                        'C': [0.25, 'C'],
                        'B': [0.1, 'B'],
                        'A': [0.05, 'A']
                    };

                    $("#id_capacitor_ceramic_invalid_code").html("");

                    var v = $scope.ceramic_raw.trim();
                    v = v.toUpperCase().replace('P', 'p').replace('N', 'n');
                    var raw = v;

                    var r = new RegExp("^[npR0-9][0-9\.Rp]{1,3}[0-9pR\.MKJGFDCBAF]*$");
                    if (!r.test(v)) {
                        $("#id_capacitor_ceramic_invalid_code").html("Invalid Code");
                        return;
                    }

                    if (v[v.length - 1] == 'F') {
                        v = v.substring(0, v.length - 1);
                    }

                    tol_ceramic = 20;
                    if (tol_table[v[v.length - 1]]) {
                        tol_ceramic = tol_table[v[v.length - 1]][0];
                        v = v.substring(0, v.length - 1);
                    }

                    if (v.indexOf('p') > -1) {  //European marking, eg 'p68'
                        capacitance_ceramic = parseFloat('0' + v.replace('p', '.')) * Math.pow(10, -12);

                    }
                    else if (v.indexOf('n') > -1) { //European marking, eg 'n68'
                        capacitance_ceramic = parseFloat('0' + v.replace('p', '.')) * Math.pow(10, -9);

                    }
                    else if ((v.split('R').length - 1 < 2)) {  //if a valid 'normal' 3 or 4 digit code

                        if (v.indexOf('R') > -1) {
                            capacitance_ceramic = parseFloat('0' + v.replace('R', '.')) * Math.pow(10, -12);
                        }
                        else {
                            if (v.length == 2) {
                                raw = ' ' + raw;
                                capacitance_ceramic = parseFloat(v[0] + v[1]) * Math.pow(10, -12);
                            }
                            else if (v.length == 3) {
                                capacitance_ceramic = parseFloat(v[0] + v[1]) * Math.pow(10, parseFloat(v[2])) * Math.pow(10, -12);
                            }
                            else if (v.length == 4) {
                                capacitance_ceramic = parseFloat(v[0] + v[1] + v[2]) * Math.pow(10, parseFloat(v[3])) * Math.pow(10, -12);
                            }
                            else {
                                $("#id_capacitor_ceramic_invalid_code").html("Invalid Code")
                                return;
                            }
                        }
                    }
                    else {
                        $("#id_capacitor_ceramic_invalid_code").html("Invalid Code")
                        return;
                    }

                    if (isNaN(capacitance_ceramic) || isNaN(tol_ceramic)) {
                        $("#id_capacitor_ceramic_invalid_code").html("Invalid Code")
                        return;
                    }
                    $scope.capacitance_ceramic = capacitance_ceramic;
                    $scope.tol_ceramic = tol_ceramic;
                    $scope.ceramic_display = raw

                }
                $scope.calculate_electrolytic();

                $scope.$watch('capacitor_mode', $scope.reset_capacitor_mode);
            }
        ]
        );
}());
document.addEventListener("deviceready", onDeviceReady, false);


var myScroll;
function onDeviceReady() {
    if (typeof window.tinyHippos == 'undefined') { //if we are not in the emulator
        //navigator.splashscreen.hide();
    }

 //   if (parseFloat(window.device.version) >= 7.0) { //offset top of screen for new ios version
      //    document.body.style.marginTop = "20px";
   // }

    angular.bootstrap(document, ['demo']);

    $("img").one('load',function () {
        // do stuff
    }).each(function () {
            if (this.complete) $(this).load();
        });
};
